/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.CompensateEventDefinition;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.BpmnError;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.helper.ErrorPropagation;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.delegate.ActivityBehavior;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class AbstractBpmnActivityBehavior
extends FlowNodeActivityBehavior {
    protected Log logger = LogFactory.getLog((String)this.getClass().getName());
    private static final long serialVersionUID = 1L;
    protected MultiInstanceActivityBehavior multiInstanceActivityBehavior;

    @Override
    public void leave(DelegateExecution execution) {
        FlowElement currentFlowElement = execution.getCurrentFlowElement();
        String errorNumber = (String)execution.getVariable("enterBdyCompensateErrorCode");
        if (currentFlowElement instanceof BillTask && ((BillTask)currentFlowElement).getCallActivity() != null && WfUtils.isNotEmpty(errorNumber)) {
            execution.removeVariable("enterBdyCompensateErrorCode");
            ErrorPropagation.propagateError(new BpmnError(errorNumber), execution, null);
        } else if (!this.hasLoopCharacteristics()) {
            super.leave(execution);
        } else if (this.hasMultiInstanceCharacteristics()) {
            ExecutionEntity parent = (ExecutionEntity)execution.getParent();
            this.logger.debug(String.format("current context: (execution[%s-isMuliRoot:%s],parent[%s-isMuliRoot:%s])", execution.getId(), execution.isMultiInstanceRoot(), parent == null ? null : parent.getId(), parent == null ? null : Boolean.valueOf(parent.isMultiInstanceRoot())));
            if (execution.isMultiInstanceRoot() || parent != null && parent.isMultiInstanceRoot()) {
                this.multiInstanceActivityBehavior.leave(execution);
            } else {
                this.logger.debug("directly leave because of non-multiInstanceRootExecution ");
                super.leave(execution);
            }
        }
    }

    protected void executeCompensateBoundaryEvents(Collection<BoundaryEvent> boundaryEvents, DelegateExecution execution) {
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            if (CollectionUtil.isEmpty(boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition)) continue;
            ExecutionEntityManager executionMgr = Context.getCommandContext().getExecutionEntityManager();
            ExecutionEntity childExecutionEntity = executionMgr.createChildExecution((ExecutionEntity)execution);
            childExecutionEntity.setParentId(execution.getId());
            childExecutionEntity.setCurrentFlowElement(boundaryEvent);
            childExecutionEntity.setScope(false);
            ActivityBehavior boundaryEventBehavior = (ActivityBehavior)boundaryEvent.getBehavior();
            boundaryEventBehavior.execute(childExecutionEntity);
            executionMgr.delete(childExecutionEntity);
        }
    }

    protected Collection<BoundaryEvent> findBoundaryEventsForFlowNode(Long processDefinitionId, Long processInstanceId, FlowElement flowElement) {
        Process process = this.getProcessDefinition(processDefinitionId, processInstanceId);
        ArrayList<BoundaryEvent> results = new ArrayList<BoundaryEvent>(1);
        List<BoundaryEvent> boundaryEvents = process.findFlowElementsOfType(BoundaryEvent.class, true);
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            if (boundaryEvent.getAttachedToRefId() == null || !boundaryEvent.getAttachedToRefId().equals(flowElement.getId())) continue;
            results.add(boundaryEvent);
        }
        return results;
    }

    protected Process getProcessDefinition(Long processDefinitionId, Long processInstanceId) {
        return ProcessDefinitionUtil.getProcess(processDefinitionId, processInstanceId);
    }

    protected boolean hasLoopCharacteristics() {
        return this.hasMultiInstanceCharacteristics();
    }

    protected boolean hasMultiInstanceCharacteristics() {
        return this.multiInstanceActivityBehavior != null;
    }

    public MultiInstanceActivityBehavior getMultiInstanceActivityBehavior() {
        return this.multiInstanceActivityBehavior;
    }

    public void setMultiInstanceActivityBehavior(MultiInstanceActivityBehavior multiInstanceActivityBehavior) {
        this.multiInstanceActivityBehavior = multiInstanceActivityBehavior;
    }
}

