/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.AutoAudit;
import kd.bos.workflow.bpmn.model.AutoCoordinate;
import kd.bos.workflow.bpmn.model.AutoCoordinateModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfAfterAuditUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.agenda.AbstractOperation;
import kd.bos.workflow.engine.impl.agenda.ContinueProcessOperation;
import kd.bos.workflow.engine.impl.agenda.callback.PlanAutoAuditOperationCallback;
import kd.bos.workflow.engine.impl.bpmn.behavior.SkipInfo;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.precomputation.PreComputorHelper;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionType;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.engine.precomputor.IPreComputorRecord;
import kd.bos.workflow.engine.precomputor.IPreComputorRecordItem;
import kd.bos.workflow.engine.task.TaskDelegateCalculateUtil;
import kd.bos.workflow.engine.task.TaskUtils;

public class AuditTaskActivityBehavior
extends UserTaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected AuditTask auditTask;
    private static final String RESULTNUMBER = "resultNumber";

    public AuditTaskActivityBehavior(AuditTask auditTask) {
        super(auditTask);
        this.auditTask = auditTask;
    }

    @Override
    public void execute(DelegateExecution execution) {
        super.execute(execution);
        ExecutionEntity exec = (ExecutionEntity)execution;
        CommandContext commandContext = Context.getCommandContext();
        SkipInfo skipInfo = DynamicFlowUtil.isSkipTask(this.auditTask, exec.getCurrentTask(), exec);
        TaskEntity task = ((ExecutionEntity)execution).getCurrentTask();
        TaskUtils.calcBatchOp(commandContext, (ExecutionEntity)execution, task, this.auditTask);
        boolean hasTask = WfUtils.isNotEmpty(task.getId());
        if (this.auditTask.getType().equals("AuditTask") && !skipInfo.isSkip() && hasTask) {
            boolean manualProcessing = false;
            boolean rejectBackNotSkip = false;
            if (!skipInfo.getSkipReason().isEmpty() && "RejectToBackNotSkip".equalsIgnoreCase(skipInfo.getSkipReason())) {
                rejectBackNotSkip = true;
            }
            if (manualProcessing = !rejectBackNotSkip ? this.isManualProcessing(task, execution) : true) {
                List<Long> autoCoordinatorIds = TaskDelegateCalculateUtil.calcAutoCoordinatorIdsWithDelegation(commandContext, (ExecutionEntity)execution, task, this.auditTask);
                TaskBehaviorUtil.calculateAuditPoint(execution, this.auditTask);
                if ("AuditTask".equals(this.auditTask.getType()) && WfUtils.isNotEmptyForCollection(task.getIdentityLinks())) {
                    this.planToDoJob(commandContext, task.getId(), execution);
                }
                this.planAutoCirculateJob(commandContext, execution, task.getId(), "start");
                if (!WfUtils.isTesting()) {
                    this.doAutoCoordinate(commandContext, exec, this.auditTask, task.getId(), autoCoordinatorIds);
                    if (WfAfterAuditUtil.canDoAfterAudit(task).booleanValue()) {
                        PreComputorHelper.doPreComputorFromAuditTaskForAfterAudit(execution.getProcessInstanceId(), "through", this.auditTask, task);
                    } else {
                        PreComputorHelper.doPreComputorFromActivityBehavior(execution.getProcessInstanceId(), "through", this.auditTask, task);
                    }
                }
                TaskBehaviorUtil.dispatchTaskAssignListener(task, "AuditTask");
                if ("AuditTask".equals(this.userTask.getType())) {
                    this.triggerCreateTaskEvent(task, new ArrayList<Long>(task.getParticipants()), commandContext);
                }
            }
        }
    }

    public boolean isManualProcessing(TaskEntity task, DelegateExecution execution) {
        boolean manualProcessing = false;
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ExecutionEntity exec = (ExecutionEntity)execution;
        TaskHelper taskHelper = processEngineConfiguration.getTaskHelper();
        if (taskHelper.isStarterSameAsAuditor(task)) {
            taskHelper.doAutoAudit(exec, WfUtils.getDefaultDecision(this.auditTask), task.getStarterId(), null);
            return false;
        }
        AutoAudit autoAudit = this.auditTask.getAutoAudit();
        if (autoAudit != null && ConditionUtil.isConditionAvailable(autoAudit.getAutoAuditCondition()) && autoAudit.isAutoAuditWhenMatch()) {
            DecisionOption autoDecision;
            String key = ConditionUtil.getConInstKey(this.auditTask.getNumber(), "autoAudit");
            ConditionType.logOpDesc(autoAudit.getAutoAuditCondition());
            boolean auto = ConditionUtil.hasTrueCondition(autoAudit.getAutoAuditCondition(), (VariableScope)task, key);
            if (auto && (autoDecision = WfUtils.getDecisionOption(this.auditTask, autoAudit.getAutoDecisionWhenMatch())) != null) {
                taskHelper.doAutoAudit(exec, autoAudit, autoDecision, null);
                return false;
            }
        }
        if (!this.auditTask.isAddSign() && !task.getHandleState().equals("dismissed") && WfAfterAuditUtil.canDoAfterAudit(task).booleanValue()) {
            IPreComputorRecordItem item = this.getNextAfterAuditNode(execution, task);
            if (item != null) {
                this.skipTask(execution, task);
                this.saveOperationLog(task.getId(), item.getNodeName());
                execution.setTransientVariable(String.format("%s-%s", task.getTaskDefinitionKey(), "executionType"), "skip");
                ((ExecutionEntity)execution).getProcessInstance().setVariable(String.format("%s_%s", item.getNodeId(), "stopNodeId"), "1");
                return false;
            }
            List<IdentityLinkEntity> identityList = task.getIdentityLinks();
            String stopNodeId = (String)((ExecutionEntity)execution).getProcessInstance().getVariable(String.format("%s_%s", execution.getCurrentActivityId(), "stopNodeId"));
            if (WfUtils.isNotEmpty(stopNodeId)) {
                manualProcessing = true;
                ((ExecutionEntity)execution).getProcessInstance().removeVariable(String.format("%s_%s", execution.getCurrentActivityId(), "stopNodeId"));
            }
        }
        if (!manualProcessing) {
            manualProcessing = this.doSamePartiRule(execution, task);
        }
        return manualProcessing;
    }

    protected boolean doSamePartiRule(DelegateExecution execution, TaskEntity task) {
        boolean manualProcessing = true;
        boolean allowRepeaters = WfConfigurationUtil.getRepeaterApprovalConfig(this.covertIdentityToUserIds(task.getIdentityLinks()));
        if (allowRepeaters && !task.getHandleState().equals("dismissed") && CollectionUtil.isNotEmpty(task.getIdentityLinks())) {
            Process process;
            boolean same;
            boolean needCalRepeater;
            ArrayList<String> approvalNumbers = new ArrayList<String>();
            for (DecisionOption op : this.auditTask.getDecisionOptions()) {
                if (!"approve".equals(op.getAuditType())) continue;
                approvalNumbers.add(op.getNumber());
            }
            HashMap<String, String> remainSourceIdKeyMap = new HashMap<String, String>();
            ArrayList<Long> userIds = new ArrayList<Long>();
            List<IdentityLinkEntity> identityLinks = task.getIdentityLinks();
            HashSet<Long> trusteeIds = new HashSet<Long>();
            if (CollectionUtil.isNotEmpty(identityLinks)) {
                for (IdentityLinkEntity identityLink : identityLinks) {
                    if (WfUtils.isNotEmpty(identityLink.getDelegateId())) {
                        trusteeIds.add(identityLink.getUserId());
                        continue;
                    }
                    userIds.add(identityLink.getUserId());
                }
            }
            boolean bl = needCalRepeater = this.auditTask.isRepeaterbtn() && this.auditTask.getRepeaterModel() != null && !"manual".equals(this.auditTask.getRepeaterModel());
            if (needCalRepeater) {
                boolean adjacentnodeonly = this.auditTask.isAdjacentnodeonly();
                List<Object> repeaterApprovalInfo = new ArrayList();
                repeaterApprovalInfo = adjacentnodeonly ? TaskUtils.getRepeaterAdjacentNodes(userIds, trusteeIds, execution.getProcessInstanceId(), this.auditTask.getId()) : TaskUtils.getRepeaterApprovalAllNumber(userIds, trusteeIds, execution.getProcessInstanceId(), execution.getProcessDefinitionId(), (ExecutionEntity)execution, remainSourceIdKeyMap);
                if (!repeaterApprovalInfo.isEmpty()) {
                    switch (this.auditTask.getRepeaterModel()) {
                        case "skip": {
                            task.setTransientVariable("isRepeaterModel", true);
                            this.skipTask(execution, task);
                            task.removeTransientVariable("isRepeaterModel");
                            execution.setTransientVariable(String.format("%s-%s", task.getTaskDefinitionKey(), "executionType"), "skip");
                            manualProcessing = false;
                            break;
                        }
                        case "auto": {
                            String hiAuditNumber = "";
                            LocaleString auditMessage = new LocaleString();
                            Long assigneeId = 0L;
                            Long hicommentId = 0L;
                            for (Map map : repeaterApprovalInfo) {
                                if (!approvalNumbers.contains(map.get(RESULTNUMBER))) continue;
                                hicommentId = Long.valueOf((String)map.get("commentId"));
                                hiAuditNumber = (String)map.get(RESULTNUMBER);
                                if (!WfUtils.isNotEmpty(hicommentId)) continue;
                                CommentEntity comment = (CommentEntity)Context.getCommandContext().getCommentEntityManager().findById(hicommentId);
                                auditMessage = comment.getCommentMessage();
                                assigneeId = comment.getUserId();
                                break;
                            }
                            if ("custom".equals(this.auditTask.getUseSameAuditMsg())) {
                                LocaleString custonAuditMessage = new LocaleString();
                                if (WfUtils.isEmpty(this.auditTask.getCustomAuditMsg())) {
                                    custonAuditMessage = (LocaleString)WfUtils.getPromptWordLocaleString("\u540c\u610f", "AuditTaskActivityBehavior_2", "bos-wf-engine");
                                } else {
                                    String string = this.auditTask.getCustomAuditMsg();
                                    JSONObject multiLangDatas = BpmnModelUtil.getMultiLangDatas(execution.getProcessInstanceId());
                                    ILocaleString auditMsg = BpmnModelUtil.getMultiLangFieldValue(multiLangDatas, this.auditTask.getId() + ".customAuditMsg", string);
                                    for (Lang lang : WfUtils.getSupportLangs()) {
                                        String key = lang.name();
                                        custonAuditMessage.put(key, auditMsg.get((Object)key));
                                    }
                                }
                                auditMessage = custonAuditMessage;
                            }
                            if (!WfUtils.isNotEmpty(hicommentId) || !WfUtils.isNotEmpty(hiAuditNumber)) break;
                            this.autoTask(execution, task, hiAuditNumber, (ILocaleString)auditMessage, assigneeId);
                            manualProcessing = false;
                            execution.setTransientVariable(String.format("%s-%s", task.getTaskDefinitionKey(), "executionType"), "byAuto");
                            break;
                        }
                        case "manual": {
                            break;
                        }
                    }
                }
            }
            if (!manualProcessing && !task.getIdentityLinks().isEmpty() && (same = this.isSameParticaipant(task.getIdentityLinks().get(0).getUserId(), execution.getProcessInstanceId(), execution.getCurrentActInstId())) && (process = ProcessDefinitionUtil.getProcess(execution.getProcessDefinitionId(), execution.getProcessInstanceId())).getProcessMode() != null) {
                switch (process.getProcessMode()) {
                    case "skip": {
                        this.skipTask(execution, task);
                        manualProcessing = false;
                        break;
                    }
                    case "auto": {
                        this.autoTask(execution, task, null, null, null);
                        manualProcessing = false;
                        break;
                    }
                    case "manual": {
                        break;
                    }
                }
            }
        }
        return manualProcessing;
    }

    private void autoTask(DelegateExecution execution, TaskEntity task, String auditNumber, ILocaleString auditMessage, Long assigneeId) {
        DecisionOption autoDecision;
        if (WfUtils.isEmpty(auditNumber)) {
            auditNumber = BpmnModelUtil.getDefaultOptionNumber(this.auditTask);
        }
        if ((autoDecision = BpmnModelUtil.getDecisionOption(this.auditTask, auditNumber)) != null) {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("autoAudit", Boolean.TRUE);
            variables.put("auditNumber", autoDecision.getNumber());
            String multiKey = BpmnModelUtil.getDecisionNameMultiKey(((ExecutionEntity)execution).getActivityId(), autoDecision.getId());
            ILocaleString autoDecisionName = BpmnModelUtil.getMultiLangFieldValue(execution.getProcessInstanceId(), multiKey, autoDecision.getName());
            ILocaleString auto = WfUtils.getPromptWordLocaleString("[\u81ea\u52a8]", "AuditTaskActivityBehavior_1", "bos-wf-engine");
            ILocaleString auditName = WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{new LocaleString("%s%s"), autoDecisionName, auto});
            variables.put("auditName", auditName);
            variables.put("auditType", autoDecision.getAuditType());
            variables.put("decisionscene", autoDecision.getDecisionScene());
            variables.put("auditMessage", auditName);
            if (WfUtils.isNotEmpty(auditMessage)) {
                variables.put("auditMessage", auditMessage);
            }
            if (WfUtils.isEmpty(assigneeId)) {
                assigneeId = task.getIdentityLinks().get(0).getUserId();
            }
            this.logger.debug(String.format("\u81ea\u52a8\u5ba1\u6279\uff1aTaskId:%s  AssigneeId:%s", execution.getCurrentTaskId(), assigneeId));
            AbstractOperation agendaOperation = Context.getCommandContext().getAgendaOperation();
            if (agendaOperation instanceof ContinueProcessOperation) {
                ((ContinueProcessOperation)agendaOperation).getCallbacks().add(new PlanAutoAuditOperationCallback((ExecutionEntity)execution, task, variables, assigneeId));
            } else {
                TaskHelper taskHelper = Context.getProcessEngineConfiguration().getTaskHelper();
                taskHelper.autoAudit((ExecutionEntity)execution, task, variables, assigneeId);
            }
        }
    }

    private void skipTask(DelegateExecution execution, TaskEntity task) {
        String firstApproveOptNum;
        Context.getCommandContext().getTaskEntityManager().changeTaskExecutionType(task, "skip");
        Context.getCommandContext().getTaskHelper().deleteTaskEntity(task, "task skip", false, false);
        String auditNum = (String)((ExecutionEntity)execution).getCurrentTask().getTransientVariableLocal("auditNumber");
        String approveType = BpmnModelUtil.getApproveTypeByNum(this.auditTask, auditNum);
        if (("reject".equals(approveType) || "terminate".equals(approveType)) && WfUtils.isNotEmpty(firstApproveOptNum = BpmnModelUtil.getFirstApproveOptNum(this.auditTask))) {
            ((ExecutionEntity)execution).getCurrentTask().setTransientVariableLocal("auditNumber", firstApproveOptNum);
        }
        Context.getCommandContext().getHistoryManager().recordActivityExecutionType((ExecutionEntity)execution, "skip", "SameParticipant");
        this.leaveByRightWay(execution);
    }

    protected boolean isSameParticaipant(Long userId, Long processInstanceId, Long currentActInstId) {
        boolean same = false;
        TaskHelper taskHelper = Context.getProcessEngineConfiguration().getTaskHelper();
        List<HistoricActivityInstanceEntity> lastNodes = taskHelper.findLastNodes(processInstanceId, currentActInstId, false);
        for (HistoricActivityInstanceEntity lastNode : lastNodes) {
            Long assigneeId;
            if (lastNode.getExecutionType().equals("skip")) {
                same = this.isSameParticaipant(userId, processInstanceId, lastNode.getId());
                continue;
            }
            if (!lastNode.getActivityType().equals("AuditTask") || !userId.equals(assigneeId = lastNode.getAssigneeId())) continue;
            same = true;
            break;
        }
        return same;
    }

    @Override
    public TaskEntity buildTaskEntity(DelegateExecution execution) {
        TaskEntity task = super.buildTaskEntity(execution);
        if (WfUtils.isEmpty(task.getHandleState()) || "willHandled".equalsIgnoreCase(task.getHandleState())) {
            task.setHandleState("willApproval");
        }
        return task;
    }

    protected boolean isSkipFirstUserTask(DelegateExecution execution) {
        return false;
    }

    protected boolean canCreateTodoWhenSameAuditor(CommandContext commandContext, DelegateExecution execution, TaskEntity task) {
        TaskHelper taskHelper = Context.getProcessEngineConfiguration().getTaskHelper();
        return !taskHelper.isStarterSameAsAuditor(task);
    }

    protected void doAutoCoordinate(CommandContext commandContext, ExecutionEntity execution, AuditTask auditTask, Long taskId, List<Long> autoCoordinatorIds) {
        if (!auditTask.isAllowCoordinate()) {
            return;
        }
        AutoCoordinateModel autoCoordinateModel = auditTask.getAutoCoordinateModel();
        if (autoCoordinateModel == null) {
            return;
        }
        AutoCoordinate autoCoordinate = autoCoordinateModel.getAutoCoordinate();
        if (autoCoordinate == null) {
            return;
        }
        if (autoCoordinatorIds == null || autoCoordinatorIds.isEmpty()) {
            return;
        }
        JobEntity autoCoordinateJob = commandContext.getJobManager().createAutoCoordinateJob(execution, taskId, autoCoordinatorIds);
        commandContext.getJobManager().scheduleAsyncJob(autoCoordinateJob);
    }

    private List<Long> covertIdentityToUserIds(List<IdentityLinkEntity> identityLinks) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        if (CollectionUtil.isNotEmpty(identityLinks)) {
            for (IdentityLinkEntity identityLink : identityLinks) {
                userIds.add(identityLink.getUserId());
            }
        }
        return userIds;
    }

    private IPreComputorRecordItem getNextAfterAuditNode(DelegateExecution execution, TaskEntity task) {
        if (WfAfterAuditUtil.canDoAfterAudit(task).booleanValue()) {
            List<IdentityLinkEntity> identityList = task.getIdentityLinks();
            HashSet<Long> participants = new HashSet<Long>(identityList.size());
            for (IdentityLinkEntity identity : identityList) {
                if (!WfUtils.isEmpty(identity.getDelegateId())) continue;
                participants.add(identity.getUserId());
            }
            if (participants.size() != 1) {
                return null;
            }
            Long participant = (Long)participants.iterator().next();
            ExecutionEntity originExecution = task.getExecution();
            IPreComputorRecord record = PreComputorHelper.doAfterAuditPreComputor(execution.getProcessInstanceId());
            task.setExecution(originExecution);
            IPreComputorRecordItem item = PreComputorHelper.getNextAfterAuditNode(record, execution.getCurrentActivityId(), participant);
            if (item != null) {
                return item;
            }
        }
        return null;
    }

    private void saveOperationLog(Long taskId, ILocaleString nodeName) {
        CommandContext commandContext = Context.getCommandContext();
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        operationLog.setTaskId(taskId);
        operationLog.setCreateDate(date);
        operationLog.setType("comment");
        operationLog.setNote(WfMultiLangUtils.replaceILocaleString((ILocaleString)ResManager.getLocaleString((String)"\u5ba1\u6279\u4eba\u540e\u5ba1\u63a7\u5236\uff0c\u4e0e\u540e\u5e8f\u8282\u70b9\uff08%s\uff09\u5904\u7406\u4eba\u76f8\u540c", (String)"AuditTaskActivityBehavior_3", (String)"bos-wf-engine"), nodeName));
        operationLog.setTerminalWay("background");
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }
}

