/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.AutoMicroServiceTask;
import kd.bos.workflow.bpmn.model.AutoService;
import kd.bos.workflow.bpmn.model.InParameter;
import kd.bos.workflow.bpmn.model.Parameter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskActivityBehavior;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.detaillog.DetailLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class AutoMicroServiceTaskActivityBehavior
extends TaskActivityBehavior {
    private AutoMicroServiceTask microServiceTask;

    public AutoMicroServiceTaskActivityBehavior(AutoMicroServiceTask microServiceTask) {
        this.microServiceTask = microServiceTask;
    }

    @Override
    public void execute(DelegateExecution execution) {
        boolean skipWhenBoot = BizFlowUtil.ifSkipWhenBootThenRecordExecutionType(execution, this.microServiceTask);
        if (skipWhenBoot) {
            super.execute(execution);
            return;
        }
        Object result = this.invokeService(execution);
        this.recordDetailLog(execution, result);
        super.execute(execution);
    }

    public Object invokeService(DelegateExecution execution) {
        AutoService autoService = this.microServiceTask.getAutoService();
        if (autoService == null) {
            this.logger.debug("invoke service failed, autoService is null.");
            return null;
        }
        List<Map<String, Object>> inParameters = this.getMicroServiceInParams(execution);
        List<Map<String, Object>> outParameters = this.getMicroServiceOutParams();
        String cloudId = autoService.getCloudId();
        String appId = autoService.getAppId();
        String serviceName = autoService.getServiceName();
        String methodName = autoService.getMethodName();
        this.logger.debug(String.format("invoke-biz-service cloudId: %s, appId: %s, sreviceName: %s, methodName: %s, inParameters: %s, outParameters: %s", cloudId, appId, serviceName, methodName, inParameters, outParameters));
        Object result = null;
        if (ModelType.NoCodeFlow.name().equals(((ExecutionEntity)execution).getProcessType())) {
            this.logger.debug("invoke-biz-service: noCodeFlow.");
            result = DispatchServiceHelper.invokeService((String)"kd.bos.nocode.servicehelper", (String)cloudId, (String)serviceName, (String)methodName, (Object[])new Object[]{inParameters, outParameters});
        } else {
            this.logger.debug("invoke-biz-service: normal.");
            result = DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{inParameters, outParameters});
        }
        HashMap<String, Object> executeResult = new HashMap<String, Object>();
        executeResult.put("fetchType", this.microServiceTask.getFetchType());
        List<Parameter> outParams = this.microServiceTask.getOutParams();
        if (outParams == null || outParams.isEmpty()) {
            executeResult.put("value", result);
        } else {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            if (result instanceof Map) {
                Map map = (Map)result;
                for (Parameter outParam : outParams) {
                    ret.put(outParam.getNumber(), map.get(outParam.getNumber()));
                }
            } else if (result instanceof DynamicObject) {
                DynamicObject dynObj = (DynamicObject)result;
                for (Parameter outParam : outParams) {
                    ret.put(outParam.getNumber(), dynObj.get(outParam.getNumber()));
                }
            } else {
                this.logger.debug(String.format("unrecognizable-result: %s", result != null ? result.getClass() : null));
                if (outParams.size() == 1) {
                    String number = outParams.get(0).getNumber();
                    ret.put(number, result);
                }
            }
            executeResult.put("value", ret);
            this.assignValueToExecuteResultMacro(execution, ret);
        }
        execution.setVariable(String.format("%sExecuteResult", this.microServiceTask.getId()), executeResult);
        return result;
    }

    private void recordDetailLog(DelegateExecution execution, Object result) {
        if (execution instanceof ExecutionEntity && ProcessType.NoCodeFlow.name().equals(((ExecutionEntity)execution).getProcessType())) {
            String template;
            CommandContext commandContext = Context.getCommandContext();
            DetailLogEntityImpl detailLog = new DetailLogEntityImpl();
            detailLog.setProcInstId(execution.getProcessInstanceId());
            detailLog.setActivityId(this.microServiceTask.getId());
            if (WfUtils.isNotEmpty(this.microServiceTask.getEntityNumber())) {
                detailLog.setEntityNumber(this.microServiceTask.getEntityNumber());
            }
            if (WfUtils.isNotEmpty(this.microServiceTask.getEntityName())) {
                detailLog.setEntityName((ILocaleString)new LocaleString(this.microServiceTask.getEntityName()));
            }
            if ("QueryDataAutoTask".equals(template = this.microServiceTask.getTemplate())) {
                detailLog.setOpinion((ILocaleString)new LocaleString(String.valueOf(result != null)));
            } else if ("CalculateAutoTask".equals(template)) {
                String retStr = WfUtils.subStringForMax(String.valueOf(result), 500);
                detailLog.setOpinion((ILocaleString)new LocaleString(retStr));
            }
            commandContext.getDetailLogEntityManager().recordDetailLog(commandContext, detailLog);
        }
    }

    private List<Map<String, Object>> getMicroServiceInParams(DelegateExecution execution) {
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(16);
        List<InParameter> inParameters = this.microServiceTask.getInParams();
        for (InParameter inParameter : inParameters) {
            List<Parameter> inParams = inParameter.getParams();
            HashMap<String, List<Map<String, Object>>> param = new HashMap<String, List<Map<String, Object>>>(inParams.size());
            for (Parameter inParam : inParams) {
                String number = inParam.getNumber();
                List<Map<String, Object>> value = inParam.getValue();
                if ("${execution.businessKey}".equals(value)) {
                    value = execution.getBusinessKey();
                } else if ("${execution.entityNumber}".equals(value)) {
                    value = execution.getEntityNumber();
                } else if ("${execution.procInstId}".equals(value)) {
                    value = execution.getProcessInstanceId();
                } else if (value instanceof String) {
                    value = this.getExpressionParsedValue(execution, value.toString());
                } else if (value == null) {
                    value = this.microServiceTask.getAttributeValue(number);
                }
                switch (number) {
                    case "topNumber": {
                        value = this.getTopNumberValue(value);
                        break;
                    }
                    case "orderby": {
                        value = this.getOrderByValue(value);
                        break;
                    }
                    case "filter": {
                        value = this.getFilterValue(execution, value);
                        break;
                    }
                }
                param.put(number, value);
            }
            params.add(param);
        }
        return params;
    }

    private List<Map<String, Object>> getMicroServiceOutParams() {
        List<Parameter> outParams = this.microServiceTask.getOutParams();
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(outParams.size());
        for (Parameter parameter : outParams) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("number", parameter.getNumber());
            param.put("name", parameter.getName());
            param.put("type", parameter.getType());
            params.add(param);
        }
        return params;
    }

    private void assignValueToExecuteResultMacro(DelegateExecution execution, Map<String, Object> result) {
        String regex = "\\$\\{proc\\.(\\w+ExecuteResult)\\.(\\w+)\\}";
        List<Parameter> outParams = this.microServiceTask.getOutParams();
        HashMap variableMap = new HashMap(16);
        for (Parameter parameter : outParams) {
            String[] expressions;
            String assignment = parameter.getAssignment();
            if (WfUtils.isEmpty(assignment)) continue;
            for (String expression : expressions = assignment.split(",")) {
                if (expression == null || !expression.matches(regex)) continue;
                String macroKey = expression.replaceFirst(regex, "$1");
                HashMap variableVal = (HashMap)variableMap.get(macroKey);
                if (variableVal == null) {
                    Object macroValue = execution.getVariable(macroKey);
                    if (macroValue instanceof Map) {
                        variableVal = (Map)macroValue;
                    } else {
                        variableVal = new HashMap();
                        this.logger.debug(String.format("%s macroValue is not a Map. class: %s", macroKey, macroValue != null ? macroValue.getClass() : null));
                    }
                    variableMap.put(macroKey, variableVal);
                }
                Map ret = (Map)variableVal.get("value");
                String property = expression.replaceFirst(regex, "$2");
                if (ret == null || !ret.containsKey(property)) continue;
                ret.put(property, result.get(parameter.getNumber()));
            }
        }
        for (Map.Entry entry : variableMap.entrySet()) {
            String macroKey = (String)entry.getKey();
            Map macroValue = (Map)entry.getValue();
            if (macroValue.isEmpty()) continue;
            execution.setVariable(macroKey, macroValue);
            this.logger.debug(String.format("update macro %s value %s. entityNumber: %s, businessKey: %s", macroKey, macroValue, execution.getEntityNumber(), execution.getBusinessKey()));
        }
    }

    private List<Map<String, Object>> getOrderByValue(Object value) {
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (value instanceof String) {
            String orderByStr = (String)value;
            if (WfUtils.isEmpty(orderByStr)) {
                return result;
            }
            JSONArray orderBys = JSON.parseArray((String)orderByStr);
            for (Object obj : orderBys) {
                JSONObject orderBy = (JSONObject)obj;
                result.add((Map<String, Object>)orderBy);
            }
        } else if (value instanceof List) {
            result = (List)value;
        }
        return result;
    }

    private List<Map<String, Object>> getFilterValue(DelegateExecution execution, Object value) {
        List<Map<String, Object>> result;
        block4: {
            String valueKey;
            block3: {
                result = new ArrayList<Map<String, Object>>();
                valueKey = "value";
                if (!(value instanceof String)) break block3;
                String filterStr = (String)value;
                if (WfUtils.isEmpty(filterStr)) {
                    return result;
                }
                JSONArray filters = JSON.parseArray((String)filterStr);
                for (Object obj : filters) {
                    JSONObject filter = (JSONObject)obj;
                    String val = filter.getString(valueKey);
                    filter.put(valueKey, this.getExpressionParsedValue(execution, val));
                    result.add((Map<String, Object>)filter);
                }
                break block4;
            }
            if (!(value instanceof List)) break block4;
            result = (List)value;
            for (Map<String, Object> ret : result) {
                String val = (String)ret.get(valueKey);
                ret.put(valueKey, this.getExpressionParsedValue(execution, val));
            }
        }
        return result;
    }

    private int getTopNumberValue(Object value) {
        String topNumber;
        if (value instanceof String && (topNumber = (String)value).matches("\\d+")) {
            return Integer.parseInt(topNumber);
        }
        return 1;
    }

    private Object getExpressionParsedValue(DelegateExecution execution, String expression) {
        String procType;
        Object value = expression;
        if (expression == null) {
            return value;
        }
        String entityNumber = execution.getEntityNumber();
        String businessKey = execution.getBusinessKey();
        DynamicObject bill = WfUtils.findBusinessObject(businessKey, entityNumber);
        String string = procType = execution instanceof ExecutionEntity ? ((ExecutionEntity)execution).getProcessType() : "";
        if (ModelType.NoCodeFlow.name().equals(procType)) {
            Pattern pattern = Pattern.compile(String.format("(%s)", "\\$?\\{\\s*proc\\..+?\\}"));
            Matcher matcher = pattern.matcher(expression);
            HashMap<String, Object> expressionMap = new HashMap<String, Object>(16);
            while (matcher.find()) {
                String exp = matcher.group();
                expressionMap.put(exp, ExpressionCalculatorUtil.parseValue(bill, execution, exp, null));
            }
            int size = expressionMap.size();
            if (size > 0) {
                for (Map.Entry entry : expressionMap.entrySet()) {
                    if (size == 1 && expression.equals(entry.getKey())) {
                        value = entry.getValue();
                        break;
                    }
                    String key = ((String)entry.getKey()).replace("$", "\\$").replace("{", "\\{").replace("}", "\\}");
                    String val = entry.getValue() != null ? String.valueOf(entry.getValue()) : "";
                    value = value.toString().replaceAll(key, val.replace("$", "\\$"));
                }
            }
        } else if (expression.indexOf("${") > -1) {
            value = ExpressionCalculatorUtil.parseValue(bill, execution, expression, null);
        }
        return value;
    }
}

