/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import kd.bos.exception.KDBizException;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.bpmn.behavior.SkipInfo;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskActivityBehavior;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.AutoTaskUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFBizException;

public class AutoTaskActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected AutoTask autoTask;

    public AutoTaskActivityBehavior(AutoTask autoTask) {
        this.autoTask = autoTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(DelegateExecution execution) {
        boolean skipWhenBoot = BizFlowUtil.ifSkipWhenBootThenRecordExecutionType(execution, this.autoTask);
        if (skipWhenBoot) {
            super.execute(execution);
            return;
        }
        SkipInfo skip = DynamicFlowUtil.isSkipNode((ExecutionEntity)execution);
        if (!skip.isSkip()) {
            try {
                this.replaceServiceExecutor(execution, this.autoTask);
                execution.setEventName("autoTask");
                AutoTaskUtil.executeExternalInterface(this.autoTask, execution, false);
                super.execute(execution);
                return;
            }
            catch (Exception e) {
                if (e instanceof WFBizException && ((WFBizException)((Object)e)).getCause() != null && ((WFBizException)((Object)e)).getCause() instanceof KDBizException) {
                    KDBizException kdBizExeception = (KDBizException)((WFBizException)((Object)e)).getCause();
                    if (ExceptionUtil.matchBoundryException(kdBizExeception, (ExecutionEntity)execution)) return;
                    throw e;
                }
                if (!(e instanceof KDBizException)) throw e;
                KDBizException kdBizExeception = (KDBizException)((Object)e);
                if (ExceptionUtil.matchBoundryException(kdBizExeception, (ExecutionEntity)execution)) return;
                throw e;
            }
            finally {
                execution.setEventName(null);
            }
        } else {
            this.logger.debug(String.format("\u8282\u70b9[%s-%s] skip", this.autoTask.getId(), this.autoTask.getName()));
            CommandContext commandContext = Context.getCommandContext();
            commandContext.getHistoryManager().recordActivityExecutionType((ExecutionEntity)execution, skip.getExecutionType(), skip.getSkipReason());
            super.execute(execution);
        }
    }
}

