/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.BillCloseConfig;
import kd.bos.workflow.bpmn.model.BillRelationshipModel;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.WaitActions;
import kd.bos.workflow.bpmn.model.WaitCloseEvent;
import kd.bos.workflow.bpmn.model.WaitCloseOperation;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.delegate.ActivityBehavior;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.exception.WFEngineException;

public class BillTaskActivityBehavior
extends UserTaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected BillTask billTask;
    private boolean skipWhenBoot;

    public BillTaskActivityBehavior(BillTask billTask) {
        super(billTask);
        this.billTask = billTask;
    }

    @Override
    public void execute(DelegateExecution exec) {
        this.skipWhenBoot = BizFlowUtil.ifSkipWhenBootThenRecordExecutionType(exec, this.billTask);
        if (this.skipWhenBoot || DynamicFlowUtil.isSkipCurNode(exec)) {
            this.logger.debug("leave by skip" + this.skipWhenBoot);
            this.leaveByRightWay(exec);
            return;
        }
        ExecutionEntity execution = (ExecutionEntity)exec;
        this.insertWaitActionsEventSubscription(execution);
        SequenceFlow incomingFlow = this.getIncomingFlow(execution);
        this.logger.debug(String.format("sequenceFlow[%s]", incomingFlow == null ? null : incomingFlow.getNumber()));
        BillRelationshipModel conversion = incomingFlow == null ? null : incomingFlow.getBillRelationshipModel();
        String stateKey = String.format("%s.%s", "conversionTask", this.billTask.getId());
        boolean newTask = conversion != null && "botpTargetBills".equals(conversion.getRelationType()) && ("manualpush".equals(conversion.getConversionMode()) || "manualdraw".equals(conversion.getConversionMode())) && execution.getVariable(stateKey) == null && BizFlowUtil.isNonBootNode(execution, this.billTask);
        this.logger.debug(String.format("bk[%s],stateKey[%s]-RelationType[%s]-isNonBootNode[%s]", execution.getBusinessKey(), execution.getVariable(stateKey), conversion == null ? "" : conversion.getRelationType(), BizFlowUtil.isNonBootNode(execution, this.billTask)));
        if (newTask) {
            super.execute(execution);
            TaskEntity task = execution.getCurrentTask();
            this.setTaskExecutionType(task, incomingFlow);
            execution.setVariableLocal(stateKey, task.getId());
        } else {
            CallActivity callActivity = this.billTask.getCallActivity();
            if (callActivity != null) {
                String bizCallActivityCode = String.format("%s.%s", this.billTask.getId(), execution.getCurrentActInstId());
                execution.setVariable("bizFlowCallActivityKey", bizCallActivityCode);
                ActivityBehavior activityBehavior = (ActivityBehavior)callActivity.getBehavior();
                activityBehavior.execute(execution);
            } else {
                String op;
                if (execution.getParent() != null && execution.getParent().isBillExecution() && WfUtils.isNotEmpty(op = (String)execution.getParent().getVariableLocal("_operation_"))) {
                    boolean continueFlow;
                    boolean bl = continueFlow = WfUtils.isEmpty(this.billTask.getOperationStr()) || WfUtils.isNotEmpty(this.billTask.getOperationStr()) && Arrays.asList(this.billTask.getOperationStr().split(",")).contains(op);
                    if (!continueFlow) {
                        boolean wait;
                        String converionMode = conversion == null ? null : conversion.getConversionMode();
                        String convertType = (String)execution.getParent().getVariableLocal("convertType");
                        String bootNodeId = (String)execution.getVariable("bootNodeId");
                        boolean bl2 = wait = ("manualpush".equalsIgnoreCase(converionMode) || "manualdraw".equalsIgnoreCase(converionMode)) && ("manualMountMultiSrcsBillCalculate".equalsIgnoreCase(convertType) || "selfBillCalculator".equalsIgnoreCase(convertType)) || this.billTask.getId().equalsIgnoreCase(bootNodeId);
                        if (wait) {
                            execution.setVariableLocal("MountOperationNotMatch", Boolean.TRUE);
                            this.logger.debug(String.format("operation is not match[%s-%s],with[%s-%s]", execution.getBusinessKey(), execution.getEntityNumber(), converionMode, convertType));
                            return;
                        }
                        this.logger.debug(String.format("operation can leave[%s-%s],with[%s-%s]", execution.getBusinessKey(), execution.getEntityNumber(), converionMode, convertType));
                    }
                }
                this.leaveByRightWay(execution);
            }
        }
    }

    private void insertWaitActionsEventSubscription(ExecutionEntity execution) {
        WaitCloseEvent closeEvent = this.getWaitCloseEvent();
        if (closeEvent != null && WfUtils.isNotEmpty(closeEvent.getNumber())) {
            Context.getCommandContext().getEventSubscriptionEntityManager().insertWaitActionsEventSubscription(execution, this.billTask.getId(), closeEvent.getNumber());
        }
    }

    private WaitCloseEvent getWaitCloseEvent() {
        WaitActions waitActions;
        WaitCloseEvent closeEvent = null;
        BillCloseConfig billCloseConfig = this.billTask.getBillCloseConfig();
        if (billCloseConfig != null && billCloseConfig.getBillCloseCondition() != null && (waitActions = billCloseConfig.getWaitActions()) != null) {
            closeEvent = waitActions.getCloseEvent();
        }
        return closeEvent;
    }

    private void setTaskExecutionType(TaskEntity task, SequenceFlow incomingFlow) {
        if (incomingFlow != null && incomingFlow.getBillRelationshipModel() != null) {
            String conversionMode = incomingFlow.getBillRelationshipModel().getConversionMode();
            String executionType = "byHand";
            if ("manualpush".equals(conversionMode)) {
                executionType = "manualpush";
            } else if ("manualdraw".equals(conversionMode)) {
                executionType = "manualdraw";
            }
            CommandContext commandContext = Context.getCommandContext();
            commandContext.getTaskEntityManager().changeTaskExecutionType(task, executionType);
        }
    }

    private SequenceFlow getIncomingFlow(ExecutionEntity execution) {
        try {
            List<SequenceFlow> seqs = this.billTask.getIncomingFlows();
            if (seqs != null && seqs.size() == 1) {
                return seqs.get(0);
            }
            CommandContext commandContext = Context.getCommandContext();
            HistoricActivityInstanceEntityManager actInstMgr = commandContext.getHistoricActivityInstanceEntityManager();
            String curActId = execution.getActivityId();
            Long curActInstId = execution.getCurrentActInstId();
            int max = 0;
            SequenceFlow flow = null;
            HistoricActivityInstanceEntity actInst = null;
            HistoricActivityInstanceEntity sequenceActInst = null;
            for (int index = 0; index < max || max == 0; ++index) {
                actInst = (HistoricActivityInstanceEntity)actInstMgr.findById(curActInstId);
                if (max == 0) {
                    max = actInst.getStep();
                }
                if ((sequenceActInst = (HistoricActivityInstanceEntity)actInstMgr.findById(actInst.getSourceElementId(), "activityId")) == null) continue;
                FlowElement element = ProcessDefinitionUtil.getFlowElement(execution.getProcessDefinitionId(), execution.getProcessInstanceId(), sequenceActInst.getActivityId());
                if (element instanceof SequenceFlow) {
                    flow = (SequenceFlow)element;
                    break;
                }
                if (element instanceof FlowNode && !element.getId().equalsIgnoreCase(curActId)) break;
                if (!element.getId().equalsIgnoreCase(curActId)) continue;
                curActInstId = actInst.getSourceElementId();
            }
            return flow;
        }
        catch (RuntimeException e) {
            throw new WFEngineException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u8282\u70b9[%s]\u8ba1\u7b97\u5165\u53e3\u7ebf\u5931\u8d25\uff0c\u8bf7\u5173\u6ce8\u6570\u636e\u6b63\u786e\u6027\u3002", (String)"BillTaskActivityBehavior_1", (String)"bos-wf-engine", (Object[])new Object[0]), execution.getActivityId()), e);
        }
    }

    @Override
    public TaskEntity buildTaskEntity(DelegateExecution execution) {
        TaskEntity task = super.buildTaskEntity(execution);
        try {
            DynamicObject billInfo = WfUtils.findBusinessObject(execution.getBusinessKey(), execution.getEntityNumber(), "creator");
            long creator = billInfo.getLong("creator_id");
            ILocaleString createName = WfUtils.findUserName(creator);
            ILocaleString createNameFormat = ParticipantHelper.getUserNameFormatValue((Long)creator, (ExecutionEntity)execution, (ILocaleString)new LocaleString());
            task.setStarterId(creator);
            task.setStartName(createName);
            task.setStartNameFormat(createNameFormat);
            task.setSenderId(String.valueOf(creator));
            task.setSenderName(createName);
            task.setSenderNameFormat(createNameFormat);
        }
        catch (Exception exception) {
            this.logger.warn("bill has no creator field...");
        }
        if (WfUtils.isEmpty(task.getSenderId())) {
            Long startUserId = execution.getStartUserId();
            task.setSenderId(String.valueOf(startUserId));
            task.setSenderName(WfUtils.findUserName(startUserId));
        }
        if (WfUtils.isEmpty(task.getHandleState()) || "willHandled".equalsIgnoreCase(task.getHandleState())) {
            task.setHandleState("unConverted");
        }
        task.setFormKey(task.getEntityNumber());
        return task;
    }

    @Override
    public void leave(DelegateExecution execution) {
        if (this.skipWhenBoot) {
            this.logger.debug(String.format("%s is skipped when boot. executionId: %s", this.billTask.getId(), execution.getId()));
            super.leave(execution);
            return;
        }
        BillCloseConfig billCloseConfig = this.billTask.getBillCloseConfig();
        if (billCloseConfig != null && billCloseConfig.getBillCloseCondition() != null) {
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            if (BizFlowUtil.isMeetBillCloseCondition(this.billTask, executionEntity)) {
                this.logger.debug(String.format("Meet the closing conditions, leave. executionId: %s, actId: %s", execution.getId(), this.billTask.getId()));
                super.leave(execution);
                return;
            }
            WaitActions waitActions = billCloseConfig.getWaitActions();
            if (waitActions != null) {
                boolean hasEvent;
                WaitCloseEvent closeEvent = waitActions.getCloseEvent();
                List<WaitCloseOperation> operations = waitActions.getOperations();
                boolean hasOperation = operations != null && !operations.isEmpty();
                boolean bl = hasEvent = closeEvent != null && WfUtils.isNotEmpty(closeEvent.getNumber());
                if (hasOperation || hasEvent) {
                    if (hasOperation && this.canLeaveByOperation(executionEntity, operations)) {
                        super.leave(executionEntity);
                        return;
                    }
                    if (hasEvent && this.canLeaveByEvent(executionEntity, closeEvent)) {
                        super.leave(executionEntity);
                        return;
                    }
                    this.logger.debug(String.format("conditions or event are not met, wait... executionId: %s, actId: %s, hasOperation: %s, hasEvent: %s ", execution.getId(), this.billTask.getId(), hasOperation, hasEvent));
                    return;
                }
            }
        }
        super.leave(execution);
    }

    /*
     * WARNING - void declaration
     */
    private boolean canLeaveByOperation(DelegateExecution execution, List<WaitCloseOperation> operations) {
        void var5_8;
        HashSet<String> opers = new HashSet<String>(operations.size());
        for (WaitCloseOperation waitCloseOperation : operations) {
            opers.add(waitCloseOperation.getNumber());
        }
        DelegateExecution billExecution = execution.getParent();
        Object var5_6 = null;
        String oper = (String)billExecution.getVariableLocal("_operations_");
        if (oper != null) {
            String[] os = oper.split(",");
            String string = os[os.length - 1];
        }
        if (var5_8 != null && opers.contains(var5_8)) {
            this.logger.debug(String.format("Operation matching, leave. executionId: %s, actId: %s, operation: %s", execution.getId(), this.billTask.getId(), var5_8));
            return true;
        }
        this.logger.debug(String.format("Waiting operations are not met. executionId: %s, actId: %s, operation: %s", execution.getId(), this.billTask.getId(), var5_8));
        return false;
    }

    private boolean canLeaveByEvent(DelegateExecution execution, WaitCloseEvent closeEvent) {
        if (closeEvent.getCondition() != null && ConditionUtil.hasTrueCondition(closeEvent.getCondition(), (VariableScope)execution, String.format("%s-billCloseConfig-closeEvent-condition", this.billTask.getId()))) {
            this.logger.debug(String.format("CloseEvent Condition is true, leave. executionId: %s, actId: %s", execution.getId(), this.billTask.getId()));
            return true;
        }
        if (Boolean.TRUE.equals(execution.getTransientVariable("satisfiesWaitActionsCondition"))) {
            this.logger.debug(String.format("Event matching, leave. executionId: %s, actId: %s, event: %s", execution.getId(), this.billTask.getId(), closeEvent.getNumber()));
            return true;
        }
        this.logger.debug(String.format("Waiting conditions are not met. executionId: %s, actId: %s", execution.getId(), this.billTask.getId()));
        return false;
    }

    @Override
    protected boolean canCreateTodo(CommandContext commandContext, String taskId, DelegateExecution execution) {
        String type = "";
        SequenceFlow incomingFlow = this.getIncomingFlow((ExecutionEntity)execution);
        if (incomingFlow != null) {
            BillRelationshipModel conversionInfo = incomingFlow.getBillRelationshipModel();
            if (conversionInfo != null) {
                type = conversionInfo.getConversionMode();
            }
            if ("auto".equals(type)) {
                return false;
            }
        }
        return true;
    }
}

