/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.util.HashMap;
import java.util.List;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.helper.ScopeUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.CompensateEventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.exception.WFEngineException;

public class BoundaryCancelEventActivityBehavior
extends BoundaryEventActivityBehavior {
    private static final long serialVersionUID = 1L;

    @Override
    public void trigger(DelegateExecution execution, String triggerName, Object triggerData) {
        BoundaryEvent boundaryEvent = (BoundaryEvent)execution.getCurrentFlowElement();
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        DelegateExecution subProcessExecution = null;
        List<ExecutionEntity> processInstanceExecutions = executionEntityManager.findChildExecutionsByProcessInstanceId(execution.getProcessInstanceId());
        for (ExecutionEntity childExecution : processInstanceExecutions) {
            if (childExecution.getCurrentFlowElement() == null || !childExecution.getCurrentFlowElement().getId().equals(boundaryEvent.getAttachedToRefId())) continue;
            subProcessExecution = childExecution;
            break;
        }
        if (subProcessExecution == null) {
            throw new WFEngineException("No execution found for sub process of boundary cancel event " + boundaryEvent.getId());
        }
        EventSubscriptionEntityManager eventSubscriptionEntityManager = commandContext.getEventSubscriptionEntityManager();
        List<CompensateEventSubscriptionEntity> eventSubscriptions = eventSubscriptionEntityManager.findCompensateEventSubscriptionsByExecutionId(subProcessExecution.getParentId());
        if (eventSubscriptions.isEmpty()) {
            this.leave(execution);
        } else {
            Activity activity;
            String deleteReason = "boundary event(" + boundaryEvent.getId() + ")";
            ScopeUtil.throwCompensationEvent(eventSubscriptions, execution, false, new HashMap<String, Object>());
            executionEntityManager.deleteExecutionAndRelatedData((ExecutionEntity)subProcessExecution, deleteReason, false);
            if (subProcessExecution.getCurrentFlowElement() instanceof Activity && (activity = (Activity)subProcessExecution.getCurrentFlowElement()).getLoopCharacteristics() != null) {
                ExecutionEntity miExecution = subProcessExecution.getParent();
                List<ExecutionEntity> miChildExecutions = executionEntityManager.findChildExecutionsByParentExecutionId(miExecution.getId());
                for (ExecutionEntity miChildExecution : miChildExecutions) {
                    if (subProcessExecution.getId().equals(miChildExecution.getId()) || !activity.getId().equals(miChildExecution.getCurrentActivityId())) continue;
                    executionEntityManager.deleteExecutionAndRelatedData(miChildExecution, deleteReason, false);
                }
            }
            this.leave(execution);
        }
    }
}

