/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.util.List;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.event.ActivitiActivityEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandExecutor;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.exception.WFEngineException;

public class BoundaryEventActivityBehavior
extends FlowNodeActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected boolean interrupting;

    public BoundaryEventActivityBehavior() {
    }

    public BoundaryEventActivityBehavior(boolean interrupting) {
        this.interrupting = interrupting;
    }

    @Override
    public void execute(DelegateExecution execution) {
    }

    @Override
    public void trigger(DelegateExecution execution, String triggerName, Object triggerData) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        CommandContext commandContext = Context.getCommandContext();
        if (this.interrupting) {
            this.executeInterruptingBehavior(executionEntity, commandContext);
        } else {
            this.executeNonInterruptingBehavior(executionEntity, commandContext);
        }
        FlowNode flowNode = (FlowNode)executionEntity.getCurrentFlowElement();
        ActivitiActivityEvent enterBoundaryErrorEvent = ActivitiEventBuilder.createActivityEvent(ActivitiEventType.NODE_ENTERBOUNDARYERROR, flowNode.getId(), flowNode.getName(), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), execution.getBusinessKey(), flowNode);
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(enterBoundaryErrorEvent);
        }
    }

    protected void executeInterruptingBehavior(ExecutionEntity executionEntity, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        ExecutionEntity attachedRefScopeExecution = (ExecutionEntity)executionEntityManager.findById(executionEntity.getParentId());
        Long attachedRefActInstId = attachedRefScopeExecution.getCurrentActInstId();
        if (WfUtils.isNotEmpty(attachedRefActInstId)) {
            commandContext.getHiUserActInstEntityManager().makeEnd(executionEntity.getProcessInstanceId(), attachedRefActInstId);
        }
        ExecutionEntity parentScopeExecution = null;
        ExecutionEntity currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(attachedRefScopeExecution.getParentId());
        while (currentlyExaminedExecution != null && parentScopeExecution == null) {
            if (currentlyExaminedExecution.isScope()) {
                parentScopeExecution = currentlyExaminedExecution;
                continue;
            }
            currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(currentlyExaminedExecution.getParentId());
        }
        if (parentScopeExecution == null) {
            throw new WFEngineException("Programmatic error: no parent scope execution found for boundary event");
        }
        this.deleteChildExecutions(attachedRefScopeExecution, executionEntity, commandContext);
        executionEntity.setParent(parentScopeExecution);
        Context.getAgenda().planTakeOutgoingSequenceFlowsOperation(executionEntity, true);
    }

    protected void executeNonInterruptingBehavior(ExecutionEntity executionEntity, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        ExecutionEntity parentExecutionEntity = (ExecutionEntity)executionEntityManager.findById(executionEntity.getParentId());
        ExecutionEntity scopeExecution = null;
        ExecutionEntity currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(parentExecutionEntity.getParentId());
        while (currentlyExaminedExecution != null && scopeExecution == null) {
            if (currentlyExaminedExecution.isScope()) {
                scopeExecution = currentlyExaminedExecution;
                continue;
            }
            currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(currentlyExaminedExecution.getParentId());
        }
        if (scopeExecution == null) {
            throw new WFEngineException("Programmatic error: no parent scope execution found for boundary event");
        }
        ExecutionEntity nonInterruptingExecution = executionEntityManager.createChildExecution(scopeExecution);
        nonInterruptingExecution.setCurrentFlowElement(executionEntity.getCurrentFlowElement());
        Context.getAgenda().planTakeOutgoingSequenceFlowsOperation(nonInterruptingExecution, true);
    }

    protected void deleteChildExecutions(final ExecutionEntity parentExecution, ExecutionEntity notToDeleteExecution, CommandContext commandContext) {
        ExecutionEntity subProcessExecution;
        final ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        List<ExecutionEntity> childExecutions = executionEntityManager.findChildExecutionsByParentExecutionId(parentExecution.getId());
        if (CollectionUtil.isNotEmpty(childExecutions)) {
            for (ExecutionEntity childExecution : childExecutions) {
                if (childExecution.getId().equals(notToDeleteExecution.getId())) continue;
                this.deleteChildExecutions(childExecution, notToDeleteExecution, commandContext);
            }
        }
        final String deleteReason = "boundary event (" + notToDeleteExecution.getCurrentActivityId() + ")";
        if (parentExecution.getCurrentFlowElement() instanceof CallActivity && (subProcessExecution = executionEntityManager.findSubProcessInstanceBySuperExecutionId(parentExecution.getId())) != null) {
            executionEntityManager.deleteProcessInstanceExecutionEntity(subProcessExecution.getId(), subProcessExecution.getCurrentActivityId(), deleteReason, true, false, true);
        }
        parentExecution.setDeleted(true);
        commandContext.addCloseListener(new DefaultCommandContextCloseListener("BoundaryEventActivityBehavior"){

            @Override
            public void closed(CommandContext commandContext) {
                super.closed(commandContext);
                CommandExecutor commandExecutor = commandContext.getProcessEngineConfiguration().getCommandExecutor();
                CommandConfig commandConfig = commandExecutor.getDefaultConfig().transactionRequiresNew();
                commandExecutor.execute(commandConfig, new Command<Void>(){

                    @Override
                    public Void execute(CommandContext commandContext) {
                        executionEntityManager.deleteExecutionAndRelatedData(parentExecution, deleteReason, false);
                        return null;
                    }
                });
            }
        });
    }

    public boolean isInterrupting() {
        return this.interrupting;
    }

    public void setInterrupting(boolean interrupting) {
        this.interrupting = interrupting;
    }
}

