/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.util.List;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.MessageEventDefinition;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.Expression;
import kd.bos.workflow.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.MessageEventSubscriptionEntity;
import org.apache.commons.lang.StringUtils;

public class BoundaryMessageEventActivityBehavior
extends BoundaryEventActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected MessageEventDefinition messageEventDefinition;

    public BoundaryMessageEventActivityBehavior(MessageEventDefinition messageEventDefinition, boolean interrupting) {
        super(interrupting);
        this.messageEventDefinition = messageEventDefinition;
    }

    @Override
    public void execute(DelegateExecution execution) {
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        String messageName = null;
        if (StringUtils.isNotEmpty((String)this.messageEventDefinition.getMessageRef())) {
            messageName = this.messageEventDefinition.getMessageRef();
        } else {
            Expression messageExpression = commandContext.getProcessEngineConfiguration().getExpressionManager().createExpression(this.messageEventDefinition.getMessageExpression());
            messageName = messageExpression.getValue(execution).toString();
        }
        commandContext.getEventSubscriptionEntityManager().insertMessageEvent(messageName, executionEntity);
    }

    @Override
    public void trigger(DelegateExecution execution, String triggerName, Object triggerData) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        BoundaryEvent boundaryEvent = (BoundaryEvent)execution.getCurrentFlowElement();
        if (boundaryEvent.isCancelActivity()) {
            EventSubscriptionEntityManager eventSubscriptionEntityManager = Context.getCommandContext().getEventSubscriptionEntityManager();
            List<EventSubscriptionEntity> eventSubscriptions = executionEntity.getEventSubscriptions();
            for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
                if (!(eventSubscription instanceof MessageEventSubscriptionEntity) || !eventSubscription.getEventName().equals(this.messageEventDefinition.getMessageRef())) continue;
                eventSubscriptionEntityManager.delete(eventSubscription);
            }
        }
        super.trigger(executionEntity, triggerName, triggerData);
    }
}

