/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.util.List;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.Signal;
import kd.bos.workflow.bpmn.model.SignalEventDefinition;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.Expression;
import kd.bos.workflow.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SignalEventSubscriptionEntity;
import org.apache.commons.lang.StringUtils;

public class BoundarySignalEventActivityBehavior
extends BoundaryEventActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected SignalEventDefinition signalEventDefinition;
    protected Signal signal;

    public BoundarySignalEventActivityBehavior(SignalEventDefinition signalEventDefinition, Signal signal, boolean interrupting) {
        super(interrupting);
        this.signalEventDefinition = signalEventDefinition;
        this.signal = signal;
    }

    @Override
    public void execute(DelegateExecution execution) {
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        String signalName = null;
        if (StringUtils.isNotEmpty((String)this.signalEventDefinition.getSignalRef())) {
            signalName = this.signalEventDefinition.getSignalRef();
        } else {
            Expression signalExpression = commandContext.getProcessEngineConfiguration().getExpressionManager().createExpression(this.signalEventDefinition.getSignalExpression());
            signalName = signalExpression.getValue(execution).toString();
        }
        commandContext.getEventSubscriptionEntityManager().insertSignalEvent(signalName, this.signal, executionEntity);
    }

    @Override
    public void trigger(DelegateExecution execution, String triggerName, Object triggerData) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        BoundaryEvent boundaryEvent = (BoundaryEvent)execution.getCurrentFlowElement();
        if (boundaryEvent.isCancelActivity()) {
            String eventName = null;
            eventName = this.signal != null ? this.signal.getName() : this.signalEventDefinition.getSignalRef();
            EventSubscriptionEntityManager eventSubscriptionEntityManager = Context.getCommandContext().getEventSubscriptionEntityManager();
            List<EventSubscriptionEntity> eventSubscriptions = executionEntity.getEventSubscriptions();
            for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
                if (!(eventSubscription instanceof SignalEventSubscriptionEntity) || !eventSubscription.getEventName().equals(eventName)) continue;
                eventSubscriptionEntityManager.delete(eventSubscription);
            }
        }
        super.trigger(executionEntity, triggerName, triggerData);
    }
}

