/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.BroadcastTask;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskActivityBehavior;
import kd.bos.workflow.engine.impl.cmd.WaitActionsEventReceivedCmd;
import kd.bos.workflow.engine.impl.cmd.WaitEventReceivedCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.service.impl.WorkflowServiceImpl;

public class BroadcastTaskActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = 6246802857968393914L;
    private BroadcastTask broadcastTask;

    public BroadcastTaskActivityBehavior(BroadcastTask broadcastTask) {
        this.broadcastTask = broadcastTask;
    }

    @Override
    public void execute(DelegateExecution execution) {
        boolean skipWhenBoot = BizFlowUtil.ifSkipWhenBootThenRecordExecutionType(execution, this.broadcastTask);
        if (skipWhenBoot) {
            this.logger.info(String.format("leave... executionId: %s, businessKey: %s", execution.getId(), execution.getBusinessKey()));
            super.leave(execution);
            return;
        }
        this.triggerWaitEvent(execution);
        this.triggerBillTaskWaitActionsEvent(execution);
        this.triggerSubscriptionEvent(execution);
        super.leave(execution);
    }

    private void triggerWaitEvent(DelegateExecution execution) {
        Map<String, Object> payload = this.initPayload(execution);
        this.logger.info(String.format("triggerWaitEvent ExecutionId:%s BusinessKey:%s PayLoad: %s", execution.getId(), execution.getBusinessKey(), payload));
        new WaitEventReceivedCmd(this.broadcastTask.getEvent(), execution.getId(), payload, true).execute(Context.getCommandContext());
    }

    private Map<String, Object> initPayload(DelegateExecution execution) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("entityNumber", execution.getEntityNumber());
        payload.put("businessKey", execution.getBusinessKey());
        payload.put("scope", this.broadcastTask.getScope());
        payload.put("processInstanceId", execution.getProcessInstanceId());
        payload.put("biztraceno", execution.getVariable("biztraceno"));
        ObjectNode eventParams = this.broadcastTask.getEventParamsJson(execution);
        payload.put("eventParams", eventParams);
        execution.setVariable("eventParams", eventParams);
        return payload;
    }

    private void triggerBillTaskWaitActionsEvent(DelegateExecution execution) {
        Map<String, Object> payload = this.initPayload(execution);
        this.logger.info(String.format("triggerWaitEvent ExecutionId:%s BusinessKey:%s PayLoad: %s", execution.getId(), execution.getBusinessKey(), payload));
        new WaitActionsEventReceivedCmd(this.broadcastTask.getEvent(), execution.getId(), payload, true).execute(Context.getCommandContext());
    }

    private void triggerSubscriptionEvent(DelegateExecution execution) {
        try {
            HashMap<String, Object> variable = new HashMap<String, Object>();
            variable.put("entityNumber", execution.getEntityNumber());
            variable.put("businessKey", execution.getBusinessKey());
            if (execution instanceof ExecutionEntity) {
                variable.put("biztraceno", ((ExecutionEntity)execution).getBizTraceNo());
            }
            variable.put("processInstanceId", execution.getRootProcessInstanceId());
            new WorkflowServiceImpl().triggerEventSubscribe(this.broadcastTask.getEvent(), SerializationUtils.toJsonString(variable));
        }
        catch (KDException e) {
            if (e.getErrorCode() != null && WFErrorCode.bizEventError().equals((Object)e.getErrorCode())) {
                this.logger.info(String.format("bec event trigger error,msg is [%s]", e.getMessage()));
                return;
            }
            throw e;
        }
    }
}

