/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.BillExceptionOp;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BillTaskCallActivity;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.IOParameter;
import kd.bos.workflow.bpmn.model.MapExceptionEntry;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.ValuedDataObject;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.crosstenant.CrossTenantArgs;
import kd.bos.workflow.engine.crosstenant.CrossTenantInfo;
import kd.bos.workflow.engine.crosstenant.CrossTenantInformationHelper;
import kd.bos.workflow.engine.crosstenant.CrossTenantInteraction;
import kd.bos.workflow.engine.crosstenant.CrossTenantProcessHandler;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.Expression;
import kd.bos.workflow.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.CallActivityUtil;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.cmd.management.BillBackOrProcessTerminateCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.delegate.SubProcessActivityBehavior;
import kd.bos.workflow.engine.impl.el.ExpressionManager;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.repository.ProcessDefinition;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.exception.WFNotFindSubProcessException;

public class CallActivityBehavior
extends AbstractBpmnActivityBehavior
implements SubProcessActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected String processDefinitonKey;
    protected Expression processDefinitionExpression;
    protected transient List<MapExceptionEntry> mapExceptions;
    protected CallActivity callActivity;

    public CallActivityBehavior(String processDefinitionKey, List<MapExceptionEntry> mapExceptions) {
        this.processDefinitonKey = processDefinitionKey;
        this.mapExceptions = mapExceptions;
    }

    public CallActivityBehavior(Expression processDefinitionExpression, List<MapExceptionEntry> mapExceptions, CallActivity callActivity) {
        this.processDefinitionExpression = processDefinitionExpression;
        this.mapExceptions = mapExceptions;
    }

    public CallActivityBehavior(CallActivity callActivity) {
        this.callActivity = callActivity;
    }

    @Override
    public void execute(DelegateExecution execution) {
        boolean skipWhenBoot = BizFlowUtil.ifSkipWhenBootThenRecordExecutionType(execution, this.callActivity);
        if (WfUtils.isTesting() || skipWhenBoot) {
            this.leave(execution);
            return;
        }
        CommandContext commandContext = Context.getCommandContext();
        commandContext.getTaskHelper().setLastUsedDealNode(execution.getParent(), commandContext, this.callActivity);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.putAll(this.getDefalutVars((ExecutionEntity)execution));
        variables.put("isCallActity", true);
        String operation = (String)variables.get("_operation_");
        if (operation == null && (operation = (String)variables.get("addressKey")) == null) {
            operation = this.getOperation(commandContext, execution, variables);
        }
        List<IOParameter> inParameters = this.callActivity.getInParameters();
        String businesskey = execution.getBusinessKey();
        String entityNumber = execution.getEntityNumber();
        Map<String, Object> inParametersMap = this.getOtherVars(execution, inParameters, businesskey, entityNumber);
        variables.putAll(inParametersMap);
        variables.put("currentActInstId", this.getActivityId());
        CrossTenantInfo crossTenantInfo = null;
        if (WfConfigurationUtil.isCalculateCrossTenant() && "true".equals(inParametersMap.get("isCrossTenant"))) {
            CrossTenantArgs processInfo = new CrossTenantArgs();
            processInfo.setEntityNumber(entityNumber);
            processInfo.setBusinesskey(businesskey);
            processInfo.setInParameters(inParametersMap);
            Long processInstanceId = execution.getProcessInstanceId();
            processInfo.setProcessInstanceId(processInstanceId);
            processInfo.setProcessDefinitionId(execution.getProcessDefinitionId());
            processInfo.setActivityId(((ExecutionEntity)execution).getActivityId());
            CrossTenantInteraction crossTenantInformation = CrossTenantInformationHelper.getCrossTenantInformation(ISVServiceHelper.getISVInfo().getId());
            crossTenantInfo = crossTenantInformation == null ? null : crossTenantInformation.getCrossTenantInformation(processInfo);
        }
        boolean isCrossTenant = false;
        if (crossTenantInfo != null && crossTenantInfo.isCrossTenant()) {
            variables.put("mainProcessInstanceId", execution.getProcessInstanceId());
            variables.put("subNodeExecutionId", execution.getId());
            variables.put("_initiator_", String.valueOf(crossTenantInfo.getCallActityInitiator()));
            variables.put("targetTenantId", crossTenantInfo.getTargetTenantId());
            variables.put("currentTenantId", RequestContext.get().getTenantId());
            variables.put("isCrossTenant", true);
            variables.put("currentTenantAccountId", RequestContext.get().getAccountId());
            variables.put("crossTenantInfo", SerializationUtils.toJsonString((Object)crossTenantInfo));
            CrossTenantProcessHandler crossTenantProcessHandler = CrossTenantInformationHelper.getCrossTenantProcessHandler(null);
            if (crossTenantProcessHandler != null) {
                crossTenantProcessHandler.tryTriggerProcess(crossTenantInfo, businesskey, operation, entityNumber, variables);
                isCrossTenant = true;
            }
        }
        if (!isCrossTenant) {
            JobEntity job = commandContext.getJobManager().createAddressMessageJob(businesskey, operation, entityNumber, variables);
            job.setProcessInstanceId(execution.getProcessInstanceId());
            job.setProcessDefinitionId(execution.getProcessDefinitionId());
            job.setElementId(this.callActivity.getId());
            commandContext.getJobManager().scheduleAsyncJob(job);
        }
    }

    private String getOperation(CommandContext commandContext, DelegateExecution execution, Map<String, Object> variables) {
        String activityId = this.getActivityId();
        if (activityId != null && activityId.equals(execution.getVariable("bootNodeId"))) {
            ExecutionEntity processInstance = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(execution.getProcessInstanceId());
            return (String)processInstance.getVariable("_operation_");
        }
        ExecutionEntity billExec = (ExecutionEntity)execution;
        while (!billExec.isBillExecution() && WfUtils.isNotEmpty(billExec.getParentId())) {
            billExec = billExec.getParent();
        }
        if (billExec != null && billExec.isBillExecution()) {
            String ops = (String)billExec.getVariableLocal("_operations_");
            if (ops != null && ops.contains(",")) {
                variables.put("_operations_", ops);
            }
            return (String)billExec.getVariableLocal("_operation_");
        }
        return null;
    }

    private String getActivityId() {
        String activityId = this.callActivity.getId();
        if (this.callActivity instanceof BillTaskCallActivity) {
            activityId = ((BillTaskCallActivity)this.callActivity).getBillTaskId();
        }
        return activityId;
    }

    private Map<String, Object> getOtherVars(DelegateExecution execution, List<IOParameter> inParameters, String businesskey, String entityNumber) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        DynamicObject businessModel = WfUtils.findBusinessObject(businesskey, entityNumber);
        if (inParameters != null) {
            for (IOParameter p : inParameters) {
                String number = p.getParamNumber();
                Object value = p.getParamValue();
                if (!WfUtils.isNotEmpty(number)) continue;
                if (value instanceof String && ((String)value).startsWith("${")) {
                    value = ExpressionCalculatorUtil.parseValue(businessModel, execution, (String)value, null);
                }
                variables.putIfAbsent(number, value);
            }
        }
        return variables;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, Object> getDefalutVars(ExecutionEntity execution) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("jobAction", "createSubProcess");
        variables.put("superExecutionId", execution.getId());
        variables.put("superProcInstId", execution.getProcessInstanceId());
        variables.put("_operation_", execution.getVariableLocal("_operation_"));
        variables.put("rootProcessInstanceId", execution.getRootProcessInstanceId());
        variables.put("calledWay", this.callActivity.getCalledWay());
        if ("processAddress".equals(this.callActivity.getCalledWay())) {
            variables.put("parentProcDefId", execution.getProcessDefinitionId());
            variables.put("addressKey", this.callActivity.getAddressKey());
        } else {
            if (!WfUtils.isNotEmpty(this.callActivity.getCallProcessNumber())) throw new WFNotFindSubProcessException(WFErrorCode.createProcessEmptyError(), execution.getActivityId(), this.callActivity.getCallProcessNumber());
            ProcessDefinitionEntity def = Context.getCommandContext().getProcessDefinitionEntityManager().findLatestEnableProcessDefinitionByKey(this.callActivity.getCallProcessNumber());
            if (def == null) throw new WFNotFindSubProcessException(WFErrorCode.createProcessNotExistError(), execution.getActivityId(), this.callActivity.getCallProcessNumber());
            variables.put("callActivityProcDefKey", this.callActivity.getCallProcessNumber());
        }
        QFilter filter = new QFilter("processInstanceId", "=", (Object)execution.getProcessInstanceId());
        List tasks = Context.getCommandContext().getHistoricTaskInstanceEntityManager().findByQueryFilters(new QFilter[]{filter});
        if (tasks != null && !tasks.isEmpty()) {
            Long initor = ((HistoricTaskInstanceEntity)tasks.get(0)).getStarterId();
            variables.put("_initiator_", String.valueOf(initor));
        }
        variables.put("biztraceno", execution.getBizTraceNo());
        return variables;
    }

    @Override
    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) {
        try {
            CallActivity callActivity;
            ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            if (executionEntity.getCurrentFlowElement() instanceof BillTask) {
                BillTask bt = (BillTask)executionEntity.getCurrentFlowElement();
                callActivity = bt.getCallActivity();
            } else {
                callActivity = (CallActivity)executionEntity.getCurrentFlowElement();
            }
            Object subRet = subProcessInstance.getVariable("subProcessResult");
            if (subRet != null) {
                execution.setTransientVariable("subProcessResult", subRet);
            }
            for (IOParameter ioParameter : callActivity.getOutParameters()) {
                Expression expression;
                String variKey = ioParameter.getParamNumber();
                if (WfUtils.isEmpty(variKey)) continue;
                if ("subProcessResult".equals(variKey)) {
                    variKey = String.format("%s_%s", callActivity.getId(), "subProcessResult");
                }
                Object value = null;
                Object pv = ioParameter.getParamValue();
                if (StringUtils.isNotEmpty((CharSequence)ioParameter.getSourceExpression())) {
                    expression = expressionManager.createExpression(ioParameter.getSourceExpression().trim());
                    value = expression.getValue(subProcessInstance);
                } else if (pv != null) {
                    if (String.valueOf(pv).startsWith("${")) {
                        expression = expressionManager.createExpression(String.valueOf(pv).trim());
                        value = expression.getValue(subProcessInstance);
                    } else {
                        value = pv;
                    }
                } else {
                    value = subProcessInstance.getVariable(ioParameter.getSource());
                }
                execution.setVariable(variKey, value);
            }
            this.transferDynInfoBySubRet(subProcessInstance, executionEntity, subRet);
        }
        catch (Exception e) {
            throw new WFException(e.getMessage(), e);
        }
    }

    private void transferDynInfoBySubRet(DelegateExecution subProcessInstance, ExecutionEntity executionEntity, Object subRet) {
        Map<String, Object> superExecutionVarMap = CallActivityUtil.getSuperExeVarMap(subProcessInstance, executionEntity, subRet);
        if (WfUtils.isNotEmptyForMap(superExecutionVarMap)) {
            executionEntity.setVariablesLocal(superExecutionVarMap);
            ExecutionEntity miRootExecution = executionEntity.getParent();
            if (miRootExecution != null && !miRootExecution.isScope() && miRootExecution.isMultiInstanceRoot()) {
                miRootExecution.setVariablesLocal(superExecutionVarMap);
            }
        }
    }

    @Override
    public void completed(DelegateExecution execution) {
        try {
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            ExecutionEntity processInstance = executionEntity.getProcessInstance();
            boolean needWaitAllCompleted = CallActivityUtil.isNeedWaitAllCompleted(processInstance);
            boolean allCallActivityCompleted = needWaitAllCompleted && CallActivityUtil.updateCompletedVarAndGetCompletedResult(executionEntity, processInstance);
            CommandContext commandContext = Context.getCommandContext();
            if ("cancel".equals(execution.getVariable("leaveType"))) {
                if (needWaitAllCompleted && allCallActivityCompleted) {
                    CallActivityUtil.skipTaskAndContinue(commandContext, processInstance);
                }
                return;
            }
            String exceptionDelayhandleType = (String)execution.getVariableLocal("billExceptionDelayHandle");
            if (execution.getCurrentActivityId().equals(exceptionDelayhandleType)) {
                boolean billTerminate;
                ExecutionEntityManager executionMgr = Context.getCommandContext().getExecutionEntityManager();
                execution.removeVariableLocal("billExceptionDelayHandle");
                String scense = (String)execution.getVariableLocal("exceptionScense");
                boolean bl = billTerminate = scense != null && scense.equalsIgnoreCase("terminate");
                if (billTerminate) {
                    execution.setActive(false);
                    executionMgr.update((ExecutionEntity)execution);
                } else {
                    executionMgr.delete(execution.getId());
                    executionMgr.delete(execution.getParentId());
                }
                execution.removeVariableLocal("exceptionScense");
            } else {
                boolean flag = true;
                Object subRet = execution.getTransientVariable("subProcessResult");
                String exceptionOp = null;
                if ("60".equals(subRet)) {
                    Process process = ProcessDefinitionUtil.getProcess(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
                    List<BillExceptionOp> ops = process.getBillExceptionOp();
                    for (BillExceptionOp op : ops) {
                        if (!"unsubmit".equals(op.getOper()) || !op.getBillnumber().equals(execution.getEntityNumber())) continue;
                        flag = false;
                        exceptionOp = op.getProcaction();
                        break;
                    }
                }
                if (flag && !needWaitAllCompleted) {
                    commandContext.getProcessEngineConfiguration().getTaskHelper().planExecutionOperationAsync(commandContext, (ExecutionEntity)execution);
                } else if (flag && allCallActivityCompleted) {
                    CallActivityUtil.skipTaskAndContinue(commandContext, processInstance);
                } else if (exceptionOp != null) {
                    ExecutionEntity billExec = (ExecutionEntity)execution;
                    if (!execution.isBillExecution()) {
                        billExec = ((ExecutionEntity)execution).getParent();
                    }
                    if ("procinstiddelete".equals(exceptionOp)) {
                        new BillBackOrProcessTerminateCmd(billExec, execution.getEntityNumber(), WfUtils.getPromptWordLocaleString("\u5355\u636e\u4f8b\u5916", "AddressProcessJobHandler_60", "bos-wf-engine"), true, "unsubmit").execute(commandContext);
                    } else if ("billdelete".equals(exceptionOp)) {
                        new BillBackOrProcessTerminateCmd(billExec, execution.getEntityNumber(), WfUtils.getPromptWordLocaleString("\u5355\u636e\u4f8b\u5916", "AddressProcessJobHandler_60", "bos-wf-engine"), false, "unsubmit").execute(commandContext);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new WFException(e.getMessage(), e);
        }
    }

    protected ProcessDefinition findProcessDefinition(String processDefinitionKey) {
        return Context.getProcessEngineConfiguration().getDeploymentManager().findDeployedLatestProcessDefinitionByKey(processDefinitionKey);
    }

    protected Map<String, Object> processDataObjects(Collection<ValuedDataObject> dataObjects) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            variablesMap = new HashMap(dataObjects.size());
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }

    protected void initializeVariables(ExecutionEntity subProcessInstance, Map<String, Object> variables) {
        subProcessInstance.setVariables(variables);
    }

    public void setProcessDefinitonKey(String processDefinitonKey) {
        this.processDefinitonKey = processDefinitonKey;
    }

    public String getProcessDefinitonKey() {
        return this.processDefinitonKey;
    }
}

