/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.SkipInfo;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;

public class CallActivityParalleMultiInstanceBehavior
extends ParallelMultiInstanceBehavior {
    public CallActivityParalleMultiInstanceBehavior(Activity activity, AbstractBpmnActivityBehavior originalActivityBehavior) {
        super(activity, originalActivityBehavior);
    }

    @Override
    protected int createInstances(DelegateExecution execution) {
        SkipInfo skipInfo = this.getSkipInfo((ExecutionEntity)execution);
        if (skipInfo.isSkip()) {
            Context.getCommandContext().getHistoryManager().recordActivityStart((ExecutionEntity)execution);
            Context.getCommandContext().getHistoryManager().recordActivityExecutionType((ExecutionEntity)execution, skipInfo.getExecutionType(), skipInfo.getSkipReason());
            return 0;
        }
        return super.createInstances(execution);
    }

    private SkipInfo getSkipInfo(ExecutionEntity execution) {
        CallActivity callActivity = (CallActivity)execution.getCurrentFlowElement();
        return DynamicFlowUtil.isSkipTask(callActivity, null, execution);
    }

    @Override
    protected TaskEntity handleTaskLeave(DelegateExecution execution, boolean jump, ExecutionEntity executionToUse) {
        Object subProcessResult;
        CallActivity callActivity = (CallActivity)executionToUse.getCurrentFlowElement();
        CommandContext commandContext = Context.getCommandContext();
        CommentEntity comment = (CommentEntity)commandContext.getCommentEntityManager().create();
        comment.setActivityId(executionToUse.getCurrentActivityId());
        comment.setType("message");
        comment.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        comment.setProcessInstanceId(executionToUse.getProcessInstanceId());
        comment.setStep(commandContext.getCommentEntityManager().calculateStep(executionToUse.getProcessInstanceId()));
        comment.setActivityName(callActivity.getCallProcessName());
        Long callProcessInstId = (Long)execution.getVariable(String.format("%s.%s", execution.getCurrentActivityId(), "subProcessInstanceId"));
        if (WfUtils.isNotEmpty(callProcessInstId)) {
            comment.setSubProcessInstanceId(callProcessInstId);
        }
        if ((subProcessResult = executionToUse.getVariable("subProcessResult")) == null) {
            subProcessResult = executionToUse.getVariable(String.format("%s_%s", callActivity.getId(), "subProcessResult"));
        }
        ILocaleString message = null;
        if (subProcessResult == null) {
            message = WfUtils.getPromptWordLocaleString("\u5b50\u6d41\u7a0b\u6ca1\u6709\u8fd4\u56de\u7ed3\u679c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", "CallActivityParalleMultiInstanceBehavior_0", "bos-wf-engine");
        } else {
            switch (subProcessResult.toString()) {
                case "approve": {
                    message = WfUtils.getPromptWordLocaleString("\u5b50\u6d41\u7a0b\u5ba1\u6279\u901a\u8fc7\u3002", "CallActivityParalleMultiInstanceBehavior_1", "bos-wf-engine");
                    break;
                }
                case "reject": {
                    message = WfUtils.getPromptWordLocaleString("\u5b50\u6d41\u7a0b\u5ba1\u6279\u4e0d\u901a\u8fc7\u3002", "CallActivityParalleMultiInstanceBehavior_2", "bos-wf-engine");
                    break;
                }
                case "20": {
                    message = WfUtils.getPromptWordLocaleString("\u5b50\u6d41\u7a0b\u7531\u4e8e\u64a4\u56de\u5220\u9664\u4e86\u3002", "CallActivityParalleMultiInstanceBehavior_3", "bos-wf-engine");
                    break;
                }
                case "30": {
                    message = WfUtils.getPromptWordLocaleString("\u5b50\u6d41\u7a0b\u88ab\u5ba1\u6279\u7ec8\u6b62\u4e86\u3002", "CallActivityParalleMultiInstanceBehavior_4", "bos-wf-engine");
                    break;
                }
                case "40": {
                    message = WfUtils.getPromptWordLocaleString("\u5b50\u6d41\u7a0b\u88ab\u7ba1\u7406\u5458\u5f3a\u5236\u7ec8\u6b62\u4e86\u3002", "CallActivityParalleMultiInstanceBehavior_5", "bos-wf-engine");
                    break;
                }
                case "50": {
                    message = WfUtils.getPromptWordLocaleString("\u5b50\u6d41\u7a0b\u7531\u4e8e\u5355\u636e\u4f8b\u5916\u7ec8\u6b62\u4e86\u3002", "CallActivityParalleMultiInstanceBehavior_6", "bos-wf-engine");
                    break;
                }
                case "60": {
                    message = WfUtils.getPromptWordLocaleString("\u5b50\u6d41\u7a0b\u88ab\u6574\u5355\u64a4\u56de\u4e86\u3002", "CallActivityParalleMultiInstanceBehavior_7", "bos-wf-engine");
                    break;
                }
                case "120": {
                    message = ResManager.getLocaleString((String)"\u5b50\u6d41\u7a0b\u56e0\u9a73\u56de\u81f3\u7236\u6d41\u7a0b\u800c\u7ec8\u6b62\u3002", (String)"CallActivityParalleMultiInstanceBehavior_8", (String)"bos-wf-engine");
                    break;
                }
                case "80": {
                    message = ResManager.getLocaleString((String)"\u5b50\u6d41\u7a0b\u56e0\u7236\u6d41\u7a0b\u7ec8\u6b62\u800c\u7ec8\u6b62\u3002", (String)"CallActivityParalleMultiInstanceBehavior_9", (String)"bos-wf-engine");
                    break;
                }
            }
        }
        executionToUse.setVariableLocal("lastUserDealNode", callActivity.getId());
        comment.setMessage(message);
        commandContext.getCommentEntityManager().insert(comment);
        return null;
    }

    @Override
    protected String getCallActivityDeleteReason(ExecutionEntity parentExecution, ExecutionEntity childExecution) {
        Object dynType = parentExecution.getVariable("dynType");
        if (dynType != null) {
            String type;
            switch (type = dynType.toString()) {
                case "dynJump": {
                    return "parent process jump";
                }
                case "forceAbort": {
                    return "parent process abort";
                }
                case "billAbort": {
                    return "parent process enforce withdraw";
                }
                case "billWithdrawJump": {
                    return "parent process billWithdraw enforceJump to firstUserNode";
                }
            }
        }
        return super.getCallActivityDeleteReason(parentExecution, childExecution);
    }
}

