/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.cmd.management.AbandonProcessCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;

public class CallActivityUtil {
    public static final String ENTERTYPE_JUMP = "jump";
    public static final String ENTERTYPE_TERMINATE = "terminate";
    private static Log logger = LogFactory.getLog(CallActivityUtil.class);

    public static Map<String, Object> getSuperExeVarMap(DelegateExecution subProcessInstance, ExecutionEntity executionEntity, Object subRet) {
        String varMapStr;
        Map<String, Object> superExecutionVarMap = new HashMap<String, Object>();
        if ("120".equals(subRet) && WfUtils.isNotEmpty(varMapStr = (String)subProcessInstance.getVariable("rejectToParentProcess_variablesMap"))) {
            Object nextNodeDealPerson;
            Map subProcessInstVarMap = (Map)SerializationUtils.fromJsonString((String)varMapStr, Map.class);
            superExecutionVarMap.put("dynType", "dynReject");
            String nextNodeId = (String)subProcessInstVarMap.get("rejectToParentProcess_nextNodeId");
            if (WfUtils.isNotEmpty(nextNodeId)) {
                superExecutionVarMap.put("nextNodeId", nextNodeId);
                Object rejectParticipant = subProcessInstVarMap.get("rejectToParentProcess_rejectParticipant");
                if (rejectParticipant != null) {
                    superExecutionVarMap.put(nextNodeId.toLowerCase() + "rejectParticipant", rejectParticipant);
                }
            }
            if ((nextNodeDealPerson = subProcessInstVarMap.get("rejectToParentProcess_nextNodeDealPerson")) != null) {
                superExecutionVarMap.put("nextnodedealperson", nextNodeDealPerson);
            }
            superExecutionVarMap = DynamicFlowUtil.extraCurNodeVariablesByDynType(executionEntity, superExecutionVarMap);
        }
        return superExecutionVarMap;
    }

    public static boolean tryAbandonAllCallActivity(CommandContext commandContext, ExecutionEntity execution, Map<String, Object> variables, String enterType) {
        if (commandContext == null || execution == null || variables == null || variables.isEmpty()) {
            return false;
        }
        Long processInstanceId = execution.getProcessInstanceId();
        List<ExecutionEntity> executionList = commandContext.getExecutionEntityManager().findChildExecutionsByProcessInstanceId(processInstanceId);
        if (executionList == null || executionList.isEmpty()) {
            logger.debug(String.format("current processInstanceId[%s], has no child.", processInstanceId));
            return false;
        }
        int abandonCallActivityTotalNum = 0;
        ArrayList<String> notCompletedKeyList = new ArrayList<String>();
        for (ExecutionEntity executionEntity : executionList) {
            FlowElement currentFlowElement;
            if (executionEntity.isScope() || executionEntity.isMultiInstanceRoot() || executionEntity.isBillExecution() || !executionEntity.isActive() || !((currentFlowElement = executionEntity.getCurrentFlowElement()) instanceof CallActivity) && !(currentFlowElement instanceof BillTask)) continue;
            Long executionEntityId = executionEntity.getId();
            logger.debug(String.format("executionId[%s], currentFlowElement is CallActivity or BillTask.", executionEntityId));
            if (!CallActivityUtil.abandonCallActivityBySuperExecution(commandContext, executionEntity, variables)) continue;
            if (!execution.getId().equals(executionEntityId)) {
                executionEntity.setVariableLocal("leaveType", "cancel");
            }
            ++abandonCallActivityTotalNum;
            String currentKey = String.format("%s_%s", currentFlowElement.getNumber(), executionEntityId);
            notCompletedKeyList.add(currentKey);
        }
        if (abandonCallActivityTotalNum > 0 && !notCompletedKeyList.isEmpty()) {
            ExecutionEntity processInstance = execution.getProcessInstance();
            Long triggerExecutionId = execution.getId();
            execution.setVariablesLocal(variables);
            CallActivityUtil.setAbandonCallActivityVar(processInstance, abandonCallActivityTotalNum, notCompletedKeyList, triggerExecutionId, new HashMap<String, Object>());
            return true;
        }
        return false;
    }

    public static boolean abandonCallActivityBySuperExecution(CommandContext commandContext, ExecutionEntity superExecution, Map<String, Object> variables) {
        Long superExecutionId = superExecution.getId();
        ExecutionEntity childProcInstExecution = commandContext.getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(superExecutionId);
        if (childProcInstExecution == null || childProcInstExecution.isDeleted()) {
            logger.debug(String.format("current superExecution %s has no subProcessInstance!", superExecutionId));
            CallActivityUtil.deleteAddressAndStartProcessDeadLetterJobs(commandContext, superExecution);
            return false;
        }
        LocaleString reason = null;
        Object dynName = variables.get("dynName");
        Object dynType = variables.get("dynType");
        String callActivityDynType = CallActivityUtil.getCallActivityFinishedDynType(dynType);
        if (StringUtils.isEmpty((CharSequence)callActivityDynType)) {
            callActivityDynType = "abortByParentProcessAbort";
        }
        if (("billExcepAbort".equals(callActivityDynType) || "abortByParentProcessWithdraw".equals(callActivityDynType)) && dynName != null) {
            try {
                reason = LocaleString.fromMap((Map)((Map)SerializationUtils.fromJsonString((String)dynName.toString(), Map.class)));
            }
            catch (Exception e) {
                logger.error(WfUtils.getExceptionStacktrace(e));
            }
        }
        Map<String, Object> params = CallActivityUtil.getParamsFromVariables(variables);
        childProcInstExecution.setVariableLocal("abortByParentProcessAbort", Boolean.TRUE);
        new AbandonProcessCmd(childProcInstExecution.getProcessInstanceId(), (ILocaleString)reason, callActivityDynType, params).execute(commandContext);
        return true;
    }

    public static void deleteAddressAndStartProcessDeadLetterJobs(CommandContext commandContext, ExecutionEntity superExecution) {
        if (CallActivityUtil.isSuspendProcess(commandContext, superExecution)) {
            Long superExecutionId = superExecution.getId();
            String businessKey = superExecution.getBusinessKey();
            QFilter q1 = new QFilter("businessKey", "=", (Object)businessKey);
            QFilter q2 = new QFilter("executionId", "=", (Object)superExecutionId);
            QFilter q3 = new QFilter("jobHandlerType", "in", (Object)new String[]{"address-process-event", "start-process-event"});
            QFilter[] qFilters = new QFilter[]{q1, q2, q3};
            logger.debug(String.format("delete address or start process deadLetter jobs by businessKey[%s], superExecutionId[%s]!", businessKey, superExecutionId));
            commandContext.getDeadLetterJobEntityManager().deleteByFilters(qFilters);
        }
    }

    private static Map<String, Object> getParamsFromVariables(Map<String, Object> variables) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (variables.get("processInstIdDynNameMap") != null) {
            params.put("processInstIdDynNameMap", variables.get("processInstIdDynNameMap"));
        }
        if (variables.get("auditAbort_sourceProcessInstanceId") instanceof Long) {
            Long sourceProcInstId = (Long)variables.get("auditAbort_sourceProcessInstanceId");
            String triggerKey = String.format("%s_%s", sourceProcInstId, "triggerExecutionId");
            params.put("auditAbort_sourceProcessInstanceId", sourceProcInstId);
            params.put(triggerKey, variables.get(triggerKey));
        }
        return params;
    }

    public static String getCallActivityFinishedDynType(Object type) {
        if (type != null) {
            String dynType;
            switch (dynType = type.toString()) {
                case "dynJump": {
                    return "abortByParentProcessJump";
                }
                case "billAbort": 
                case "billWithdrawJump": {
                    return "abortByParentProcessWithdraw";
                }
                case "billExcepAbort": {
                    return "billExcepAbort";
                }
                case "forceAbort": 
                case "abortByParentProcessAbort": 
                case "abortByParentProcessJump": 
                case "abortByParentProcessWithdraw": {
                    return "abortByParentProcessAbort";
                }
            }
        }
        return null;
    }

    private static void setAbandonCallActivityVar(ExecutionEntity processInstance, int abandonCallActivityTotalNum, List<String> notCompletedKeyList, Long triggerExecutionId, Map<String, Object> variables) {
        if (processInstance == null) {
            return;
        }
        processInstance.setVariableLocal("abandonCallActivity_totalNum", abandonCallActivityTotalNum);
        processInstance.setVariableLocal("abandonCallActivity_completedNum", 0);
        processInstance.setVariableLocal("abandonCallActivity_notCompletedKeyList", String.join((CharSequence)",", notCompletedKeyList));
        processInstance.setVariableLocal("abandonCallActivity_triggerExecutionId", triggerExecutionId);
    }

    public static boolean isNeedWaitAllCompleted(ExecutionEntity processInstance) {
        if (processInstance != null) {
            Object totalNumObj = processInstance.getVariableLocal("abandonCallActivity_totalNum");
            Object completedNumObj = processInstance.getVariableLocal("abandonCallActivity_completedNum");
            Object notCompletedKeyListObj = processInstance.getVariableLocal("abandonCallActivity_notCompletedKeyList");
            if (completedNumObj != null && totalNumObj != null && notCompletedKeyListObj != null) {
                int totalNum = (Integer)totalNumObj;
                int completedNum = (Integer)completedNumObj;
                String notCompletedKeyListStr = String.valueOf(notCompletedKeyListObj);
                return totalNum > 0 && completedNum < totalNum && StringUtils.isNotEmpty((CharSequence)notCompletedKeyListStr);
            }
        }
        return false;
    }

    public static boolean updateCompletedVarAndGetCompletedResult(ExecutionEntity execution, ExecutionEntity processInstance) {
        if (processInstance == null) {
            return false;
        }
        boolean allCallActivityCompleted = false;
        Object totalNumObj = processInstance.getVariableLocal("abandonCallActivity_totalNum");
        Object completedNumObj = processInstance.getVariableLocal("abandonCallActivity_completedNum");
        Object notCompletedKeyListObj = processInstance.getVariableLocal("abandonCallActivity_notCompletedKeyList");
        if (completedNumObj != null && totalNumObj != null && notCompletedKeyListObj != null) {
            String currentKey;
            int totalNum = (Integer)totalNumObj;
            int completedNum = (Integer)completedNumObj;
            String notCompletedKeyListStr = String.valueOf(notCompletedKeyListObj);
            if (notCompletedKeyListStr.contains(currentKey = String.format("%s_%s", execution.getCurrentFlowElement().getNumber(), execution.getId()))) {
                String[] notCompletedKeyArray = notCompletedKeyListStr.split(",");
                List filterResultList = Arrays.stream(notCompletedKeyArray).filter(key -> !currentKey.equals(key)).collect(Collectors.toList());
                notCompletedKeyListStr = String.join((CharSequence)",", filterResultList);
                if (totalNum == ++completedNum && StringUtils.isBlank((CharSequence)notCompletedKeyListStr)) {
                    allCallActivityCompleted = true;
                }
                processInstance.setVariableLocal("abandonCallActivity_completedNum", completedNum);
                processInstance.setVariableLocal("abandonCallActivity_notCompletedKeyList", notCompletedKeyListStr);
            } else {
                logger.info(String.format("unidentified completedKey[%s]. processInstanceId[%s]. totalNum[%s]. completedNum[%s], notCompletedKeyListStr[%s]", currentKey, processInstance.getId(), totalNum, completedNum, notCompletedKeyListStr));
            }
        }
        return allCallActivityCompleted;
    }

    public static void skipTaskAndContinue(CommandContext commandContext, ExecutionEntity processInstance) {
        ExecutionEntity destExecution;
        if (processInstance == null) {
            return;
        }
        Object executionIdObj = processInstance.getVariableLocal("abandonCallActivity_triggerExecutionId");
        if (executionIdObj instanceof Long && (destExecution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById((Long)executionIdObj)) != null) {
            TaskService taskService = commandContext.getProcessEngineConfiguration().getTaskService();
            Long curUserId = RequestContext.get().getCurrUserId();
            boolean isSuspend = CallActivityUtil.isSuspendProcess(commandContext, destExecution);
            Map<String, Object> variables = destExecution.getVariablesLocal();
            taskService.skipTaskAndContinue(destExecution, curUserId, variables, isSuspend);
        }
        CallActivityUtil.removeAllAbandonCallActivityVars(processInstance);
    }

    private static boolean isSuspendProcess(CommandContext commandContext, ExecutionEntity destExecution) {
        if (destExecution != null) {
            List<DeadLetterJobEntity> deadLetterJobEntities;
            ExecutionEntity processInstance = destExecution.getProcessInstance();
            String suspensionState = processInstance.getSuspensionState();
            boolean isSuspend = ManagementConstants.SUSPENDED.getStateCode().equals(suspensionState);
            if (!isSuspend && ModelType.BizFlow.name().equalsIgnoreCase(destExecution.getProcessType()) && (deadLetterJobEntities = commandContext.getDeadLetterJobEntityManager().findRunningJobsByProcessInstanceId(destExecution.getProcessInstanceId())) != null && !deadLetterJobEntities.isEmpty()) {
                isSuspend = true;
            }
            return isSuspend;
        }
        return false;
    }

    private static void removeAllAbandonCallActivityVars(ExecutionEntity processInstance) {
        if (processInstance != null) {
            processInstance.removeVariableLocal("abandonCallActivity_totalNum");
            processInstance.removeVariableLocal("abandonCallActivity_completedNum");
            processInstance.removeVariableLocal("abandonCallActivity_notCompletedKeyList");
            processInstance.removeVariableLocal("abandonCallActivity_triggerExecutionId");
        }
    }

    public static boolean isSerialExecuteEndEventWhenAbortByParentProcess(FlowNode flowNode, ExecutionEntity execution) {
        return flowNode instanceof EndEvent && "EndTerminateEvent".equals(flowNode.getType()) && execution != null && execution.getSuperExecutionId() != null && ("80".equals(execution.getVariable("endType")) || "30".equals(execution.getVariable("endType"))) && Boolean.TRUE.equals(execution.getProcessInstance().getVariableLocal("abortByParentProcessAbort"));
    }
}

