/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.utils.CustomTaskUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.msg.info.ParticipantInfo;
import kd.bos.workflow.engine.msg.info.TaskEntityInfo;

public class CustomTaskBehaviorUtil {
    private static Log logger = LogFactory.getLog(CustomTaskBehaviorUtil.class);

    public static Map<String, Object> createTask(CommandContext commandContext, TaskEntityInfo taskEntityInfo) {
        if (taskEntityInfo == null || taskEntityInfo.getParticipantInfos().size() == 0) {
            logger.debug(String.format("create task is fail and taskEntityInfo: %s", taskEntityInfo));
            return CustomTaskUtils.getResult((Boolean)Boolean.FALSE, (String)"create task is fail and taskEntityInfo");
        }
        Map taskResult = new HashMap();
        try {
            TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
            TaskEntity taskEntity = CustomTaskBehaviorUtil.buildTaskEntity(commandContext, taskEntityInfo);
            taskEntityManager.insert(taskEntity, null);
            List participantInfos = taskEntityInfo.getParticipantInfos();
            ArrayList<Long> userIds = new ArrayList<Long>(participantInfos.size());
            for (ParticipantInfo participantInfo : participantInfos) {
                userIds.add(participantInfo.getUserId());
            }
            taskEntity.addUserIdentityLinks(userIds, "participant");
            if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_CREATED, taskEntity));
            }
            TaskBehaviorUtil.dispatchTaskAssignListener(taskEntity, null);
            CustomTaskBehaviorUtil.planToDoJob(commandContext, taskEntity.getId());
            JSONObject data = new JSONObject();
            data.put("taskId", (Object)taskEntity.getId());
            taskResult = CustomTaskUtils.getResult((Boolean)Boolean.TRUE, (String)"create task is success", (String)data.toJSONString());
        }
        catch (Exception e) {
            String desc = WfUtils.getExceptionStacktrace(e);
            logger.warn("task create us fail and desc " + desc);
            taskResult = CustomTaskUtils.getResult((Boolean)Boolean.FALSE, (String)desc);
        }
        return taskResult;
    }

    private static TaskEntity buildTaskEntity(CommandContext commandContext, TaskEntityInfo taskEntityInfo) {
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        TaskEntity task = (TaskEntity)taskEntityManager.create();
        task.setId(taskEntityInfo.getId());
        task.setName(taskEntityInfo.getName());
        task.setSubject(taskEntityInfo.getSubject());
        task.setDescription(taskEntityInfo.getDescription().getLocaleValue());
        task.setDueDate(taskEntityInfo.getDueDate());
        task.setFormKey(taskEntityInfo.getFormKey());
        task.setMobileFormKey(taskEntityInfo.getMobileFormKey());
        task.setBillNo(taskEntityInfo.getBillNo());
        task.setBusinessKey(taskEntityInfo.getBusinessKey());
        task.setEntityNumber(taskEntityInfo.getEntityNumber());
        CustomTaskBehaviorUtil.setEntityProperties(task, taskEntityInfo.getEntityNumber(), taskEntityInfo.getBusinessKey());
        if (WfUtils.isNotEmpty(taskEntityInfo.getSource())) {
            task.setSource(taskEntityInfo.getSource());
        } else {
            String entityNumber = taskEntityInfo.getEntityNumber();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            String bizAppId = mainEntityType.getAppId();
            task.setSource(bizAppId);
        }
        if (WfUtils.isNotEmpty(taskEntityInfo.getProcessingPage())) {
            task.setProcessingPage(taskEntityInfo.getProcessingPage());
        } else {
            task.setProcessingMobilePage("msg_approvalpagetpl_pc");
        }
        if (WfUtils.isNotEmpty(taskEntityInfo.getProcessingMobilePage())) {
            task.setProcessingMobilePage(taskEntityInfo.getProcessingMobilePage());
        } else {
            task.setProcessingMobilePage("msg_approvalpage_mob");
        }
        task.setHandleState(taskEntityInfo.getHandleState());
        if (WfUtils.isEmpty(task.getHandleState()) || "willHandled".equalsIgnoreCase(task.getHandleState())) {
            task.setHandleState("willHandled");
        }
        task.setStarterId(taskEntityInfo.getStarterId());
        task.setStartName(WfUtils.findUserName(taskEntityInfo.getStarterId()));
        task.setStartNameFormat(task.getStartName());
        task.setDisplay(taskEntityInfo.isDisplay());
        if (WfUtils.isNotEmpty(taskEntityInfo.getEndType())) {
            task.setEndType(taskEntityInfo.getEndType());
        } else {
            task.setEndType("all");
        }
        task.setCategory(taskEntityInfo.getCategory());
        task.setValidateOperation(taskEntityInfo.getValidateOperation());
        return task;
    }

    private static void setEntityProperties(TaskEntity task, String entityNumber, String businessKey) {
        Map<String, Object> entityProperties = WfUtils.getEntityProperties(entityNumber, businessKey);
        if (!entityProperties.isEmpty()) {
            LocaleString entityName;
            String billType = (String)entityProperties.get("billType");
            if (WfUtils.isNotEmpty(billType)) {
                task.setBillType(billType);
            }
            if (WfUtils.isNotEmpty((ILocaleString)(entityName = (LocaleString)entityProperties.get("entityName")))) {
                task.setEntityName((ILocaleString)entityName);
            }
        }
    }

    private static void planToDoJob(CommandContext commandContext, Long taskId) {
        commandContext.getMessageService().createToDo(taskId);
    }
}

