/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.CompensateEventDefinition;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.ThrowEvent;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.helper.ScopeUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.CompensateEventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntityManager;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import org.apache.commons.lang.StringUtils;

public class IntermediateThrowCompensationEventActivityBehavior
extends FlowNodeActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected final CompensateEventDefinition compensateEventDefinition;

    public IntermediateThrowCompensationEventActivityBehavior(CompensateEventDefinition compensateEventDefinition) {
        this.compensateEventDefinition = compensateEventDefinition;
    }

    @Override
    public void execute(DelegateExecution execution) {
        ThrowEvent throwEvent = (ThrowEvent)execution.getCurrentFlowElement();
        String activityRef = this.compensateEventDefinition.getActivityRef();
        CommandContext commandContext = Context.getCommandContext();
        EventSubscriptionEntityManager eventSubscriptionEntityManager = commandContext.getEventSubscriptionEntityManager();
        ArrayList<CompensateEventSubscriptionEntity> eventSubscriptions = new ArrayList<CompensateEventSubscriptionEntity>();
        if (StringUtils.isNotEmpty((String)activityRef)) {
            eventSubscriptions.addAll(eventSubscriptionEntityManager.findCompensateEventSubscriptionsByProcessInstanceIdAndActivityId(execution.getProcessInstanceId(), activityRef));
        } else {
            Process process = ProcessDefinitionUtil.getProcess(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
            BaseElement flowElementsContainer = null;
            flowElementsContainer = throwEvent.getSubProcess() == null ? process : throwEvent.getSubProcess();
            for (FlowElement flowElement : flowElementsContainer.getFlowElements()) {
                if (!(flowElement instanceof Activity)) continue;
                eventSubscriptions.addAll(eventSubscriptionEntityManager.findCompensateEventSubscriptionsByProcessInstanceIdAndActivityId(execution.getProcessInstanceId(), flowElement.getId()));
            }
        }
        if (eventSubscriptions.isEmpty()) {
            this.leave(execution);
        } else {
            ScopeUtil.throwCompensationEvent(eventSubscriptions, execution, false, new HashMap<String, Object>());
            this.leave(execution);
        }
    }
}

