/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.CompensateEventDefinition;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.BpmnError;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.Expression;
import kd.bos.workflow.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.ChildInstanceReport;
import kd.bos.workflow.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.helper.ErrorPropagation;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.delegate.ActivityBehavior;
import kd.bos.workflow.engine.impl.delegate.SubProcessActivityBehavior;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public abstract class MultiInstanceActivityBehavior
extends FlowNodeActivityBehavior
implements SubProcessActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected static Log logger = LogFactory.getLog(MultiInstanceActivityBehavior.class);
    protected final String NUMBER_OF_INSTANCES = "nrOfInstances";
    protected final String NUMBER_OF_ACTIVE_INSTANCES = "nrOfActiveInstances";
    protected final String NUMBER_OF_COMPLETED_INSTANCES = "nrOfCompletedInstances";
    protected Activity activity;
    protected AbstractBpmnActivityBehavior innerActivityBehavior;
    protected Expression loopCardinalityExpression;
    protected Expression completionConditionExpression;
    protected Expression collectionExpression;
    protected String collectionVariable;
    protected String collectionElementVariable;
    protected String collectionElementIndexVariable = "loopCounter";

    public MultiInstanceActivityBehavior(Activity activity, AbstractBpmnActivityBehavior innerActivityBehavior) {
        this.activity = activity;
        this.setInnerActivityBehavior(innerActivityBehavior);
    }

    @Override
    public void execute(DelegateExecution execution) {
        if (this.getLocalLoopVariable(execution, this.getCollectionElementIndexVariable()) == null) {
            int nrOfInstances = 0;
            try {
                nrOfInstances = this.createInstances(execution);
            }
            catch (BpmnError error) {
                ErrorPropagation.propagateError(error, execution, (Throwable)((Object)error));
            }
            if (nrOfInstances == 0) {
                super.leave(execution);
            }
        } else {
            this.innerActivityBehavior.execute(execution);
        }
    }

    protected abstract int createInstances(DelegateExecution var1);

    public abstract void addInstances(ExecutionEntity var1, Collection<? extends Object> var2);

    public abstract void removeInstances(TaskEntity var1, List<Long> var2);

    protected void executeCompensationBoundaryEvents(FlowElement flowElement, DelegateExecution execution) {
        Collection<BoundaryEvent> boundaryEvents = this.findBoundaryEventsForFlowNode(execution.getProcessDefinitionId(), execution.getProcessInstanceId(), flowElement);
        if (CollectionUtil.isNotEmpty(boundaryEvents)) {
            for (BoundaryEvent boundaryEvent : boundaryEvents) {
                if (CollectionUtil.isEmpty(boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition)) continue;
                ExecutionEntity childExecutionEntity = Context.getCommandContext().getExecutionEntityManager().createChildExecution((ExecutionEntity)execution);
                childExecutionEntity.setParentId(execution.getId());
                childExecutionEntity.setCurrentFlowElement(boundaryEvent);
                childExecutionEntity.setScope(false);
                ActivityBehavior boundaryEventBehavior = (ActivityBehavior)boundaryEvent.getBehavior();
                boundaryEventBehavior.execute(childExecutionEntity);
            }
        }
    }

    protected Collection<BoundaryEvent> findBoundaryEventsForFlowNode(Long processDefinitionId, Long processInstanceId, FlowElement flowElement) {
        Process process = this.getProcessDefinition(processDefinitionId, processInstanceId);
        ArrayList<BoundaryEvent> results = new ArrayList<BoundaryEvent>(1);
        List<BoundaryEvent> boundaryEvents = process.findFlowElementsOfType(BoundaryEvent.class, true);
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            if (boundaryEvent.getAttachedToRefId() == null || !boundaryEvent.getAttachedToRefId().equals(flowElement.getId())) continue;
            results.add(boundaryEvent);
        }
        return results;
    }

    protected Process getProcessDefinition(Long processDefinitionId, Long processInstanceId) {
        return ProcessDefinitionUtil.getProcess(processDefinitionId, processInstanceId);
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        this.innerActivityBehavior.trigger(execution, signalName, signalData);
    }

    public void lastExecutionEnded(DelegateExecution execution) {
        this.leave(execution);
    }

    @Override
    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) {
    }

    @Override
    public void completed(DelegateExecution execution) {
        try {
            this.leave(execution);
        }
        catch (Exception e) {
            throw new WFException(e.getMessage(), e);
        }
    }

    protected int resolveNrOfInstances(DelegateExecution execution) {
        if (this.loopCardinalityExpression != null) {
            return this.resolveLoopCardinality(execution);
        }
        if (this.usesCollection()) {
            Collection collection = this.resolveAndValidateCollection(execution);
            return collection.size();
        }
        throw new WFIllegalArgumentException("Couldn't resolve collection expression nor variable reference");
    }

    protected void executeOriginalBehavior(DelegateExecution execution, int loopCounter) {
        Collection collection = null;
        if (this.usesCollection() && this.collectionElementVariable != null) {
            collection = (Collection)this.resolveCollection(execution);
        }
        this.executeOriginalBehavior(execution, loopCounter, collection);
    }

    protected void executeOriginalBehavior(DelegateExecution execution, int loopCounter, Collection<? extends Object> elements) {
        if (elements != null && !elements.isEmpty()) {
            logger.debug(String.format("elements:[%s]", WfUtils.listToString(elements, ",")));
            Object value = null;
            Iterator<? extends Object> it = elements.iterator();
            for (int index = 0; index <= loopCounter; ++index) {
                value = it.next();
            }
            this.setLoopVariable(execution, this.collectionElementVariable, value);
        }
        execution.setCurrentFlowElement(this.activity);
        Context.getAgenda().planContinueMultiInstanceOperation((ExecutionEntity)execution);
    }

    protected Collection resolveAndValidateCollection(DelegateExecution execution) {
        Object obj = this.resolveCollection(execution);
        if (this.collectionExpression != null) {
            if (!(obj instanceof Collection)) {
                throw new WFIllegalArgumentException(this.collectionExpression.getExpressionText() + "' didn't resolve to a Collection");
            }
        } else if (this.collectionVariable != null) {
            if (obj == null) {
                throw new WFIllegalArgumentException("Variable " + this.collectionVariable + " is not found");
            }
            if (!(obj instanceof Collection)) {
                throw new WFIllegalArgumentException("Variable " + this.collectionVariable + "' is not a Collection");
            }
        } else {
            throw new WFIllegalArgumentException("Couldn't resolve collection expression nor variable reference");
        }
        return (Collection)obj;
    }

    protected Object resolveCollection(DelegateExecution execution) {
        Object collection = null;
        if (this.collectionExpression != null) {
            collection = this.collectionExpression.getValue(execution);
        } else if (this.collectionVariable != null) {
            collection = execution.getVariable(this.collectionVariable);
        }
        return collection;
    }

    protected boolean usesCollection() {
        return this.collectionExpression != null || this.collectionVariable != null;
    }

    protected boolean isExtraScopeNeeded(FlowNode flowNode) {
        return flowNode.getSubProcess() != null;
    }

    protected int resolveLoopCardinality(DelegateExecution execution) {
        Object value = this.loopCardinalityExpression.getValue(execution);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new WFIllegalArgumentException("Could not resolve loopCardinality expression '" + this.loopCardinalityExpression.getExpressionText() + "': not a number nor number String");
    }

    protected boolean completionConditionSatisfied(DelegateExecution execution) {
        if (this.completionConditionExpression != null) {
            Object value = this.completionConditionExpression.getValue(execution);
            if (!(value instanceof Boolean)) {
                throw new WFIllegalArgumentException("completionCondition '" + this.completionConditionExpression.getExpressionText() + "' does not evaluate to a boolean value");
            }
            Boolean booleanValue = (Boolean)value;
            logger.debug(String.format("Completion condition of multi-instance satisfied: %s", booleanValue));
            return booleanValue;
        }
        return false;
    }

    protected void setLoopVariable(DelegateExecution execution, String variableName, Object value) {
        execution.setVariableLocal(variableName, value);
    }

    protected Integer getLoopVariable(DelegateExecution execution, String variableName) {
        Object value = execution.getVariableLocal(variableName);
        for (DelegateExecution parent = execution.getParent(); value == null && parent != null; parent = parent.getParent()) {
            value = parent.getVariableLocal(variableName);
        }
        return (Integer)(value != null ? value : Integer.valueOf(0));
    }

    protected Integer getLocalLoopVariable(DelegateExecution execution, String variableName) {
        return (Integer)execution.getVariableLocal(variableName);
    }

    protected void removeLocalLoopVariable(DelegateExecution execution, String variableName) {
        execution.removeVariableLocal(variableName);
    }

    protected void callActivityEndListeners(DelegateExecution execution) {
        Context.getCommandContext().getProcessEngineConfiguration().getListenerNotificationHelper().executeExecutionListeners(this.activity, execution, "end");
    }

    protected void logLoopDetails(DelegateExecution execution, String custom, int loopCounter, int nrOfCompletedInstances, int nrOfActiveInstances, int nrOfInstances) {
        logger.debug(String.format("Multi-instance '%s' %s. Details: loopCounter=%d, nrOrCompletedInstances=%d,nrOfActiveInstances=%d,nrOfInstances=%d", execution.getCurrentFlowElement() != null ? execution.getCurrentFlowElement().getId() : "", custom, loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances));
    }

    protected DelegateExecution getMultiInstanceRootExecution(DelegateExecution executionEntity) {
        DelegateExecution multiInstanceRootExecution = null;
        DelegateExecution currentExecution = executionEntity;
        while (currentExecution != null && multiInstanceRootExecution == null && currentExecution.getParent() != null) {
            if (currentExecution.isMultiInstanceRoot()) {
                multiInstanceRootExecution = currentExecution;
                continue;
            }
            currentExecution = currentExecution.getParent();
        }
        return multiInstanceRootExecution;
    }

    public Expression getLoopCardinalityExpression() {
        return this.loopCardinalityExpression;
    }

    public void setLoopCardinalityExpression(Expression loopCardinalityExpression) {
        this.loopCardinalityExpression = loopCardinalityExpression;
    }

    public Expression getCompletionConditionExpression() {
        return this.completionConditionExpression;
    }

    public void setCompletionConditionExpression(Expression completionConditionExpression) {
        this.completionConditionExpression = completionConditionExpression;
    }

    public Expression getCollectionExpression() {
        return this.collectionExpression;
    }

    public void setCollectionExpression(Expression collectionExpression) {
        this.collectionExpression = collectionExpression;
    }

    public String getCollectionVariable() {
        return this.collectionVariable;
    }

    public void setCollectionVariable(String collectionVariable) {
        this.collectionVariable = collectionVariable;
    }

    public String getCollectionElementVariable() {
        return this.collectionElementVariable;
    }

    public void setCollectionElementVariable(String collectionElementVariable) {
        this.collectionElementVariable = collectionElementVariable;
    }

    public String getCollectionElementIndexVariable() {
        return this.collectionElementIndexVariable;
    }

    public void setCollectionElementIndexVariable(String collectionElementIndexVariable) {
        this.collectionElementIndexVariable = collectionElementIndexVariable;
    }

    public final void setInnerActivityBehavior(AbstractBpmnActivityBehavior innerActivityBehavior) {
        this.innerActivityBehavior = innerActivityBehavior;
        this.innerActivityBehavior.setMultiInstanceActivityBehavior(this);
    }

    public AbstractBpmnActivityBehavior getInnerActivityBehavior() {
        return this.innerActivityBehavior;
    }

    public abstract void dealChildrenReport(ExecutionEntity var1, ChildInstanceReport var2);
}

