/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.identity.UserInfo;
import kd.bos.workflow.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import kd.bos.workflow.engine.impl.cmd.task.processassistant.ProcessAssistantUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.detaillog.DetailLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class NoneStartEventActivityBehavior
extends FlowNodeActivityBehavior {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(DelegateExecution execution) {
        this.leave(execution);
        this.recordNoCodeFlwoDetailLog(execution);
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        Context.getAgenda().planContinueProcessSynchronousOperation((ExecutionEntity)execution);
    }

    private void recordNoCodeFlwoDetailLog(DelegateExecution execution) {
        CommandContext commandContext;
        if (execution instanceof ExecutionEntity && ProcessType.NoCodeFlow.name().equals(((ExecutionEntity)execution).getProcessType()) && (commandContext = Context.getCommandContext()) != null) {
            DetailLogEntityImpl detailLog = new DetailLogEntityImpl();
            detailLog.setProcInstId(execution.getProcessInstanceId());
            detailLog.setActivityId(execution.getCurrentActivityId());
            if (execution.getCurrentFlowElement() != null) {
                detailLog.setCategory(execution.getCurrentFlowElement().getType());
            }
            if (WfUtils.isNotEmpty(execution.getStartUserId())) {
                detailLog.setStartId(execution.getStartUserId());
                HashSet<Long> userIds = new HashSet<Long>(1);
                userIds.add(execution.getStartUserId());
                Map<String, UserInfo> userInfoMap = ProcessAssistantUtil.queryUserInfos(userIds);
                if (WfUtils.isNotEmptyForMap(userInfoMap)) {
                    UserInfo userInfo = userInfoMap.get(detailLog.geStartId().toString());
                    detailLog.setStartName((ILocaleString)(userInfo != null ? userInfo.getName() : new LocaleString()));
                    detailLog.setStartAvatar(userInfo != null ? userInfo.getImgUrl() : "");
                }
            }
            commandContext.getDetailLogEntityManager().recordDetailLog(commandContext, detailLog);
        }
    }
}

