/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.CompensateEventDefinition;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SelectNodesModel;
import kd.bos.workflow.bpmn.model.SubProcess;
import kd.bos.workflow.bpmn.model.Transaction;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.BpmnError;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.ChildInstanceReport;
import kd.bos.workflow.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.bpmn.helper.ErrorPropagation;
import kd.bos.workflow.engine.impl.bpmn.helper.ScopeUtil;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.BatchSQLInfo;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class ParallelMultiInstanceBehavior
extends MultiInstanceActivityBehavior {
    private static final long serialVersionUID = 1L;

    public ParallelMultiInstanceBehavior(Activity activity, AbstractBpmnActivityBehavior originalActivityBehavior) {
        super(activity, originalActivityBehavior);
    }

    @Override
    protected int createInstances(DelegateExecution execution) {
        int nrOfInstances = this.resolveNrOfInstances(execution);
        if (nrOfInstances < 0) {
            throw new WFIllegalArgumentException("Invalid number of instances: must be non-negative integer value, but was " + nrOfInstances);
        }
        execution.setMultiInstanceRoot(true);
        this.setLoopVariable(execution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(execution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(execution, "nrOfActiveInstances", nrOfInstances);
        ArrayList<ExecutionEntity> concurrentExecutions = new ArrayList<ExecutionEntity>(nrOfInstances);
        for (int loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            ExecutionEntity concurrentExecution = Context.getCommandContext().getExecutionEntityManager().createChildExecution((ExecutionEntity)execution);
            concurrentExecution.setCurrentFlowElement(this.activity);
            concurrentExecution.setActive(true);
            concurrentExecution.setScope(false);
            concurrentExecution.setActivityName(((ExecutionEntity)execution).getActivityName());
            concurrentExecutions.add(concurrentExecution);
            this.logLoopDetails(concurrentExecution, "initialized", loopCounter, 0, nrOfInstances, nrOfInstances);
        }
        String comingInWay = DynamicFlowUtil.getComingInWay(execution, execution.getCurrentActivityId());
        for (int loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            DelegateExecution concurrentExecution = (DelegateExecution)concurrentExecutions.get(loopCounter);
            if (!concurrentExecution.isActive() || concurrentExecution.isEnded() || !concurrentExecution.getParent().isActive() || concurrentExecution.getParent().isEnded()) continue;
            this.setLoopVariable(concurrentExecution, "comingInWay", comingInWay);
            this.setLoopVariable(concurrentExecution, this.getCollectionElementIndexVariable(), loopCounter);
            this.executeOriginalBehavior(concurrentExecution, loopCounter);
        }
        if (!concurrentExecutions.isEmpty()) {
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            executionEntity.setActive(false);
        }
        return nrOfInstances;
    }

    @Override
    public void addInstances(ExecutionEntity execution, Collection<? extends Object> elements) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances");
        int orignalLoopCounter = nrOfInstances;
        int size = elements.size();
        this.setLoopVariable(execution, "nrOfInstances", nrOfInstances += size);
        this.setLoopVariable(execution, "nrOfActiveInstances", nrOfActiveInstances += size);
        ArrayList<ExecutionEntity> concurrentExecutions = new ArrayList<ExecutionEntity>(size);
        for (int index = 0; index < size; ++index) {
            ExecutionEntity concurrentExecution = Context.getCommandContext().getExecutionEntityManager().createChildExecution(execution);
            concurrentExecution.setCurrentFlowElement(this.activity);
            concurrentExecution.setActive(true);
            concurrentExecution.setScope(false);
            concurrentExecutions.add(concurrentExecution);
            this.logLoopDetails(concurrentExecution, "add", index, 0, nrOfInstances, nrOfActiveInstances);
        }
        String comingInWay = DynamicFlowUtil.getComingInWay(execution, execution.getCurrentActivityId());
        for (int index = 0; index < size; ++index) {
            DelegateExecution concurrentExecution = (DelegateExecution)concurrentExecutions.get(index);
            if (!concurrentExecution.isActive() || concurrentExecution.isEnded() || concurrentExecution.getParent().isEnded()) continue;
            this.setLoopVariable(concurrentExecution, "comingInWay", comingInWay);
            this.setLoopVariable(concurrentExecution, this.getCollectionElementIndexVariable(), orignalLoopCounter + index);
            this.setLoopVariable(concurrentExecution, "fromAddInstance", Boolean.TRUE);
            this.executeOriginalBehavior(concurrentExecution, index, elements);
        }
    }

    @Override
    public void removeInstances(TaskEntity task, List<Long> participants) {
        if (task != null) {
            int count = 0;
            List<TaskEntity> subTasks = Context.getCommandContext().getTaskEntityManager().findTasksByParentTaskId(task.getId());
            if (subTasks != null && !subTasks.isEmpty()) {
                for (TaskEntity subTask : subTasks) {
                    Set t = subTask.getParticipants();
                    if (!participants.containsAll(t)) continue;
                    Context.getCommandContext().getExecutionEntityManager().deleteExecutionAndRelatedData(subTask.getExecution(), "multiInstance delete", false, true);
                    ++count;
                }
            }
            if (count > 0) {
                ExecutionEntity execution = task.getExecution();
                int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
                int nrOfCompletedInstance = this.getLoopVariable(execution, "nrOfCompletedInstances");
                this.setLoopVariable(execution, "nrOfInstances", nrOfInstances - count);
                this.setLoopVariable(execution, "nrOfActiveInstances", nrOfInstances - count - nrOfCompletedInstance);
            }
        }
    }

    public void recoverInstances(List<HistoricTaskInstanceEntity> hiTasks, Map<String, String> varaibles) {
        if (hiTasks != null && !hiTasks.isEmpty()) {
            CommandContext commandContext = Context.getCommandContext();
            int count = 0;
            boolean remainComment = varaibles != null && varaibles.get("RemainComment") != null;
            ExecutionEntity parentExec = null;
            BatchSQLInfo execution = new BatchSQLInfo("UPDATE T_WF_EXECUTION SET FISACTIVE = ? WHERE FID = ?", 50);
            BatchSQLInfo comments = new BatchSQLInfo("UPDATE T_WF_HICOMMENT SET FTYPE = ? WHERE FTASKID = ? AND FTYPE=? ", 50);
            for (HistoricTaskInstanceEntity hitask : hiTasks) {
                ExecutionEntity exec = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(hitask.getExecutionId());
                if (exec == null) continue;
                if (parentExec == null) {
                    parentExec = exec.getParent();
                }
                if (parentExec != null && !parentExec.isMultiInstanceRoot()) continue;
                if (remainComment) {
                    comments.addParam(new Object[]{"suggestion", hitask.getId(), "comment"});
                } else {
                    QFilter qf1 = new QFilter("processInstanceId", "=", (Object)hitask.getProcessInstanceId());
                    QFilter qf2 = new QFilter("taskId", "=", (Object)hitask.getId());
                    commandContext.getCommentEntityManager().deleteByFilters(new QFilter[]{qf1, qf2});
                }
                execution.addParam(new Object[]{Boolean.TRUE, exec.getId()});
                ++count;
                hitask.setEndTime(null);
                hitask.setDurationInMillis(0L);
                hitask.setRealDurationInMillis(0L);
                hitask.setHandleState("willApproval");
                hitask.setAssigneeId(0L);
                hitask.setAssignee(null);
                TaskEntity task = commandContext.getTaskEntityManager().recoverTask(hitask);
                commandContext.getHistoricTaskInstanceEntityManager().update(hitask);
                HistoricActivityInstanceEntity hiact = commandContext.getHistoricActivityInstanceEntityManager().findActivityByTaskId(hitask.getId());
                if (hiact != null) {
                    hiact.setDeleteReason(" ");
                    hiact.setDurationInMillis(0L);
                    hiact.setRealDurationInMillis(0L);
                    hiact.setEndTime(null);
                    hiact.setAssignee(null);
                    hiact.setAssigneeId(0L);
                    commandContext.getHistoricActivityInstanceEntityManager().update(hiact);
                }
                commandContext.getMessageService().deleteDealToDoAndCreateToDo(task.getId());
            }
            if (count > 0 && parentExec != null) {
                int nrOfInstances = this.getLoopVariable(parentExec, "nrOfInstances");
                int nrOfCompletedInstance = this.getLoopVariable(parentExec, "nrOfCompletedInstances");
                if (nrOfCompletedInstance > 0) {
                    int completedNum = nrOfCompletedInstance - count;
                    this.setLoopVariable(parentExec, "nrOfCompletedInstances", completedNum);
                    this.setLoopVariable(parentExec, "nrOfActiveInstances", nrOfInstances - completedNum);
                }
                if (WfUtils.isNotEmptyForCollection(comments.getParamsList())) {
                    commandContext.getCommentEntityManager().addBatchSQLInfo(comments);
                }
                if (WfUtils.isNotEmptyForCollection(execution.getParamsList())) {
                    commandContext.getExecutionEntityManager().addBatchSQLInfo(execution);
                }
            }
        }
    }

    @Override
    public void leave(DelegateExecution execution) {
        boolean parentExecution;
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        ExecutionEntity miRootExecution = (ExecutionEntity)this.getMultiInstanceRootExecution(execution);
        boolean jump = DynamicFlowUtil.isSkipForMultiInstance(executionEntity, miRootExecution);
        boolean zeroNrOfInstances = false;
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        logger.debug(String.format("jump[%1$s],nrOfInstances[%2$s],execution[%3$s]", jump, nrOfInstances, execution == null ? "" : execution.getId()));
        if (!jump && this.resolveNrOfInstances(miRootExecution) == 0 && nrOfInstances == 0) {
            zeroNrOfInstances = true;
            this.removeLocalLoopVariable(execution, this.getCollectionElementIndexVariable());
            super.leave(execution);
            if (execution != null) {
                execution.setMultiInstanceRoot(false);
            }
            logger.debug(String.format("leave from here,jump[%s],nrOfInstances[%s],execution[%s]", jump, nrOfInstances, execution == null ? null : execution.getId()));
        }
        int loopCounter = this.getLoopVariable(execution, this.getCollectionElementIndexVariable());
        int nrOfCompletedInstances = this.getLoopVariable(execution, "nrOfCompletedInstances") + 1;
        int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances") - 1;
        Context.getCommandContext().getHistoryManager().recordActivityEnd((ExecutionEntity)execution, null);
        if (zeroNrOfInstances) {
            return;
        }
        if (miRootExecution != null) {
            this.setLoopVariable(miRootExecution, "nrOfCompletedInstances", nrOfCompletedInstances);
            this.setLoopVariable(miRootExecution, "nrOfActiveInstances", nrOfActiveInstances);
        }
        this.logLoopDetails(execution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
        boolean bl = parentExecution = miRootExecution != null && miRootExecution.equals(executionEntity);
        if (executionEntity != null && (executionEntity.getParent() != null || parentExecution)) {
            if (!parentExecution) {
                executionEntity.inactivate();
                this.lockFirstParentScope(executionEntity);
            }
            if (jump || this.completionConditionSatisfied(execution) && this.completeNormalLevel(execution, this.activity) || nrOfCompletedInstances >= nrOfInstances) {
                logger.debug(String.format("condition is satisfied,leave from here,jump[%s],nrOfInstances[%s],nrOfCompletedInstances[%s],execution[%s]", jump, nrOfInstances, nrOfCompletedInstances, execution == null ? null : execution.getId()));
                if (this.activity != null && this.activity instanceof UserTask && ((UserTask)this.activity).isCompositeTasks()) {
                    Context.getCommandContext().getProcessEngineConfiguration().getTaskHelper().voteNewCompiTask(execution, jump);
                }
                ExecutionEntity executionToUse = null;
                executionToUse = nrOfInstances > 0 ? (parentExecution ? executionEntity : executionEntity.getParent()) : executionEntity;
                boolean hasCompensation = false;
                Activity activity = (Activity)execution.getCurrentFlowElement();
                if (activity instanceof Transaction) {
                    hasCompensation = true;
                } else if (activity instanceof SubProcess) {
                    SubProcess subProcess = (SubProcess)activity;
                    block0: for (FlowElement subElement : subProcess.getFlowElements()) {
                        Object subActivity;
                        if (!(subElement instanceof Activity) || !CollectionUtil.isNotEmpty(((Activity)(subActivity = (Activity)subElement)).getBoundaryEvents())) continue;
                        for (BoundaryEvent boundaryEvent : ((Activity)subActivity).getBoundaryEvents()) {
                            if (!CollectionUtil.isNotEmpty(boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition)) continue;
                            hasCompensation = true;
                            continue block0;
                        }
                    }
                }
                if (hasCompensation) {
                    ScopeUtil.createCopyOfSubProcessExecutionForCompensation(executionToUse);
                }
                if (activity instanceof CallActivity) {
                    ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
                    if (executionToUse != null) {
                        ArrayList<Long> callActivityExecutionIds = new ArrayList<Long>();
                        List<ExecutionEntity> childExecutions = executionEntityManager.collectChildren(executionToUse);
                        if (childExecutions != null) {
                            for (ExecutionEntity childExecution : childExecutions) {
                                if (!activity.getId().equals(childExecution.getCurrentActivityId())) continue;
                                callActivityExecutionIds.add(childExecution.getId());
                            }
                            for (int i = childExecutions.size() - 1; i >= 0; --i) {
                                ExecutionEntity childExecution;
                                childExecution = childExecutions.get(i);
                                if (!WfUtils.isNotEmpty(childExecution.getSuperExecutionId()) || !callActivityExecutionIds.contains(childExecution.getSuperExecutionId())) continue;
                                executionEntityManager.deleteProcessInstanceExecutionEntity(childExecution.getId(), childExecution.getCurrentActivityId(), this.getCallActivityDeleteReason(executionEntity, childExecution), true, false, true);
                            }
                        }
                    }
                }
                if (null != executionToUse) {
                    this.deleteChildExecutions(executionToUse, false, Context.getCommandContext());
                    this.removeLocalLoopVariable(executionToUse, this.getCollectionElementIndexVariable());
                    executionToUse.setScope(false);
                    executionToUse.setMultiInstanceRoot(false);
                    WfCacheHelper.removeSerialJobIds(executionToUse.getId().toString());
                    TaskEntity parentTask = this.handleTaskLeave(execution, jump, executionToUse);
                    if (parentTask != null && "enterBoundary".equals(parentTask.getExecutionType())) {
                        return;
                    }
                    String exceptionDelayhandleType = (String)executionToUse.getVariableLocal("billExceptionDelayHandle");
                    String errorNumber = (String)execution.getVariable("enterBdyCompensateErrorCode");
                    if (executionToUse.getCurrentActivityId().equals(exceptionDelayhandleType) || WfUtils.isNotEmpty(errorNumber)) {
                        boolean billTerminate;
                        executionToUse.removeVariableLocal("billExceptionDelayHandle");
                        ExecutionEntityManager executionMgr = Context.getCommandContext().getExecutionEntityManager();
                        String scense = (String)executionToUse.getVariableLocal("exceptionScense");
                        boolean bl2 = billTerminate = scense != null && scense.equalsIgnoreCase("terminate");
                        if (executionToUse.getCurrentActivityId().equals(exceptionDelayhandleType)) {
                            if (billTerminate) {
                                executionToUse.setActive(false);
                                executionMgr.update(executionToUse);
                            } else {
                                executionMgr.delete(executionToUse.getId());
                                executionMgr.delete(executionToUse.getParentId());
                            }
                        }
                        executionToUse.removeVariableLocal("exceptionScense");
                        if (activity instanceof CallActivity && WfUtils.isNotEmpty(errorNumber)) {
                            execution.removeVariable("enterBdyCompensateErrorCode");
                            ErrorPropagation.propagateError(new BpmnError(errorNumber), executionToUse, null);
                        }
                    } else {
                        Object var = executionToUse.getVariableLocal("endOtherBranch");
                        if ("endOtherBranch".equals(var)) {
                            executionToUse.removeVariableLocal("endOtherBranch");
                        } else {
                            Context.getAgenda().planTakeOutgoingSequenceFlowsOperation(executionToUse, true);
                        }
                    }
                }
            } else {
                logger.debug(String.format("condition is not satisfied,jump[%s],nrOfInstances[%s],nrOfCompletedInstances[%s],execution[%s]", jump, nrOfInstances, nrOfCompletedInstances, execution == null ? null : execution.getId()));
                if (execution.getCurrentFlowElement() instanceof YunzhijiaTask) {
                    BPMNUtil.updateHitaskInstPresentAssignee(executionEntity, null);
                }
            }
        } else {
            logger.debug(String.format("executionEntity is not child execution,jump[%s],nrOfInstances[%s],nrOfCompletedInstances[%s],execution[%s]", jump, nrOfInstances, nrOfCompletedInstances, execution == null ? null : execution.getId()));
            this.removeLocalLoopVariable(execution, this.getCollectionElementIndexVariable());
            if (execution != null) {
                execution.setMultiInstanceRoot(false);
            }
            super.leave(execution);
        }
    }

    protected boolean completeNormalLevel(DelegateExecution execution, Activity task) {
        return true;
    }

    protected String getNextNodeId(DelegateExecution execution) {
        List<DecisionOption> decisionOptions = ((YunzhijiaTask)execution.getCurrentFlowElement()).getDecisionOptions();
        if (decisionOptions == null || decisionOptions.size() == 0) {
            Process process = ProcessDefinitionUtil.getProcess(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
            YunzhijiaTask yunzhijiaTask = (YunzhijiaTask)process.getFlowElement(execution.getCurrentActivityId());
            decisionOptions = yunzhijiaTask.getDecisionOptions();
        }
        for (DecisionOption decision : decisionOptions) {
            List<SelectNodesModel> rejectOptions;
            if (!"reject".equals(decision.getAuditType()) || (rejectOptions = decision.getRejectOptions()) == null || rejectOptions.size() == 0) continue;
            return rejectOptions.get(0).getItemId();
        }
        return "";
    }

    protected TaskEntity handleTaskLeave(DelegateExecution execution, boolean jump, ExecutionEntity executionToUse) {
        return null;
    }

    protected String getCallActivityDeleteReason(ExecutionEntity parentExecution, ExecutionEntity childExecution) {
        return "call activity completion condition met";
    }

    protected void lockFirstParentScope(DelegateExecution execution) {
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        boolean found = false;
        ExecutionEntity parentScopeExecution = null;
        ExecutionEntity currentExecution = (ExecutionEntity)execution;
        while (!found && currentExecution != null && currentExecution.getParentId() != null) {
            parentScopeExecution = (ExecutionEntity)executionEntityManager.findById(currentExecution.getParentId());
            if (parentScopeExecution != null && parentScopeExecution.isScope()) {
                found = true;
            }
            currentExecution = parentScopeExecution;
        }
        if (parentScopeExecution != null) {
            parentScopeExecution.forceUpdate();
        }
    }

    protected void deleteChildExecutions(ExecutionEntity parentExecution, boolean deleteExecution, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        List<ExecutionEntity> childExecutions = executionEntityManager.findChildExecutionsByParentExecutionId(parentExecution.getId());
        if (CollectionUtil.isNotEmpty(childExecutions)) {
            for (ExecutionEntity childExecution : childExecutions) {
                logger.debug(String.format("delete child execution: %s actInstId: %s parentExecutionId: %s", childExecution.getId(), childExecution.getCurrentActInstId(), parentExecution.getId()));
                this.deleteChildExecutions(childExecution, true, commandContext);
            }
        }
        if (!(!deleteExecution || WfUtils.isNotEmpty(parentExecution.getActivityId()) && parentExecution.getActivityId().contains("BoundaryEvent"))) {
            executionEntityManager.deleteExecutionAndRelatedData(parentExecution, null, false);
        }
    }

    @Override
    public void dealChildrenReport(ExecutionEntity execution, ChildInstanceReport report) {
        logger.debug(String.format("%s-%s", "taskReceived", "taskReceivers"));
    }
}

