/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.model.RPATask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.asyncexecutor.JobManager;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskActivityBehavior;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.TrdProcRelationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.TrdProcRelationEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityManager;
import kd.bos.workflow.engine.impl.util.RPAUtil;
import kd.bos.workflow.exception.WFException;

public class RPATaskActivityBehavior
extends TaskActivityBehavior {
    private RPATask rpaTask;

    public RPATaskActivityBehavior(RPATask rpaTask) {
        this.rpaTask = rpaTask;
    }

    @Override
    public void execute(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        if (!WfUtils.isNotEmpty(this.rpaTask.getRpaRobotId()) || !WfUtils.isNotEmpty(this.rpaTask.getRpaProcCode())) {
            this.logger.debug(String.format("rpaRobotId or rpaProcCode is null. rpaRobotId: %1$s, rpaProcCode: %2$s ", this.rpaTask.getRpaRobotId(), this.rpaTask.getRpaProcCode()));
            throw new WFException(ResManager.loadKDString((String)"RPA\u6d41\u7a0b\u548cRPA\u673a\u5668\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u914d\u7f6e\u3002", (String)"RPATaskActivityBehavior_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        CommandContext commandContext = Context.getCommandContext();
        JobManager jobManager = commandContext.getJobManager();
        JobEntity message = jobManager.createStartRPAProcessJob(executionEntity);
        jobManager.scheduleAsyncJob(message);
        this.recordSendStartRPAProcMsgAndTrdProcRelation(commandContext, executionEntity);
        super.execute(execution);
    }

    private void recordSendStartRPAProcMsgAndTrdProcRelation(CommandContext commandContext, ExecutionEntity execution) {
        CommentEntity commentEntity = this.recordComment(commandContext, execution);
        this.recordRelation(commandContext, execution, commentEntity.getId());
        RPAUtil.recordOperationLog(commandContext, commentEntity, execution.getProcessDefinitionId());
    }

    private CommentEntity recordComment(CommandContext commandContext, ExecutionEntity execution) {
        String fields = String.format("%s,%s,%s,%s,%s,%s,%s,%s", "activityId", "activityName", "billno", "businessKey", "activityType", "entitynumber", "executionType", "processInstanceId");
        HistoricActivityInstanceEntity actInst = (HistoricActivityInstanceEntity)commandContext.getHistoricActivityInstanceEntityManager().findById(execution.getCurrentActInstId(), fields);
        CommentEntityManager commentManager = commandContext.getCommentEntityManager();
        CommentEntity commentEntity = (CommentEntity)commentManager.create();
        commentEntity.setStarterId(execution.getStartUserId());
        commentEntity.setStartNameFormat(execution.getStarUserNameFormat());
        commentEntity.setMessage(RPAUtil.getSendStartRPAProcMsgText());
        commentEntity.setAssignee(RPAUtil.getRobotName());
        commentEntity.setTime(WfUtils.now());
        commentEntity.setStep(commentManager.calculateStep(execution.getProcessInstanceId()));
        commentEntity.setType("comment");
        commentEntity.setTerminalWay(RequestContext.get().getClient());
        commentEntity.setActivityId(actInst.getActivityId());
        commentEntity.setActivityName(actInst.getActivityName());
        commentEntity.setBillNo(actInst.getBillNo());
        commentEntity.setBusinessKey(actInst.getBusinessKey());
        commentEntity.setCategory(actInst.getActivityType());
        commentEntity.setEntityName(execution.getEntraBillName());
        commentEntity.setEntityNumber(actInst.getEntityNumber());
        commentEntity.setExecutionType(actInst.getExecutionType());
        commentEntity.setProcessInstanceId(actInst.getProcessInstanceId());
        commentEntity.setProcessType(execution.getProcessType());
        commentManager.insert(commentEntity);
        return commentEntity;
    }

    private void recordRelation(CommandContext commandContext, ExecutionEntity execution, Long commentId) {
        TrdProcRelationEntityManager manager = commandContext.getTrdProcRelationEntityManager();
        TrdProcRelationEntity relation = (TrdProcRelationEntity)manager.create();
        relation.setProcInstId(execution.getProcessInstanceId());
        relation.setType("rpa");
        relation.setEntityNumber(execution.getEntityNumber());
        relation.setBusinessKey(execution.getBusinessKey());
        relation.setCommentId(commentId);
        relation.setActInstId(execution.getCurrentActInstId());
        relation.setActivityId(this.rpaTask.getId());
        manager.insert(relation);
    }
}

