/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.BpmnError;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.ChildInstanceReport;
import kd.bos.workflow.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class SequentialMultiInstanceBehavior
extends MultiInstanceActivityBehavior {
    private static final long serialVersionUID = 1066419677149678061L;

    public SequentialMultiInstanceBehavior(Activity activity, AbstractBpmnActivityBehavior innerActivityBehavior) {
        super(activity, innerActivityBehavior);
    }

    @Override
    protected int createInstances(DelegateExecution execution) {
        int nrOfInstances = this.resolveNrOfInstances(execution);
        if (nrOfInstances == 0) {
            return nrOfInstances;
        }
        if (nrOfInstances < 0) {
            throw new WFIllegalArgumentException("Invalid number of instances: must be a non-negative integer value, but was " + nrOfInstances);
        }
        this.createChildExecution(execution, nrOfInstances, 0, nrOfInstances, 0);
        return nrOfInstances;
    }

    protected void createChildExecution(DelegateExecution execution, int nrOfInstances, int completedInstances, int activeInstances, int loopCounter) {
        ExecutionEntity childExecution = Context.getCommandContext().getExecutionEntityManager().createChildExecution((ExecutionEntity)execution);
        childExecution.setCurrentFlowElement(execution.getCurrentFlowElement());
        execution.setMultiInstanceRoot(true);
        execution.setActive(false);
        childExecution.setActivityName(((ExecutionEntity)execution).getActivityName());
        String comingInWay = (String)execution.getVariableLocal("comingInWay");
        if (WfUtils.isEmpty(comingInWay)) {
            comingInWay = DynamicFlowUtil.getComingInWay(execution, execution.getCurrentActivityId());
            this.setLoopVariable(execution, "comingInWay", comingInWay);
        }
        this.setLoopVariable(execution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(execution, "nrOfCompletedInstances", completedInstances);
        this.setLoopVariable(execution, "nrOfActiveInstances", activeInstances);
        String teamMembers = (String)execution.getCurrentTask().getVariable("teamMembers");
        String[] userIds = teamMembers.split("\\,");
        if (userIds == null || userIds.length <= loopCounter) {
            throw new WFEngineException(ResManager.loadKDString((String)"\u4eba\u5458\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SequentialMultiInstanceBehavior_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (nrOfInstances > 0) {
            this.setLoopVariable(childExecution, "comingInWay", comingInWay);
            this.setLoopVariable(childExecution, this.getCollectionElementIndexVariable(), loopCounter);
            this.setLoopVariable(execution, this.getCollectionElementIndexVariable(), loopCounter);
            this.setLoopVariable(childExecution, this.collectionElementVariable, Long.valueOf(userIds[loopCounter]));
            childExecution.setCurrentFlowElement(this.activity);
            Context.getAgenda().planContinueMultiInstanceOperation(childExecution);
        }
    }

    @Override
    public void leave(DelegateExecution childExecution) {
        boolean parentExecution;
        ExecutionEntity childExecutionEntity = (ExecutionEntity)childExecution;
        ExecutionEntity rootExecutionEntity = (ExecutionEntity)this.getMultiInstanceRootExecution(childExecution);
        boolean jump = DynamicFlowUtil.isSkipForMultiInstance(childExecutionEntity, rootExecutionEntity);
        int nrOfInstances = this.getLoopVariable(rootExecutionEntity, "nrOfInstances");
        int loopCounter = this.getLoopVariable(childExecution, this.getCollectionElementIndexVariable()) + 1;
        int nrOfCompletedInstances = this.getLoopVariable(rootExecutionEntity, "nrOfCompletedInstances") + 1;
        int nrOfActiveInstances = this.getLoopVariable(rootExecutionEntity, "nrOfActiveInstances") - 1;
        this.setLoopVariable(rootExecutionEntity, "nrOfCompletedInstances", nrOfCompletedInstances);
        this.setLoopVariable(rootExecutionEntity, "nrOfActiveInstances", nrOfActiveInstances);
        this.setLoopVariable(childExecution, this.getCollectionElementIndexVariable(), loopCounter);
        Context.getCommandContext().getHistoryManager().recordActivityEnd((ExecutionEntity)childExecution, null);
        boolean bl = parentExecution = rootExecutionEntity != null && rootExecutionEntity.equals(childExecutionEntity);
        if (!parentExecution) {
            childExecutionEntity.inactivate();
        }
        if (jump || this.completionConditionSatisfied(childExecution) && this.completeNormalLevel(childExecution, this.activity) || loopCounter >= nrOfInstances) {
            ExecutionEntity executionToUse = null;
            executionToUse = nrOfInstances > 0 ? (parentExecution ? childExecutionEntity : childExecutionEntity.getParent()) : childExecutionEntity;
            if (null != executionToUse) {
                this.deleteChildExecutions(executionToUse, false, Context.getCommandContext());
                this.removeLocalLoopVariable(executionToUse, this.getCollectionElementIndexVariable());
                this.removeLocalLoopVariable(executionToUse, "comingInWay");
                executionToUse.setScope(false);
                executionToUse.setMultiInstanceRoot(false);
                TaskEntity parentTask = this.handleTaskLeave(childExecution, jump, executionToUse);
                if (parentTask != null && "enterBoundary".equals(parentTask.getExecutionType())) {
                    return;
                }
                Long procInstId = childExecution.getProcessInstanceId();
                String activityId = childExecution.getCurrentActivityId();
                WfCacheHelper.removeMultiInstVariable(procInstId, activityId, "nrOfCompletedInstances");
                WfCacheHelper.removeMultiInstVariable(procInstId, activityId, "nrOfActiveInstances");
                Context.getAgenda().planTakeOutgoingSequenceFlowsOperation(executionToUse, true);
            }
        } else {
            try {
                DelegateExecution childParentExecution = childExecution.getParent();
                this.createChildExecution(childParentExecution, nrOfInstances, nrOfCompletedInstances, nrOfActiveInstances, loopCounter);
            }
            catch (BpmnError error) {
                throw error;
            }
            catch (Exception e) {
                throw new WFIllegalArgumentException("Could not execute inner activity behavior of multi instance behavior", e);
            }
        }
    }

    @Override
    public void addInstances(ExecutionEntity execution, Collection<? extends Object> elements) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances");
        int size = elements.size();
        this.setLoopVariable(execution, "nrOfInstances", nrOfInstances += size);
        this.setLoopVariable(execution, "nrOfActiveInstances", nrOfActiveInstances += size);
    }

    @Override
    public void removeInstances(TaskEntity task, List<Long> participants) {
        if (task == null || participants == null) {
            return;
        }
        ExecutionEntity execution = task.getExecution();
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances");
        int size = participants.size();
        this.setLoopVariable(execution, "nrOfInstances", nrOfInstances -= size);
        this.setLoopVariable(execution, "nrOfActiveInstances", nrOfActiveInstances -= size);
    }

    protected boolean completeNormalLevel(DelegateExecution execution, Activity task) {
        return true;
    }

    protected void deleteChildExecutions(ExecutionEntity parentExecution, boolean deleteExecution, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        List<ExecutionEntity> childExecutions = executionEntityManager.findChildExecutionsByParentExecutionId(parentExecution.getId());
        if (CollectionUtil.isNotEmpty(childExecutions)) {
            for (ExecutionEntity childExecution : childExecutions) {
                logger.debug(String.format("delete child execution: %s actInstId: %s parentExecutionId: %s", childExecution.getId(), childExecution.getCurrentActInstId(), parentExecution.getId()));
                this.deleteChildExecutions(childExecution, true, commandContext);
            }
        }
        if (!(!deleteExecution || WfUtils.isNotEmpty(parentExecution.getActivityId()) && parentExecution.getActivityId().contains("BoundaryEvent"))) {
            executionEntityManager.deleteExecutionAndRelatedData(parentExecution, null, false);
        }
    }

    protected TaskEntity handleTaskLeave(DelegateExecution execution, boolean jump, ExecutionEntity executionToUse) {
        return null;
    }

    @Override
    public void dealChildrenReport(ExecutionEntity execution, ChildInstanceReport report) {
        logger.debug(String.format("%s-%s", "taskReceived", "taskReceivers"));
    }
}

