/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.FilterDimemsionsUtils;

public class TaskActivityBehavior
extends AbstractBpmnActivityBehavior {
    private static final long serialVersionUID = 1L;

    protected String getActiveValue(String originalValue, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValueNode;
        String activeValue = originalValue;
        if (taskElementProperties != null && (overrideValueNode = taskElementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : overrideValueNode.asText();
        }
        return activeValue;
    }

    protected List<String> getActiveValueList(List<String> originalValues, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValuesNode;
        List<String> activeValues = originalValues;
        if (taskElementProperties != null && (overrideValuesNode = taskElementProperties.get(propertyName)) != null) {
            if (overrideValuesNode.isNull() || !overrideValuesNode.isArray() || overrideValuesNode.size() == 0) {
                activeValues = null;
            } else {
                activeValues = new ArrayList<String>();
                for (JsonNode valueNode : overrideValuesNode) {
                    activeValues.add(valueNode.asText());
                }
            }
        }
        return activeValues;
    }

    protected void replaceServiceExecutor(DelegateExecution execution, AutoTask autoTask) {
        String executorJson = autoTask.getServiceExecutor();
        List<Object> executors = new ArrayList();
        if (WfUtils.isNotEmpty(executorJson)) {
            Long executor;
            try {
                executors = FilterDimemsionsUtils.parseOptionData(executorJson, execution.getBusinessKey(), execution.getEntityNumber(), execution);
            }
            catch (Exception e) {
                this.logger.error(String.format("\u670d\u52a1\u6267\u884c\u4eba\u89e3\u6790\u5931\u8d25\uff01\u539f\u56e0\uff1a%s", WfUtils.getExceptionStacktrace(e)));
            }
            executors = this.checkUserValid(executors);
            if (CollectionUtil.isNotEmpty(executors) && WfUtils.isNotEmpty(executor = (Long)executors.get(0))) {
                this.replaceUserId(executor);
            }
        }
    }

    private List<Long> checkUserValid(List<Long> executors) {
        if (CollectionUtil.isEmpty(executors)) {
            return executors;
        }
        QFilter filterUser = new QFilter("id", "in", executors);
        QFilter filterEnable = new QFilter("enable", "=", (Object)true);
        QFilter[] filterUsers = new QFilter[]{filterUser, filterEnable};
        String selectFileds = "id,enable";
        Map userMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)selectFileds, (QFilter[])filterUsers);
        executors = new ArrayList<Long>();
        for (Map.Entry userEntry : userMap.entrySet()) {
            DynamicObject userObject = (DynamicObject)userEntry.getValue();
            if (userObject == null) continue;
            executors.add(userObject.getLong("id"));
        }
        return executors;
    }

    private void replaceUserId(Long userId) {
        HashMap<String, Map<String, Object>> payload = new HashMap<String, Map<String, Object>>();
        RequestContext requestContext = RequestContext.get();
        Map<String, Object> context = WfUtils.dumpRequestContext(requestContext);
        context.put("userId", String.valueOf(userId));
        payload.put("_requestContext_", context);
        JSONObject json = new JSONObject(payload);
        WfUtils.restoreRequestContext(json.toString());
    }
}

