/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.HasExecutionListeners;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SubProcess;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.history.HistoryLevel;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class TerminateEndEventActivityBehavior
extends FlowNodeActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected Log log = LogFactory.getLog(this.getClass());
    protected boolean terminateAll;
    protected boolean terminateMultiInstance;

    @Override
    public void execute(DelegateExecution execution) {
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        this.log.debug("-- execute TerminateEndEventActivityBehavior: " + this.terminateAll + "  " + this.terminateMultiInstance);
        if (this.terminateAll) {
            this.terminateAllBehaviour(execution, commandContext, executionEntityManager);
        } else if (this.terminateMultiInstance) {
            this.terminateMultiInstanceRoot(execution, commandContext, executionEntityManager);
        } else {
            this.defaultTerminateEndEventBehaviour(execution, commandContext, executionEntityManager);
        }
    }

    protected void terminateAllBehaviour(DelegateExecution execution, CommandContext commandContext, ExecutionEntityManager executionEntityManager) {
        ExecutionEntity rootExecutionEntity = executionEntityManager.findByRootProcessInstanceId(execution.getRootProcessInstanceId());
        String deleteReason = this.createDeleteReason(execution.getCurrentActivityId());
        String endType = (String)execution.getVariableLocal("endType");
        this.deleteExecutionEntities(executionEntityManager, rootExecutionEntity, deleteReason);
        this.endAllHistoricActivities(rootExecutionEntity.getId(), deleteReason);
        commandContext.getHistoryManager().recordProcessInstanceEnd(rootExecutionEntity.getId(), deleteReason, endType, execution.getCurrentActivityId());
    }

    protected void executeProcessTerminateExecutionListeners(CommandContext commandContext, ExecutionEntity execution) {
        Process process = ProcessDefinitionUtil.getProcess(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
        this.log.debug(String.format("--executeExecutionListeners: type: terminal execution:%s", execution.getId()));
        this.executeExecutionListeners(commandContext, process, execution, "terminate");
        if ("processrestart".equals((String)execution.getVariable("wfSubmitType"))) {
            this.executeExecutionListeners(commandContext, process, execution, "processrestart");
        }
    }

    protected void executeExecutionListeners(CommandContext commandContext, HasExecutionListeners elementWithExecutionListeners, ExecutionEntity executionEntity, String eventType) {
        commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeExecutionListeners(elementWithExecutionListeners, executionEntity, eventType);
    }

    protected void defaultTerminateEndEventBehaviour(DelegateExecution execution, CommandContext commandContext, ExecutionEntityManager executionEntityManager) {
        Object deleteReasonObj;
        ExecutionEntity scopeExecutionEntity = executionEntityManager.findFirstScope((ExecutionEntity)execution);
        this.sendProcessInstanceCancelledEvent(scopeExecutionEntity, execution.getCurrentFlowElement());
        this.executeProcessTerminateExecutionListeners(commandContext, scopeExecutionEntity);
        String deleteReason = this.createDeleteReason(execution.getCurrentActivityId());
        String endType = (String)scopeExecutionEntity.getVariable("endType");
        if ("110".equalsIgnoreCase(endType) && WfUtils.isNotEmptyString(deleteReasonObj = scopeExecutionEntity.getVariable("deleteReason"))) {
            deleteReason = String.format("%s;errorCode(%s)", deleteReason, deleteReasonObj.toString());
        }
        scopeExecutionEntity.setVariable("subProcessResult", endType);
        if (scopeExecutionEntity.isProcessInstanceType() && scopeExecutionEntity.getSuperExecutionId() == null) {
            this.endAllHistoricActivities(scopeExecutionEntity.getId(), deleteReason);
            this.deleteExecutionEntities(executionEntityManager, scopeExecutionEntity, deleteReason);
            commandContext.getHistoryManager().recordProcessInstanceEnd(scopeExecutionEntity.getId(), deleteReason, endType, execution.getCurrentActivityId());
        } else if (scopeExecutionEntity.getCurrentFlowElement() instanceof SubProcess) {
            SubProcess subProcess = (SubProcess)scopeExecutionEntity.getCurrentFlowElement();
            scopeExecutionEntity.setDeleteReason(deleteReason);
            if (subProcess.hasMultiInstanceLoopCharacteristics()) {
                Context.getAgenda().planDestroyScopeOperation(scopeExecutionEntity);
                MultiInstanceActivityBehavior multiInstanceBehavior = (MultiInstanceActivityBehavior)subProcess.getBehavior();
                multiInstanceBehavior.leave(scopeExecutionEntity);
            } else {
                Context.getAgenda().planDestroyScopeOperation(scopeExecutionEntity);
                ExecutionEntity outgoingFlowExecution = executionEntityManager.createChildExecution(scopeExecutionEntity.getParent());
                outgoingFlowExecution.setCurrentFlowElement(scopeExecutionEntity.getCurrentFlowElement());
                Context.getAgenda().planTakeOutgoingSequenceFlowsOperation(outgoingFlowExecution, true);
            }
        } else if (scopeExecutionEntity.getParentId() == null && scopeExecutionEntity.getSuperExecutionId() != null) {
            List<ExecutionEntity> executions = executionEntityManager.findChildExecutionsByProcessInstanceId(execution.getProcessInstanceId());
            if (execution.getVariable("justAbandonCurrentExecution") == null) {
                for (ExecutionEntity e : executions) {
                    if (e.isScope() || execution.getId().equals(e.getId())) continue;
                    e.setActive(false);
                    executionEntityManager.update(e);
                }
                Context.getAgenda().planTakeOutgoingSequenceFlowsOperation((ExecutionEntity)execution, true);
            } else {
                for (ExecutionEntity e : executions) {
                    e.setActive(false);
                    e.setScope(false);
                    executionEntityManager.update(e);
                }
                HistoricActivityInstanceEntityManager historicActivityInstanceEntityManager = commandContext.getHistoricActivityInstanceEntityManager();
                List<HistoricActivityInstanceEntity> historicActivityInstanceEntities = historicActivityInstanceEntityManager.findByActivityId(execution.getProcessInstanceId(), execution.getCurrentActivityId());
                for (HistoricActivityInstanceEntity historicActivityInstanceEntity : historicActivityInstanceEntities) {
                    if (historicActivityInstanceEntity.getEndTime() != null) continue;
                    historicActivityInstanceEntity.markEnded(null);
                    historicActivityInstanceEntityManager.update(historicActivityInstanceEntity);
                }
                commandContext.getHistoryManager().recordProcessInstanceEnd(execution.getProcessInstanceId(), deleteReason, endType, execution.getCurrentActivityId());
            }
        }
        if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            HashMap<String, Object> jsonMap = new HashMap<String, Object>(2);
            jsonMap.put("billNo", scopeExecutionEntity.getBillNo());
            jsonMap.put("cause", endType);
            new EventTriggerCmd("wf.AfterProcessAbortEvent", execution, jsonMap).execute(commandContext);
        }
    }

    protected void endAllHistoricActivities(Long processInstanceId, String deleteReason) {
        if (!Context.getProcessEngineConfiguration().getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            return;
        }
        List<HistoricActivityInstanceEntity> historicActivityInstances = Context.getCommandContext().getHistoricActivityInstanceEntityManager().findUnfinishedHistoricActivityInstancesByProcessInstanceId(processInstanceId);
        for (HistoricActivityInstanceEntity historicActivityInstance : historicActivityInstances) {
            historicActivityInstance.markEnded(deleteReason);
        }
    }

    protected void terminateMultiInstanceRoot(DelegateExecution execution, CommandContext commandContext, ExecutionEntityManager executionEntityManager) {
        ExecutionEntity miRootExecutionEntity = executionEntityManager.findFirstMultiInstanceRoot((ExecutionEntity)execution);
        if (miRootExecutionEntity != null) {
            ExecutionEntity siblingExecution = executionEntityManager.createChildExecution(miRootExecutionEntity.getParent());
            siblingExecution.setCurrentFlowElement(miRootExecutionEntity.getCurrentFlowElement());
            this.deleteExecutionEntities(executionEntityManager, miRootExecutionEntity, this.createDeleteReason(miRootExecutionEntity.getActivityId()));
            Context.getAgenda().planTakeOutgoingSequenceFlowsOperation(siblingExecution, true);
        } else {
            this.defaultTerminateEndEventBehaviour(execution, commandContext, executionEntityManager);
        }
    }

    protected void deleteExecutionEntities(ExecutionEntityManager executionEntityManager, ExecutionEntity rootExecutionEntity, String deleteReason) {
        List<ExecutionEntity> childExecutions = executionEntityManager.collectChildren(rootExecutionEntity);
        for (int i = childExecutions.size() - 1; i >= 0; --i) {
            executionEntityManager.deleteExecutionAndRelatedData(childExecutions.get(i), deleteReason, false);
        }
        executionEntityManager.deleteExecutionAndRelatedData(rootExecutionEntity, deleteReason, false);
    }

    protected void sendProcessInstanceCancelledEvent(DelegateExecution execution, FlowElement terminateEndEvent) {
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled() && (execution.isProcessInstanceType() && execution.getSuperExecutionId() == null || execution.getParentId() == null && execution.getSuperExecutionId() != null)) {
            String currentString = execution.getCurrentFlowElement() == null ? "" : String.format(ResManager.loadKDString((String)"%s\u7ec8\u6b62\u7ed3\u675f", (String)"TerminateEndEventActivityBehavior_1", (String)"bos-wf-engine", (Object[])new Object[0]), execution.getCurrentFlowElement().getName());
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createCancelledEvent(execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), currentString, execution.getBusinessKey()));
        }
        this.dispatchExecutionCancelled(execution, terminateEndEvent);
    }

    protected void dispatchExecutionCancelled(DelegateExecution execution, FlowElement terminateEndEvent) {
        FlowElement flowElement;
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        for (DelegateExecution delegateExecution : executionEntityManager.findChildExecutionsByParentExecutionId(execution.getId())) {
            this.dispatchExecutionCancelled(delegateExecution, terminateEndEvent);
        }
        ExecutionEntity subProcessInstance = Context.getCommandContext().getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(execution.getId());
        if (subProcessInstance != null) {
            this.dispatchExecutionCancelled(subProcessInstance, terminateEndEvent);
        }
        if ((flowElement = execution.getCurrentFlowElement()) instanceof FlowNode) {
            this.dispatchActivityCancelled(execution, terminateEndEvent);
        }
    }

    protected void dispatchActivityCancelled(DelegateExecution execution, FlowElement terminateEndEvent) {
        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityCancelledEvent(execution.getCurrentFlowElement().getId(), execution.getCurrentFlowElement().getName(), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), this.parseActivityType((FlowNode)execution.getCurrentFlowElement()), terminateEndEvent));
    }

    protected String createDeleteReason(String activityId) {
        return "terminate end event (" + activityId + ")";
    }

    public boolean isTerminateAll() {
        return this.terminateAll;
    }

    public void setTerminateAll(boolean terminateAll) {
        this.terminateAll = terminateAll;
    }

    public boolean isTerminateMultiInstance() {
        return this.terminateMultiInstance;
    }

    public void setTerminateMultiInstance(boolean terminateMultiInstance) {
        this.terminateMultiInstance = terminateMultiInstance;
    }
}

