/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.message.utils.MessageSystemParamterUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CirculateModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.enumeration.TaskListenerInvocationType;
import kd.bos.workflow.engine.impl.WfTracerHelper;
import kd.bos.workflow.engine.impl.agenda.AbstractOperation;
import kd.bos.workflow.engine.impl.agenda.ContinueProcessOperation;
import kd.bos.workflow.engine.impl.agenda.callback.AutoLeaveWhenContinueProcessCallback;
import kd.bos.workflow.engine.impl.bpmn.behavior.SkipInfo;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.calculator.ParticipantCalculator;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.cmd.precomputation.PreComputorHelper;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.log.LogClassType;
import kd.bos.workflow.engine.impl.log.RunTimeLog;
import kd.bos.workflow.engine.impl.log.SceneType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.task.TaskDelegateCalculateUtil;
import kd.bos.workflow.engine.task.TaskEventTypeEnum;
import kd.bos.workflow.engine.task.delegatesetting.TaskDelegateCalculateResult;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFTaskException;
import org.apache.commons.lang.StringUtils;

public class UserTaskActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected UserTask userTask;

    public UserTaskActivityBehavior(UserTask userTask) {
        this.userTask = userTask;
    }

    @Override
    public void execute(DelegateExecution execution) {
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntity mainExecution = ((ExecutionEntity)execution).getProcessInstance();
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ParticipantCalculator participantCalculator = processEngineConfiguration.getParticipantCalculator();
        TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
        BpmnModel bpm = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
        boolean isAutoProcess = bpm.isAutoFlow();
        if (isAutoProcess && BpmnModelUtil.instanceofUserTaskOnly(this.userTask.getType())) {
            this.leaveByRightWay(execution);
            return;
        }
        this.isTaskRepeated(execution, taskEntityManager);
        TaskEntity task = this.buildTaskEntity(execution);
        ((ExecutionEntity)execution).setCurrentTask(task);
        ParticipatantModel activeTaskParticipant = this.userTask.getParticipant();
        List<Long> userIds = null;
        String businessKey = task.getBusinessKey();
        boolean isNoCodeUserTask = ModelType.NoCodeFlow.name().equals(mainExecution.getProcessType()) && "UserTask".equals(this.userTask.getType());
        HashMap<Long, List<DelegateSettingEntity>> assignorIdAndDelegateSettingEntitys = new HashMap<Long, List<DelegateSettingEntity>>();
        try {
            if (isNoCodeUserTask) {
                businessKey = execution.getBusinessKey();
            }
            userIds = this.handleParticipants(activeTaskParticipant, businessKey, participantCalculator, execution, assignorIdAndDelegateSettingEntitys, task);
            TaskBehaviorUtil.updateParticipantVariable(task, userIds, this.userTask.getParticipant() == null ? false : this.userTask.getParticipant().isAllowNoneParticipant());
            task.setSubject(TaskBehaviorUtil.getTaskSubject(this.userTask, task, execution.getBusinessKey(), execution.getEntityNumber()));
        }
        catch (Exception e) {
            if (!DynamicFlowUtil.isSkipCurNode(task.getExecution())) {
                throw e;
            }
            this.logger.debug(String.format("\u8282\u70b9[%s-%s] cannot get participants, and skip,exception is [%s]", this.userTask.getId(), this.userTask.getName(), WfUtils.getExceptionStacktrace(e)));
        }
        SkipInfo skipInfo = this.getSkipInfo(task, (ExecutionEntity)execution);
        if (userIds == null || userIds.isEmpty()) {
            boolean skipNodeWithoutPart = false;
            Object skipNodeWithoutPartObj = DynamicFlowUtil.getDynNodeInfoByAttr((ExecutionEntity)execution, this.userTask.getId(), "skipNodeWithoutPart");
            if (skipNodeWithoutPartObj instanceof Boolean) {
                skipNodeWithoutPart = (Boolean)skipNodeWithoutPartObj;
            }
            boolean rejectBackNotSkip = false;
            if (!skipInfo.getSkipReason().isEmpty() && "RejectToBackNotSkip".equalsIgnoreCase(skipInfo.getSkipReason())) {
                rejectBackNotSkip = true;
            }
            if ((skipNodeWithoutPart || activeTaskParticipant != null && activeTaskParticipant.isSkipNodeWithoutPart()) && !rejectBackNotSkip) {
                skipInfo.setSkip(true);
                skipInfo.setSkipReason("NoParticipant");
            } else if (skipInfo.isFirstNode() && !isNoCodeUserTask) {
                userIds = new ArrayList<Long>();
                userIds.add(execution.getStartUserId());
            } else if (!this.userTask.getParticipant().isAllowNoneParticipant() && !skipInfo.isSkip()) {
                if (BpmnModelUtil.isFirstNodeByModel(this.userTask)) {
                    userIds = ParticipantHelper.getUserIdsForParticipantFromHiActivity(commandContext, task.getProcessInstanceId(), execution.getCurrentFlowElement().getId());
                    if (userIds.isEmpty()) {
                        throw ExceptionUtil.createWFNullParticipantException(execution);
                    }
                    userIds = participantCalculator.validateUserIds(execution, userIds);
                } else {
                    throw ExceptionUtil.createWFNullParticipantException(execution);
                }
            }
        }
        if (skipInfo.isSkip() && skipInfo.isFirstNode()) {
            if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_CREATED, task));
            }
            task.setDueDate(null);
            if (!MessageSystemParamterUtils.showSubmitLog()) {
                task.setDisplay(false);
            }
            taskEntityManager.insert(task, (ExecutionEntity)execution);
            ((ExecutionEntity)execution).setCurrentTask(task);
            ((ExecutionEntity)execution).setCurrentTaskId(task.getId());
            executionEntityManager.update((ExecutionEntity)execution);
            Long initor = task.getStarterId();
            String obj = (String)execution.getVariable("_initiator_");
            if (WfUtils.isNotEmpty(obj)) {
                initor = Long.valueOf(obj);
            }
            task.addUserIdentityLink(initor, "participant");
            commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners(this.userTask, task, "approverModify", TaskListenerInvocationType.NOTWITHDRAW);
            taskEntityManager.changeTaskAssignee(task, initor, null);
            String operation = (String)((ExecutionEntity)execution).getProcessInstance().getVariable("_operation_");
            ILocaleString defaultValue = WfUtils.getPromptWordLocaleString("\u63d0\u4ea4", "UserTaskActivityBehavior_1", "bos-wf-engine");
            ILocaleString resultName = TaskBehaviorUtil.getOperationName(task.getEntityNumber(), operation, defaultValue);
            Object auditMessageObj = ((ExecutionEntity)execution).getProcessInstance().getVariable("auditmessage");
            if (null != auditMessageObj && WfUtils.isJSONFormat(auditMessageObj)) {
                try {
                    Map auditMessageMap = (Map)SerializationUtils.fromJsonString((String)auditMessageObj.toString(), Map.class);
                    auditMessageObj = auditMessageMap.isEmpty() ? null : auditMessageMap;
                }
                catch (Exception e) {
                    this.logger.info(e.getMessage());
                }
            }
            if (WfUtils.isEmptyString(auditMessageObj)) {
                auditMessageObj = resultName;
            }
            boolean audit = BizFlowUtil.isAuditFlowExecution((ExecutionEntity)execution);
            boolean parentAudit = BizFlowUtil.isAuditFlowExecution(((ExecutionEntity)execution).getSuperExecution());
            if (!(audit && parentAudit && this.userTask.getClass().getName().equalsIgnoreCase(UserTask.class.getName()))) {
                LocaleString name;
                HashMap<String, Object> vars = new HashMap<String, Object>();
                vars.put("auditNumber", operation);
                vars.put("auditName", resultName);
                vars.put("auditMessage", auditMessageObj);
                vars.put("assignee", WfUtils.findUserName(initor));
                ILocaleString dai = WfUtils.getPromptWordLocaleString("%1$s(\u4ee3%2$s)", "UserTaskActivityBehavior_2", "bos-wf-engine");
                if (!initor.equals(task.getStarterId())) {
                    name = new LocaleString();
                    ILocaleString assignee = WfUtils.findUserName(initor);
                    ILocaleString startName = task.getStartName();
                    if (assignee != null && WfUtils.isNotEmpty(assignee)) {
                        name = WfMultiLangUtils.getMultiLangValue(dai, assignee, startName);
                    }
                    vars.put("assignee", name);
                }
                if (!initor.equals(task.getStarterId())) {
                    name = new LocaleString();
                    ILocaleString startNameFormat = task.getStartNameFormat();
                    ILocaleString assigneeFormat = ParticipantHelper.getParticipantDisplayInfo(task, Collections.singletonList(initor)).get(initor);
                    if (assigneeFormat != null && WfUtils.isNotEmpty(assigneeFormat)) {
                        name = WfMultiLangUtils.getMultiLangValue(dai, assigneeFormat, startNameFormat);
                    }
                    vars.put("assigneeFormat", name);
                }
                taskHelper.addComment(task.getId(), task.getProcessInstanceId(), initor, "comment", vars);
            }
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("auditName", resultName);
            variables.put("auditNumber", operation);
            variables.put("auditMessage", auditMessageObj);
            Object priority = ((ExecutionEntity)execution).getProcessInstance().getVariable("priority");
            if (WfUtils.isNotEmptyString(priority)) {
                variables.put("priority", priority);
            }
            task.setVariablesLocal(variables);
            TaskBehaviorUtil.dispatchTaskAssignListener(task, "UserTask");
            taskEntityManager.changeTaskExecutionType(task, "skip");
            taskHelper.deleteTaskEntity(task, "first_usertask_skip", false, false);
            taskHelper.updateHistoricIdentityLinkEntities(commandContext, task.getId(), Long.parseLong(RequestContext.get().getUserId()));
            commandContext.getHistoryManager().recordActivityExecutionType((ExecutionEntity)execution, "skip", skipInfo.getSkipReason());
            processEngineConfiguration.getListenerNotificationHelper().executeTaskListeners(task, "complete");
            if ("enterBoundary".equals(task.getExecutionType())) {
                return;
            }
            this.leaveByRightWay(execution);
        } else if (!skipInfo.isSkip()) {
            if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_CREATED, task));
            }
            DelegateExecution varScope = execution;
            if ("YunzhijiaTask".equals(this.userTask.getType())) {
                varScope = execution.getParent();
            }
            taskHelper.setLastUsedDealNode(varScope, commandContext, this.userTask);
            this.setTaskOtherProperties(task, (ExecutionEntity)execution);
            taskEntityManager.insert(task, (ExecutionEntity)execution);
            ((ExecutionEntity)execution).setCurrentTask(task);
            ((ExecutionEntity)execution).setCurrentTaskId(task.getId());
            executionEntityManager.update((ExecutionEntity)execution);
            String taskType = this.userTask.getType();
            HashMap<String, IdentityLinkEntity> identityLinkMap = new HashMap<String, IdentityLinkEntity>();
            if (userIds != null && !userIds.isEmpty()) {
                Object taskLevel;
                this.logger.debug(String.format("English display,userId are:%s", userIds.toString()));
                ArrayList<Long> nodeParticipantIds = new ArrayList<Long>();
                if (assignorIdAndDelegateSettingEntitys != null && !assignorIdAndDelegateSettingEntitys.isEmpty()) {
                    Set userIdKeySet = assignorIdAndDelegateSettingEntitys.keySet();
                    nodeParticipantIds.addAll(userIdKeySet);
                } else {
                    nodeParticipantIds.addAll(userIds);
                }
                Map userIdentityLinks = task.addUserIdentityLinks(nodeParticipantIds, "participant");
                TaskDelegateCalculateUtil.taskDelegate(task, nodeParticipantIds, assignorIdAndDelegateSettingEntitys);
                for (Long userId : userIds) {
                    identityLinkMap.put(String.valueOf(userId), (IdentityLinkEntity)userIdentityLinks.get(userId));
                }
                if (this.userTask.isCompositeTasks()) {
                    commandContext.getProcessEngineConfiguration().getTaskHelper().calcCompositeTask(mainExecution, this.userTask, userIds, identityLinkMap);
                }
                if (WfUtils.isNotEmptyString(taskLevel = DynamicFlowUtil.getDynNodeInfoByAttr((ExecutionEntity)execution, this.userTask.getId(), "priority"))) {
                    TaskHelper.setTaskPriority(taskLevel.toString(), task.getIdentityLinks(), task);
                }
                if ("UserTask".equals(taskType) || "BillTask".equals(taskType)) {
                    this.planToDoJob(commandContext, task.getId(), execution);
                }
            }
            if (!WfUtils.isTesting() && "UserTask".equals(this.userTask.getType())) {
                this.planAutoCirculateJob(commandContext, execution, task.getId(), "start");
                PreComputorHelper.doPreComputorFromActivityBehavior(execution.getProcessInstanceId(), "through", this.userTask, task);
            }
            commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners(this.userTask, task, "approverModify", TaskListenerInvocationType.NOTWITHDRAW);
            processEngineConfiguration.getListenerNotificationHelper().executeAfterTaskListeners(task, "afterCreate");
            TaskBehaviorUtil.dispatchTaskAssignListener(task, "UserTask");
            TaskHelper.planSavePageParameter(this.userTask, task);
            if ("UserTask".equals(taskType) || "BillTask".equals(taskType)) {
                this.triggerCreateTaskEvent(task, userIds, commandContext);
            }
            this.judgeExitJobAndExecute(commandContext, task);
        } else {
            commandContext.getHistoryManager().recordActivityExecutionType((ExecutionEntity)execution, skipInfo.getExecutionType(), skipInfo.getSkipReason());
            AbstractOperation agendaOperation = Context.getCommandContext().getAgendaOperation();
            if (agendaOperation instanceof ContinueProcessOperation) {
                String firstApproveOptNum;
                String auditNum;
                String approveType;
                if (this.userTask instanceof AuditTask && !"approve".equals(approveType = BpmnModelUtil.getApproveTypeByNum(this.userTask, auditNum = (String)((ExecutionEntity)execution).getCurrentTask().getTransientVariableLocal("auditNumber"))) && WfUtils.isNotEmpty(firstApproveOptNum = BpmnModelUtil.getFirstApproveOptNum(this.userTask))) {
                    ((ExecutionEntity)execution).getCurrentTask().setTransientVariableLocal("auditNumber", firstApproveOptNum);
                }
                ((ContinueProcessOperation)agendaOperation).getCallbacks().add(new AutoLeaveWhenContinueProcessCallback(this, execution));
            } else {
                this.leave(execution);
            }
        }
    }

    protected void triggerCreateTaskEvent(TaskEntity task, List<Long> userIds, CommandContext commandContext) {
        if (!commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskId", task.getId());
        map.put("userIds", userIds);
        map.put("busKey", task.getBusinessKey());
        map.put("billNo", task.getBillNo());
        map.put("entityNum", task.getEntityNumber());
        map.put("taskTitle", task.getSubject());
        map.put("activityId", task.getTaskDefinitionKey());
        map.put("activityName", task.getName());
        map.put("createTime", task.getCreateDate());
        new EventTriggerCmd(TaskEventTypeEnum.TASK_CREATE_EVENT.getCode(), SerializationUtils.toJsonString(map)).execute(commandContext);
    }

    protected void leaveByRightWay(DelegateExecution execution) {
        AbstractOperation agendaOperation = Context.getCommandContext().getAgendaOperation();
        if (agendaOperation instanceof ContinueProcessOperation) {
            ((ContinueProcessOperation)agendaOperation).getCallbacks().add(new AutoLeaveWhenContinueProcessCallback(this, execution));
        } else {
            this.leave(execution);
        }
    }

    private void judgeExitJobAndExecute(CommandContext commandContext, final TaskEntity task) {
        if (!WfConfigurationUtil.isNotDelayTriggerOperation()) {
            return;
        }
        if (!BpmnModelUtil.instanceofUserTaskOnly(task.getCategory())) {
            return;
        }
        List<DecisionOption> options = this.userTask.getDecisionOptions();
        if (options == null || options.isEmpty()) {
            return;
        }
        final ArrayList<String> operations = new ArrayList<String>(options.size());
        for (DecisionOption dp : options) {
            operations.add(dp.getNumber());
        }
        this.logger.debug(String.format("judge operation exist [%s] ", this.userTask.getNumber()));
        final ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        commandContext.addCloseListener(new DefaultCommandContextCloseListener(""){

            @Override
            public void closed(CommandContext commandContext) {
                CommandConfig commandConfig = processEngineConfiguration.getCommandExecutor().getDefaultConfig().transactionRequiresNew();
                processEngineConfiguration.getCommandExecutor().execute(commandConfig, new Command<Void>(){

                    @Override
                    public Void execute(CommandContext commandContext) {
                        QFilter pkf = new QFilter("businessKey", "=", (Object)task.getBusinessKey());
                        QFilter enf = new QFilter("entityNumber", "=", (Object)UserTaskActivityBehavior.this.userTask.getEntityNumber());
                        QFilter jtf = new QFilter("jobHandlerType", "=", (Object)"address-process-event");
                        QFilter opf = new QFilter("operation", "in", (Object)operations);
                        QFilter exf = new QFilter("exclusive", "=", (Object)true);
                        JobEntityManager jobManager = commandContext.getJobEntityManager();
                        final List jobs = jobManager.findByQueryFilters(new QFilter[]{pkf, enf, jtf, opf, exf});
                        JobEntity firstJob = null;
                        for (JobEntity job : jobs) {
                            if (firstJob == null) {
                                job.setState(JobStateEnum.CREATED.getNumber());
                                job.setSource(JobHandleStrategyFactory.getWFSource());
                                firstJob = job;
                            }
                            job.setExclusive(false);
                            jobManager.update(job);
                            UserTaskActivityBehavior.this.logger.debug(String.format("find address job [%s],job[%s] ", UserTaskActivityBehavior.this.userTask.getNumber(), job.getId()));
                        }
                        final JobEntity tmp = firstJob;
                        if (!jobs.isEmpty() && tmp != null) {
                            commandContext.addCloseListener(new DefaultCommandContextCloseListener(""){

                                @Override
                                public void closed(CommandContext commandContext) {
                                    JobUtil.sendJobToMQ(tmp);
                                    UserTaskActivityBehavior.this.logger.debug(String.format("send address job to mq [%s],job[%s] ", UserTaskActivityBehavior.this.userTask.getNumber(), jobs.size()));
                                }
                            });
                        } else {
                            UserTaskActivityBehavior.this.logger.debug(String.format("not found address job for [%s] ", UserTaskActivityBehavior.this.userTask.getNumber()));
                        }
                        return null;
                    }
                });
            }
        });
    }

    protected void setTaskOtherProperties(TaskEntity task, ExecutionEntity execution) {
    }

    public SkipInfo getSkipInfo(TaskEntity task, ExecutionEntity execution) {
        return DynamicFlowUtil.isSkipTask(this.userTask, task, execution);
    }

    protected void isTaskRepeated(DelegateExecution execution, TaskEntityManager taskEntityManager) {
        List<TaskEntity> taskEntities = taskEntityManager.findTasksByExecutionId(execution.getId());
        for (TaskEntity taskEntity : taskEntities) {
            if (taskEntity.isDeleted()) continue;
            throw new WFTaskException(WFErrorCode.taskRepeated(), taskEntity.getName(), taskEntity.getId());
        }
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        CommandContext commandContext = Context.getCommandContext();
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        List<TaskEntity> taskEntities = taskEntityManager.findTasksByExecutionId(execution.getId());
        for (TaskEntity taskEntity : taskEntities) {
            if (taskEntity.isDeleted()) continue;
            throw new WFTaskException(WFErrorCode.taskUnFinished(), this.userTask.getName(), taskEntity.getId());
        }
        this.leave(execution);
    }

    /*
     * Loose catch block
     */
    protected List<Long> handleParticipants(ParticipatantModel participant, String businessKey, ParticipantCalculator participantCalculator, DelegateExecution execution, Map<Long, List<DelegateSettingEntity>> assignorIdAndDelegateSettingEntitys, TaskEntity task) {
        try {
            try (TraceSpan tracer = Tracer.create((String)"WF_PARTICIPANT", (String)WfTracerHelper.wrapTagValue("handleParticipants", String.valueOf(execution.getProcessDefinitionId()), businessKey, execution.getCurrentActivityId()));){
                RunTimeLog.get().init(SceneType.TASKPARTICIPANTPARSE, LogClassType.PARTICIPANT_LOG_BLOCK);
                List<Long> userIds = participantCalculator.getUserIds(execution.getProcessInstanceId(), execution.getCurrentActivityId(), businessKey, execution, true);
                Set<Long> trusteeIds = this.getTrusteeIds(task, userIds, assignorIdAndDelegateSettingEntitys);
                if (trusteeIds != null && !trusteeIds.isEmpty()) {
                    for (Long trusteeId : trusteeIds) {
                        if (userIds.contains(trusteeId)) continue;
                        userIds.add(trusteeId);
                    }
                }
                this.logger.debug("participant parse end ");
                List<Long> list = userIds;
                return list;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            RunTimeLog.get().end(execution);
            this.logger.debug("longcontext end  ");
        }
    }

    public TaskEntity buildTaskEntity(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        TaskEntity task = TaskBehaviorUtil.buildTaskEntity(execution, this.userTask);
        executionEntity.setCurrentTask(task);
        if (ModelType.NoCodeFlow.name().equals(executionEntity.getProcessType()) && "UserTask".equals(this.userTask.getType())) {
            String newBusinessKey = this.parseAndResetBusinessKey(executionEntity, task);
            if (WfUtils.isEmpty(newBusinessKey)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u8282\u70b9\u4e1a\u52a1\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserTaskActivityBehavior_3", (String)"bos-wf-engine", (Object[])new Object[0]), this.userTask.getName()));
            }
            if (!executionEntity.getEntityNumber().equals(this.userTask.getEntityNumber())) {
                task.setEntityNumber(this.userTask.getEntityNumber());
                TaskBehaviorUtil.setEntityProperties(task, this.userTask.getEntityNumber(), newBusinessKey);
            }
        }
        return task;
    }

    private String parseAndResetBusinessKey(ExecutionEntity executionEntity, TaskEntity task) {
        String billId = this.userTask.getAttributeValue("noCodeData.billId");
        if (billId == null) {
            billId = this.userTask.getAttributeValue("extData.noCode_billId");
        }
        if (WfUtils.isEmpty(billId)) {
            this.logger.debug("billId is null.");
            return null;
        }
        String businessKey = null;
        if ("${execution.businessKey}".equals(billId)) {
            businessKey = executionEntity.getBusinessKey();
        } else {
            DynamicObject dynObj = WfUtils.findBusinessObject(executionEntity.getBusinessKey(), executionEntity.getEntityNumber());
            businessKey = ExpressionCalculatorUtil.parseContent(billId.replaceFirst("\\$(\\{.+\\})", "$1"), dynObj, executionEntity, null, false);
        }
        task.setBusinessKey(businessKey);
        this.logger.debug(String.format("The value after parsing %s is %s. ActivityId: %s, ProcInstId: %s", billId, businessKey, this.userTask.getId(), executionEntity.getProcessInstanceId()));
        return businessKey;
    }

    private Set<Long> getTrusteeIds(TaskEntity task, List<Long> nodeParticipantIds, Map<Long, List<DelegateSettingEntity>> assignorIdAndDelegateSettingEntitys) {
        TaskDelegateCalculateResult taskDelegateCalculateResult;
        HashSet<Long> trusteeIds = new HashSet<Long>();
        if (!BpmnModelUtil.isFirstNodeByModel(this.userTask) && (taskDelegateCalculateResult = TaskDelegateCalculateUtil.getTrusteeIds(task, nodeParticipantIds, new ArrayList<Long>())).getTrustees() != null) {
            trusteeIds.addAll(taskDelegateCalculateResult.getTrustees());
            assignorIdAndDelegateSettingEntitys.putAll(taskDelegateCalculateResult.getAssignorIdAndDelegateSettingEntitys());
        }
        return trusteeIds;
    }

    protected void planToDoJob(CommandContext commandContext, Long taskId, DelegateExecution execution) {
        if (!this.userTask.isAllowSendTodo()) {
            execution.setTransientVariableLocal("isNotAllowSendTodo", Boolean.TRUE);
            this.logger.debug(String.format("[%s] is not allow send to do", this.userTask.getNumber()));
        }
        if (this.canCreateTodo(commandContext, String.valueOf(taskId), execution)) {
            execution.setTransientVariableLocal("allowSendTaskReceivedMsg", Boolean.TRUE);
            commandContext.getMessageService().createToDo(taskId);
        } else {
            this.logger.debug(String.format("cannot send todo msg for task[%s]", taskId));
        }
    }

    protected boolean canCreateTodo(CommandContext commandContext, String taskId, DelegateExecution execution) {
        return Boolean.TRUE;
    }

    protected void planAutoCirculateJob(CommandContext commandContext, DelegateExecution execution, Long taskId, String trigger) {
        boolean allowCirculate = false;
        CirculateModel circulateModel = this.userTask.getCirculateModel();
        allowCirculate = circulateModel != null ? circulateModel.isCirculateWhenMatch() : true;
        if (allowCirculate && circulateModel != null && circulateModel.getCirculate() != null && circulateModel.getCirculate().getTrigger() != null && StringUtils.equals((String)trigger, (String)circulateModel.getCirculate().getTrigger())) {
            JobEntity circulateJob = commandContext.getJobManager().createCirculateJob((ExecutionEntity)execution, taskId);
            commandContext.getJobManager().scheduleAsyncJob(circulateJob);
        }
    }
}

