/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.TimingModel;
import kd.bos.workflow.bpmn.model.WaitTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskActivityBehavior;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.DelayBroadcastJobHandler;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.timing.TimingModelUtil;

public class WaitTaskActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = 6246802857968393914L;
    private WaitTask waitTask;

    public WaitTaskActivityBehavior(WaitTask waitTask) {
        this.waitTask = waitTask;
    }

    @Override
    public void execute(DelegateExecution execution) {
        boolean skipWhenBoot = BizFlowUtil.ifSkipWhenBootThenRecordExecutionType(execution, this.waitTask);
        if (WfUtils.isTesting() || skipWhenBoot) {
            this.logger.debug(String.format("leave... executionId: %s, businessKey: %s", execution.getId(), execution.getBusinessKey()));
            this.leave(execution);
            return;
        }
        TimingModel timingModel = this.waitTask.getTimingModel();
        if (timingModel != null) {
            if ("event".equals(timingModel.getType())) {
                this.doWaitByEvent((ExecutionEntity)execution, timingModel);
            } else {
                TimingModelUtil.asyncExecuteByTime(timingModel, "waitTask", Context.getCommandContext(), (ExecutionEntity)execution);
            }
        } else {
            this.logger.debug(String.format("%s's TimingModel is null!", this.waitTask.getId()));
        }
        Object lastNodeVar = execution.getVariableLocal("lastUserDealNode");
        if ("startProcessInstance".equals(lastNodeVar) || "startStrongControl".equals(lastNodeVar)) {
            execution.setVariableLocal("lastUserDealNode", "start");
        }
    }

    private void doWaitByEvent(ExecutionEntity execution, TimingModel timingModel) {
        this.logger.debug(String.format("doWaitByEvent executionId: %s, businessKey: %s", execution.getId(), execution.getBusinessKey()));
        CommandContext commandContext = Context.getCommandContext();
        boolean result = new DelayBroadcastJobHandler().consumeDelayBroadcastJob(commandContext, execution, this.waitTask);
        if (result) {
            this.logger.debug(String.format("consume delay-broadcast event %s, leave. executionId: %s", timingModel.getEvent(), execution.getId()));
            this.leave(execution);
            return;
        }
        commandContext.getEventSubscriptionEntityManager().insertWaitEventSubscription(execution, this.waitTask.getId(), timingModel.getEvent());
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        QFilter[] filters = new QFilter[]{new QFilter("jobHandlerType", "=", (Object)"async-timing"), new QFilter("executionId", "=", (Object)execution.getId()), new QFilter("elementId", "=", (Object)this.waitTask.getId())};
        Context.getCommandContext().getTimerJobEntityManager().deleteByFilters(filters);
        this.leave(execution);
    }
}

