/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.agenda.ForkJoinUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.GatewayActivityBehavior;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.delegate.ActivityBehavior;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntityManager;
import kd.bos.workflow.engine.task.center.ForkNodeRejectListener;

public class WarpGatewayActivityBehavior
extends GatewayActivityBehavior {
    private static final long serialVersionUID = 912824828994721222L;
    protected static Log logger = LogFactory.getLog(WarpGatewayActivityBehavior.class);
    private ActivityBehavior activityBehavior;
    private FlowNode flowNode;

    public WarpGatewayActivityBehavior() {
    }

    public WarpGatewayActivityBehavior(FlowNode flowNode) {
        this.flowNode = flowNode;
    }

    public ActivityBehavior getActivityBehavior() {
        return this.activityBehavior;
    }

    public void setActivityBehavior(ActivityBehavior activityBehavior) {
        this.activityBehavior = activityBehavior;
    }

    @Override
    public void execute(DelegateExecution execution) {
        String joinFlag = ForkJoinUtils.getJoinFlag(execution, this.flowNode.getId());
        if (this.flowNode.getJoin() != null && this.flowNode.getJoin().booleanValue() && "enterwhenallarrive".equals(this.flowNode.getInSet()) && WfUtils.isNotEmpty(joinFlag)) {
            Object tmp;
            int noOfArrived = 1;
            ExecutionEntity proinst = ((ExecutionEntity)execution).getProcessInstance();
            this.calculateAndCacheFirstEnterExecId(execution, proinst, joinFlag);
            if (execution.getVariableLocal("lastUserDealNode") != null && ("startProcessInstance".equals(execution.getVariableLocal("lastUserDealNode")) || "startStrongControl".equals(execution.getVariableLocal("lastUserDealNode")))) {
                Long firstEnterExecutionId = (Long)ForkJoinUtils.getFirstEnterJoinExecution(joinFlag, proinst);
                execution.setVariableLocal("lastUserDealNode", "start");
                if (!execution.getId().equals(firstEnterExecutionId)) {
                    ExecutionEntity firstExe = (ExecutionEntity)Context.getCommandContext().getExecutionEntityManager().findById(firstEnterExecutionId);
                    firstExe.setVariableLocal("lastUserDealNode", "start");
                }
            }
            if ((tmp = ForkJoinUtils.getNoOfArrived(joinFlag, proinst)) != null) {
                noOfArrived = (Integer)tmp + 1;
            }
            ForkJoinUtils.setNoOfArrived(joinFlag, proinst, noOfArrived);
            tmp = ForkJoinUtils.getNoOfShouldSurvive(joinFlag, proinst);
            int noOfShouldSurvive = 0;
            if (tmp != null) {
                noOfShouldSurvive = (Integer)tmp;
            }
            if (ForkJoinUtils.meetJoinCondition(this.flowNode, noOfShouldSurvive, noOfArrived, (ExecutionEntity)execution)) {
                ExecutionEntity runExe = (ExecutionEntity)Context.getCommandContext().getExecutionEntityManager().findById((Long)ForkJoinUtils.getFirstEnterJoinExecution(joinFlag, proinst));
                if (runExe.getVariableLocal("lastUserDealNode") != null && "start".equals(runExe.getVariableLocal("lastUserDealNode"))) {
                    runExe.setVariableLocal("lastUserDealNode", "startProcessInstance");
                }
                if (this.activityBehavior == null) {
                    super.leave(runExe);
                } else {
                    this.activityBehavior.execute(runExe);
                    if (execution instanceof ExecutionEntity) {
                        ((ExecutionEntity)execution).setCurrentTaskId(runExe.getCurrentTaskId());
                    }
                }
            } else {
                execution.setTransientVariable("joinNoteEnterState", "notIn");
                logger.warn("\u4e0d\u80fd\u6ee1\u8db3\u805a\u5408\u6761\u4ef6\uff0c\u8bb0\u5f55\u53d8\u91cfjoinNoteEnterState\u4e3anotIn");
            }
        } else if ("enterwhenfirstone".equals(this.flowNode.getInSet())) {
            List<HistoricActivityInstanceEntity> preNodes;
            if (this.activityBehavior == null) {
                super.leave(execution);
            } else {
                this.activityBehavior.execute(execution);
            }
            HistoricActivityInstanceEntityManager hiActMgr = Context.getCommandContext().getHistoricActivityInstanceEntityManager();
            List<HistoricActivityInstanceEntity> targets = hiActMgr.findByTargetId(execution.getProcessInstanceId(), execution.getCurrentActInstId());
            if (targets != null && !targets.isEmpty() && (preNodes = hiActMgr.findByTargetId(execution.getProcessInstanceId(), targets.get(0).getId())) != null && !preNodes.isEmpty()) {
                ForkNodeRejectListener.markOtherBranchsEnd(Context.getCommandContext(), (ExecutionEntity)execution, execution.getProcessInstanceId(), preNodes.get(0).getActivityId(), "", "", "inset");
            }
        } else if (this.activityBehavior == null) {
            super.leave(execution);
        } else {
            this.activityBehavior.execute(execution);
        }
    }

    private void calculateAndCacheFirstEnterExecId(DelegateExecution execution, ExecutionEntity proinst, String joinFlag) {
        HiUserActInstEntityManager userInstMgr = Context.getCommandContext().getHiUserActInstEntityManager();
        Long firstEnterExecutionId = null;
        if (ForkJoinUtils.getFirstEnterJoinExecution(joinFlag, proinst) == null) {
            ForkJoinUtils.setFirstEnterJoinExecution(joinFlag, proinst, execution.getId());
            firstEnterExecutionId = execution.getId();
        } else {
            firstEnterExecutionId = (Long)ForkJoinUtils.getFirstEnterJoinExecution(joinFlag, proinst);
            execution.setActive(false);
        }
        if (ProcessType.AuditFlow.name().equals(proinst.getProcessType()) || ProcessType.NoCodeFlow.name().equals(proinst.getProcessType())) {
            List<HiUserActInstEntity> userInsts = userInstMgr.findByActivityAndProinstId(execution.getCurrentActInstId(), execution.getProcessInstanceId());
            for (HiUserActInstEntity i : userInsts) {
                if (!WfUtils.isEmpty(i.getCurrentExecutionId())) continue;
                i.setCurrentExecutionId(firstEnterExecutionId);
                userInstMgr.update(i);
            }
        }
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        if (this.activityBehavior instanceof FlowNodeActivityBehavior) {
            ((FlowNodeActivityBehavior)this.activityBehavior).trigger(execution, signalName, signalData);
        } else {
            super.trigger(execution, signalName, signalData);
        }
    }
}

