/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SelectNodesModel;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.identity.ParticipantPositionEntity;
import kd.bos.workflow.engine.impl.bpmn.behavior.SkipInfo;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.calculator.ParticipantCalculator;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.log.LogClassType;
import kd.bos.workflow.engine.impl.log.RunTimeLog;
import kd.bos.workflow.engine.impl.log.SceneType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.MessageTypeEnum;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.task.TaskDelegateCalculateUtil;
import kd.bos.workflow.engine.task.delegatesetting.TaskDelegateCalculateResult;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;

public class YunzhijiaCommonMultiInstanceBehavior {
    protected static Log logger = LogFactory.getLog(YunzhijiaCommonMultiInstanceBehavior.class);
    private static final String SUMDECISION = "sumDecision";

    public boolean createParentTask(DelegateExecution execution, Activity activity, boolean parallel) {
        CommandContext commandContext = Context.getCommandContext();
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        YunzhijiaTask yunzhijiaTask = (YunzhijiaTask)activity;
        TaskEntity parentTask = TaskBehaviorUtil.buildTaskEntity(execution, yunzhijiaTask);
        parentTask.setHandleState("willApproval");
        ((ExecutionEntity)execution).setCurrentTask(parentTask);
        List<Long> userIds = null;
        try {
            ParticipantCalculator participantCalculator = commandContext.getProcessEngineConfiguration().getParticipantCalculator();
            RunTimeLog.get().init(SceneType.TASKPARTICIPANTPARSE, LogClassType.PARTICIPANT_LOG_BLOCK);
            userIds = participantCalculator.getUserIds(execution.getProcessInstanceId(), execution.getCurrentActivityId(), execution.getBusinessKey(), execution, true);
            Set<Long> trusteeIds = this.getTrusteeIds(parentTask, userIds, execution);
            ArrayList<Long> userIdsAndTrusteeIdsList = new ArrayList<Long>();
            userIdsAndTrusteeIdsList.addAll(userIds);
            if (trusteeIds != null && !trusteeIds.isEmpty()) {
                for (Long trusteeId : trusteeIds) {
                    if (userIdsAndTrusteeIdsList.contains(trusteeId)) continue;
                    userIdsAndTrusteeIdsList.add(trusteeId);
                }
            }
            RunTimeLog.get().end(execution);
            TaskBehaviorUtil.updateParticipantVariable(parentTask, userIdsAndTrusteeIdsList, yunzhijiaTask.getParticipant() == null ? false : yunzhijiaTask.getParticipant().isAllowNoneParticipant());
            parentTask.setSubject(TaskBehaviorUtil.getTaskSubject(yunzhijiaTask, parentTask, execution.getBusinessKey(), execution.getEntityNumber()));
            if (parallel && userIds != null && !userIds.isEmpty()) {
                String key = String.format("%s_%s", execution.getId(), execution.getCurrentActInstId());
                Context.getCommandContext().addAttribute(key, userIds);
                logger.debug(String.format("initUser:[%s]", WfUtils.listToString(userIds, ",")));
            }
        }
        catch (Exception e) {
            if (!DynamicFlowUtil.isSkipCurNode(parentTask.getExecution())) {
                throw e;
            }
            logger.debug(String.format("\u8282\u70b9[%s-%s] cannot get participants, and skip,exection is [%s]", yunzhijiaTask.getId(), yunzhijiaTask.getName(), WfUtils.getExceptionStacktrace(e)));
        }
        parentTask.setDisplay(!yunzhijiaTask.isHideTaskInCenter());
        ((ExecutionEntity)execution).setCurrentTask(parentTask);
        SkipInfo skipInfo = DynamicFlowUtil.isSkipTask(yunzhijiaTask, parentTask, (ExecutionEntity)execution);
        ParticipatantModel yunzhijiaTaskParticipant = yunzhijiaTask.getParticipant();
        boolean rejectBackNotSkip = false;
        if (!skipInfo.getSkipReason().isEmpty() && "RejectToBackNotSkip".equalsIgnoreCase(skipInfo.getSkipReason())) {
            rejectBackNotSkip = true;
        }
        if (userIds == null || userIds.isEmpty()) {
            boolean skipNodeWithoutPart = false;
            Object skipNodeWithoutPartObj = DynamicFlowUtil.getDynNodeInfoByAttr((ExecutionEntity)execution, yunzhijiaTask.getId(), "skipNodeWithoutPart");
            if (skipNodeWithoutPartObj instanceof Boolean) {
                skipNodeWithoutPart = (Boolean)skipNodeWithoutPartObj;
            }
            if (!rejectBackNotSkip && (skipNodeWithoutPart || yunzhijiaTaskParticipant != null && yunzhijiaTaskParticipant.isSkipNodeWithoutPart())) {
                skipInfo.setSkip(true);
                skipInfo.setSkipReason("NoParticipant");
            }
        }
        if (skipInfo.isSkip()) {
            String firstApproveOptNum;
            commandContext.getHistoryManager().recordActivityStart((ExecutionEntity)execution);
            commandContext.getHistoryManager().recordActivityExecutionType((ExecutionEntity)execution, skipInfo.getExecutionType(), skipInfo.getSkipReason());
            String auditNum = (String)((ExecutionEntity)execution).getCurrentTask().getTransientVariableLocal("auditNumber");
            String approveType = BpmnModelUtil.getApproveTypeByNum(yunzhijiaTask, auditNum);
            if (("reject".equals(approveType) || "forceReject".equals(approveType)) && WfUtils.isNotEmpty(firstApproveOptNum = BpmnModelUtil.getFirstApproveOptNum(yunzhijiaTask))) {
                ((ExecutionEntity)execution).getCurrentTask().setTransientVariableLocal("auditNumber", firstApproveOptNum);
            }
        } else {
            taskEntityManager.insert(parentTask, (ExecutionEntity)execution);
            parentTask.setVariableLocal("yunZhiJiaNodeRejectBackNotSkip", rejectBackNotSkip);
            parentTask.setVariableLocal("teamMembers", WfUtils.listToString(userIds, ","));
            ILocaleString participantName = WfUtils.getILocaleUsersName(userIds);
            if (WfUtils.isNotEmpty(participantName)) {
                parentTask.setVariableLocal("teamMemberNames", SerializationUtils.toJsonString((Object)participantName));
            }
            if (userIds != null && !userIds.isEmpty()) {
                ILocaleString participantNameFormater = ParticipantHelper.getUserNameFormatValue(parentTask, userIds);
                if (WfUtils.isNotEmpty(participantNameFormater)) {
                    parentTask.setVariableLocal("teamMemberNamesFormat", SerializationUtils.toJsonString((Object)participantNameFormater));
                }
                HashMap<Long, ParticipantPositionEntity> userPositionMap = new HashMap<Long, ParticipantPositionEntity>(userIds.size());
                for (Long userId : userIds) {
                    userPositionMap.put(userId, commandContext.getUserPosoitionCache(userId));
                }
                execution.setVariable("userPosition", userPositionMap);
            }
            ((ExecutionEntity)execution).setCurrentTask(parentTask);
            ((ExecutionEntity)execution).setCurrentTaskId(parentTask.getId());
            executionEntityManager.update((ExecutionEntity)execution);
        }
        return skipInfo.isSkip();
    }

    private Set<Long> getTrusteeIds(TaskEntity parentTask, List<Long> userIds, DelegateExecution execution) {
        TaskDelegateCalculateResult taskDelegateCalculateResult = TaskDelegateCalculateUtil.getTrusteeIds(parentTask, userIds, new ArrayList<Long>());
        Set<Long> trusteeIds = taskDelegateCalculateResult.getTrustees();
        Map<Long, List<DelegateSettingEntity>> assignorIdAndDelegateSettingEntitys = taskDelegateCalculateResult.getAssignorIdAndDelegateSettingEntitys();
        HashMap userAndTrusteeIdMap = new HashMap();
        HashMap assignorIdAndDelegateIdsMap = new HashMap();
        if (assignorIdAndDelegateSettingEntitys != null && !assignorIdAndDelegateSettingEntitys.isEmpty()) {
            Set<Map.Entry<Long, List<DelegateSettingEntity>>> delegateSettings = assignorIdAndDelegateSettingEntitys.entrySet();
            for (Map.Entry<Long, List<DelegateSettingEntity>> delegateSetting : delegateSettings) {
                ArrayList<Long> delegateSettingTrusteeIds = new ArrayList<Long>();
                ArrayList<Long> assignorIdAndDelegateIds = new ArrayList<Long>();
                List<DelegateSettingEntity> values = delegateSetting.getValue();
                for (DelegateSettingEntity value : values) {
                    if (value == null) continue;
                    delegateSettingTrusteeIds.add(value.getTrusteeId());
                    assignorIdAndDelegateIds.add(value.getId());
                }
                userAndTrusteeIdMap.put(delegateSetting.getKey(), delegateSettingTrusteeIds);
                assignorIdAndDelegateIdsMap.put(delegateSetting.getKey(), assignorIdAndDelegateIds);
            }
        }
        execution.setVariableLocal("trusteeIds", SerializationUtils.toJsonString(userAndTrusteeIdMap));
        execution.setVariableLocal("assignorIdAndDelegate", SerializationUtils.toJsonString(assignorIdAndDelegateIdsMap));
        return trusteeIds;
    }

    public boolean completeNormalLevel(DelegateExecution execution, Activity activity) {
        TaskEntity parentTask;
        YunzhijiaTask task = null;
        if (!(activity instanceof YunzhijiaTask)) {
            return true;
        }
        task = (YunzhijiaTask)activity;
        Map<String, Object> variables = ((ExecutionEntity)execution).getCurrentTask().getVariablesLocal();
        ExecutionEntity parentExecution = (ExecutionEntity)execution.getParent();
        Object yzjApprvoalInfo = parentExecution.getVariable("yzjParentApprovl");
        List<DecisionOption> decisions = task.getDecisionOptions();
        Object yzjResultNumber = parentExecution.getVariable("yunzhijiaResultNumber");
        boolean approve = false;
        if (!(yzjApprvoalInfo instanceof Boolean)) {
            throw new WFException(WFErrorCode.engineError(), ResManager.loadKDString((String)"\u4f1a\u5ba1\u8282\u70b9\u751f\u6210\u6c47\u603b\u4fe1\u606f\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u6c47\u603b\u51b3\u7b56\u7c7b\u578b\u3002", (String)"YunzhijiaParallelMultiInstanceBehavior_9", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        approve = (Boolean)yzjApprvoalInfo;
        DecisionOption decision = this.getYunzhijiaDecisionOption(decisions, yzjResultNumber);
        if (decision == null) {
            decision = this.getOriDecisionOption(decisions, approve, variables, task);
        }
        CommentEntity comment = (CommentEntity)Context.getCommandContext().getCommentEntityManager().create();
        TaskEntity taskEntity = parentExecution.getCurrentTask();
        if (taskEntity == null) {
            return true;
        }
        comment.setTaskId(taskEntity.getId());
        comment.setGroupId(String.valueOf(taskEntity.getId()));
        comment.setBackToBack(task.getBackToBackVote());
        comment.setType("comment");
        comment.setTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        comment.setProcessInstanceId(parentExecution.getProcessInstanceId());
        comment.setActivityId(parentExecution.getCurrentActivityId());
        ILocaleString result = WfUtils.getPromptWordLocaleString("\u6700\u7ec8\u7ed3\u679c\u4e3a%s", "ParticipantCalculatorImpl_6", "bos-wf-engine");
        LocaleString value = new LocaleString();
        if (decision != null) {
            comment.setDecisionType(decision.getAuditType());
            comment.setResultNumber(decision.getNumber());
            String multiKey = BpmnModelUtil.getDecisionNameMultiKey(comment.getActivityId(), decision.getId());
            comment.setResultName(BpmnModelUtil.getMultiLangFieldValue(comment.getProcessInstanceId(), multiKey, decision.getName()));
            ILocaleString passed = WfUtils.getPromptWordLocaleString("\u3010\u901a\u8fc7\u3011\u3002", "ParticipantCalculatorImpl_7", "bos-wf-engine");
            ILocaleString rejected = WfUtils.getPromptWordLocaleString("\u3010\u9a73\u56de\u3011\u3002", "ParticipantCalculatorImpl_8", "bos-wf-engine");
            ILocaleString forceRejected = WfUtils.getPromptWordLocaleString("\u3010\u5f3a\u5236\u9a73\u56de\u3011\u3002", "ParticipantCalculatorImpl_33", "bos-wf-engine");
            ILocaleString terminationed = WfUtils.getPromptWordLocaleString("\u3010\u7ec8\u6b62\u3011\u3002", "ParticipantCalculatorImpl_29", "bos-wf-engine");
            value = approve ? passed : ("forceReject".equals(decision.getAuditType()) ? forceRejected : ("reject".equals(decision.getAuditType()) ? rejected : terminationed));
        }
        comment.setMessage(WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{result, value}));
        parentExecution.setTransientVariable(SUMDECISION, comment);
        List<TaskEntity> tasks = Context.getCommandContext().getTaskEntityManager().findTasksByExecutionId(parentExecution.getId());
        TaskEntity taskEntity2 = parentTask = tasks != null && !tasks.isEmpty() ? tasks.get(0) : null;
        if (parentTask != null) {
            comment.setTaskId(parentTask.getId());
            parentExecution.setCurrentTask(parentTask);
            parentTask.removeTransientVariable("auditNumber");
            parentTask.setVariablesLocal(variables);
            parentTask.setVariableLocal("auditNumber", comment.getResultNumber());
            parentTask.setVariableLocal("auditName", comment.getCommentResult());
            String auditTypeValue = "";
            if (approve) {
                auditTypeValue = "approve";
            } else if (decision != null) {
                auditTypeValue = "reject".equals(decision.getAuditType()) || "forceReject".equals(decision.getAuditType()) ? "reject" : "terminate";
            }
            parentTask.setVariableLocal("auditType", auditTypeValue);
            parentTask.setVariableLocal("auditMessage", comment.getMessage());
            parentTask.setVariableLocal("businessModel", task.getBusinessModel());
            parentTask.setVariableLocal("showThroughRules", String.valueOf(task.isShowThroughRules()));
            parentTask.setVariableLocal("throughRulesType", task.getThroughRulesType());
            parentTask.setVariableLocal("rulesContent", task.getRulesContent());
            if ("passByFraction".equals(task.getPasstype())) {
                parentTask.setVariableLocal("passFraction", task.getPassfraction());
            } else if ("passByAnyOne".equals(task.getPasstype())) {
                parentTask.setVariableLocal("passType", task.getPasstype());
            } else {
                parentTask.setVariableLocal("passPercentage", task.getPassPercentage());
            }
            if (approve) {
                parentTask.removeVariableLocal("nextNodeId");
            } else if (decision != null) {
                String nextNode = (String)parentTask.getVariableLocal("nextNodeId");
                if (WfUtils.isEmpty(nextNode) && ("reject".equals(decision.getAuditType()) || "forceReject".equals(decision.getAuditType()))) {
                    nextNode = this.getNextNodeId(execution, decision);
                    if (!"abortByRejectToParentProcess".equals(parentTask.getVariableLocal("dynType"))) {
                        parentTask.setVariableLocal("dynType", "dynReject");
                    }
                    parentTask.setVariableLocal("nextNodeId", nextNode);
                } else if ("terminate".equals(decision.getAuditType())) {
                    parentTask.removeVariableLocal("nextNodeId");
                }
            }
        }
        return true;
    }

    protected String getNextNodeId(DelegateExecution execution, DecisionOption decis) {
        List<DecisionOption> decisionOptions = ((YunzhijiaTask)execution.getCurrentFlowElement()).getDecisionOptions();
        if (CollectionUtil.isEmpty(decisionOptions)) {
            Process process = ProcessDefinitionUtil.getProcess(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
            YunzhijiaTask yunzhijiaTask = (YunzhijiaTask)process.getFlowElement(execution.getCurrentActivityId());
            decisionOptions = yunzhijiaTask.getDecisionOptions();
        }
        for (DecisionOption decision : decisionOptions) {
            List<SelectNodesModel> rejectOptions;
            if (decis == null || !decis.getNumber().equals(decision.getNumber())) continue;
            if (decision.isRejectPreNodeScene()) {
                rejectOptions = DynamicFlowUtil.getUpperLevel(((ExecutionEntity)execution).getCurrentTask());
                return rejectOptions.get(0).getItemId();
            }
            rejectOptions = decision.getRejectOptions();
            if (rejectOptions == null || rejectOptions.isEmpty()) continue;
            return rejectOptions.get(0).getItemId();
        }
        return "";
    }

    public TaskEntity handleTaskLeave(DelegateExecution execution, boolean jump, ExecutionEntity executionToUse, Activity activity) {
        ExecutionEntity procinst;
        CommentEntity comment = (CommentEntity)executionToUse.getTransientVariable(SUMDECISION);
        TaskEntity parentTask = null;
        TaskEntity task = (TaskEntity)execution.getCurrentTask();
        if (task != null) {
            parentTask = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(task.getParentTaskId());
        }
        if ((procinst = executionToUse.getProcessInstance()) != null) {
            procinst.removeVariable(String.format("%s-%s", ((YunzhijiaTask)activity).getNumber(), "yzjSubInstNum"));
            procinst.removeVariable(String.format("%s-%s", ((YunzhijiaTask)activity).getNumber(), "yzjConsentVoteNum"));
            procinst.removeVariable(String.format("%s-%s", ((YunzhijiaTask)activity).getNumber(), "yzjReceivedTaskUsers"));
        }
        if (comment != null) {
            QFilter proinstIdFilter = new QFilter("processInstanceId", "=", (Object)execution.getProcessInstanceId());
            QFilter groupIdFilter = new QFilter("groupId", "=", (Object)String.valueOf(((TaskEntity)execution.getCurrentTask()).getParentTaskId()));
            List childrenComments = Context.getCommandContext().getCommentEntityManager().findByQueryFilters(new QFilter[]{proinstIdFilter, groupIdFilter}, true);
            if (childrenComments != null && !childrenComments.isEmpty()) {
                LocaleString assignee = new LocaleString();
                int size = childrenComments.size();
                CommentEntity c = null;
                int step = 9;
                for (int i = 0; i < size; ++i) {
                    c = (CommentEntity)childrenComments.get(i);
                    step = Math.max(step, c.getStep());
                    ILocaleString name = c.getTaskAssignee();
                    for (String key : name.keySet()) {
                        String value = (String)assignee.get((Object)key);
                        StringBuilder sb = null;
                        sb = value == null ? new StringBuilder() : new StringBuilder(value);
                        sb.append((String)name.get((Object)key));
                        if (i < size - 1) {
                            sb.append(',');
                        }
                        assignee.put((Object)key, (Object)sb.toString());
                    }
                }
                if (assignee != null && !WfUtils.isEmpty(assignee.toString())) {
                    comment.setAssignee((ILocaleString)assignee);
                }
                comment.setStep(++step);
            }
            Context.getCommandContext().getCommentEntityManager().insert(comment);
            Context.getCommandContext().getTaskHelper().deleteTask(comment.getTaskId(), "task complete", false, false);
            executionToUse.removeTransientVariable(SUMDECISION);
            Context.getCommandContext().getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners(parentTask, "complete");
            this.sendSubscribeMsg(parentTask, comment);
        } else if (jump) {
            if (execution.getCurrentTask() != null && execution.getCurrentTask().getId() != null) {
                QFilter filter0 = new QFilter("processInstanceId", "=", (Object)execution.getProcessInstanceId());
                QFilter filter = new QFilter("groupId", "=", (Object)((TaskEntity)execution.getCurrentTask()).getId().toString());
                Context.getCommandContext().getCommentEntityManager().deleteByFilters(new QFilter[]{filter0, filter});
            }
            if (parentTask != null) {
                Context.getCommandContext().getTaskEntityManager().changeTaskExecutionType(parentTask, "skip");
                Context.getCommandContext().getTaskHelper().deleteTask(parentTask.getId(), "task skip", false, false);
            }
        }
        Context.getCommandContext().getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners((TaskEntity)execution.getCurrentTask(), "delete");
        return parentTask;
    }

    private void sendSubscribeMsg(TaskEntity taskEntity, CommentEntity comment) {
        if (taskEntity == null) {
            logger.debug(String.format("task[%s] is null when leave yunzhijia audit node.", comment == null ? null : comment.getTaskId()));
            return;
        }
        ILocaleString taskSubject = taskEntity.getSubject();
        ILocaleString entityName = taskEntity.getEntityName();
        ILocaleString taskName = taskEntity.getName();
        ILocaleString commentMsg = comment.getCommentMessage();
        ILocaleString subject = WfUtils.getPromptWordLocaleString("\u60a8\u8ba2\u9605\u7684\u4e3b\u9898\u4e3a\u3010%1$s\u3011\u7684\u3010%2$s\u3011\u5728\u3010%3$s\u3011\u8282\u70b9\u5df2\u7ecf\u5ba1\u6279\u7ed3\u675f\uff0c%4$s", "ParticipantCalculatorImpl_13", "bos-wf-engine");
        ILocaleString message = WfMultiLangUtils.getMultiLangValue(subject, taskSubject, entityName, taskName, commentMsg);
        HistoricIdentityLinkEntityManager manager = Context.getCommandContext().getHistoricIdentityLinkEntityManager();
        List<Long> userIds = manager.findParticipantsByParentTaskIdAndSubscribe(taskEntity.getId(), true);
        if (!userIds.isEmpty()) {
            MessageContext ctx = MessageServiceUtil.buildMessageContext(taskEntity.getId());
            MessageInfo info = MessageServiceUtil.buildMessageInfo(taskEntity.getProcessInstanceId(), taskEntity.getTaskDefinitionKey());
            info.setMessageContent(message);
            info.setUserIds(userIds);
            info.setTplScene(MessageTypeEnum.SUBSCRIBEYZJRESULT.getNumber());
            info.setEntityNumber("wf_hitaskinst");
            Context.getCommandContext().getMessageService().sendMessage(ctx, info);
        }
    }

    private DecisionOption getYunzhijiaDecisionOption(List<DecisionOption> decisions, Object yzjResultNumber) {
        DecisionOption decision = null;
        if (yzjResultNumber == null) {
            return null;
        }
        String resultNumber = yzjResultNumber.toString();
        for (DecisionOption dec : decisions) {
            if (!dec.getNumber().equalsIgnoreCase(resultNumber)) continue;
            decision = dec;
            break;
        }
        return decision;
    }

    private DecisionOption getOriDecisionOption(List<DecisionOption> decisions, boolean approve, Map<String, Object> variables, YunzhijiaTask task) {
        DecisionOption decision = null;
        if (approve) {
            for (DecisionOption dec : decisions) {
                if (!"approve".equalsIgnoreCase(dec.getAuditType())) continue;
                decision = dec;
                break;
            }
        } else {
            Object auditType = variables.get("auditType");
            if ("forceReject".equalsIgnoreCase((String)auditType)) {
                for (DecisionOption dec : decisions) {
                    if (!"forceReject".equalsIgnoreCase(dec.getAuditType())) continue;
                    decision = dec;
                    break;
                }
            } else {
                Object auditNumber = variables.get("auditNumber");
                boolean isOneVoteVeto = "oneVoteVeto".equals(task.getBusinessModel());
                for (DecisionOption dec : decisions) {
                    if (isOneVoteVeto && auditNumber != null) {
                        if (!auditNumber.equals(dec.getNumber())) continue;
                        decision = dec;
                    } else {
                        if (!"reject".equalsIgnoreCase(dec.getAuditType())) continue;
                        decision = dec;
                    }
                    break;
                }
            }
        }
        return decision;
    }
}

