/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.MessageSendModel;
import kd.bos.workflow.bpmn.model.NotifyTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.bpmn.behavior.SkipInfo;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskActivityBehavior;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionType;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;

public class YunzhijiaNotifyActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = -8283162682145004276L;
    protected NotifyTask notifyTask;

    public YunzhijiaNotifyActivityBehavior(NotifyTask notifyTask) {
        this.notifyTask = notifyTask;
    }

    @Override
    public void execute(DelegateExecution execution) {
        super.execute(execution);
        boolean skipWhenBoot = BizFlowUtil.ifSkipWhenBootThenRecordExecutionType(execution, this.notifyTask);
        if (skipWhenBoot) {
            return;
        }
        if (!WfUtils.isTesting()) {
            SkipInfo skip = DynamicFlowUtil.isSkipNode((ExecutionEntity)execution);
            if (!skip.isSkip()) {
                FlowElement flowElement = execution.getCurrentFlowElement();
                if (flowElement instanceof YunzhijiaTask && execution.getParent().isMultiInstanceRoot()) {
                    return;
                }
                List<MessageSendModel> msgModels = this.notifyTask.getInMsg();
                if (msgModels != null && !msgModels.isEmpty()) {
                    ArrayList<MessageSendModel> msgRet = new ArrayList<MessageSendModel>();
                    for (MessageSendModel sendModel : msgModels) {
                        if (!sendModel.isNotify() || sendModel.getReceiver() == null || sendModel.getReceiver().isEmpty() || !this.isFulfillRule(execution, sendModel) || !"notify".equals(sendModel.getMessagetype())) continue;
                        msgRet.add(sendModel);
                    }
                    if (!msgRet.isEmpty() && null != flowElement) {
                        Context.getCommandContext().getMessageService().sendMessageForNode(execution, flowElement.getId(), msgRet, "start");
                    }
                }
            } else {
                this.logger.debug(String.format("\u8282\u70b9[%s-%s] skip", this.notifyTask.getId(), this.notifyTask.getName()));
                CommandContext commandContext = Context.getCommandContext();
                commandContext.getHistoryManager().recordActivityExecutionType((ExecutionEntity)execution, skip.getExecutionType(), skip.getSkipReason());
            }
        }
    }

    public NotifyTask getNotifyTask() {
        return this.notifyTask;
    }

    public void setNotifyTask(NotifyTask notifyTask) {
        this.notifyTask = notifyTask;
    }

    protected boolean isFulfillRule(DelegateExecution execution, MessageSendModel sendModel) {
        ConditionalRuleEntity messageSendRule = sendModel.getRule();
        boolean isFulfillRule = false;
        if (messageSendRule != null) {
            ConditionType.logOpDesc(messageSendRule);
            String key = ConditionUtil.getConInstKey(this.notifyTask.getNumber(), "msg");
            isFulfillRule = ConditionUtil.hasTrueCondition(messageSendRule, (VariableScope)execution, key);
        } else {
            isFulfillRule = true;
        }
        return isFulfillRule;
    }
}

