/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.MessageSendModel;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.AuditRuleForYzjUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.ChildInstanceReport;
import kd.bos.workflow.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.YunzhijiaCommonMultiInstanceBehavior;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.exception.ExceptionUtil;

public class YunzhijiaParallelMultiInstanceBehavior
extends ParallelMultiInstanceBehavior {
    private static final long serialVersionUID = 1L;
    private static final String SUMDECISION = "sumDecision";
    private YunzhijiaCommonMultiInstanceBehavior yunzhijiaCommonMultiInstanceBehavior = new YunzhijiaCommonMultiInstanceBehavior();

    public YunzhijiaParallelMultiInstanceBehavior(Activity activity, AbstractBpmnActivityBehavior originalActivityBehavior) {
        super(activity, originalActivityBehavior);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int createInstances(DelegateExecution execution) {
        int ret;
        block5: {
            int n;
            ret = 0;
            try {
                boolean skip = this.yunzhijiaCommonMultiInstanceBehavior.createParentTask(execution, this.activity, true);
                if (!skip) break block5;
                n = 0;
            }
            catch (Throwable throwable) {
                String key = String.format("%s_%s", execution.getId(), execution.getCurrentActInstId());
                Context.getCommandContext().removeAttribute(key);
                logger.debug("remove user list.");
                throw throwable;
            }
            String key = String.format("%s_%s", execution.getId(), execution.getCurrentActInstId());
            Context.getCommandContext().removeAttribute(key);
            logger.debug("remove user list.");
            return n;
        }
        ret = super.createInstances(execution);
        if (ret <= 0) {
            throw ExceptionUtil.createWFNullParticipantException(execution);
        }
        YunzhijiaTask yunzhijiaTask = (YunzhijiaTask)this.activity;
        if (ret <= 1 && "voteOnProportion".equals(yunzhijiaTask.getBusinessModel())) {
            throw ExceptionUtil.createWFVoteParticipantException(execution, ret);
        }
        String key = String.format("%s_%s", execution.getId(), execution.getCurrentActInstId());
        Context.getCommandContext().removeAttribute(key);
        logger.debug("remove user list.");
        return ret;
    }

    @Override
    protected int resolveLoopCardinality(DelegateExecution execution) {
        String userIdStr;
        String string = userIdStr = execution.getCurrentTask() == null ? null : (String)execution.getCurrentTask().getVariable("teamMembers");
        if (userIdStr != null && userIdStr.length() > 0) {
            String[] userIds = userIdStr.split(",");
            return userIds.length;
        }
        return super.resolveLoopCardinality(execution);
    }

    @Override
    protected Object resolveCollection(DelegateExecution execution) {
        String execId = String.valueOf(execution.getId());
        if (execution != null && execution.getParent() != null && execution.getParent().isMultiInstanceRoot()) {
            execId = String.valueOf(execution.getParent().getId());
        }
        String key = String.format("%s_%s", execId, execution.getCurrentActInstId());
        List userIds = (List)Context.getCommandContext().getAttribute(key);
        if (userIds != null && !userIds.isEmpty()) {
            logger.debug(String.format("cache user:[%s]", WfUtils.listToString(userIds, ",")));
            return userIds;
        }
        Object obj = super.resolveCollection(execution);
        logger.debug("re parse user");
        return obj;
    }

    @Override
    protected TaskEntity handleTaskLeave(DelegateExecution execution, boolean jump, ExecutionEntity executionToUse) {
        return this.yunzhijiaCommonMultiInstanceBehavior.handleTaskLeave(execution, jump, executionToUse, this.activity);
    }

    @Override
    protected boolean completeNormalLevel(DelegateExecution execution, Activity activity) {
        return this.yunzhijiaCommonMultiInstanceBehavior.completeNormalLevel(execution, activity);
    }

    @Override
    public void dealChildrenReport(ExecutionEntity execution, ChildInstanceReport report) {
        this.dispatchTaskReceivedListener(execution, report);
    }

    protected void dispatchTaskReceivedListener(ExecutionEntity execution, ChildInstanceReport report) {
        YunzhijiaTask yzjTask = (YunzhijiaTask)this.activity;
        ExecutionEntity procinst = execution.getProcessInstance();
        TaskEntity task = execution.getCurrentTask();
        task = task == null ? report.getTask() : task;
        Integer nrOfInstances = (Integer)task.getParentTaskInstance().getVariable("nrOfInstances");
        if (nrOfInstances == null) {
            return;
        }
        String subInstNumKey = String.format("%s-%s", yzjTask.getNumber(), "yzjSubInstNum");
        int subInstNum = procinst.getVariable(subInstNumKey) == null ? 1 : (Integer)procinst.getVariable(subInstNumKey) + 1;
        procinst.setVariable(subInstNumKey, subInstNum);
        String consentVoteNumKey = String.format("%s-%s", yzjTask.getNumber(), "yzjConsentVoteNum");
        int consentVoteNum = procinst.getVariable(consentVoteNumKey) == null ? 0 : (Integer)procinst.getVariable(consentVoteNumKey);
        String vkey = String.format("%s-%s", yzjTask.getNumber(), "yzjReceivedTaskUsers");
        Object users = procinst.getVariable(vkey);
        if ("byHand".equals(report.getExecutionType())) {
            Object taskReceivers = task.getTransientVariableLocal("taskReceivers");
            if (taskReceivers != null) {
                users = users == null ? taskReceivers : String.format("%s,%s", users, taskReceivers);
                procinst.setVariable(vkey, users);
            }
            logger.debug(String.format("dispatchTaskReceivedListener users[%s] execution[%s] taskReceivers[%s] task[%s]", users, execution, taskReceivers, task));
        } else {
            procinst.setVariable(consentVoteNumKey, ++consentVoteNum);
        }
        if (subInstNum == nrOfInstances) {
            if (!this.isAutoApproval(nrOfInstances, consentVoteNum, yzjTask)) {
                this.sendMessageWhenTaskReceived(execution, task);
                BPMNUtil.updateHitaskInstPresentAssignee(execution, null);
                this.updateYzjNameVariables(execution);
            }
            procinst.removeVariable(subInstNumKey);
            procinst.removeVariable(consentVoteNumKey);
            procinst.removeVariable(vkey);
        }
    }

    private void updateYzjNameVariables(ExecutionEntity execution) {
        QFilter qFilter1 = new QFilter("parenttaskid", "=", (Object)execution.getParent().getCurrentTask().getId());
        QFilter qFilter2 = new QFilter("type", "=", (Object)"participant");
        QFilter[] qFilters = new QFilter[]{qFilter1, qFilter2};
        List identityLinkEntitys = Context.getCommandContext().getIdentityLinkEntityManager().findByQueryFilters(qFilters);
        HashMap trustNameMap = new HashMap(16);
        HashMap trustNameFormatMap = new HashMap(16);
        HashMap<Long, ILocaleString> ownerNameMap = new HashMap<Long, ILocaleString>();
        HashMap<Long, ILocaleString> ownerNameFormatMap = new HashMap<Long, ILocaleString>();
        for (IdentityLinkEntity identityLinkEntity : identityLinkEntitys) {
            if (WfUtils.isEmpty(identityLinkEntity.getDelegateId()) || WfUtils.isEmpty(identityLinkEntity.getOwnerId())) {
                ownerNameMap.put(identityLinkEntity.getUserId(), identityLinkEntity.getUserName());
                ownerNameFormatMap.put(identityLinkEntity.getUserId(), identityLinkEntity.getUserNameFormatter());
                continue;
            }
            List<ILocaleString> trustNames = new ArrayList();
            List<ILocaleString> trustNameFormats = new ArrayList();
            if (trustNameMap.get(identityLinkEntity.getOwnerId()) != null) {
                trustNames = (List)trustNameMap.get(identityLinkEntity.getOwnerId());
            }
            if (trustNameFormatMap.get(identityLinkEntity.getOwnerId()) != null) {
                trustNameFormats = (List)trustNameFormatMap.get(identityLinkEntity.getOwnerId());
            }
            trustNames.add(identityLinkEntity.getUserName());
            trustNameFormats.add(identityLinkEntity.getUserNameFormatter());
            trustNameMap.put(identityLinkEntity.getOwnerId(), trustNames);
            trustNameFormatMap.put(identityLinkEntity.getOwnerId(), trustNameFormats);
        }
        Set trustNameEntrySet = trustNameMap.entrySet();
        ArrayList<ILocaleString> finalNames = new ArrayList<ILocaleString>(10);
        ArrayList<ILocaleString> finalNameFormats = new ArrayList<ILocaleString>(10);
        ILocaleString delegate = WFMultiLangConstants.getDelegateLocaleString();
        for (Map.Entry trustName : trustNameEntrySet) {
            Long owerId = (Long)trustName.getKey();
            ILocaleString trustNameMergeValue = WfMultiLangUtils.getFormatMergeValue((List)trustName.getValue());
            ILocaleString trustNameFormatMergeValue = WfMultiLangUtils.getFormatMergeValue((List)trustNameFormatMap.get(owerId));
            ILocaleString owerName = (ILocaleString)ownerNameMap.get(owerId);
            ILocaleString owerNameFormat = (ILocaleString)ownerNameFormatMap.get(owerId);
            LocaleString finalName = new LocaleString();
            LocaleString finalNameFormat = new LocaleString();
            for (Lang supportLang : WfMultiLangUtils.getSupportLangs()) {
                finalName.put((Object)supportLang.toString(), (Object)String.format((String)delegate.get((Object)supportLang.toString()), owerName.get((Object)supportLang.toString()), trustNameMergeValue.get((Object)supportLang.toString())));
                finalNameFormat.put((Object)supportLang.toString(), (Object)String.format((String)delegate.get((Object)supportLang.toString()), owerNameFormat.get((Object)supportLang.toString()), trustNameFormatMergeValue.get((Object)supportLang.toString())));
            }
            finalNames.add((ILocaleString)finalName);
            finalNameFormats.add((ILocaleString)finalNameFormat);
        }
        execution.getParent().getCurrentTask().setVariable("teamMemberNames", WfMultiLangUtils.getFormatMergeValue(finalNames));
        execution.getParent().getCurrentTask().setVariable("teamMemberNamesFormat", WfMultiLangUtils.getFormatMergeValue(finalNameFormats));
    }

    private boolean isAutoApproval(int nrOfInstances, int consentVoteNum, YunzhijiaTask yzjTask) {
        if (0 != nrOfInstances && 0 != consentVoteNum) {
            switch (yzjTask.getBusinessModel()) {
                case "passByOne": {
                    return consentVoteNum > 0;
                }
                case "oneVoteVeto": {
                    return nrOfInstances == consentVoteNum;
                }
                case "allVote": {
                    return nrOfInstances == consentVoteNum;
                }
                case "voteOnProportion": {
                    double vp = (double)(consentVoteNum * 100) / Double.parseDouble(String.valueOf(nrOfInstances));
                    if (vp >= yzjTask.getVotePercentage()) {
                        return AuditRuleForYzjUtil.isThroughVotePercentage(consentVoteNum, nrOfInstances, yzjTask, "approve");
                    }
                    return false;
                }
                case "voteByPassProportion": {
                    return AuditRuleForYzjUtil.isThroughPassPercent(consentVoteNum, nrOfInstances, yzjTask, "approve");
                }
            }
            return false;
        }
        return false;
    }

    protected void executeTaskReceivedExecutionListeners(ExecutionEntity execution) {
        Context.getCommandContext().getProcessEngineConfiguration().getListenerNotificationHelper().executeExecutionListeners(this.activity, execution, "taskReceived");
    }

    private void sendMessageWhenTaskReceived(ExecutionEntity execution, TaskEntity task) {
        MessageSendModel msg;
        YunzhijiaTask yzjTask = (YunzhijiaTask)this.activity;
        boolean flag = false;
        List<MessageSendModel> inMsgs = yzjTask.getInMsg();
        if (inMsgs == null) {
            return;
        }
        Iterator<MessageSendModel> iterator = inMsgs.iterator();
        while (iterator.hasNext() && !(flag = "taskReceived".equals((msg = iterator.next()).getSendevt()))) {
        }
        if (flag) {
            task.setTransientVariable("auditType", "Consent");
            Object currentParticipant = task.getTransientVariable("currentParticipant");
            String vkey = String.format("%s-%s", yzjTask.getNumber(), "yzjReceivedTaskUsers");
            Object users = execution.getProcessInstance().getVariable(vkey);
            task.setTransientVariableLocal("currentParticipant", users);
            logger.debug(String.format("over, currentParticipant[%s]", task.getVariable("currentParticipant")));
            this.executeTaskReceivedExecutionListeners(execution);
            task.setTransientVariableLocal("currentParticipant", currentParticipant);
            task.removeTransientVariable("auditType");
        }
    }
}

