/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.AuditRuleForYzjUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.identity.ParticipantPositionEntity;
import kd.bos.workflow.engine.impl.bpmn.behavior.AuditTaskActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.ChildInstanceReport;
import kd.bos.workflow.engine.impl.bpmn.behavior.IReport;
import kd.bos.workflow.engine.impl.bpmn.behavior.SkipInfo;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.calculator.ParticipantCalculator;
import kd.bos.workflow.engine.impl.cmd.GetLastAuditInfoCmd;
import kd.bos.workflow.engine.impl.cmd.GetYunzhijiaTaskParticipantsCmd;
import kd.bos.workflow.engine.impl.cmd.precomputation.PreComputorHelper;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.AuditInfo;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstance;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.task.TaskDelegateCalculateUtil;

public class YunzhijiaTaskActivityBehavior
extends AuditTaskActivityBehavior
implements IReport {
    private static final long serialVersionUID = 1937329269944351843L;
    private static final int NUMBER_OF_PERCENT = 100;
    private static final String USERPOSITION = "userPosition";

    public YunzhijiaTaskActivityBehavior(YunzhijiaTask auditTask) {
        super(auditTask);
    }

    @Override
    public void execute(DelegateExecution execution) {
        CommandContext commandContext = Context.getCommandContext();
        super.execute(execution);
        TaskEntity task = ((ExecutionEntity)execution).getCurrentTask();
        boolean hasTask = WfUtils.isNotEmpty(task.getId());
        if (!hasTask) {
            return;
        }
        ChildInstanceReport reportInfo = new ChildInstanceReport(execution, task, "byHand");
        if (execution.getParent().getVariableLocal("lastUserDealNode") != null && ("startProcessInstance".equals(execution.getParent().getVariableLocal("lastUserDealNode")) || "startStrongControl".equals(execution.getParent().getVariableLocal("lastUserDealNode")))) {
            execution.getParent().setVariableLocal("lastUserDealNode", "start");
        }
        Long parentTaskId = ((ExecutionEntity)execution.getParent()).getCurrentTaskId();
        if (((YunzhijiaTask)this.userTask).getBackToBackVote()) {
            task.setYzjGroupId("1");
        }
        task.setParentTaskId(parentTaskId);
        Long participantId = null;
        for (IdentityLinkEntity identityLink : task.getIdentityLinks()) {
            identityLink.setParenttaskid(task.getParentTaskId());
            participantId = identityLink.getUserId();
        }
        commandContext.getHistoryManager().recordTaskParentTaskIdChange(task.getId(), task.getParentTaskId());
        boolean manualProcessing = true;
        boolean yunzhijiaRejectBackNotSkip = false;
        VariableInstance variableInstance = task.getParentTaskInstance() == null ? null : task.getParentTaskInstance().getVariableInstanceLocal("yunZhiJiaNodeRejectBackNotSkip");
        this.logger.debug(String.format("YunzhijiaTaskActivityBehavior,task is %s;task.getParentTaskInstance() is %s", task, task.getParentTaskInstance()));
        if (variableInstance != null) {
            yunzhijiaRejectBackNotSkip = (Boolean)variableInstance.getValue();
        }
        if (!yunzhijiaRejectBackNotSkip) {
            manualProcessing = this.isManualProcessing(task, execution);
        }
        if (manualProcessing) {
            boolean isSetted;
            List<Long> autoCoordinatorIds = TaskDelegateCalculateUtil.calcAutoCoordinatorIdsWithDelegation(commandContext, (ExecutionEntity)execution, task, this.auditTask);
            TaskBehaviorUtil.calculateAuditPoint(execution, this.auditTask);
            if ("YunzhijiaTask".equals(this.auditTask.getType())) {
                this.planToDoJob(commandContext, task.getId(), execution);
            }
            if (!(isSetted = WfCacheHelper.isSettedYunzhijiaTaskParentId(parentTaskId))) {
                this.planAutoCirculateJob(commandContext, execution, task.getId(), "start");
                WfCacheHelper.setYunzhijiaTaskParentId(parentTaskId);
                if (!WfUtils.isTesting()) {
                    this.excludeTrustFromAutoCoordinateIds(commandContext, task, autoCoordinatorIds);
                    this.doAutoCoordinate(commandContext, (ExecutionEntity)execution, this.auditTask, parentTaskId, autoCoordinatorIds);
                    PreComputorHelper.doPreComputorFromActivityBehavior(execution.getProcessInstanceId(), "through", this.auditTask, task);
                }
            }
            TaskBehaviorUtil.dispatchTaskAssignListener(task, "YunzhijiaTask");
            if ("YunzhijiaTask".equals(this.userTask.getType())) {
                this.triggerCreateTaskEvent(task, new ArrayList<Long>(task.getParticipants()), commandContext);
            }
        } else {
            String vkey = String.format("%s-%s", task.getTaskDefinitionKey(), "executionType");
            reportInfo.setExecutionType((String)execution.getTransientVariable(vkey));
            execution.removeTransientVariable(vkey);
        }
        this.report((ExecutionEntity)execution, reportInfo);
    }

    @Override
    public boolean isManualProcessing(TaskEntity task, DelegateExecution execution) {
        CommandContext commandContext = Context.getCommandContext();
        boolean isNotAutoAudit = this.isNotAutoAudit(execution);
        boolean manualProcessing = true;
        TaskHelper taskHelper = Context.getProcessEngineConfiguration().getTaskHelper();
        Long participantId = null;
        for (IdentityLinkEntity identityLink : task.getIdentityLinks()) {
            identityLink.setParenttaskid(task.getParentTaskId());
            participantId = identityLink.getUserId();
        }
        AuditInfo auditInfo = this.getLastAuditInfo(task, participantId, commandContext, isNotAutoAudit);
        boolean sameAsStarter = taskHelper.isStarterSameAsAuditor(task);
        if (sameAsStarter || auditInfo.isAutoAudit()) {
            DecisionOption option = null;
            option = sameAsStarter || WfUtils.isEmpty(auditInfo.getAuditNumber()) ? WfUtils.getDefaultDecision(this.auditTask) : WfUtils.getDecisionOption(this.auditTask, auditInfo.getAuditNumber());
            participantId = sameAsStarter ? task.getStarterId() : participantId;
            taskHelper.doAutoAudit((ExecutionEntity)execution, option, participantId, auditInfo.isAutoAudit() ? auditInfo.getAuditMsg() : null);
            execution.setTransientVariable(String.format("%s-%s", task.getTaskDefinitionKey(), "executionType"), "byAuto");
            manualProcessing = false;
        } else {
            manualProcessing = this.doSamePartiRule(execution, task);
        }
        return manualProcessing;
    }

    private void excludeTrustFromAutoCoordinateIds(CommandContext commandContext, TaskEntity task, List<Long> autoCoordinatorIds) {
        String teamMemberIds;
        TaskEntity parentTask = task.getParentTaskInstance();
        if (parentTask == null) {
            return;
        }
        Object teamMemberIdsObj = parentTask.getVariable("teamMembers");
        String string = teamMemberIds = teamMemberIdsObj != null ? (String)teamMemberIdsObj : "";
        if (WfUtils.isEmpty(teamMemberIds) || CollectionUtil.isEmpty(autoCoordinatorIds)) {
            return;
        }
        List participantIds = (List)WfUtils.stringToCollection(teamMemberIds, ",");
        if (CollectionUtil.isEmpty(participantIds)) {
            return;
        }
        DelegateSettingEntityManager delegateEntityManager = commandContext.getDelegateSettingEntityManager();
        for (Long participantId : participantIds) {
            Set<Long> trustParticipants = TaskBehaviorUtil.findTrustParticipants(delegateEntityManager, participantId, task, new HashMap<Long, DelegateSettingEntity>());
            if (!CollectionUtil.isNotEmpty(trustParticipants)) continue;
            for (Long trustParticipant : trustParticipants) {
                autoCoordinatorIds.remove(trustParticipant);
            }
        }
    }

    @Override
    protected void setTaskOtherProperties(TaskEntity task, ExecutionEntity execution) {
        super.setTaskOtherProperties(task, execution);
        Long parentTaskId = execution.getParent().getCurrentTaskId();
        task.setParentTaskId(parentTaskId);
    }

    @Override
    public SkipInfo getSkipInfo(TaskEntity task, ExecutionEntity execution) {
        SkipInfo skipInfo = DynamicFlowUtil.isSkipTask(this.userTask, task, execution);
        if ("MeetSkipCondition".equals(skipInfo.getSkipReason())) {
            skipInfo = new SkipInfo(false);
        }
        return skipInfo;
    }

    @Override
    protected List<Long> handleParticipants(ParticipatantModel participant, String businessKey, ParticipantCalculator participantCalculator, DelegateExecution execution, Map<Long, List<DelegateSettingEntity>> assignorIdAndDelegateSettingEntitys, TaskEntity task) {
        Map userPositionMap;
        ArrayList<Long> userIds = new ArrayList<Long>();
        Long userId = (Long)execution.getVariable("participant");
        if (userId != null) {
            userIds.add(userId);
        }
        this.addTrusteeIdTouUserIds(execution, assignorIdAndDelegateSettingEntitys, userIds, userId);
        Object userPositionVariable = execution.getVariable(USERPOSITION);
        Map map = userPositionMap = userPositionVariable == null ? null : (Map)userPositionVariable;
        if (userPositionMap != null && userPositionMap.get(String.valueOf(userId)) != null) {
            Map participantPositionMap = (Map)userPositionMap.get(String.valueOf(userId));
            String type = (String)participantPositionMap.get("type");
            Map userPositionNameMap = (Map)participantPositionMap.get(USERPOSITION);
            Map dptMap = (Map)participantPositionMap.get("dpt");
            LocaleString userPosition = new LocaleString();
            LocaleString dpt = new LocaleString();
            for (Lang langLang : WfUtils.getSupportLangs()) {
                String lang = langLang.toString();
                if (userPositionNameMap != null) {
                    userPosition.put((Object)lang, userPositionNameMap.get(lang));
                }
                if (dptMap == null) continue;
                dpt.put((Object)lang, dptMap.get(lang));
            }
            this.logger.debug(String.format("userPosition\u503c\u4e3a%s\uff0cdpt\u503c\u4e3a\uff1a%s", userPosition, dpt));
            ParticipantPositionEntity participantPositionEntity = new ParticipantPositionEntity(userId, (ILocaleString)userPosition, type, (ILocaleString)dpt);
            Context.getCommandContext().putUserPosoitionCache(participantPositionEntity);
        }
        return userIds;
    }

    private void addTrusteeIdTouUserIds(DelegateExecution execution, Map<Long, List<DelegateSettingEntity>> assignorIdAndDelegateSettingEntitys, ArrayList<Long> userIds, Long userId) {
        String assignorIdAndDelegateStr;
        Map userAndTrusteeIdMap;
        List trusteeIds;
        String trusteeIdsStr;
        String string = trusteeIdsStr = execution.getVariable("trusteeIds") == null ? " " : (String)execution.getVariable("trusteeIds");
        if (WfUtils.isNotEmpty(trusteeIdsStr) && (trusteeIds = (List)(userAndTrusteeIdMap = (Map)SerializationUtils.fromJsonString((String)trusteeIdsStr, Map.class)).get(String.valueOf(userId))) != null && !trusteeIds.isEmpty()) {
            ArrayList<Long> truseteeIdList = new ArrayList<Long>();
            for (Object trusteeId : trusteeIds) {
                if (trusteeId instanceof Integer) {
                    truseteeIdList.add(Long.valueOf(((Integer)trusteeId).intValue()));
                    continue;
                }
                if (!(trusteeId instanceof Long)) continue;
                truseteeIdList.add((Long)trusteeId);
            }
            if (!truseteeIdList.isEmpty()) {
                userIds.addAll(truseteeIdList);
            }
        }
        String string2 = assignorIdAndDelegateStr = execution.getVariable("assignorIdAndDelegate") == null ? " " : (String)execution.getVariable("assignorIdAndDelegate");
        if (WfUtils.isNotEmpty(assignorIdAndDelegateStr)) {
            Map assignorIdAndDelegateMap = (Map)SerializationUtils.fromJsonString((String)assignorIdAndDelegateStr, Map.class);
            List assignorIdAndDelegates = (List)assignorIdAndDelegateMap.get(String.valueOf(userId));
            ArrayList<Long> assignorIdAndDelegateList = new ArrayList<Long>();
            if (assignorIdAndDelegates != null && !assignorIdAndDelegates.isEmpty()) {
                for (Object assignorIdAndDelegate : assignorIdAndDelegates) {
                    if (assignorIdAndDelegate instanceof Integer) {
                        assignorIdAndDelegateList.add(Long.valueOf(((Integer)assignorIdAndDelegate).intValue()));
                        continue;
                    }
                    if (!(assignorIdAndDelegate instanceof Long)) continue;
                    assignorIdAndDelegateList.add((Long)assignorIdAndDelegate);
                }
            }
            List delegateSettingEntitys = Context.getCommandContext().getDelegateSettingEntityManager().findByQueryFilters(new QFilter[]{new QFilter("id", "in", assignorIdAndDelegateList)});
            assignorIdAndDelegateSettingEntitys.put(userId, delegateSettingEntitys);
        }
    }

    @Override
    protected boolean canCreateTodoWhenSameAuditor(CommandContext commandContext, DelegateExecution execution, TaskEntity task) {
        boolean isNotAutoAudit;
        Process process = ProcessDefinitionUtil.getProcess(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
        if (Boolean.TRUE.equals(process.getAutoAuditWhenSamePerson())) {
            Object participant = execution.getVariable("participant");
            Long starterId = task.getStarterId();
            if (starterId.equals(participant)) {
                return false;
            }
            Object participants = new GetYunzhijiaTaskParticipantsCmd(execution.getId()).execute(commandContext);
            boolean canCreateTodo = true;
            if (!participants.contains(starterId)) {
                return canCreateTodo;
            }
            YunzhijiaTask yzjTask = (YunzhijiaTask)process.getFlowElement(task.getTaskDefinitionKey());
            DecisionOption decision = WfUtils.getDefaultDecision(yzjTask);
            switch (yzjTask.getBusinessModel()) {
                case "passByOne": {
                    if (!"approve".equals(decision.getAuditType())) break;
                    canCreateTodo = false;
                    break;
                }
                case "oneVoteVeto": {
                    if (!"reject".equals(decision.getAuditType())) break;
                    canCreateTodo = false;
                    break;
                }
                case "voteOnProportion": {
                    boolean pass;
                    boolean bl = pass = 100.0 / Double.parseDouble(String.valueOf(participants.size())) >= yzjTask.getVotePercentage();
                    if (!"approve".equals(decision.getAuditType()) || !pass) break;
                    canCreateTodo = false;
                    break;
                }
            }
            return canCreateTodo;
        }
        boolean canCreateTodo = true;
        YunzhijiaTask yzjTask = (YunzhijiaTask)process.getFlowElement(task.getTaskDefinitionKey());
        if (yzjTask.isNoNeedCountersign() && !(isNotAutoAudit = this.isNotAutoAudit(execution))) {
            Long participant = WfUtils.getLongValueFromObj(execution.getVariable("participant"));
            AuditInfo auditInfo = this.getLastAuditInfo(task, participant, commandContext, isNotAutoAudit);
            boolean bl = canCreateTodo = !auditInfo.isAutoAudit();
            if (canCreateTodo) {
                int userCount = 0;
                Long parentTaskId = null;
                DelegateExecution executionParent = execution.getParent();
                if (null != executionParent) {
                    Object userCountObj = executionParent.getVariable("nrOfInstances");
                    if (null != userCountObj && userCountObj instanceof Integer) {
                        userCount = Integer.parseInt(userCountObj.toString());
                    }
                    parentTaskId = executionParent.getCurrentTaskId();
                }
                if (0 != userCount) {
                    canCreateTodo = !AuditRuleForYzjUtil.isAutoAuditForNoNeedCountersign(execution, yzjTask, userCount, commandContext, parentTaskId);
                }
            }
        }
        return canCreateTodo;
    }

    private AuditInfo getLastAuditInfo(TaskEntity task, Long participantId, CommandContext commandContext, boolean isNotAutoAudit) {
        AuditInfo auditInfo = null;
        boolean isNoNeedCountersign = false;
        YunzhijiaTask yunzhijiaTask = (YunzhijiaTask)this.auditTask;
        if (null != yunzhijiaTask) {
            isNoNeedCountersign = yunzhijiaTask.isNoNeedCountersign();
        }
        if (!isNoNeedCountersign || isNotAutoAudit) {
            auditInfo = new AuditInfo(isNoNeedCountersign, null);
            auditInfo.setAutoAudit(false);
        } else {
            if (WfUtils.isEmpty(participantId)) {
                for (IdentityLinkEntity identityLink : task.getIdentityLinks()) {
                    participantId = identityLink.getUserId();
                }
            }
            auditInfo = new GetLastAuditInfoCmd(task.getProcessInstanceId(), task.getTaskDefinitionKey(), "approve", participantId).execute(commandContext);
        }
        return auditInfo;
    }

    private boolean isNotAutoAudit(DelegateExecution execution) {
        boolean sensitiveFieldsChange = this.isSensitiveFieldsChange(execution);
        return "dynReject".equals(execution.getVariable("comingInWay")) || "dynJump".equals(execution.getVariable("comingInWay")) || sensitiveFieldsChange;
    }

    private boolean isSensitiveFieldsChange(DelegateExecution execution) {
        String businessKey = execution.getBusinessKey();
        QFilter qFilter = new QFilter("businessKey", "=", (Object)businessKey);
        QFilter[] filters = new QFilter[]{qFilter};
        CommandContext commandContext = Context.getCommandContext();
        String selectFields = "id, activityid, groupid, resultnumber, decisiontype, step, businesskey, sensitivefieldchange";
        List comments = commandContext.getCommentEntityManager().findByQueryFilters(filters, selectFields, "step desc");
        if (CollectionUtil.isNotEmpty(comments)) {
            String currentActivityId = execution.getCurrentActivityId();
            Long currentParentTaskId = ((ExecutionEntity)execution.getParent()).getCurrentTaskId();
            for (CommentEntity comment : comments) {
                String activityId = comment.getActivityId();
                if (StringUtils.equals((CharSequence)activityId, (CharSequence)currentActivityId)) {
                    if (currentParentTaskId != null && comment.getGroupId().equals(currentParentTaskId.toString())) continue;
                    return false;
                }
                if (!WfUtils.isNotEmpty(comment.getSensitivefieldchange())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void report(ExecutionEntity execution, ChildInstanceReport reportInfo) {
        if (reportInfo != null) {
            Context.getAgenda().planChildInstanceReportOperation(execution, reportInfo);
            reportInfo = null;
        }
    }
}

