/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.deployer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverter;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.EventSubProcess;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.basedata.BaseDataHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.bpmn.deployer.BpmnDeploymentHelper;
import kd.bos.workflow.engine.impl.bpmn.deployer.CachingAndArtifactsManager;
import kd.bos.workflow.engine.impl.bpmn.deployer.ParsedDeployment;
import kd.bos.workflow.engine.impl.bpmn.deployer.ParsedDeploymentBuilderFactory;
import kd.bos.workflow.engine.impl.bpmn.deployer.ProcessDefinitionDiagramHelper;
import kd.bos.workflow.engine.impl.bpmn.deployer.ProcessOperation;
import kd.bos.workflow.engine.impl.bpmn.deployer.VersionUtils;
import kd.bos.workflow.engine.impl.cmd.GetSubProcIdsClassifiedByDeployStateCmd;
import kd.bos.workflow.engine.impl.cmd.management.DisableOtherProcessCmd;
import kd.bos.workflow.engine.impl.cmd.management.InitProcessInfoEntityCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.CreateDynamicConfigSchemeCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.SynchronizeSchemeCmd;
import kd.bos.workflow.engine.impl.cmd.model.DynamicPartialHelper;
import kd.bos.workflow.engine.impl.cmd.model.PublishModelCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.deploy.Deployer;
import kd.bos.workflow.engine.impl.persistence.deploy.ProcessDefinitionCacheEntry;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.DeploymentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionInfoEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionInfoEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionInfoEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ExtractMultiLanguageWordsUtil;
import kd.bos.workflow.engine.repository.ProcessDefinition;
import kd.bos.workflow.exception.WFErrorCode;

public class BpmnDeployer
implements Deployer {
    protected static Log log = LogFactory.getLog(BpmnDeployer.class);
    protected ParsedDeploymentBuilderFactory parsedDeploymentBuilderFactory;
    protected BpmnDeploymentHelper bpmnDeploymentHelper;
    protected CachingAndArtifactsManager cachingAndArtifactsManager;
    protected ProcessDefinitionDiagramHelper processDefinitionDiagramHelper;

    @Override
    public List<ProcessDefinitionCacheEntry> deploy(DeploymentEntity deployment, Map<String, Object> deploymentSettings) {
        log.debug(String.format("Processing deployment %s", deployment.getName()));
        ParsedDeployment parsedDeployment = this.parsedDeploymentBuilderFactory.getBuilderForDeploymentAndSettings(deployment, deploymentSettings).build();
        this.bpmnDeploymentHelper.verifyProcessDefinitionsDoNotShareKeys(parsedDeployment.getAllProcessDefinitions());
        this.bpmnDeploymentHelper.copyDeploymentValuesToProcessDefinitions(parsedDeployment.getDeployment(), parsedDeployment.getAllProcessDefinitions());
        if (deployment.isNew()) {
            Map<ProcessDefinitionEntity, ProcessDefinitionEntity> mapOfNewProcessDefinitionToPreviousVersion = this.getPreviousVersionsOfProcessDefinitions(parsedDeployment);
            this.setProcessDefinitionVersionsAndEnable(parsedDeployment, mapOfNewProcessDefinitionToPreviousVersion, deploymentSettings);
            this.copyModelPropToProcessDefintion(parsedDeployment);
            this.persistProcessDefinitionsAndAuthorizations(parsedDeployment, mapOfNewProcessDefinitionToPreviousVersion, deploymentSettings);
            this.updateTimersAndEvents(parsedDeployment, mapOfNewProcessDefinitionToPreviousVersion);
            this.addProcessDefitionOperationInfo(parsedDeployment);
        } else {
            Object processDefinitionIdObject = deploymentSettings.get("processDefinitionId");
            Long processDefinitionId = processDefinitionIdObject == null ? null : (Long)processDefinitionIdObject;
            this.makeProcessDefinitionsConsistentWithPersistedVersions(parsedDeployment, processDefinitionId);
        }
        this.updateBpmnModelDynamicPartial(deployment.isNew(), parsedDeployment, deploymentSettings);
        this.disposeDefaultCondRule(parsedDeployment);
        return this.cachingAndArtifactsManager.updateCachingAndArtifacts(parsedDeployment, deploymentSettings);
    }

    private void updateProcessStartUpCondition(ParsedDeployment parsedDeployment, ProcessDefinitionEntity processDefinition, Map<String, Object> deploymentSettings) {
        if (parsedDeployment == null) {
            return;
        }
        CommandContext commandContext = Context.getCommandContext();
        BpmnModel bpmnModel = parsedDeployment.getBpmnModelForProcessDefinition(processDefinition);
        Process process = bpmnModel.getMainProcess();
        if (BpmnModelUtil.isBizFlow(process.getProcessType())) {
            BizFlowUtil.addBizFlowProcessConfigs(commandContext, processDefinition, process);
            return;
        }
        commandContext.getProcessConfigEntityManager().create(bpmnModel, processDefinition);
        ConditionalRuleEntity rule = null;
        if (bpmnModel != null && (rule = bpmnModel.getMainProcess().getStartupcondrule()) != null && (WfUtils.isNotEmpty(rule.getExpression()) || WfUtils.isNotEmpty(rule.getPlugin()))) {
            rule.setProcdefid(processDefinition.getId());
            List<ConditionalEntity> entities = rule.getEntryentity();
            if (entities != null && entities.size() > 0) {
                for (ConditionalEntity entity : entities) {
                    entity.setId(null);
                }
            }
            rule.setEntryentity(entities);
            commandContext.getConditionRuleEntityManager().insert(rule);
            BaseDataHelper.recordConditionRule(entities, null, processDefinition.getId(), null);
        } else {
            Map processDefinitionSetting = (Map)deploymentSettings.get(String.valueOf(processDefinition.getModelId()));
            if (processDefinitionSetting != null && !processDefinitionSetting.isEmpty()) {
                Boolean disablePrevious;
                Boolean bl = disablePrevious = processDefinitionSetting.get("upgradeStartCondition") == null ? Boolean.FALSE : (Boolean)processDefinitionSetting.get("upgradeStartCondition");
                if (disablePrevious.booleanValue()) {
                    this.upgradeStartUpCondition(processDefinition);
                }
            }
        }
    }

    private void addProcessDefitionOperationInfo(ParsedDeployment parsedDeployment) {
        CommandContext commandContext = Context.getCommandContext();
        ProcessDefinitionInfoEntityManager processDefinitionManager = commandContext.getProcessDefinitionInfoEntityManager();
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            BpmnModel model = parsedDeployment.getBpmnModelForProcessDefinition(processDefinition);
            String entraBillName = model.getMainProcess().getEntraBillName();
            List<ProcessOperation> operations = this.bpmnDeploymentHelper.getAllProcessOperations(model);
            if (operations == null || operations.size() <= 0) continue;
            for (ProcessOperation po : operations) {
                processDefinitionManager.insert(this.getProcessDefinitionInfoEntity(po.getElement(), processDefinition, po.getOp(), po.getEntityNumber(), entraBillName));
            }
        }
    }

    private ProcessDefinitionInfoEntity getProcessDefinitionInfoEntity(BaseElement element, ProcessDefinitionEntity processDefinition, String operation, String entityNumber, String entraBillName) {
        ProcessDefinitionInfoEntityImpl infoEntityImpl = new ProcessDefinitionInfoEntityImpl();
        infoEntityImpl.setActId(element == null ? null : element.getId());
        infoEntityImpl.setEntityNumber(entityNumber);
        infoEntityImpl.setOperation(operation);
        infoEntityImpl.setProcessDefinitionId(processDefinition.getId());
        return infoEntityImpl;
    }

    private void updateBpmnModelDynamicPartial(boolean isNewDeploy, ParsedDeployment parsedDeployment, Map<String, Object> deploymentSettings) {
        BpmnModel bpmnModel = null;
        CommandContext commandContext = Context.getCommandContext();
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            DynamicConfigSchemeEntity scheme;
            HistoricProcessInstanceEntity procInst;
            Object processInstanceId;
            if (isNewDeploy && ModelType.NoCodeFlow.name().equals(processDefinition.getType())) continue;
            bpmnModel = parsedDeployment.getBpmnModelForProcessDefinition(processDefinition);
            Long procDefId = processDefinition.getId();
            Object schemeIdObj = deploymentSettings.get("schemeId");
            Long schemeId = WfUtils.getLongValueFromObj(schemeIdObj);
            if (WfUtils.isEmpty(schemeId) && (processInstanceId = deploymentSettings.get("processInstanceId")) instanceof Long && (procInst = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById((Long)processInstanceId, "schemeId")) != null) {
                schemeId = procInst.getSchemeId();
            }
            if (WfUtils.isEmpty(schemeId) && (scheme = commandContext.getDynamicConfigSchemeEntityManager().getDefaultSchemeByProcDefId(procDefId)) != null) {
                schemeId = scheme.getId();
            }
            DynamicPartialHelper.updateBpmnModelDynamicPartial(bpmnModel, null, procDefId, schemeId);
        }
    }

    private void copyModelPropToProcessDefintion(ParsedDeployment parsedDeployment) {
        List<ProcessDefinitionEntity> processDefinitionEntities = parsedDeployment.getAllProcessDefinitions();
        ModelEntityManager manager = Context.getProcessEngineConfiguration().getModelEntityManager();
        ProcessCategoryEntityManager cagetoryManager = Context.getProcessEngineConfiguration().getProcessCategoryEntityManager();
        for (ProcessDefinitionEntity definitionEntity : processDefinitionEntities) {
            ProcessCategoryEntity categoryEntity;
            ModelEntity modelEntity;
            if (definitionEntity.getModelId() == null || (modelEntity = (ModelEntity)manager.findById(definitionEntity.getModelId())) == null) continue;
            definitionEntity.setEntraBillId(modelEntity.getEntraBillId());
            definitionEntity.setEntraBill(modelEntity.getEntraBill());
            definitionEntity.setOrgUnitId(modelEntity.getOrgUnitId());
            definitionEntity.setOperation(modelEntity.getOperation());
            definitionEntity.setType(modelEntity.getType());
            definitionEntity.setApplicationId(modelEntity.getApplicationId());
            definitionEntity.setPrimarySubprocess(modelEntity.getPrimarySubprocess());
            ProcessCategoryEntity category = modelEntity.getCategoryEntity();
            if (category != null) {
                definitionEntity.setCategoryName(category.getName());
                definitionEntity.setCategoryId(category.getId());
                continue;
            }
            Long categoryId = modelEntity.getCategory();
            if (!WfUtils.isEmpty(categoryId) && (categoryEntity = (ProcessCategoryEntity)cagetoryManager.findById(categoryId)) != null) {
                definitionEntity.setCategoryName(categoryEntity.getName());
            }
            definitionEntity.setCategoryId(categoryId);
        }
    }

    protected Map<ProcessDefinitionEntity, ProcessDefinitionEntity> getPreviousVersionsOfProcessDefinitions(ParsedDeployment parsedDeployment) {
        LinkedHashMap<ProcessDefinitionEntity, ProcessDefinitionEntity> result = new LinkedHashMap<ProcessDefinitionEntity, ProcessDefinitionEntity>();
        for (ProcessDefinitionEntity newDefinition : parsedDeployment.getAllProcessDefinitions()) {
            ProcessDefinitionEntity existingDefinition = this.bpmnDeploymentHelper.getMostRecentVersionOfProcessDefinition(newDefinition);
            if (existingDefinition == null) continue;
            result.put(newDefinition, existingDefinition);
        }
        return result;
    }

    protected void setProcessDefinitionVersionsAndEnable(ParsedDeployment parsedDeployment, Map<ProcessDefinitionEntity, ProcessDefinitionEntity> mapNewToOldProcessDefinitions, Map<String, Object> deploymentSettings) {
        CommandContext commandContext = Context.getCommandContext();
        Boolean enable = (Boolean)deploymentSettings.get("isProcessActivateEnabled");
        Map testingFlag = (Map)deploymentSettings.get("testing");
        boolean isTesting = null != testingFlag;
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            if (isTesting) {
                processDefinition.setVersionState("testing");
                processDefinition.setVersion("testing");
                processDefinition.setEnable("testing");
            } else {
                String version = null;
                ProcessDefinitionEntity latest = mapNewToOldProcessDefinitions.get(processDefinition);
                if (latest != null) {
                    version = latest.getVersion();
                    latest.setVersionState("historical");
                    commandContext.getProcessDefinitionEntityManager().update(latest);
                }
                processDefinition.setVersionState("newest");
                processDefinition.setVersion(VersionUtils.getNextVersion(version));
                if (enable.booleanValue()) {
                    processDefinition.setEnable("enable");
                } else {
                    processDefinition.setEnable("disable");
                }
            }
            Map processDefinitionSetting = (Map)deploymentSettings.get(String.valueOf(processDefinition.getModelId()));
            if (processDefinitionSetting != null) {
                String versionDescription = (String)processDefinitionSetting.get("versionDescription");
                processDefinition.setVersionDesc(versionDescription);
            }
            if (!commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) continue;
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, processDefinition));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistProcessDefinitionsAndAuthorizations(ParsedDeployment parsedDeployment, Map<ProcessDefinitionEntity, ProcessDefinitionEntity> mapOfNewProcessDefinitionToPreviousVersion, Map<String, Object> deploymentSettings) {
        CommandContext commandContext = Context.getCommandContext();
        ProcessDefinitionEntityManager processDefinitionManager = commandContext.getProcessDefinitionEntityManager();
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            if (this.alreadyPublished(commandContext, processDefinition)) continue;
            try {
                this.suspendPreviousProcessDefinition(mapOfNewProcessDefinitionToPreviousVersion, deploymentSettings, processDefinition);
                this.publishSubProcess(parsedDeployment, deploymentSettings, processDefinition);
                processDefinition.setPublishName(WfUtils.findUserName(WfUtils.getCurrentUser()));
                this.otherProcessDisabled(deploymentSettings, processDefinition);
            }
            finally {
                commandContext.removeAttribute("alreadyDisabledId");
            }
            processDefinitionManager.insert(processDefinition, false);
            this.updateProcessStartUpCondition(parsedDeployment, processDefinition, deploymentSettings);
            this.extractMultiLangWords(commandContext, processDefinition);
            Long schemeId = this.createDefaultConfigScheme(processDefinition);
            this.synchronizeScheme(deploymentSettings, processDefinition, schemeId);
            this.synchronizeResourceWords(deploymentSettings, processDefinition);
            this.initProcessInfo(commandContext, processDefinition, schemeId);
            this.bpmnDeploymentHelper.updateModelVersion(processDefinition);
        }
    }

    private void initProcessInfo(CommandContext commandContext, ProcessDefinitionEntity processDefinition, Long schemeId) {
        new InitProcessInfoEntityCmd(processDefinition, schemeId).execute(commandContext);
    }

    private void synchronizeScheme(Map<String, Object> deploymentSettings, ProcessDefinitionEntity processDefinition, Long schemeId) {
        Map setting = (Map)deploymentSettings.get(String.valueOf(processDefinition.getModelId()));
        if (setting == null || setting.isEmpty()) {
            log.debug("setting is empty!");
            return;
        }
        String procDefId = (String)setting.get("processDefinitionId");
        if (WfUtils.isNotEmpty(procDefId)) {
            CommandContext commandContext = Context.getCommandContext();
            new SynchronizeSchemeCmd(processDefinition, Long.valueOf(procDefId), schemeId).execute(commandContext);
        }
    }

    private void extractMultiLangWords(CommandContext commandContext, ProcessDefinitionEntity processDefinition) {
        Long modelId = processDefinition.getModelId();
        ModelEntity model = (ModelEntity)commandContext.getModelEntityManager().findById(modelId);
        if (model != null) {
            String version = "";
            version = null != processDefinition.getVersion() && "testing".equals(processDefinition.getVersion()) ? processDefinition.getVersion() : VersionUtils.getNextVersion(processDefinition.getVersion());
            ExtractMultiLanguageWordsUtil.extractWordsAndSaveOrUpdate(processDefinition.getResourceId(), model.getName().toString(), modelId, version, model.getKey());
        }
    }

    private Long createDefaultConfigScheme(ProcessDefinitionEntity processDefinition) {
        Long procDefId = processDefinition.getId();
        CommandContext commandContext = Context.getCommandContext();
        DynamicConfigSchemeEntity scheme = new CreateDynamicConfigSchemeCmd(procDefId, true).execute(commandContext);
        return scheme.getId();
    }

    private boolean alreadyPublished(CommandContext commandContext, ProcessDefinitionEntity processDefinition) {
        ProcessDefinitionEntityManager entityManager = commandContext.getProcessDefinitionEntityManager();
        ProcessDefinitionEntity result = entityManager.findProcDefByModelIdAndVersion(processDefinition.getModelId(), processDefinition.getVersion());
        return result != null;
    }

    private void upgradeStartUpCondition(ProcessDefinitionEntity processDefinition) {
        QFilter[] filters;
        if (Integer.parseInt(processDefinition.getVersion()) == 1) {
            return;
        }
        CommandContext context = Context.getCommandContext();
        String prevVersion = VersionUtils.getPrevVersion(processDefinition.getVersion());
        ProcessDefinition prevProcDef = context.getProcessDefinitionEntityManager().findProcessDefinitionByKeyAndVersion(processDefinition.getKey(), prevVersion);
        ConditionalRuleEntityManager condRuleManager = context.getConditionRuleEntityManager();
        List condRuleEntities = condRuleManager.findByQueryFilters(filters = new QFilter[]{new QFilter("procdefid", "=", (Object)prevProcDef.getId()), new QFilter("type", "=", (Object)ConditionalRuleType.processStartUp.toString())});
        if (condRuleEntities != null && !condRuleEntities.isEmpty()) {
            ConditionalRuleEntity condRuleEntity = (ConditionalRuleEntity)((ConditionalRuleEntity)condRuleEntities.get(0)).clone();
            condRuleEntity.setId(null);
            condRuleEntity.setCreateDate(null);
            condRuleEntity.setCreatorId(null);
            condRuleEntity.setModifyDate(null);
            condRuleEntity.setModifierId(null);
            condRuleEntity.setProcdefid(processDefinition.getId());
            for (ConditionalEntity entity : condRuleEntity.getEntryentity()) {
                entity.setId(null);
            }
            condRuleManager.insert(condRuleEntity);
        }
    }

    private void publishSubProcess(ParsedDeployment parsedDeployment, Map<String, Object> deploymentSettings, ProcessDefinitionEntity processDefinition) {
        Long modelId = processDefinition.getModelId();
        Map setting = (Map)deploymentSettings.get(modelId + "");
        if (setting == null || setting.isEmpty()) {
            return;
        }
        ResourceEntity resource = parsedDeployment.getResourceForProcessDefinition(processDefinition);
        BpmnModel bpmnModel = parsedDeployment.getBpmnModelForProcessDefinition(processDefinition);
        List<EventSubProcess> subProcs = bpmnModel.getMainProcess().findFlowElementsOfType(EventSubProcess.class);
        if (subProcs == null || subProcs.isEmpty()) {
            return;
        }
        CommandContext context = Context.getCommandContext();
        Boolean publishSubProc = setting.get("publishSubProcess") == null ? Boolean.FALSE : (Boolean)setting.get("publishSubProcess");
        Object idMap = new GetSubProcIdsClassifiedByDeployStateCmd(modelId).execute(context);
        HashMap<Long, Long> modelProcDefMap = new HashMap<Long, Long>();
        List subIds = null;
        if (publishSubProc.booleanValue()) {
            subIds = (List)idMap.get("all");
        } else {
            subIds = (List)idMap.get("undeployed");
            List deployedSubIds = (List)idMap.get("deployed");
            for (Long id : deployedSubIds) {
                modelProcDefMap.put(id, context.getProcessDefinitionEntityManager().findLatestProcessDefinitionByModelId(id).getId());
            }
        }
        if (subIds != null && !subIds.isEmpty()) {
            Long[] subModelIds = new Long[subIds.size()];
            for (int i = 0; i < subIds.size(); ++i) {
                subModelIds[i] = (Long)subIds.get(i);
            }
            try {
                new PublishModelCmd(subModelIds).execute(context);
            }
            catch (Exception e) {
                throw new KDException(WFErrorCode.publishSubProcessError(), new Object[]{e.getMessage()});
            }
            for (Long id : subIds) {
                modelProcDefMap.put(id, context.getProcessDefinitionEntityManager().findLatestProcessDefinitionByModelId(id).getId());
            }
        }
        Long subProcDefId = null;
        for (EventSubProcess subProc : subProcs) {
            subProcDefId = (Long)modelProcDefMap.get(Long.parseLong(subProc.getSubProcessId()));
            if (subProcDefId == null) continue;
            subProc.setSubProcessId(String.valueOf(subProcDefId));
        }
        BpmnJsonConverter convert = new BpmnJsonConverter();
        resource.setData(convert.convertToJson(bpmnModel).toString());
        context.getResourceEntityManager().update(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendPreviousProcessDefinition(Map<ProcessDefinitionEntity, ProcessDefinitionEntity> mapOfNewProcessDefinitionToPreviousVersion, Map<String, Object> deploymentSettings, ProcessDefinitionEntity processDefinition) {
        Boolean disablePrevious;
        CommandContext commandContext = Context.getCommandContext();
        ProcessDefinitionEntityManager processDefinitionManager = commandContext.getProcessDefinitionEntityManager();
        Map processDefinitionSetting = (Map)deploymentSettings.get(String.valueOf(processDefinition.getModelId()));
        if (processDefinitionSetting == null) {
            return;
        }
        Boolean bl = disablePrevious = processDefinitionSetting.get("disablePrevious") == null ? Boolean.FALSE : (Boolean)processDefinitionSetting.get("disablePrevious");
        if (!disablePrevious.booleanValue()) {
            return;
        }
        ProcessDefinitionEntity processDefinitionPrevious = mapOfNewProcessDefinitionToPreviousVersion.get(processDefinition);
        if (processDefinitionPrevious != null) {
            try {
                commandContext.addAttribute("env", "publish");
                commandContext.getProcessEngineConfiguration().getRepositoryService().suspendProcessDefinitionById(processDefinitionPrevious.getId());
                commandContext.addAttribute("alreadyDisabledId", processDefinitionPrevious.getId());
            }
            finally {
                commandContext.removeAttribute("env");
            }
        }
    }

    private void otherProcessDisabled(Map<String, Object> deploymentSettings, ProcessDefinitionEntity processDefinition) {
        CommandContext commandContext = Context.getCommandContext();
        Map processDefinitionSetting = (Map)deploymentSettings.get(String.valueOf(processDefinition.getModelId()));
        if (processDefinitionSetting != null && !processDefinitionSetting.isEmpty()) {
            Boolean otherProcessDisabled = Boolean.FALSE;
            if (processDefinitionSetting.get("disableOtherProcess") != null) {
                otherProcessDisabled = (Boolean)processDefinitionSetting.get("disableOtherProcess");
            }
            if (otherProcessDisabled.booleanValue()) {
                new DisableOtherProcessCmd(processDefinition).execute(commandContext);
            }
        }
    }

    protected void disposeDefaultCondRule(ParsedDeployment parsedDeployment) {
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            if (!ModelType.AuditFlow.name().equals(processDefinition.getType())) continue;
            this.bpmnDeploymentHelper.disposeDefaultConditional(parsedDeployment.getBpmnModelForProcessDefinition(processDefinition));
        }
    }

    protected void updateTimersAndEvents(ParsedDeployment parsedDeployment, Map<ProcessDefinitionEntity, ProcessDefinitionEntity> mapNewToOldProcessDefinitions) {
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            this.bpmnDeploymentHelper.updateTimersAndEvents(processDefinition, mapNewToOldProcessDefinitions.get(processDefinition), parsedDeployment);
        }
    }

    protected void dispatchProcessDefinitionEntityInitializedEvent(ParsedDeployment parsedDeployment) {
        CommandContext commandContext = Context.getCommandContext();
        for (ProcessDefinitionEntity processDefinitionEntity : parsedDeployment.getAllProcessDefinitions()) {
            if (!commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) continue;
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, processDefinitionEntity));
        }
    }

    protected void makeProcessDefinitionsConsistentWithPersistedVersions(ParsedDeployment parsedDeployment, Long processDefinitionId) {
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            ProcessDefinitionEntity persistedProcessDefinition = this.bpmnDeploymentHelper.getPersistedInstanceOfProcessDefinition(processDefinition, processDefinitionId);
            if (persistedProcessDefinition == null) continue;
            processDefinition.setId(persistedProcessDefinition.getId());
            processDefinition.setApplicationId(persistedProcessDefinition.getApplicationId());
            processDefinition.setVersion(persistedProcessDefinition.getVersion());
            processDefinition.setEnable(persistedProcessDefinition.getEnable());
            processDefinition.setEntraBill(persistedProcessDefinition.getEntraBill());
            processDefinition.setEntraBillId(persistedProcessDefinition.getEntraBillId());
            processDefinition.setCategory(persistedProcessDefinition.getCategory());
            processDefinition.setCategoryName(persistedProcessDefinition.getCategoryName());
            processDefinition.setOperation(persistedProcessDefinition.getOperation());
            processDefinition.setVersionDesc(persistedProcessDefinition.getVersionDesc());
            processDefinition.setDescription(persistedProcessDefinition.getDescription());
            processDefinition.setType(persistedProcessDefinition.getType());
            processDefinition.setOrgUnitId(persistedProcessDefinition.getOrgUnitId());
            processDefinition.setModelId(persistedProcessDefinition.getModelId());
            processDefinition.setCreateDate(persistedProcessDefinition.getCreateDate());
            processDefinition.setModifyDate(persistedProcessDefinition.getModifyDate());
            processDefinition.setCreatorId(persistedProcessDefinition.getCreatorId());
            processDefinition.setModifierId(persistedProcessDefinition.getModifierId());
        }
    }

    protected boolean isEqualToCurrentLocalizationValue(String language, String id, String propertyName, String propertyValue, ObjectNode infoNode) {
        boolean isEqual = false;
        JsonNode localizationNode = infoNode.path("localization").path(language).path(id).path(propertyName);
        if (!localizationNode.isMissingNode() && !localizationNode.isNull() && localizationNode.asText().equals(propertyValue)) {
            isEqual = true;
        }
        return isEqual;
    }

    private void synchronizeResourceWords(Map<String, Object> deploymentSettings, ProcessDefinitionEntity processDefinition) {
        Map deploymentSetting = (Map)deploymentSettings.get(String.valueOf(processDefinition.getModelId()));
        if (deploymentSetting == null || deploymentSetting.isEmpty()) {
            log.debug("deploymentSettings is empty!");
            return;
        }
        String procDefId = (String)deploymentSetting.get("synchronizeResourceWords");
        if (WfUtils.isNotEmpty(procDefId)) {
            ProcessDefinitionEntity srcProcDef = (ProcessDefinitionEntity)Context.getCommandContext().getProcessDefinitionEntityManager().findById(Long.valueOf(procDefId));
            if (srcProcDef == null) {
                log.debug(String.format("\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49Id[%s]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6d41\u7a0b\u5b9a\u4e49\u5b9e\u4f53\uff01", procDefId));
                return;
            }
            ExtractMultiLanguageWordsUtil.synchronizeResourceWords(srcProcDef.getResourceId(), processDefinition.getResourceId());
        }
    }

    public ParsedDeploymentBuilderFactory getExParsedDeploymentBuilderFactory() {
        return this.parsedDeploymentBuilderFactory;
    }

    public void setParsedDeploymentBuilderFactory(ParsedDeploymentBuilderFactory parsedDeploymentBuilderFactory) {
        this.parsedDeploymentBuilderFactory = parsedDeploymentBuilderFactory;
    }

    public BpmnDeploymentHelper getBpmnDeploymentHelper() {
        return this.bpmnDeploymentHelper;
    }

    public void setBpmnDeploymentHelper(BpmnDeploymentHelper bpmnDeploymentHelper) {
        this.bpmnDeploymentHelper = bpmnDeploymentHelper;
    }

    public CachingAndArtifactsManager getCachingAndArtifcatsManager() {
        return this.cachingAndArtifactsManager;
    }

    public void setCachingAndArtifactsManager(CachingAndArtifactsManager manager) {
        this.cachingAndArtifactsManager = manager;
    }

    public ProcessDefinitionDiagramHelper getProcessDefinitionDiagramHelper() {
        return this.processDefinitionDiagramHelper;
    }

    public void setProcessDefinitionDiagramHelper(ProcessDefinitionDiagramHelper processDefinitionDiagramHelper) {
        this.processDefinitionDiagramHelper = processDefinitionDiagramHelper;
    }
}

