/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.deployer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BillCloseConfig;
import kd.bos.workflow.bpmn.model.BillExceptionOp;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.StartItem;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.WaitCloseOperation;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.bpmn.deployer.EventSubscriptionManager;
import kd.bos.workflow.engine.impl.bpmn.deployer.ParsedDeployment;
import kd.bos.workflow.engine.impl.bpmn.deployer.ProcessOperation;
import kd.bos.workflow.engine.impl.bpmn.deployer.TimerManager;
import kd.bos.workflow.engine.impl.bpmn.deployer.VersionUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.DeploymentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.exception.WFEngineException;

public class BpmnDeploymentHelper {
    protected TimerManager timerManager;
    protected EventSubscriptionManager eventSubscriptionManager;
    protected static Log log = LogFactory.getLog(BpmnDeploymentHelper.class);

    public void verifyProcessDefinitionsDoNotShareKeys(Collection<ProcessDefinitionEntity> processDefinitions) {
        LinkedHashSet<String> keySet = new LinkedHashSet<String>(processDefinitions.size());
        for (ProcessDefinitionEntity processDefinition : processDefinitions) {
            if (keySet.contains(processDefinition.getKey())) {
                throw new WFEngineException("The deployment contains process definitions with the same key (process id attribute), this is not allowed");
            }
            keySet.add(processDefinition.getKey());
        }
    }

    public void copyDeploymentValuesToProcessDefinitions(DeploymentEntity deployment, List<ProcessDefinitionEntity> processDefinitions) {
        String engineVersion = deployment.getEngineVersion();
        Long deploymentId = deployment.getId();
        for (ProcessDefinitionEntity processDefinition : processDefinitions) {
            processDefinition.setEngineVersion(engineVersion);
            processDefinition.setDeploymentId(deploymentId);
        }
    }

    public void setResourceNamesOnProcessDefinitions(ParsedDeployment parsedDeployment) {
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            String resourceName = parsedDeployment.getResourceForProcessDefinition(processDefinition).getName();
            processDefinition.setResourceId(Long.valueOf(resourceName));
        }
    }

    public ProcessDefinitionEntity getMostRecentVersionOfProcessDefinition(ProcessDefinitionEntity processDefinition) {
        String key = processDefinition.getKey();
        ProcessDefinitionEntityManager processDefinitionManager = Context.getCommandContext().getProcessEngineConfiguration().getProcessDefinitionEntityManager();
        ProcessDefinitionEntity existingDefinition = null;
        existingDefinition = processDefinitionManager.findLatestProcessDefinitionByKey(key);
        return existingDefinition;
    }

    public ProcessDefinitionEntity getPersistedInstanceOfProcessDefinition(ProcessDefinitionEntity processDefinition, Long processDefinitionId) {
        Long deploymentId = processDefinition.getDeploymentId();
        if (WfUtils.isEmpty(processDefinition.getDeploymentId())) {
            throw new IllegalStateException("Provided process definition must have a deployment id.");
        }
        ProcessDefinitionEntityManager processDefinitionManager = Context.getCommandContext().getProcessEngineConfiguration().getProcessDefinitionEntityManager();
        ProcessDefinitionEntity persistedProcessDefinition = null;
        if (WfUtils.isNotEmpty(processDefinitionId)) {
            log.debug(String.format("processDefinitionId is null\uff0cprocessDefinitionId is:%s", processDefinitionId));
            persistedProcessDefinition = (ProcessDefinitionEntity)processDefinitionManager.findById(processDefinitionId);
        } else {
            log.debug(String.format("processDefinitionId is not null\uff0cdeploymentId:%s,processDefinition's key:%s", deploymentId, processDefinition.getKey()));
            persistedProcessDefinition = processDefinitionManager.findProcessDefinitionByDeploymentAndKey(deploymentId, processDefinition.getKey());
        }
        return persistedProcessDefinition;
    }

    public void updateTimersAndEvents(ProcessDefinitionEntity processDefinition, ProcessDefinitionEntity previousProcessDefinition, ParsedDeployment parsedDeployment) {
        Process process = parsedDeployment.getProcessModelForProcessDefinition(processDefinition);
        BpmnModel bpmnModel = parsedDeployment.getBpmnModelForProcessDefinition(processDefinition);
        this.eventSubscriptionManager.addMessageEventSubscriptions(processDefinition, process, bpmnModel);
        if (ModelType.BizFlow.name().equals(process.getProcessType())) {
            BizFlowUtil.addBizFlowSignalEventSubscriptions(Context.getCommandContext(), processDefinition, process, bpmnModel);
        } else {
            this.eventSubscriptionManager.addSignalEventSubscriptions(Context.getCommandContext(), processDefinition, process, bpmnModel);
        }
        this.timerManager.removeObsoleteTimers(processDefinition);
        this.timerManager.scheduleTimers(processDefinition, process);
    }

    public void addAuthorizationsForNewProcessDefinition(Process process, ProcessDefinitionEntity processDefinition) {
    }

    protected void addAuthorizationsFromIterator(CommandContext commandContext, List<String> expressions, ProcessDefinitionEntity processDefinition, ExpressionType expressionType) {
        if (expressions != null) {
            for (String expression : expressions) {
                IdentityLinkEntity identityLink = (IdentityLinkEntity)commandContext.getIdentityLinkEntityManager().create();
                identityLink.setProcessDef(processDefinition);
                if (ExpressionType.USER == expressionType) {
                    Long userId = Long.parseLong(expression);
                    identityLink.setUserId(userId);
                    identityLink.setUserName(WfUtils.findUserName(userId));
                }
                identityLink.setType("participant");
                commandContext.getIdentityLinkEntityManager().insert(identityLink);
            }
        }
    }

    public TimerManager getTimerManager() {
        return this.timerManager;
    }

    public void setTimerManager(TimerManager timerManager) {
        this.timerManager = timerManager;
    }

    public EventSubscriptionManager getEventSubscriptionManager() {
        return this.eventSubscriptionManager;
    }

    public void setEventSubscriptionManager(EventSubscriptionManager eventSubscriptionManager) {
        this.eventSubscriptionManager = eventSubscriptionManager;
    }

    public void updateModelVersion(ProcessDefinitionEntity processDefinition) {
        if (processDefinition != null && processDefinition.getModelId() != null) {
            ModelEntityManager manager = Context.getProcessEngineConfiguration().getModelEntityManager();
            ModelEntity modelEntity = (ModelEntity)manager.findById(processDefinition.getModelId());
            modelEntity.setDeploymentId(processDefinition.getDeploymentId());
            if (!"testing".equals(processDefinition.getVersion())) {
                modelEntity.setVersion(VersionUtils.getNextVersion(processDefinition.getVersion()));
            }
            modelEntity.setPublish(true);
            manager.update(modelEntity);
        }
    }

    public void disposeDefaultConditional(BpmnModel bpmnModel) {
        Process process = bpmnModel.getMainProcess();
        StringBuilder sb = new StringBuilder();
        sb.append("disposeDefaultConditional:");
        this.disposeDefaultConditionalForCallActivity(bpmnModel, process);
        List<AuditTask> list = process.findFlowElementsOfType(AuditTask.class);
        for (AuditTask auditTask : list) {
            boolean needApprove = true;
            for (SequenceFlow sequenceFlow : auditTask.getOutgoingFlows()) {
                if (sequenceFlow.getConditionalRule() == null || !WfUtils.isNotEmpty(sequenceFlow.getConditionalRule().getExpression())) continue;
                Pattern pattern = Pattern.compile("auditNumber");
                Matcher matcher = pattern.matcher(sequenceFlow.getConditionalRule().getExpression());
                if (matcher.find()) {
                    needApprove = false;
                    break;
                }
                pattern = Pattern.compile(sequenceFlow.getSourceFlowElement().getId() + "AuditNumber");
                matcher = pattern.matcher(sequenceFlow.getConditionalRule().getExpression());
                if (!matcher.find()) continue;
                needApprove = false;
                break;
            }
            sb.append(String.format("%s-%s", auditTask.getId(), needApprove));
            if (!needApprove) continue;
            auditTask.setDynamicReject(true);
            String defaultDecisionNumber = "";
            StringBuilder approvalNumbers = new StringBuilder();
            for (DecisionOption decisionOption : auditTask.getDecisionOptions()) {
                if (!"approve".equals(decisionOption.getAuditType())) continue;
                approvalNumbers.append(",").append(decisionOption.getNumber());
            }
            if (approvalNumbers.length() > 1) {
                defaultDecisionNumber = approvalNumbers.substring(1);
            }
            sb.append(defaultDecisionNumber);
            for (SequenceFlow sequenceFlow : auditTask.getOutgoingFlows()) {
                if (sequenceFlow.isDynamic()) continue;
                ConditionalEntityImpl conditional = new ConditionalEntityImpl();
                ConditionalRuleEntity conditionalRule = sequenceFlow.getConditionalRule();
                if (conditionalRule != null && WfUtils.isNotEmpty(conditionalRule.getPlugin())) continue;
                conditional.setParamnumber("auditNumber");
                conditional.setOperation("IN");
                conditional.setValue(defaultDecisionNumber);
                String expression = null;
                String originalExpression = "";
                if (conditionalRule != null && WfUtils.isNotEmpty(expression = conditionalRule.getExpression())) {
                    originalExpression = conditionalRule.getExpression();
                    conditionalRule = (ConditionalRuleEntity)conditionalRule.clone();
                    conditional.setLogic("&&");
                    List<ConditionalEntity> entryEntity = conditionalRule.getEntryentity();
                    entryEntity.add(conditional);
                    conditionalRule.setEntryentity(entryEntity);
                    if ((expression.startsWith("entryAnyOne(") || expression.startsWith("entryUnion(")) && expression.contains("${")) {
                        String[] expressions = expression.split("\\$\\{");
                        expressions[1] = "${ ( " + expressions[1].substring(0, expressions[1].length() - 2) + ") " + String.format("&& %s %s \"%s\"", "auditNumber", "IN", defaultDecisionNumber) + " }";
                        expression = expressions[0] + expressions[1] + ")";
                    } else {
                        expression = expression.substring(2, expression.length() - 1);
                        expression = "${ ( " + expression + ") " + String.format("&& %s %s \"%s\"", "auditNumber", "IN", defaultDecisionNumber) + " }";
                    }
                    conditionalRule.setExpression(expression);
                    sb.append(expression);
                } else {
                    conditionalRule = new ConditionalRuleEntityImpl();
                    conditionalRule.setElementid(sequenceFlow.getId());
                    conditionalRule.setType(ConditionalRuleType.sequenceFlow.toString());
                    conditionalRule.setExpression(String.format("${ %s %s \"%s\" }", "auditNumber", "IN", defaultDecisionNumber));
                    ArrayList<ConditionalEntity> entryentity = new ArrayList<ConditionalEntity>();
                    entryentity.add(conditional);
                    conditionalRule.setEntryentity(entryentity);
                    sb.append(expression);
                }
                sequenceFlow.setConditionalRule(conditionalRule);
                sequenceFlow.setOrignalExpression(originalExpression);
                log.debug(sb.toString());
            }
        }
    }

    private void disposeDefaultConditionalForCallActivity(BpmnModel bpmnModel, Process process) {
        List<CallActivity> list = process.findFlowElementsOfType(CallActivity.class);
        for (CallActivity callActivity : list) {
            String subProcessResultKey = callActivity.getId() + "SubProcessResult";
            boolean findSubProcessResultKey = false;
            for (SequenceFlow sequenceFlow : callActivity.getOutgoingFlows()) {
                Pattern pattern;
                Matcher matcher;
                if (sequenceFlow.getConditionalRule() == null || !WfUtils.isNotEmpty(sequenceFlow.getConditionalRule().getExpression()) || !(matcher = (pattern = Pattern.compile(subProcessResultKey)).matcher(sequenceFlow.getConditionalRule().getExpression())).find()) continue;
                findSubProcessResultKey = true;
                break;
            }
            if (findSubProcessResultKey) continue;
            callActivity.setDynamicReject(true);
        }
    }

    public List<ProcessOperation> getAllProcessOperations(BpmnModel bpmnModel) {
        ArrayList<ProcessOperation> operations = new ArrayList<ProcessOperation>();
        List<Process> processes = bpmnModel.getProcesses();
        if (processes == null || processes.isEmpty()) {
            return operations;
        }
        HashSet<String> entityActOpers = new HashSet<String>(operations.size());
        for (Process process : processes) {
            if (process.getBillExceptionOp() != null && !process.getBillExceptionOp().isEmpty()) {
                for (BillExceptionOp op : process.getBillExceptionOp()) {
                    if (!entityActOpers.add(this.getEntityActivityOperationKey(op.getBillnumber(), process, op.getOper()))) continue;
                    operations.add(new ProcessOperation(process, op.getOper(), op.getBillnumber()));
                }
            }
            List<UserTask> elements = process.findFlowElementsOfType(UserTask.class);
            for (UserTask element : elements) {
                if (!element.getClass().equals(UserTask.class) && !element.getClass().equals(BillTask.class)) continue;
                try {
                    List<DecisionOption> options = element.getDecisionOptions();
                    if (options == null || options.isEmpty()) continue;
                    for (DecisionOption option : options) {
                        if (!entityActOpers.add(this.getEntityActivityOperationKey(element.getEntityNumber(), element, option.getNumber()))) continue;
                        operations.add(new ProcessOperation(element, option.getNumber(), element.getEntityNumber()));
                    }
                }
                catch (Exception e) {
                    log.error("getAllProcessOperations has a exception, msg:" + e.getMessage());
                }
            }
            if (BpmnModelUtil.isBizFlow(process.getProcessType())) {
                this.addStartItemOperations(operations, process, entityActOpers);
                this.addWaitCloseOperations(operations, process, entityActOpers);
                continue;
            }
            if (!ModelType.NoCodeFlow.name().equals(process.getProcessType())) continue;
            this.addNoCodeTriggerOperations(operations, process);
        }
        return operations;
    }

    private void addNoCodeTriggerOperations(List<ProcessOperation> operations, Process process) {
        String[] ops;
        String triggerMode = process.getTriggerMode();
        if (WfUtils.isEmpty(triggerMode)) {
            log.error(String.format("triggerMode is null. procNumber: %s", process.getId()));
            return;
        }
        for (String op : ops = triggerMode.split(",")) {
            operations.add(new ProcessOperation(process, op, process.getEntraBill()));
        }
    }

    private void addStartItemOperations(List<ProcessOperation> operations, Process process, Set<String> entityActOpers) {
        List<StartItem> startItems = process.getStartItems();
        for (StartItem item : startItems) {
            if (WfUtils.isEmpty(item.getOperation())) continue;
            List<String> nodeIds = BizFlowUtil.getStartItemNodeIds(item);
            JSONArray opers = JSON.parseArray((String)item.getOperation());
            for (int i = 0; i < opers.size(); ++i) {
                JSONObject oper = opers.getJSONObject(i);
                String operation = oper.getString("number");
                for (String nodeId : nodeIds) {
                    FlowElement element = process.getFlowElement(nodeId);
                    if (!entityActOpers.add(this.getEntityActivityOperationKey(item.getEntitynumber(), element, operation))) continue;
                    operations.add(new ProcessOperation(element, operation, item.getEntitynumber()));
                }
            }
        }
    }

    private void addWaitCloseOperations(List<ProcessOperation> operations, Process process, Set<String> entityActOpers) {
        List<BillTask> billTasks = process.findFlowElementsOfType(BillTask.class);
        if (billTasks == null || billTasks.isEmpty()) {
            return;
        }
        BillCloseConfig billCloseConfig = null;
        List<WaitCloseOperation> closeOperations = null;
        for (BillTask billTask : billTasks) {
            billCloseConfig = billTask.getBillCloseConfig();
            if (billCloseConfig == null || billCloseConfig.getWaitActions() == null || billCloseConfig.getWaitActions().getOperations() == null) continue;
            String entityNumber = billTask.getEntityNumber();
            closeOperations = billCloseConfig.getWaitActions().getOperations();
            for (WaitCloseOperation closeOperation : closeOperations) {
                String operation = closeOperation.getNumber();
                if (!entityActOpers.add(this.getEntityActivityOperationKey(entityNumber, billTask, operation))) continue;
                operations.add(new ProcessOperation(billTask, operation, entityNumber));
            }
        }
    }

    private String getEntityActivityOperationKey(String entityNumber, BaseElement baseElement, String operation) {
        if (baseElement == null) {
            return String.format("%s-%s", entityNumber, operation);
        }
        return String.format("%s-%s-%s", entityNumber, baseElement.getId(), operation);
    }

    static enum ExpressionType {
        USER,
        GROUP;

    }
}

