/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.deployer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.deployer.BpmnDeploymentHelper;
import kd.bos.workflow.engine.impl.bpmn.deployer.ParsedDeployment;
import kd.bos.workflow.engine.impl.bpmn.deployer.ProcessOperation;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.deploy.DeploymentCache;
import kd.bos.workflow.engine.impl.persistence.deploy.DeploymentManager;
import kd.bos.workflow.engine.impl.persistence.deploy.ProcessDefinitionCacheEntry;
import kd.bos.workflow.engine.impl.persistence.deploy.ProcessDefinitionInfoCacheObject;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DeploymentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionInfoEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionInfoEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class CachingAndArtifactsManager {
    protected static Log log = LogFactory.getLog(CachingAndArtifactsManager.class);
    private BpmnDeploymentHelper bpmnDeploymentHelper = new BpmnDeploymentHelper();

    public List<ProcessDefinitionCacheEntry> updateCachingAndArtifacts(ParsedDeployment parsedDeployment, Map<String, Object> deploymentSettings) {
        CommandContext commandContext = Context.getCommandContext();
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        DeploymentCache<ProcessDefinitionCacheEntry> processDefinitionCache = processEngineConfiguration.getDeploymentManager().getProcessDefinitionCache();
        DeploymentEntity deployment = parsedDeployment.getDeployment();
        ArrayList<ProcessDefinitionCacheEntry> ret = new ArrayList<ProcessDefinitionCacheEntry>(parsedDeployment.getAllProcessDefinitions().size());
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            BpmnModel bpmnModel = parsedDeployment.getBpmnModelForProcessDefinition(processDefinition);
            Process process = parsedDeployment.getProcessModelForProcessDefinition(processDefinition);
            process.setVersion(processDefinition.getVersion());
            ProcessDefinitionCacheEntry cacheEntry = new ProcessDefinitionCacheEntry(processDefinition, bpmnModel, process);
            Long schemeId = null;
            Long procInstId = null;
            if (deploymentSettings != null) {
                schemeId = (Long)deploymentSettings.get("schemeId");
                procInstId = (Long)deploymentSettings.get("processInstanceId");
            }
            Long cacheId = processDefinition.getId();
            String modifyDate = String.valueOf(processDefinition.getModifyDate().getTime());
            if (WfUtils.isNotEmpty(procInstId)) {
                cacheId = procInstId;
                modifyDate = String.valueOf(this.getModifyDate(commandContext, procInstId));
            } else if (WfUtils.isNotEmpty(schemeId)) {
                cacheId = schemeId;
                modifyDate = String.valueOf(this.getSchemeModifyDate(commandContext, schemeId));
            }
            processDefinitionCache.add(cacheId, cacheEntry, modifyDate);
            ret.add(cacheEntry);
            List<ProcessOperation> operations = this.bpmnDeploymentHelper.getAllProcessOperations(bpmnModel);
            this.addDefinitionInfoToCache(processDefinition, processEngineConfiguration, commandContext, operations);
            deployment.addDeployedArtifact(processDefinition);
        }
        return ret;
    }

    private Long getModifyDate(CommandContext commandContext, Long processInstanceId) {
        Long modifyDate = null;
        ExecutionEntity entity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(processInstanceId);
        if (entity != null) {
            modifyDate = entity.getModifyDate().getTime();
        } else {
            HistoricProcessInstanceEntity hisEntity = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(processInstanceId);
            if (hisEntity != null) {
                modifyDate = hisEntity.getModifyDate().getTime();
            } else {
                log.debug(String.format("--procInstEntity[%s] has been deleted", processInstanceId));
            }
        }
        return modifyDate;
    }

    private Long getSchemeModifyDate(CommandContext commandContext, Long schemeId) {
        DynamicConfigSchemeEntity scheme = (DynamicConfigSchemeEntity)commandContext.getDynamicConfigSchemeEntityManager().findById(schemeId);
        if (scheme != null) {
            return scheme.getModifyDate().getTime();
        }
        return null;
    }

    protected void addDefinitionInfoToCache(ProcessDefinitionEntity processDefinition, ProcessEngineConfigurationImpl processEngineConfiguration, CommandContext commandContext, List<ProcessOperation> operations) {
        WfCacheHelper.updateProcessDefWhenStateChange(commandContext, processDefinition.getEntraBill(), operations);
        if (!processEngineConfiguration.isEnableProcessDefinitionInfoCache()) {
            return;
        }
        DeploymentManager deploymentManager = processEngineConfiguration.getDeploymentManager();
        ProcessDefinitionInfoEntityManager definitionInfoEntityManager = commandContext.getProcessDefinitionInfoEntityManager();
        ProcessDefinitionInfoEntity definitionInfoEntity = definitionInfoEntityManager.findProcessDefinitionInfoByProcessDefinitionId(processDefinition.getId());
        ProcessDefinitionInfoCacheObject definitionCacheObject = new ProcessDefinitionInfoCacheObject();
        if (definitionInfoEntity == null) {
            definitionCacheObject.setRevision(0);
        } else {
            definitionCacheObject.setId(definitionInfoEntity.getId());
        }
        deploymentManager.getProcessDefinitionInfoCache().add(processDefinition.getId(), definitionCacheObject);
    }
}

