/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.deployer;

import java.util.List;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.EventDefinition;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Message;
import kd.bos.workflow.bpmn.model.MessageEventDefinition;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.Signal;
import kd.bos.workflow.bpmn.model.SignalEventDefinition;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.MessageEventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SignalEventSubscriptionEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.exception.WFEngineException;

public class EventSubscriptionManager {
    protected void addMessageEventSubscriptions(ProcessDefinitionEntity processDefinition, Process process, BpmnModel bpmnModel) {
        if (CollectionUtil.isNotEmpty(process.getFlowElements())) {
            for (FlowElement element : process.getFlowElements()) {
                EventDefinition eventDefinition;
                StartEvent startEvent;
                if (!(element instanceof StartEvent) || !CollectionUtil.isNotEmpty((startEvent = (StartEvent)element).getEventDefinitions()) || !((eventDefinition = startEvent.getEventDefinitions().get(0)) instanceof MessageEventDefinition)) continue;
                MessageEventDefinition messageEventDefinition = (MessageEventDefinition)eventDefinition;
                this.insertMessageEvent(messageEventDefinition, startEvent, processDefinition, bpmnModel);
            }
        }
    }

    protected void insertMessageEvent(MessageEventDefinition messageEventDefinition, StartEvent startEvent, ProcessDefinitionEntity processDefinition, BpmnModel bpmnModel) {
        CommandContext commandContext = Context.getCommandContext();
        if (bpmnModel.containsMessageId(messageEventDefinition.getMessageRef())) {
            Message message = bpmnModel.getMessage(messageEventDefinition.getMessageRef());
            messageEventDefinition.setMessageRef(message.getName());
        }
        List<EventSubscriptionEntity> subscriptionsForSameMessageName = commandContext.getEventSubscriptionEntityManager().findEventSubscriptionsByName("message", messageEventDefinition.getMessageRef());
        for (EventSubscriptionEntity eventSubscriptionEntity : subscriptionsForSameMessageName) {
            if (!WfUtils.isEmpty(eventSubscriptionEntity.getProcessInstanceId())) continue;
            throw new WFEngineException("Cannot deploy process definition '" + processDefinition.getResourceId() + "': there already is a message event subscription for the message with name '" + messageEventDefinition.getMessageRef() + "'.");
        }
        MessageEventSubscriptionEntity newSubscription = commandContext.getEventSubscriptionEntityManager().createMessageEventSubscription();
        newSubscription.setEventName(messageEventDefinition.getMessageRef());
        newSubscription.setActivityId(startEvent.getId());
        newSubscription.setConfiguration(String.valueOf(processDefinition.getId()));
        newSubscription.setProcessDefinitionId(processDefinition.getId());
        newSubscription.setVersion(processDefinition.getVersion());
        commandContext.getEventSubscriptionEntityManager().insert(newSubscription);
    }

    protected void addSignalEventSubscriptions(CommandContext commandContext, ProcessDefinitionEntity processDefinition, Process process, BpmnModel bpmnModel) {
        if (CollectionUtil.isNotEmpty(process.getFlowElements())) {
            for (FlowElement element : process.getFlowElements()) {
                EventDefinition eventDefinition;
                StartEvent startEvent;
                if (!(element instanceof StartEvent) || !CollectionUtil.isNotEmpty((startEvent = (StartEvent)element).getEventDefinitions()) || !((eventDefinition = startEvent.getEventDefinitions().get(0)) instanceof SignalEventDefinition)) continue;
                SignalEventDefinition signalEventDefinition = (SignalEventDefinition)eventDefinition;
                SignalEventSubscriptionEntity subscriptionEntity = commandContext.getEventSubscriptionEntityManager().createSignalEventSubscription();
                Signal signal = bpmnModel.getSignal(signalEventDefinition.getSignalRef());
                if (signal != null) {
                    subscriptionEntity.setEventName(signal.getName());
                } else {
                    subscriptionEntity.setEventName(signalEventDefinition.getSignalRef());
                }
                subscriptionEntity.setActivityId(startEvent.getId());
                subscriptionEntity.setProcessDefinitionId(processDefinition.getId());
                subscriptionEntity.setVersion(processDefinition.getVersion());
                Context.getCommandContext().getEventSubscriptionEntityManager().insert(subscriptionEntity);
            }
        }
    }
}

