/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.deployer;

import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.impl.bpmn.parser.BpmnParse;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DeploymentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;

public class ParsedDeployment {
    protected DeploymentEntity deploymentEntity;
    protected List<ProcessDefinitionEntity> processDefinitions;
    protected Map<ProcessDefinitionEntity, BpmnParse> mapProcessDefinitionsToParses;
    protected Map<ProcessDefinitionEntity, ResourceEntity> mapProcessDefinitionsToResources;

    public ParsedDeployment(DeploymentEntity entity, List<ProcessDefinitionEntity> processDefinitions, Map<ProcessDefinitionEntity, BpmnParse> mapProcessDefinitionsToParses, Map<ProcessDefinitionEntity, ResourceEntity> mapProcessDefinitionsToResources) {
        this.deploymentEntity = entity;
        this.processDefinitions = processDefinitions;
        this.mapProcessDefinitionsToParses = mapProcessDefinitionsToParses;
        this.mapProcessDefinitionsToResources = mapProcessDefinitionsToResources;
    }

    public DeploymentEntity getDeployment() {
        return this.deploymentEntity;
    }

    public List<ProcessDefinitionEntity> getAllProcessDefinitions() {
        return this.processDefinitions;
    }

    public ResourceEntity getResourceForProcessDefinition(ProcessDefinitionEntity processDefinition) {
        return this.mapProcessDefinitionsToResources.get(processDefinition);
    }

    public BpmnParse getBpmnParseForProcessDefinition(ProcessDefinitionEntity processDefinition) {
        return this.mapProcessDefinitionsToParses.get(processDefinition);
    }

    public BpmnModel getBpmnModelForProcessDefinition(ProcessDefinitionEntity processDefinition) {
        BpmnParse parse = this.getBpmnParseForProcessDefinition(processDefinition);
        return parse == null ? null : parse.getBpmnModel();
    }

    public Process getProcessModelForProcessDefinition(ProcessDefinitionEntity processDefinition) {
        BpmnModel model = this.getBpmnModelForProcessDefinition(processDefinition);
        return model == null ? null : model.getProcessById(processDefinition.getKey());
    }
}

