/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.deployer;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.deployer.ParsedDeployment;
import kd.bos.workflow.engine.impl.bpmn.parser.BpmnParse;
import kd.bos.workflow.engine.impl.bpmn.parser.BpmnParser;
import kd.bos.workflow.engine.impl.cmd.management.scheme.GetConfigSchemeBpmnJsonStringCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.IDynamicResourceItem;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DeploymentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ExtractMultiLanguageWordsUtil;
import kd.bos.workflow.exception.WFErrorCode;

public class ParsedDeploymentBuilder {
    protected static Log log = LogFactory.getLog(ParsedDeploymentBuilder.class);
    protected DeploymentEntity deployment;
    protected BpmnParser bpmnParser;
    protected Map<String, Object> deploymentSettings;

    public ParsedDeploymentBuilder(DeploymentEntity deployment, BpmnParser bpmnParser, Map<String, Object> deploymentSettings) {
        this.deployment = deployment;
        this.bpmnParser = bpmnParser;
        this.deploymentSettings = deploymentSettings;
    }

    public ParsedDeployment build() {
        ArrayList<ProcessDefinitionEntity> processDefinitions = new ArrayList<ProcessDefinitionEntity>();
        LinkedHashMap<ProcessDefinitionEntity, BpmnParse> processDefinitionsToBpmnParseMap = new LinkedHashMap<ProcessDefinitionEntity, BpmnParse>();
        LinkedHashMap<ProcessDefinitionEntity, ResourceEntity> processDefinitionsToResourceMap = new LinkedHashMap<ProcessDefinitionEntity, ResourceEntity>();
        for (ResourceEntity resource : this.deployment.getResources().values()) {
            if (!this.isBpmnResource(resource.getName())) continue;
            log.debug(String.format("Processing BPMN resource %s", resource.getName()));
            BpmnParse parse = this.createBpmnParseFromResource(resource);
            for (ProcessDefinitionEntity processDefinition : parse.getProcessDefinitions()) {
                this.setModelIdToProcessDefinition(processDefinition, resource);
                processDefinitions.add(processDefinition);
                processDefinitionsToBpmnParseMap.put(processDefinition, parse);
                processDefinitionsToResourceMap.put(processDefinition, resource);
            }
        }
        return new ParsedDeployment(this.deployment, processDefinitions, processDefinitionsToBpmnParseMap, processDefinitionsToResourceMap);
    }

    private void setModelIdToProcessDefinition(ProcessDefinitionEntity processDefinition, ResourceEntity resource) {
        if (resource.getModelId() != null && processDefinition.getModelId() == null) {
            processDefinition.setModelId(resource.getModelId());
            processDefinition.setResourceId(resource.getId());
        }
    }

    protected BpmnParse createBpmnParseFromResource(ResourceEntity resource) {
        String resourceContent = null;
        Long processInstanceId = null;
        CommandContext commandContext = Context.getCommandContext();
        Entity processInstanceEntity = null;
        if (this.deploymentSettings != null) {
            Long schemeId = (Long)this.deploymentSettings.get("schemeId");
            if (WfUtils.isEmpty(schemeId) && WfUtils.isNotEmpty(processInstanceId = (Long)this.deploymentSettings.get("processInstanceId"))) {
                ExecutionEntity execution = commandContext.getExecutionEntityManager().findProcessInstanceById(processInstanceId);
                if (execution != null) {
                    processInstanceEntity = execution;
                    schemeId = execution.getSchemeId();
                } else {
                    HistoricProcessInstanceEntity procInstEntity = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(processInstanceId);
                    if (procInstEntity != null) {
                        processInstanceEntity = procInstEntity;
                        schemeId = procInstEntity.getSchemeId();
                    } else {
                        log.debug(String.format("--procInstEntity[%s] has been deleted", processInstanceId));
                    }
                }
            }
            if (WfUtils.isNotEmpty(schemeId)) {
                log.debug(String.format("--DynamicConfigScheme--%s \u6709\u914d\u7f6e\u65b9\u6848 %s\uff0c\u4ece\u914d\u7f6e\u65b9\u6848\u83b7\u53d6BpmnModel\uff01", processInstanceId, schemeId));
                resourceContent = new GetConfigSchemeBpmnJsonStringCmd(schemeId, null).execute(commandContext);
            } else {
                log.debug(String.format("--DynamicConfigScheme--%s \u6ca1\u6709\u914d\u7f6e\u65b9\u6848\uff01", processInstanceId));
            }
        }
        if (resourceContent == null) {
            String lang = RequestContext.get().getLang().toString();
            resourceContent = ExtractMultiLanguageWordsUtil.getMultiLanguageResourceData(resource, lang);
        }
        String resourceName = resource.getName();
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(resourceContent.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new KDException(WFErrorCode.invalidateResourceContentError(), new Object[]{this.getClass().getName() + "createBpmnParseFromResource->" + e.getMessage()});
        }
        BpmnParse bpmnParse = this.bpmnParser.createParse().sourceInputStream(inputStream).setSourceSystemId(resourceName).deployment(this.deployment).resource(resource).name(resourceName);
        if (this.deploymentSettings != null) {
            if (this.deploymentSettings.containsKey("isBpmn20XsdValidationEnabled")) {
                bpmnParse.setValidateSchema((Boolean)this.deploymentSettings.get("isBpmn20XsdValidationEnabled"));
            }
            if (this.deploymentSettings.containsKey("isProcessValidationEnabled")) {
                bpmnParse.setValidateProcess((Boolean)this.deploymentSettings.get("isProcessValidationEnabled"));
            }
        } else {
            bpmnParse.setValidateSchema(false);
            bpmnParse.setValidateProcess(false);
        }
        if (resource.getName().endsWith(".json")) {
            bpmnParse.setValidateSchema(false);
            bpmnParse.setValidateProcess(false);
            List<IDynamicResourceItem> dynamicResourceItems = bpmnParse.mergeDynamicResource(processInstanceEntity);
            bpmnParse.executeJSONConverter(dynamicResourceItems);
        }
        return bpmnParse;
    }

    protected boolean isBpmnResource(String resourceName) {
        return true;
    }
}

