/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.deployer;

import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.bpmn.model.EventDefinition;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.TimerEventDefinition;
import kd.bos.workflow.engine.impl.asyncexecutor.JobManager;
import kd.bos.workflow.engine.impl.cmd.CancelJobsCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.TimerEventHandler;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;

public class TimerManager {
    protected void removeObsoleteTimers(ProcessDefinitionEntity processDefinition) {
        CommandContext commandContext = Context.getCommandContext();
        List<TimerJobEntity> jobsToDelete = commandContext.getTimerJobEntityManager().findTimerStartJobsByProcessDefinitionKey(processDefinition.getKey(), "id");
        if (jobsToDelete != null) {
            ArrayList<Long> jobIds = new ArrayList<Long>(jobsToDelete.size());
            for (TimerJobEntity job : jobsToDelete) {
                jobIds.add(job.getId());
            }
            new CancelJobsCmd(jobIds).execute(commandContext);
        }
    }

    protected void scheduleTimers(ProcessDefinitionEntity processDefinition, Process process) {
        JobManager jobManager = Context.getCommandContext().getJobManager();
        List<TimerJobEntity> timers = this.getTimerDeclarations(processDefinition, process);
        for (TimerJobEntity timer : timers) {
            jobManager.scheduleTimerJob(timer);
        }
    }

    protected List<TimerJobEntity> getTimerDeclarations(ProcessDefinitionEntity processDefinition, Process process) {
        JobManager jobManager = Context.getCommandContext().getJobManager();
        ArrayList<TimerJobEntity> timers = new ArrayList<TimerJobEntity>();
        if (CollectionUtil.isEmpty(process.getFlowElements())) {
            return timers;
        }
        for (FlowElement element : process.getFlowElements()) {
            StartEvent startEvent;
            if (!(element instanceof StartEvent) || CollectionUtil.isEmpty((startEvent = (StartEvent)element).getEventDefinitions())) continue;
            for (EventDefinition eventDefinition : startEvent.getEventDefinitions()) {
                TimerEventDefinition timerEventDefinition;
                TimerJobEntity timerJob;
                if (!(eventDefinition instanceof TimerEventDefinition) || (timerJob = jobManager.createTimerJob(timerEventDefinition = (TimerEventDefinition)eventDefinition, false, null, "timer-start-event", TimerEventHandler.createConfiguration(startEvent.getId(), timerEventDefinition.getEndDate(), timerEventDefinition.getCalendarName()))) == null) continue;
                timerJob.setProcessDefinitionId(processDefinition.getId());
                timers.add(timerJob);
            }
        }
        return timers;
    }
}

