/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.LocaleValue;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.startup.AddressProcessCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricDynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.util.concurrent.ConcurrentDataUpdateUtil;

public class BPMNUtil {
    protected static Log logger = LogFactory.getLog(BPMNUtil.class);

    public static void updateActivityName(ExecutionEntity executionEntity) {
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntityManager executionMgr = commandContext.getExecutionEntityManager();
        Long rootProInstId = executionEntity.getProcessInstanceId();
        ExecutionEntity rootExecutionEntity = (ExecutionEntity)executionMgr.findById(rootProInstId);
        FlowElement currentElement = executionEntity.getCurrentFlowElement();
        if (currentElement != null && currentElement.isAddSign()) {
            ILocaleString addSignNodeName = BPMNUtil.getAddSignNodeName(executionEntity, currentElement);
            rootExecutionEntity.setActivityName(addSignNodeName);
            executionMgr.update(rootExecutionEntity);
            executionEntity.setActivityName(addSignNodeName);
            executionMgr.update(executionEntity);
            return;
        }
        List<ExecutionEntity> execEntityList = commandContext.getWithdrawExes();
        if (execEntityList == null || execEntityList.isEmpty()) {
            execEntityList = executionMgr.findChildExecutionsByProcessInstanceId(rootProInstId);
        }
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(executionEntity.getProcessInstance().getProcessDefinitionId(), rootProInstId);
        Process process = bpmnModel.getMainProcess();
        HashMap<String, String> idNameMap = new HashMap<String, String>();
        HashSet<String> actIds = new HashSet<String>();
        for (ExecutionEntity exec : execEntityList) {
            FlowNode flowNode;
            FlowElement flowElement;
            if (exec.isScope() || exec.isDeleted() || !exec.isActive() && (!((flowElement = process.getFlowElement(exec.getActivityId(), true)) instanceof FlowNode) || (flowNode = (FlowNode)flowElement).getJoin() == null || !flowNode.getJoin().booleanValue() || !"enterwhenallarrive".equals(flowNode.getInSet()))) continue;
            FlowElement currentFlowElement = executionEntity.getCurrentFlowElement();
            if (currentFlowElement instanceof FlowNode && !(currentFlowElement instanceof BoundaryEvent) && executionEntity.getId().equals(exec.getId()) && !currentFlowElement.isAddSign()) {
                actIds.add(executionEntity.getCurrentFlowElement().getId());
                idNameMap.put(executionEntity.getCurrentFlowElement().getId(), executionEntity.getCurrentFlowElement().getName());
                continue;
            }
            FlowElement elem = process.getFlowElement(exec.getActivityId(), true);
            if (elem instanceof BoundaryEvent) continue;
            if (elem == null && exec.getCurrentFlowElement() != null) {
                elem = exec.getCurrentFlowElement();
            }
            if (elem == null || !WfUtils.isNotEmpty(elem.getName())) continue;
            actIds.add(elem.getId());
            idNameMap.put(elem.getId(), elem.getName());
        }
        JSONObject multiLangDatas = BpmnModelUtil.getMultiLangDatas(rootProInstId);
        HashMap idNameMapCopy = new HashMap();
        for (Map.Entry entry : idNameMapCopy.entrySet()) {
            String id = (String)entry.getKey();
            if (!WfUtils.isNotEmpty(process.getBoundaryEventId(id))) continue;
            idNameMapCopy.put(id, entry.getValue());
            break;
        }
        if (!idNameMapCopy.isEmpty()) {
            idNameMap = idNameMapCopy;
            actIds = new HashSet();
            actIds.addAll(idNameMapCopy.keySet());
        }
        String actName = WfUtils.listToString(new ArrayList(idNameMap.values()), ",");
        String actId = WfUtils.listToString(new ArrayList(actIds), ",");
        rootExecutionEntity.setActivityId(actId);
        LocaleString activityName = new LocaleString(actName);
        for (String key : multiLangDatas.keySet()) {
            String multiKey = null;
            StringBuilder ret = new StringBuilder();
            JSONObject datas = multiLangDatas.getJSONObject(key);
            if (datas == null) continue;
            for (String id : actIds) {
                multiKey = BpmnModelUtil.getActivityNameMultiKey(id);
                String val = datas.getString(multiKey);
                ret.append(val != null ? val : (String)idNameMap.get(id)).append(StandardTips.getComma());
            }
            if (ret.length() <= 0) continue;
            activityName.put((Object)key, (Object)ret.deleteCharAt(ret.length() - 1).toString());
        }
        rootExecutionEntity.setActivityName((ILocaleString)activityName);
        executionMgr.update(rootExecutionEntity);
        executionEntity = (ExecutionEntity)executionMgr.findById(executionEntity.getId());
        if (currentElement != null) {
            String activityNameKey = BpmnModelUtil.getActivityNameMultiKey(currentElement.getId());
            executionEntity.setActivityName(BpmnModelUtil.getMultiLangFieldValue(multiLangDatas, activityNameKey, currentElement.getName()));
        }
        executionMgr.update(executionEntity);
    }

    public static void updateExecutionActivityName(ExecutionEntity executionEntity) {
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntityManager executionMgr = commandContext.getExecutionEntityManager();
        FlowElement currentElement = executionEntity.getCurrentFlowElement();
        executionEntity = (ExecutionEntity)executionMgr.findById(executionEntity.getId());
        String activityNameKey = BpmnModelUtil.getActivityNameMultiKey(currentElement.getId());
        JSONObject multiLangDatas = BpmnModelUtil.getMultiLangDatas(executionEntity.getProcessInstanceId());
        if (currentElement.isAddSign() && currentElement instanceof AuditTask) {
            ILocaleString addSignNodeName = BPMNUtil.getAddSignNodeName(executionEntity, currentElement);
            executionEntity.setActivityName(addSignNodeName);
        } else if (currentElement.isDynamic()) {
            List<HistoricDynamicResourceEntity> dnHiResEnt = commandContext.getHistoricDynamicResourceEntityManager().findByProcessInstanceId(executionEntity.getProcessInstanceId());
            ILocaleString name = BPMNUtil.handleDyElePtcName(dnHiResEnt, currentElement.getId());
            if (WfUtils.isEmptyForMap((Map)name)) {
                name = BpmnModelUtil.getMultiLangFieldValue(multiLangDatas, activityNameKey, currentElement.getName());
            }
            executionEntity.setActivityName(name);
        } else {
            ILocaleString cname = BpmnModelUtil.getMultiLangFieldValue(multiLangDatas, activityNameKey, currentElement.getName());
            logger.debug(String.format("\u6839\u636e%s,%s\u83b7\u53d6\u5230\u5f53\u524d\u8282\u70b9%s", activityNameKey, currentElement.getName(), cname));
            executionEntity.setActivityName(BpmnModelUtil.getMultiLangFieldValue(multiLangDatas, activityNameKey, currentElement.getName()));
        }
        executionMgr.update(executionEntity);
        logger.debug(String.format("\u6267\u884c\u5b9e\u4f8b%s\u8ba1\u7b97\u5f53\u524d\u8282\u70b9", executionEntity));
        ConcurrentDataUpdateUtil.updateActivityName(executionEntity, commandContext);
    }

    public static ILocaleString getAddSignNodeName(ExecutionEntity executionEntity, FlowElement currentElement) {
        LocaleString flowElementName = new LocaleString();
        Map addSignNames = (Map)executionEntity.getProcessInstance().getVariable("addsigninfonodename");
        if (addSignNames != null) {
            Object localeString = addSignNames.get(currentElement.getNumber());
            if (localeString instanceof LocaleString) {
                flowElementName = (LocaleString)localeString;
            } else if (localeString instanceof Map) {
                Map map = (Map)localeString;
                for (Lang lang : WfUtils.getSupportLangs()) {
                    String key = lang.name();
                    flowElementName.put(key, map.get(key));
                }
            }
        }
        return flowElementName;
    }

    public static ILocaleString subStringSubject(ILocaleString subject) {
        if (subject == null) {
            return subject;
        }
        for (String key : subject.keySet()) {
            subject.setItem(key, (Object)BPMNUtil.getInterceptedString((String)subject.get((Object)key), 1000));
        }
        return subject;
    }

    public static String getInterceptedString(String str, int maxLength) {
        if (str != null && str.length() > maxLength) {
            str = str.substring(0, maxLength);
        }
        return str;
    }

    public static void updateHitaskInstPresentAssignee(ExecutionEntity executionEntity, Map<String, Object> param) {
        ConcurrentDataUpdateUtil.updatePresentAssignee(executionEntity, Context.getCommandContext(), param);
    }

    public static ProcessDefinitionEntity findProcessDefinition(CommandContext commandContext, DynamicObject bill, String operation) {
        QFilter[] filters = new QFilter[]{new QFilter("businessKey", "=", (Object)String.valueOf(bill.getPkValue())), new QFilter("endTime", "is null", null)};
        Long procDefId = null;
        List procInsts = commandContext.getHistoricProcessInstanceEntityManager().findByQueryFilters(filters, "processDefinitionId", "CREATEDATE DESC");
        procDefId = !procInsts.isEmpty() ? ((HistoricProcessInstanceEntity)procInsts.get(0)).getProcessDefinitionId() : new AddressProcessCmd(operation, bill).execute(commandContext);
        if (WfUtils.isEmpty(procDefId)) {
            return null;
        }
        return (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(procDefId);
    }

    public static ProcessDefinitionEntity findProcessDefinition(CommandContext commandContext, String processNumber, String version) {
        ProcessDefinitionEntityManager procDefManager = commandContext.getProcessDefinitionEntityManager();
        EntityQueryBuilder queryBuilder = procDefManager.createQueryBuilder();
        queryBuilder.addFilter("key", processNumber);
        if (WfUtils.isNotEmpty(version)) {
            queryBuilder.addFilter("version", version);
        }
        queryBuilder.orderBy(String.format("%s DESC", "id"));
        List procDefs = procDefManager.findByQueryBuilder(queryBuilder);
        if (procDefs == null || procDefs.isEmpty()) {
            logger.warn(String.format("Cann't found the ProcessDefinition! %s %s", processNumber, version));
            return null;
        }
        return (ProcessDefinitionEntity)procDefs.get(0);
    }

    private static ILocaleString handleDyElePtcName(List<HistoricDynamicResourceEntity> dnHiResEnt, String currentElementId) {
        return (ILocaleString)dnHiResEnt.stream().filter(t -> Optional.ofNullable(t.getContent().getLocaleValue()).filter(val -> StringUtils.contains((CharSequence)val, (CharSequence)"EndNoneEvent") || StringUtils.contains((CharSequence)val, (CharSequence)"EndTerminateEvent")).isPresent()).flatMap(r -> r.getContent().entrySet().stream().flatMap(t -> ProcessDefinitionUtil.getBpmnModel((String)t.getValue()).getMainProcess().getFlowElementList().stream().filter(e -> Objects.equals(e.getId(), currentElementId)).limit(1L).map(e -> new AbstractMap.SimpleEntry(t.getKey(), e.getName())))).collect(LocaleString::new, (m, e) -> {
            String cfr_ignored_0 = (String)m.put((String)e.getKey(), e.getValue());
        }, LocaleValue::putAll);
    }
}

