/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.CompensateBackSet;
import kd.bos.workflow.bpmn.model.CompensateEventDefinition;
import kd.bos.workflow.bpmn.model.CompensateOperation;
import kd.bos.workflow.bpmn.model.CompensateTask;
import kd.bos.workflow.bpmn.model.EventDefinition;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.BpmnError;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.bpmn.helper.ScopeUtil;
import kd.bos.workflow.engine.impl.cmd.management.AbandonProcessCmd;
import kd.bos.workflow.engine.impl.cmd.management.BillBackOrProcessTerminateCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.BillRelationInfo;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.CompensateEventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExeConversionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionGroup;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;

public class BoundaryCompensationHelper {
    protected static Log logger = LogFactory.getLog(BoundaryCompensationHelper.class);

    public static boolean triggerCompensation(BpmnError error, DelegateExecution execution, CommandContext commandContext) {
        if (execution instanceof ExecutionEntity) {
            boolean triggerCompensation;
            CompensateBackSet backSet;
            ExecutionEntity e = (ExecutionEntity)execution;
            FlowElement ele = e.getCurrentFlowElement();
            ExecutionEntity superExecution = e.getSuperExecution();
            if (superExecution != null) {
                execution = superExecution;
                ele = superExecution.getCurrentFlowElement();
                backSet = BoundaryCompensationHelper.mapperBackNode(superExecution, ele.getId(), error.getErrorNumber());
            } else {
                backSet = BoundaryCompensationHelper.mapperBackNode(e, ele.getId(), error.getErrorNumber());
            }
            boolean bl = triggerCompensation = backSet != null;
            if (triggerCompensation) {
                HashMap<String, Object> passVars = new HashMap<String, Object>(16);
                String backNode = backSet.getBackNode();
                String errorOccurNode = execution.getCurrentFlowElement().getId();
                String errorCode = error.getErrorNumber();
                String exceMsg = (String)execution.getVariable("compensationErrorMessage");
                if (WfUtils.isNotEmpty(exceMsg)) {
                    execution.removeVariables(passVars.keySet());
                }
                logger.debug(String.format("\u8282\u70b9[%s]\u53d1\u751f\u5f02\u5e38[%s],\u5f53\u524d\u6267\u884c\u5b9e\u4f8b[%s],\u7236\u6d41\u7a0b[%s],\u56de\u9000\u8282\u70b9[%s],\u5f02\u5e38\u4fe1\u606f[%s]", errorOccurNode, errorCode, execution, superExecution, backNode, WfUtils.getExceptionStacktrace((Throwable)((Object)error))));
                if (superExecution != null) {
                    ILocaleString cause = WfUtils.getPromptWordLocaleString("\u8865\u507f\u7ec8\u6b62", "BoundaryCompensationHelper_0", "bos-wf-engine");
                    commandContext.getAgenda().planAbandonProcessOperation(e, cause, "compensationAbort", null);
                    superExecution.setVariable("enterBdyCompensateErrorCode", error.getErrorNumber());
                    superExecution.setVariable("compensationErrorMessage", exceMsg);
                } else {
                    passVars.put("triggerCompensationExecuteExe", execution.getId());
                    passVars.put("compensationErrorCode", errorCode);
                    passVars.put("BACKSETNODE", backNode);
                    passVars.put("compensationErrorMessage", WfUtils.getExceptionStacktrace((Throwable)((Object)error)));
                    passVars.put("triggerCompensationNode", errorOccurNode);
                    ArrayList<String> errorPks = new ArrayList<String>(4);
                    errorPks.add(e.getBusinessKey());
                    BoundaryCompensationHelper.executeCompensationStepBySetp((FlowNode)ele, (ExecutionEntity)execution, errorPks, errorCode, backNode, errorOccurNode, true, passVars);
                }
                return true;
            }
        }
        return false;
    }

    private static CompensateBackSet mapperBackNode(ExecutionEntity e, String eleId, String code) {
        Process process = ProcessDefinitionUtil.getProcessByProcInstId(e.getProcessInstanceId());
        List<BoundaryEvent> boundaryEvents = process.findFlowElementsOfType(BoundaryEvent.class, true);
        for (BoundaryEvent event : boundaryEvents) {
            if (!event.getAttachedToRefId().equals(eleId)) continue;
            List<EventDefinition> eventDefs = event.getEventDefinitions();
            for (EventDefinition eds : eventDefs) {
                List<CompensateBackSet> backSets;
                if (!(eds instanceof CompensateEventDefinition) || (backSets = ((CompensateEventDefinition)eds).getBackSet()) == null) continue;
                for (CompensateBackSet bs : backSets) {
                    if (!bs.getErrorCode().equals(code)) continue;
                    return bs;
                }
            }
        }
        return null;
    }

    public static void executeCompensationStepBySetp(FlowNode curExecuteNode, ExecutionEntity execution, List<String> errorBizPks, String errorCode, String backNode, String errorOccurNode, boolean firstTrigger, Map<String, Object> passVars) {
        logger.debug(String.format("\u5bfb\u627e\u8865\u507f\u4e8b\u4ef6\uff1a\u5f53\u524d\u8282\u70b9[%s]\uff0c\u8fdb\u5165execution[%s]\uff0c\u9519\u8bef\u5355\u636e[%s]\uff0c\u56de\u9000\u8282\u70b9[%s]\uff0c\u9519\u8bef\u53d1\u751f\u8282\u70b9[%s]", curExecuteNode.getId(), execution, WfUtils.listToString(errorBizPks, ","), backNode, firstTrigger));
        Map<FlowNode, FlowNode> compensateNodesPair = BoundaryCompensationHelper.getCompensateNodesPair(curExecuteNode, execution, errorCode, backNode, firstTrigger);
        ExecutionEntityManager executionMgr = Context.getCommandContext().getExecutionEntityManager();
        boolean compensated = false;
        if (!compensateNodesPair.isEmpty()) {
            EventSubscriptionEntityManager eventSubMgr = Context.getCommandContext().getEventSubscriptionEntityManager();
            for (Map.Entry<FlowNode, FlowNode> compensatePair : compensateNodesPair.entrySet()) {
                CompensateTask nextCt;
                String ctEntityNumber;
                FlowNode continueMainNode = compensatePair.getKey();
                logger.debug(String.format("\u8865\u507f\u8def\u5f84[%s-%s]", continueMainNode.getId(), compensatePair.getValue().getId()));
                List<CompensateEventSubscriptionEntity> allCompensates = eventSubMgr.findCompensateEventSubscriptionsByProcessInstanceIdAndActivityId(execution.getProcessInstanceId(), compensatePair.getValue().getId());
                if (allCompensates.isEmpty()) continue;
                List<String> pks = errorBizPks;
                if (!continueMainNode.getId().equals(curExecuteNode.getId())) {
                    pks = Context.getCommandContext().getExeConversionEntityManager().getSourceBusinesskeys(errorBizPks, continueMainNode.getId(), curExecuteNode.getId(), execution.getProcessInstanceId());
                    logger.debug(String.format("\u83b7\u53d6\u76ee\u6807\u8282\u70b9[%s]\u7684\u5355\u636e[%s]", continueMainNode.getId(), WfUtils.listToString(pks, ",")));
                }
                if (!firstTrigger && pks.equals(errorBizPks) && !(ctEntityNumber = MetadataDao.getNumberById((String)(nextCt = (CompensateTask)compensatePair.getValue()).getEntityId())).equals(execution.getEntityNumber())) {
                    backNode = curExecuteNode.getId();
                    break;
                }
                Iterator<CompensateEventSubscriptionEntity> iter = allCompensates.iterator();
                while (iter.hasNext()) {
                    CompensateEventSubscriptionEntity ces = iter.next();
                    if (pks.contains(ces.getBusinesskey())) continue;
                    iter.remove();
                }
                if (allCompensates.isEmpty()) continue;
                logger.debug("\u627e\u5230\u8865\u507f\u4e8b\u4ef6");
                ScopeUtil.throwCompensationEvent(allCompensates, execution, false, passVars);
                compensated = true;
                break;
            }
        }
        if (firstTrigger) {
            logger.debug(String.format("\u5f02\u5e38\u53d1\u751f\u8282\u70b9\u5728\u672c\u8282\u70b9\u7684\u8865\u507f\u66f4\u65b0\u5f53\u524d\u5355\u636e\u5b9e\u4f8b\u6e05\u7406\u548c\u5173\u95ed\u3002[%s]", execution));
            Context.getCommandContext().getHistoryManager().recordActivityEnd(execution, "compensation delete");
            execution.getParent().setActive(false);
            executionMgr.update(execution.getParent());
            List<ExecutionEntity> childExecutions = executionMgr.findChildExecutionsByParentExecutionId(execution.getId());
            for (ExecutionEntity childExecution : childExecutions) {
                executionMgr.deleteExecutionAndRelatedData(childExecution, null, false);
            }
            execution.setActive(false);
            executionMgr.update(execution);
            executionMgr.deleteDataForExecution(execution, "compensation delete", false, false);
        } else if (!WfUtils.exist(execution.getEntityNumber(), (Object)execution.getBusinessKey())) {
            Context.getCommandContext().getCirculateRelationEntityManager().deleteByFilters(new QFilter[]{new QFilter("businesskey", "=", (Object)execution.getBusinessKey())});
        }
        if (!compensated) {
            Long triggerErrorExeId = (Long)execution.getVariable("triggerCompensationExecuteExe");
            ExecutionEntity errorOccurExe = (ExecutionEntity)executionMgr.findById(triggerErrorExeId);
            if (firstTrigger && errorOccurExe == null) {
                errorOccurExe = execution;
            }
            List<String> stopPks = new ArrayList<String>();
            stopPks.add(errorOccurExe.getBusinessKey());
            if (!backNode.equals(errorOccurNode)) {
                stopPks = Context.getCommandContext().getExeConversionEntityManager().getSourceBusinesskeys(stopPks, backNode, errorOccurNode, execution.getProcessInstanceId());
            }
            logger.debug(String.format("\u8865\u507f\u7ed3\u675f\uff0c\u7ed3\u675f\u5f53\u524d\u8865\u507f\uff1b\u56de\u9000\u8282\u70b9\u5355\u636e[%s]", WfUtils.listToString(stopPks, ",")));
            if (stopPks.isEmpty()) {
                logger.debug(String.format("\u9519\u8bef\u53d1\u751f\u8282\u70b9%s,\u56de\u9000\u8282\u70b9%s,\u9519\u8bef\u53d1\u751f\u5b9e\u4f8b%s", errorOccurNode, backNode, triggerErrorExeId));
                throw new WFException(WFErrorCode.compensateError(), ResManager.loadKDString((String)"\u8865\u507f\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u56de\u9000\u8282\u70b9\u5bf9\u5e94\u7684\u5355\u636e\u3002", (String)"BoundaryCompensationHelper_2", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            FlowNode backNodeEle = (FlowNode)ProcessDefinitionUtil.getFlowElement(execution.getProcessDefinitionId(), execution.getProcessInstanceId(), backNode);
            BoundaryCompensationHelper.endCompensation(execution, backNodeEle, stopPks);
        }
        BPMNUtil.updateExecutionActivityName(execution);
    }

    private static Map<FlowNode, FlowNode> getCompensateNodesPair(FlowNode curExecuteNode, ExecutionEntity execution, String errorCode, String backNode, boolean firstTrigger) {
        LinkedHashMap<FlowNode, FlowNode> compensateNodesPair = new LinkedHashMap<FlowNode, FlowNode>(16);
        ArrayList<FlowElement> preNodes = new ArrayList<FlowElement>(16);
        if (firstTrigger) {
            preNodes.add(curExecuteNode);
        } else if (curExecuteNode.getId().equals(backNode)) {
            return compensateNodesPair;
        }
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
        preNodes.addAll(BpmnModelUtil.getPreviousNodes(bpmnModel, curExecuteNode.getId()));
        LinkedHashMap<String, BoundaryEvent> attachedNodes = bpmnModel.getMainProcess().getCompensateBoundaryAttachedNodes();
        BoundaryEvent event = null;
        for (FlowElement e : preNodes) {
            CompensateTask ctask;
            List<CompensateOperation> operations;
            List<SequenceFlow> outgoingFlows;
            event = (BoundaryEvent)attachedNodes.get(e.getId());
            if (event != null && !event.getEventDefinitions().isEmpty() && (outgoingFlows = event.getOutgoingFlows()) != null && !outgoingFlows.isEmpty() && outgoingFlows.get(0).getTargetFlowElement() instanceof CompensateTask && (operations = (ctask = (CompensateTask)outgoingFlows.get(0).getTargetFlowElement()).getOperations()) != null) {
                for (CompensateOperation operation : operations) {
                    if (operation == null || !errorCode.equals(operation.getErrorCode())) continue;
                    compensateNodesPair.put((FlowNode)e, ctask);
                    break;
                }
            }
            if (!e.getId().equals(backNode)) continue;
            break;
        }
        return compensateNodesPair;
    }

    public static void dealCompensateNodeEnd(ExecutionEntity execution, FlowElement compensateTask) {
        String compensateBizPksStr = (String)execution.getVariableLocal("batchCompensateBusinesskey");
        execution.removeVariable("batchCompensateBusinesskey");
        logger.debug("compensateBizPksStr : " + compensateBizPksStr + "|| execution:" + execution.getId());
        List<String> errorBizPks = Arrays.asList(compensateBizPksStr.split("\\,"));
        BoundaryCompensationHelper.deleteEvtSubsAndJudgeCompensate(execution, compensateTask, errorBizPks);
        FlowNode node = (FlowNode)compensateTask;
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(execution.getProcessInstanceId());
        LinkedHashMap<String, FlowNode> continueNodeAttachedCompensateNode = bpmnModel.getMainProcess().getCompensateNodeAttachedNodes();
        FlowNode curExecuteNode = null;
        for (Map.Entry entry : continueNodeAttachedCompensateNode.entrySet()) {
            if (!((FlowNode)entry.getValue()).getId().equals(compensateTask.getId())) continue;
            curExecuteNode = (FlowNode)bpmnModel.getFlowElement((String)entry.getKey());
            break;
        }
        if (curExecuteNode == null) {
            throw new WFException(WFErrorCode.compensateError(), String.format(WfUtils.getPromptWordLocaleString("\u5173\u8054\u8865\u507f\u8282\u70b9%s\u7684\u6b63\u5411\u8282\u70b9\u6ca1\u627e\u5230\uff01", "BoundaryCompensationHelper_1", "bos-wf-engine").getLocaleValue(), node.getName()));
        }
        String backNode = (String)execution.getVariableLocal("BACKSETNODE");
        String errorCode = (String)execution.getVariableLocal("compensationErrorCode");
        String errorOccurNode = (String)execution.getVariableLocal("triggerCompensationNode");
        String compensationErrorMessage = (String)execution.getVariableLocal("compensationErrorMessage");
        Object triggerCompensationExecuteExe = execution.getVariableLocal("triggerCompensationExecuteExe");
        HashMap<String, Object> passVars = new HashMap<String, Object>();
        passVars.put("triggerCompensationExecuteExe", triggerCompensationExecuteExe);
        passVars.put("compensationErrorCode", errorCode);
        passVars.put("BACKSETNODE", backNode);
        passVars.put("compensationErrorMessage", compensationErrorMessage);
        passVars.put("triggerCompensationNode", errorOccurNode);
        BoundaryCompensationHelper.executeCompensationStepBySetp(curExecuteNode, execution, errorBizPks, errorCode, backNode, errorOccurNode, false, passVars);
    }

    private static boolean deleteEvtSubsAndJudgeCompensate(ExecutionEntity execution, FlowElement currentFlowElement, List<String> compensatePks) {
        boolean continueCompensate = true;
        String evtSubIds = (String)execution.getVariable("batchCompensateEventSubsId");
        EventSubscriptionEntityManager eseMgr = Context.getCommandContext().getEventSubscriptionEntityManager();
        if (BpmnModelUtil.instanceofUserTask(currentFlowElement.getType())) {
            List<EventSubscriptionEntity> activeEvtSubs = eseMgr.findCompensateEventSubscriptionsByProcessInstanceIdPksAndActivityId(execution.getProcessInstanceId(), compensatePks, currentFlowElement.getId());
            continueCompensate = activeEvtSubs.size() == 1;
            for (EventSubscriptionEntity evsb : activeEvtSubs) {
                if (!evsb.getBusinesskey().equals(execution.getBusinessKey())) continue;
                eseMgr.delete(evsb);
                break;
            }
        } else {
            String[] evtIds = evtSubIds.split("\\,");
            for (int i = 0; i < evtIds.length; ++i) {
                eseMgr.delete(Long.valueOf(evtIds[i]));
            }
        }
        return continueCompensate;
    }

    public static void endCompensation(ExecutionEntity execution, FlowNode backNode, List<String> stopPks) {
        CommandContext commandContext = Context.getCommandContext();
        List<ExeConversionEntity> conversions = Context.getCommandContext().getExeConversionEntityManager().findExecByTagBusinesskey(new HashSet<String>(stopPks));
        HashMap<String, BillRelationInfo> billInfos = new HashMap<String, BillRelationInfo>();
        for (ExeConversionEntity conversion : conversions) {
            String pk = conversion.getTagBusinesskey();
            BillRelationInfo info = (BillRelationInfo)billInfos.get(pk);
            if (info == null) {
                info = new BillRelationInfo();
                info.setBusinesskey(pk);
                info.setEntityNumber(conversion.getTagEntityNumber());
                billInfos.put(pk, info);
            }
            info.setSrcBill(conversion.getSrcEntityNumber(), conversion.getSrcBusinesskey());
        }
        logger.debug(String.format("\u5355\u636e\u5173\u7cfb%s", WfUtils.mapToString(billInfos)));
        ExecutionEntityManager executionMgr = commandContext.getExecutionEntityManager();
        Long procInstId = execution.getProcessInstanceId();
        Map<String, ExecutionGroup> exectionGroups = BoundaryCompensationHelper.getAllExecutionInfos(procInstId, commandContext);
        ArrayList<ExecutionGroup> pkExistedExes = new ArrayList<ExecutionGroup>();
        ArrayList<ExecutionGroup> pkNotExistedExes = new ArrayList<ExecutionGroup>();
        ArrayList<ExecutionGroup> noSrcAndNotExitedExes = new ArrayList<ExecutionGroup>();
        HashSet<Long> deleteBillExecs = new HashSet<Long>();
        for (ExecutionGroup exeGroup : exectionGroups.values()) {
            String businesskey = exeGroup.getBusiensskey();
            boolean exsit = WfUtils.exist(exeGroup.getEntityNumber(), (Object)businesskey);
            if (!exsit) {
                logger.debug(String.format("\u5220\u9664%s\u7684\u4e0a\u4e0b\u6e38\u8ddf\u8e2a\u56fe\u548c\u5355\u636e\u5173\u7cfb", businesskey));
                BizFlowUtil.deleteBizRelationData(commandContext, businesskey);
                if (exeGroup.getBillExecution() != null && WfUtils.isNotEmpty(exeGroup.getBillExecution().getId())) {
                    deleteBillExecs.add(exeGroup.getBillExecution().getId());
                }
            }
            if (stopPks.contains(businesskey)) {
                if (exsit) {
                    logger.debug(String.format("\u6dfb\u52a0%s\u5230pkExistedExes", exeGroup));
                    pkExistedExes.add(exeGroup);
                    continue;
                }
                BillRelationInfo info = (BillRelationInfo)billInfos.get(businesskey);
                if (info != null && !info.getSrcBills().isEmpty()) {
                    for (String spk : info.getSrcBills().keySet()) {
                        ExecutionGroup group = exectionGroups.get(spk);
                        if (pkNotExistedExes.contains(group)) continue;
                        pkNotExistedExes.add(group);
                        logger.debug(String.format("\u6dfb\u52a0%s\u5230pkNotExistedExes", exeGroup));
                    }
                    continue;
                }
                noSrcAndNotExitedExes.add(exeGroup);
                logger.debug(String.format("\u5355\u636e[%s-%s-%s]\u6ca1\u6709\u6e90\u5355", exeGroup.getEntityNumber(), businesskey, exeGroup.getBillExecution()));
                continue;
            }
            if (!exeGroup.isActivie() || exsit) continue;
            List<ExecutionEntity> executeExes = exeGroup.getExecuteExecutions();
            for (ExecutionEntity executeExe : executeExes) {
                ExecutionEntity boundaryExe;
                FlowElement currentNode = executeExe.getCurrentFlowElement();
                Long currentExeId = executeExe.getId();
                ILocaleString stopTips = WfUtils.getPromptWordLocaleString("\u8865\u507f\u7ec8\u6b62", "BoundaryCompensationHelper_0", "bos-wf-engine");
                if (currentNode instanceof CallActivity) {
                    List<ExecutionEntity> multiProcessExes = exeGroup.getMultiChildExecution();
                    if (multiProcessExes.isEmpty()) {
                        logger.debug(String.format("\u627e\u4e0d\u5230\u8282\u70b9\u201c%1$s\u201d\u6267\u884c\u5b9e\u4f8b\u201c%2$s\u201d\u7684\u5b50\u6d41\u7a0b\u591a\u5b9e\u4f8b\u3002", currentNode.getId(), currentExeId));
                    }
                    ExecutionEntity subProcessInst = null;
                    subProcessInst = executionMgr.findSubProcessInstanceBySuperExecutionId(multiProcessExes.get(0).getId());
                    if (subProcessInst == null) {
                        throw new WFException(WFErrorCode.billExceptionError(), String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8282\u70b9\u201c%1$s\u201d\u6267\u884c\u5b9e\u4f8b\u201c%2$s\u201d\u7684\u5b50\u6d41\u7a0b\u591a\u5b9e\u4f8b\u3002", (String)"BoundaryCompensationHelper_4", (String)"bos-wf-engine", (Object[])new Object[0]), currentNode.getId(), currentExeId));
                    }
                    logger.debug(String.format("\u7ec8\u6b62\u5b50\u6d41\u7a0b%s", subProcessInst.getProcessInstanceId()));
                    new AbandonProcessCmd(subProcessInst.getProcessInstanceId(), stopTips, "compensationAbort").execute(commandContext);
                    executeExe.setVariableLocal("billExceptionDelayHandle", currentNode.getId());
                    executeExe.setVariableLocal("exceptionScense", "terminate");
                    ExecutionEntity boundaryExe2 = exeGroup.getBoundaryExecution();
                    if (boundaryExe2 == null) continue;
                    commandContext.getExecutionEntityManager().delete(boundaryExe2);
                    continue;
                }
                if (!BpmnModelUtil.instanceofUserTask(currentNode.getType())) continue;
                ExecutionEntity subProcessExe = executionMgr.findSubProcessInstanceBySuperExecutionId(currentExeId);
                if (subProcessExe != null) {
                    logger.debug(String.format("\u7ec8\u6b62\u5355\u636e\u5b50\u6d41\u7a0b%s", subProcessExe.getProcessInstanceId()));
                    new AbandonProcessCmd(subProcessExe.getProcessInstanceId(), stopTips, "billExcepAbort").execute(commandContext);
                    executeExe.setVariableLocal("billExceptionDelayHandle", currentNode.getId());
                    executeExe.setVariableLocal("exceptionScense", "terminate");
                }
                if ((boundaryExe = exeGroup.getBoundaryExecution()) != null) {
                    commandContext.getExecutionEntityManager().delete(boundaryExe);
                }
                BoundaryCompensationHelper.commonEndCurrentExecution(commandContext, executeExe, "cancel");
            }
        }
        if (!noSrcAndNotExitedExes.isEmpty()) {
            for (ExecutionGroup exeGroup : noSrcAndNotExitedExes) {
                ExecutionEntity billExecution = exeGroup.getBillExecution();
                if (!billExecution.isActive()) {
                    billExecution.setActive(true);
                    for (ExecutionEntity e : exeGroup.getExecuteExecutions()) {
                        e.setActive(true);
                    }
                }
                new BillBackOrProcessTerminateCmd(billExecution, billExecution.getEntityNumber(), WfUtils.getPromptWordLocaleString("\u8865\u507f\u7ec8\u6b62", "BoundaryCompensationHelper_0", "bos-wf-engine"), "terminate").execute(commandContext);
            }
        }
        logger.debug("\u751f\u6210\u5f02\u5e38job");
        BoundaryCompensationHelper.createDeadletterJob(execution, backNode, commandContext, procInstId, pkExistedExes, "async-continuation");
        BoundaryCompensationHelper.createDeadletterJob(execution, backNode, commandContext, procInstId, pkNotExistedExes, "async-executionConversion");
        if (!deleteBillExecs.isEmpty()) {
            for (Long id : deleteBillExecs) {
                commandContext.getExecutionEntityManager().deleteChildrenExecutions(id);
                commandContext.getExecutionEntityManager().delete(id);
            }
            logger.debug(String.format("\u5220\u9664[%s]\u5355\u636e\u5b9e\u4f8b\u4ee5\u53ca\u5bf9\u5e94\u7684\u5b50\u6267\u884c\u5b9e\u4f8b.", WfUtils.listToString(deleteBillExecs, ",")));
        }
    }

    private static void createDeadletterJob(ExecutionEntity execution, FlowNode backNode, CommandContext commandContext, Long procInstId, List<ExecutionGroup> pkExistedExes, String jobType) {
        for (ExecutionGroup group : pkExistedExes) {
            JobEntity job;
            Object instans;
            List<SequenceFlow> inFlows;
            List<ExecutionEntity> executeExecutions = group.getExecuteExecutions();
            ExecutionEntity destExe = null;
            if (executeExecutions.size() == 1) {
                destExe = executeExecutions.get(0);
            } else if (executeExecutions.size() > 1) {
                destExe = executeExecutions.get(0);
                List<HistoricActivityInstanceEntity> actInsts = commandContext.getHistoricActivityInstanceEntityManager().findByActivityIdByProcInstIdAndActivityIdAndBusinessKey(procInstId, backNode.getId(), group.getBusiensskey());
                for (ExecutionEntity e : executeExecutions) {
                    boolean flag = false;
                    for (HistoricActivityInstanceEntity inst : actInsts) {
                        if (!inst.getExecutionId().equals(e.getId())) continue;
                        flag = true;
                        destExe = e;
                        break;
                    }
                    if (!flag) continue;
                    break;
                }
            } else {
                logger.debug("\u6ca1\u6709\u6267\u884c\u5b9e\u4f8b");
                continue;
            }
            destExe.setActive(true);
            destExe.setActivityId(backNode.getId());
            Long currentActinstId = destExe.getCurrentActInstId();
            if (WfUtils.isNotEmpty(currentActinstId) && !(inFlows = backNode.getIncomingFlows()).isEmpty() && !(instans = commandContext.getHistoricActivityInstanceEntityManager().findByActivityIdByProcInstIdAndActivityIdAndBusinessKey(procInstId, inFlows.get(0).getId(), group.getBusiensskey())).isEmpty()) {
                destExe.setCurrentActInstId(((HistoricActivityInstanceEntity)instans.get(0)).getId());
            }
            Set<String> names = destExe.getVariableNamesLocal();
            instans = names.iterator();
            while (instans.hasNext()) {
                Object val;
                String vname = instans.next();
                if (!vname.contains("conversionTask") || "true".equals(String.valueOf(val = destExe.getVariableLocal(vname)))) continue;
                destExe.removeVariableLocal(vname);
            }
            commandContext.getExecutionEntityManager().update(destExe);
            String errorCode = (String)execution.getVariableLocal("compensationErrorCode");
            QFilter procFilter = new QFilter("executionId", "=", (Object)destExe.getId());
            QFilter pkFilter = new QFilter("businessKey", "=", (Object)destExe.getBusinessKey());
            QFilter typeFilter = new QFilter("jobHandlerType", "=", (Object)jobType);
            QFilter eleFilter = new QFilter("elementId", "=", (Object)backNode.getId());
            QFilter errorCodeFilter = new QFilter("errorCode", "=", (Object)errorCode);
            if (commandContext.getDeadLetterJobEntityManager().exist(new QFilter[]{procFilter, pkFilter, typeFilter, eleFilter, errorCodeFilter})) {
                logger.debug(String.format("\u5f02\u5e38\u6d88\u606f%s-%s-%s-%s-%s", destExe.getId(), destExe.getBusinessKey(), jobType, backNode.getId(), errorCode));
                return;
            }
            if ("async-continuation".equals(jobType)) {
                job = commandContext.getJobManager().createAsyncContinuationJob(destExe, backNode.isExclusive());
            } else {
                List<SequenceFlow> inFlows2 = backNode.getIncomingFlows();
                SequenceFlow incomingFlow = inFlows2.get(0);
                for (SequenceFlow flow : inFlows2) {
                    List<HistoricActivityInstanceEntity> instans2 = commandContext.getHistoricActivityInstanceEntityManager().findByActivityIdByProcInstIdAndActivityIdAndBusinessKey(procInstId, flow.getId(), group.getBusiensskey());
                    if (instans2.isEmpty()) continue;
                    incomingFlow = flow;
                    break;
                }
                job = commandContext.getJobManager().createAsyncExecutionConversionJob(destExe, incomingFlow);
            }
            DeadLetterJobEntity deadLetterJob = commandContext.getJobManager().moveJobToDeadLetterJob(job, null);
            deadLetterJob.setErrorCode(errorCode);
            String exceptionMessage = (String)execution.getVariableLocal("compensationErrorMessage");
            deadLetterJob.setExceptionMessage(exceptionMessage);
            deadLetterJob.setExceptionStackMessage(exceptionMessage);
        }
    }

    private static void commonEndCurrentExecution(CommandContext commandContext, ExecutionEntity executeExe, String executionType) {
        Long procInstId = executeExe.getProcessInstanceId();
        Long currentExeId = executeExe.getId();
        FlowElement currentNode = executeExe.getCurrentFlowElement();
        Long taskId = executeExe.getCurrentTaskId();
        if (WfUtils.isNotEmpty(taskId)) {
            logger.debug(String.format("\u5220\u9664\u4efb\u52a1%s\u548c\u4ee3\u529e", taskId));
            commandContext.getTaskHelper().deleteTask(taskId, "billExcepAbort", false);
            BizFlowUtil.deleteToDoMsg(commandContext, taskId);
        } else {
            logger.debug(String.format("\u8fd9\u79cd\u60c5\u51b5\u4e00\u5b9a\u8981\u8bb0\u5f55!exec:[%s]", executeExe.getId()));
        }
        HistoricActivityInstanceEntity currentActInst = BizFlowUtil.makeEndActInst(commandContext, executeExe, executionType);
        commandContext.getDeadLetterJobEntityManager().deleteByFilters(new QFilter[]{new QFilter("executionId", "=", (Object)currentExeId)});
        logger.debug("\u5220\u9664job\uff0ctimerjob\uff0c\u4e8b\u4ef6\u8ba2\u9605\uff0c\u5f02\u5e38\u4fe1\u606f\u8868");
        QFilter exeQf = new QFilter("executionId", "=", (Object)currentActInst.getExecutionId());
        QFilter actQf = new QFilter("elementId", "=", (Object)currentActInst.getActivityId());
        commandContext.getJobEntityManager().deleteByFilters(new QFilter[]{exeQf, actQf});
        commandContext.getTimerJobEntityManager().deleteByFilters(new QFilter[]{exeQf, actQf});
        commandContext.getEventSubscriptionEntityManager().deleteByFilters(new QFilter[]{new QFilter("processDefinitionId", "=", (Object)procInstId).and("executionId", "=", (Object)currentExeId).and("activityId", "=", (Object)currentNode.getId())});
    }

    public static Map<String, ExecutionGroup> getAllExecutionInfos(Long procInstId, CommandContext commandContext) {
        HashMap<String, ExecutionGroup> executionInfos = new HashMap<String, ExecutionGroup>();
        List<ExecutionEntity> allExecutions = commandContext.getExecutionEntityManager().findChildExecutionsByProcessInstanceId(procInstId);
        ExecutionEntity proInstance = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(procInstId);
        Process process = ProcessDefinitionUtil.getProcessByProcInstId(procInstId);
        for (ExecutionEntity e : allExecutions) {
            ExecutionGroup eg;
            if (e.getId().equals(e.getProcessInstanceId())) continue;
            String pk = e.getBusinessKey();
            ExecutionGroup cachedEg = executionInfos.putIfAbsent(pk, eg = new ExecutionGroup());
            if (cachedEg == null) {
                eg.setProcInstance(proInstance);
            } else {
                eg = cachedEg;
            }
            if (e.isBillExecution()) {
                eg.setBillExecution(e);
                eg.setEntityNumber(e.getEntityNumber());
                continue;
            }
            FlowElement ele = process.getFlowElement(e.getActivityId());
            if (ele instanceof BoundaryEvent) {
                eg.setBoundaryExecution(e);
                continue;
            }
            if (ele instanceof Activity && ((Activity)ele).isForCompensation()) {
                eg.setBoundaryExecution(e);
                continue;
            }
            if (e.isMultiInstanceRoot()) {
                eg.setExecuteExecution(e);
                continue;
            }
            if (eg.getBillExecution() != null && e.getId().equals(eg.getBillExecution().getId())) {
                eg.setExecuteExecution(e);
                continue;
            }
            if (e.getParent().isBillExecution()) {
                eg.setExecuteExecution(e);
                continue;
            }
            eg.setMultiChildExecution(e);
        }
        return executionInfos;
    }
}

