/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.helper;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.api.ExecutionListener;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.MapExceptionEntry;
import kd.bos.workflow.bpmn.model.Task;
import kd.bos.workflow.engine.delegate.BpmnError;
import kd.bos.workflow.engine.delegate.CustomPropertiesResolver;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.DelegateTask;
import kd.bos.workflow.engine.delegate.Expression;
import kd.bos.workflow.engine.delegate.JavaDelegate;
import kd.bos.workflow.engine.delegate.TaskListener;
import kd.bos.workflow.engine.delegate.TransactionDependentExecutionListener;
import kd.bos.workflow.engine.delegate.TransactionDependentTaskListener;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.enumeration.TaskListenerInvocationType;
import kd.bos.workflow.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.helper.ErrorPropagation;
import kd.bos.workflow.engine.impl.bpmn.helper.SkipExpressionUtil;
import kd.bos.workflow.engine.impl.bpmn.parser.FieldDeclaration;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.delegate.ActivityBehavior;
import kd.bos.workflow.engine.impl.delegate.SubProcessActivityBehavior;
import kd.bos.workflow.engine.impl.delegate.TriggerableActivityBehavior;
import kd.bos.workflow.engine.impl.delegate.invocation.ExecutionListenerInvocation;
import kd.bos.workflow.engine.impl.delegate.invocation.TaskListenerInvocation;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ReflectUtil;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFBizException;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class ClassDelegate
extends AbstractBpmnActivityBehavior
implements TaskListener,
ExecutionListener,
TransactionDependentExecutionListener,
TransactionDependentTaskListener,
SubProcessActivityBehavior,
CustomPropertiesResolver {
    private static final String ON_CLASS = "' on class ";
    private static final String INSTANCE = " instance";
    private static final String DOESN_T_IMPLEMENT = " doesn't implement ";
    private static final long serialVersionUID = 1L;
    protected String serviceTaskId;
    protected String className;
    protected List<FieldDeclaration> fieldDeclarations;
    protected ExecutionListener executionListenerInstance;
    protected TransactionDependentExecutionListener transactionDependentExecutionListenerInstance;
    protected TaskListener taskListenerInstance;
    protected TransactionDependentTaskListener transactionDependentTaskListenerInstance;
    protected ActivityBehavior activityBehaviorInstance;
    protected Expression skipExpression;
    protected List<MapExceptionEntry> mapExceptions;
    protected CustomPropertiesResolver customPropertiesResolverInstance;

    public ClassDelegate(String className, List<FieldDeclaration> fieldDeclarations, Expression skipExpression) {
        this.className = className;
        this.fieldDeclarations = fieldDeclarations;
        this.skipExpression = skipExpression;
    }

    public ClassDelegate(String id, String className, List<FieldDeclaration> fieldDeclarations, Expression skipExpression, List<MapExceptionEntry> mapExceptions) {
        this(className, fieldDeclarations, skipExpression);
        this.serviceTaskId = id;
        this.mapExceptions = mapExceptions;
    }

    public ClassDelegate(String className, List<FieldDeclaration> fieldDeclarations) {
        this(className, fieldDeclarations, null);
    }

    public ClassDelegate(Class<?> clazz, List<FieldDeclaration> fieldDeclarations) {
        this(clazz.getName(), fieldDeclarations, null);
    }

    public ClassDelegate(Class<?> clazz, List<FieldDeclaration> fieldDeclarations, Expression skipExpression) {
        this(clazz.getName(), fieldDeclarations, skipExpression);
    }

    public void notify(AgentExecution execution) {
        String bizClass = null;
        try {
            if (this.executionListenerInstance == null) {
                this.executionListenerInstance = this.getExecutionListenerInstance();
            }
            bizClass = this.executionListenerInstance.getClass().getName();
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ExecutionListenerInvocation(this.executionListenerInstance, (DelegateExecution)execution, false));
            if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                boolean inner;
                DelegateExecution delegateExecution = (DelegateExecution)execution;
                boolean bl = inner = bizClass.indexOf("kd.bos.workflow") > -1;
                if (!inner) {
                    Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createBusinessExecuteEvent(ActivitiEventType.BUSINESS_EXECUTE_SUCCESS, delegateExecution.getId(), delegateExecution.getProcessInstanceId(), delegateExecution.getProcessDefinitionId(), delegateExecution.getCurrentTaskId(), delegateExecution.getBusinessKey(), bizClass, null, ""));
                }
            }
        }
        catch (KDBizException e) {
            throw ExceptionUtil.createBusinessException((DelegateExecution)execution, e, bizClass, WFErrorCode.businessBizOperationError());
        }
        catch (WFBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw ExceptionUtil.createBusinessException((DelegateExecution)execution, e, bizClass);
        }
    }

    public void notifyByWithdraw(AgentExecution execution) {
        if (this.executionListenerInstance == null) {
            this.executionListenerInstance = this.getExecutionListenerInstance();
        }
        Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ExecutionListenerInvocation(this.executionListenerInstance, (DelegateExecution)execution, true));
    }

    @Override
    public void notify(Long processInstanceId, Long executionId, FlowElement flowElement, Map<String, Object> executionVariables, Map<String, Object> customPropertiesMap) {
        if (this.transactionDependentExecutionListenerInstance == null) {
            this.transactionDependentExecutionListenerInstance = this.getTransactionDependentExecutionListenerInstance();
        }
        this.transactionDependentExecutionListenerInstance.notify(processInstanceId, executionId, flowElement, executionVariables, customPropertiesMap);
    }

    @Override
    public Map<String, Object> getCustomPropertiesMap(DelegateExecution execution) {
        if (this.customPropertiesResolverInstance == null) {
            this.customPropertiesResolverInstance = this.getCustomPropertiesResolverInstance();
        }
        return this.customPropertiesResolverInstance.getCustomPropertiesMap(execution);
    }

    @Override
    public void notify(AgentTask delegateTask) {
        if (this.taskListenerInstance == null) {
            this.taskListenerInstance = this.getTaskListenerInstance();
        }
        try {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation(this.taskListenerInstance, (DelegateTask)delegateTask, TaskListenerInvocationType.NOTWITHDRAW));
        }
        catch (WFEngineException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WFEngineException("Exception while invoking TaskListener: " + e.getMessage(), e);
        }
    }

    @Override
    public void notifyByWithdraw(AgentTask delegateTask) {
        if (this.taskListenerInstance == null) {
            this.taskListenerInstance = this.getTaskListenerInstance();
        }
        try {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation(this.taskListenerInstance, (DelegateTask)delegateTask, TaskListenerInvocationType.WITHDRAW));
        }
        catch (Exception e) {
            throw new WFEngineException("Exception while invoking withdraw TaskListener: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean canWithdraw(AgentTask delegateTask) {
        if (this.taskListenerInstance == null) {
            this.taskListenerInstance = this.getTaskListenerInstance();
        }
        try {
            return (Boolean)Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation(this.taskListenerInstance, (DelegateTask)delegateTask, TaskListenerInvocationType.CANWITHDRAW));
        }
        catch (Exception e) {
            throw new WFEngineException(e.getMessage(), e);
        }
    }

    @Override
    public void afterHandleTask(AgentTask task, String evtName, Map<String, Object> executeParam) {
        if (this.taskListenerInstance == null) {
            this.taskListenerInstance = this.getTaskListenerInstance();
        }
        try {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation(this.taskListenerInstance, (DelegateTask)task, evtName, executeParam, TaskListenerInvocationType.AFTERCREATE));
        }
        catch (WFEngineException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WFEngineException("Exception while invoking TaskListener: " + e.getMessage(), e);
        }
    }

    @Override
    public void notify(Long processInstanceId, Long executionId, Task task, Map<String, Object> executionVariables, Map<String, Object> customPropertiesMap) {
        if (this.transactionDependentTaskListenerInstance == null) {
            this.transactionDependentTaskListenerInstance = this.getTransactionDependentTaskListenerInstance();
        }
        this.transactionDependentTaskListenerInstance.notify(processInstanceId, executionId, task, executionVariables, customPropertiesMap);
    }

    protected ExecutionListener getExecutionListenerInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof ExecutionListener) {
            return (ExecutionListener)delegateInstance;
        }
        throw new WFIllegalArgumentException(delegateInstance.getClass().getName() + DOESN_T_IMPLEMENT + ExecutionListener.class + " nor " + JavaDelegate.class);
    }

    protected TransactionDependentExecutionListener getTransactionDependentExecutionListenerInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof TransactionDependentExecutionListener) {
            return (TransactionDependentExecutionListener)delegateInstance;
        }
        throw new WFIllegalArgumentException(delegateInstance.getClass().getName() + DOESN_T_IMPLEMENT + TransactionDependentExecutionListener.class);
    }

    protected CustomPropertiesResolver getCustomPropertiesResolverInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof CustomPropertiesResolver) {
            return (CustomPropertiesResolver)delegateInstance;
        }
        throw new WFIllegalArgumentException(delegateInstance.getClass().getName() + DOESN_T_IMPLEMENT + CustomPropertiesResolver.class);
    }

    protected TaskListener getTaskListenerInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof TaskListener) {
            return (TaskListener)delegateInstance;
        }
        throw new WFIllegalArgumentException(delegateInstance.getClass().getName() + DOESN_T_IMPLEMENT + TaskListener.class);
    }

    protected TransactionDependentTaskListener getTransactionDependentTaskListenerInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof TransactionDependentTaskListener) {
            return (TransactionDependentTaskListener)delegateInstance;
        }
        throw new WFIllegalArgumentException(delegateInstance.getClass().getName() + DOESN_T_IMPLEMENT + TransactionDependentTaskListener.class);
    }

    @Override
    public void execute(DelegateExecution execution) {
        block5: {
            boolean isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled(execution, this.skipExpression);
            if (!isSkipExpressionEnabled || isSkipExpressionEnabled && !SkipExpressionUtil.shouldSkipFlowElement(execution, this.skipExpression)) {
                if (this.activityBehaviorInstance == null) {
                    this.activityBehaviorInstance = this.getActivityBehaviorInstance();
                }
                try {
                    this.activityBehaviorInstance.execute(execution);
                }
                catch (BpmnError error) {
                    ErrorPropagation.propagateError(error, execution, (Throwable)((Object)error));
                }
                catch (RuntimeException e) {
                    if (ErrorPropagation.mapException(e, (ExecutionEntity)execution, this.mapExceptions)) break block5;
                    throw e;
                }
            }
        }
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        if (this.activityBehaviorInstance == null) {
            this.activityBehaviorInstance = this.getActivityBehaviorInstance();
        }
        if (!(this.activityBehaviorInstance instanceof TriggerableActivityBehavior)) {
            throw new WFEngineException("signal() can only be called on a " + TriggerableActivityBehavior.class.getName() + INSTANCE);
        }
        ((TriggerableActivityBehavior)this.activityBehaviorInstance).trigger(execution, signalName, signalData);
    }

    @Override
    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) {
        try {
            if (this.activityBehaviorInstance == null) {
                this.activityBehaviorInstance = this.getActivityBehaviorInstance();
            }
            if (!(this.activityBehaviorInstance instanceof SubProcessActivityBehavior)) {
                throw new WFEngineException("completing() can only be called on a " + SubProcessActivityBehavior.class.getName() + INSTANCE);
            }
            ((SubProcessActivityBehavior)this.activityBehaviorInstance).completing(execution, subProcessInstance);
        }
        catch (Exception e) {
            throw new WFException(e.getMessage(), e);
        }
    }

    @Override
    public void completed(DelegateExecution execution) {
        try {
            if (this.activityBehaviorInstance == null) {
                this.activityBehaviorInstance = this.getActivityBehaviorInstance();
            }
            if (!(this.activityBehaviorInstance instanceof SubProcessActivityBehavior)) {
                throw new WFEngineException("completed() can only be called on a " + SubProcessActivityBehavior.class.getName() + INSTANCE);
            }
            ((SubProcessActivityBehavior)this.activityBehaviorInstance).completed(execution);
        }
        catch (Exception e) {
            throw new WFException(e.getMessage(), e);
        }
    }

    protected ActivityBehavior getActivityBehaviorInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof ActivityBehavior) {
            return this.determineBehaviour((ActivityBehavior)delegateInstance);
        }
        throw new WFIllegalArgumentException(delegateInstance.getClass().getName() + DOESN_T_IMPLEMENT + JavaDelegate.class.getName() + " nor " + ActivityBehavior.class.getName());
    }

    protected ActivityBehavior determineBehaviour(ActivityBehavior delegateInstance) {
        if (this.hasMultiInstanceCharacteristics()) {
            this.multiInstanceActivityBehavior.setInnerActivityBehavior((AbstractBpmnActivityBehavior)delegateInstance);
            return this.multiInstanceActivityBehavior;
        }
        return delegateInstance;
    }

    protected Object instantiateDelegate(String className, List<FieldDeclaration> fieldDeclarations) {
        return ClassDelegate.defaultInstantiateDelegate(className, fieldDeclarations);
    }

    public static Object defaultInstantiateDelegate(Class<?> clazz, List<FieldDeclaration> fieldDeclarations) {
        return ClassDelegate.defaultInstantiateDelegate(clazz.getName(), fieldDeclarations);
    }

    public static Object defaultInstantiateDelegate(String className, List<FieldDeclaration> fieldDeclarations) {
        Object object = ReflectUtil.instantiate(className);
        ClassDelegate.applyFieldDeclaration(fieldDeclarations, object);
        return object;
    }

    public static void applyFieldDeclaration(List<FieldDeclaration> fieldDeclarations, Object target) {
        ClassDelegate.applyFieldDeclaration(fieldDeclarations, target, true);
    }

    public static void applyFieldDeclaration(List<FieldDeclaration> fieldDeclarations, Object target, boolean throwExceptionOnMissingField) {
        if (fieldDeclarations != null) {
            for (FieldDeclaration declaration : fieldDeclarations) {
                ClassDelegate.applyFieldDeclaration(declaration, target, throwExceptionOnMissingField);
            }
        }
    }

    public static void applyFieldDeclaration(FieldDeclaration declaration, Object target) {
        ClassDelegate.applyFieldDeclaration(declaration, target, true);
    }

    public static void applyFieldDeclaration(FieldDeclaration declaration, Object target, boolean throwExceptionOnMissingField) {
        Method setterMethod = ReflectUtil.getSetter(declaration.getName(), target.getClass(), declaration.getValue().getClass());
        if (setterMethod != null) {
            try {
                setterMethod.invoke(target, declaration.getValue());
            }
            catch (IllegalArgumentException e) {
                throw new WFEngineException("Error while invoking '" + declaration.getName() + ON_CLASS + target.getClass().getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new WFEngineException("Illegal acces when calling '" + declaration.getName() + ON_CLASS + target.getClass().getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new WFEngineException("Exception while invoking '" + declaration.getName() + ON_CLASS + target.getClass().getName(), e);
            }
        } else {
            Field field = ReflectUtil.getField(declaration.getName(), target);
            if (field == null) {
                if (throwExceptionOnMissingField) {
                    throw new WFIllegalArgumentException("Field definition uses unexisting field '" + declaration.getName() + ON_CLASS + target.getClass().getName());
                }
                return;
            }
            if (!ClassDelegate.fieldTypeCompatible(declaration, field)) {
                throw new WFIllegalArgumentException("Incompatible type set on field declaration '" + declaration.getName() + "' for class " + target.getClass().getName() + ". Declared value has type " + declaration.getValue().getClass().getName() + ", while expecting " + field.getType().getName());
            }
            ReflectUtil.setField(field, target, declaration.getValue());
        }
    }

    public static boolean fieldTypeCompatible(FieldDeclaration declaration, Field field) {
        if (declaration.getValue() != null) {
            return field.getType().isAssignableFrom(declaration.getValue().getClass());
        }
        return true;
    }

    public String getClassName() {
        return this.className;
    }
}

