/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.ErrorEventDefinition;
import kd.bos.workflow.bpmn.model.Event;
import kd.bos.workflow.bpmn.model.EventSubProcess;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowElementsContainer;
import kd.bos.workflow.bpmn.model.MapExceptionEntry;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.BpmnError;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.bpmn.helper.BoundaryCompensationHelper;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.ReflectUtil;
import org.apache.commons.lang.StringUtils;

public class ErrorPropagation {
    protected static Log logger = LogFactory.getLog(ErrorPropagation.class);

    public static boolean propagateError(BpmnError error, DelegateExecution execution, Throwable e) {
        boolean ret;
        boolean bl = ret = ErrorPropagation.propagateError(error.getErrorNumber(), execution) || BoundaryCompensationHelper.triggerCompensation(error, execution, Context.getCommandContext());
        if (ret) {
            ExecutionEntity procInstance = ((ExecutionEntity)execution).getRootProcessInstance();
            if (e != null) {
                logger.debug(String.format("\u6267\u884c\u51fa\u73b0\u5f02\u5e38\uff0c\u8fdb\u5165\u8fb9\u754c\uff1aexception=%s", WfUtils.getExceptionStacktrace(e)));
                procInstance.setVariable("enterBdyErrorMessage", e.getMessage());
            }
            procInstance.setVariable("enterBdyErrorCode", error.getErrorNumber());
        }
        return ret;
    }

    public static boolean propagateError(String errorCode, DelegateExecution execution) {
        ExecutionEntityManager executionEntityManager;
        ExecutionEntity processInstanceExecution;
        boolean matchError = true;
        Map<String, List<Event>> eventMap = ErrorPropagation.findCatchingEventsForProcess(execution.getProcessDefinitionId(), execution.getProcessInstanceId(), errorCode);
        if (eventMap.size() > 0) {
            matchError = ErrorPropagation.executeCatch(eventMap, (ExecutionEntity)execution, errorCode);
        } else if (!execution.getProcessInstanceId().equals(execution.getRootProcessInstanceId()) && (processInstanceExecution = (ExecutionEntity)(executionEntityManager = Context.getCommandContext().getExecutionEntityManager()).findById(execution.getProcessInstanceId())) != null) {
            ExecutionEntity parentExecution = processInstanceExecution.getSuperExecution();
            HashSet<Long> toDeleteProcessInstanceIds = new HashSet<Long>();
            toDeleteProcessInstanceIds.add(execution.getProcessInstanceId());
            while (parentExecution != null && eventMap.size() == 0) {
                eventMap = ErrorPropagation.findCatchingEventsForProcess(parentExecution.getProcessDefinitionId(), execution.getProcessInstanceId(), errorCode);
                if (eventMap.size() > 0) {
                    for (Long processInstanceId : toDeleteProcessInstanceIds) {
                        ExecutionEntity processInstanceEntity = (ExecutionEntity)executionEntityManager.findById(processInstanceId);
                        executionEntityManager.deleteProcessInstanceExecutionEntity(processInstanceEntity.getId(), execution.getCurrentFlowElement() != null ? execution.getCurrentFlowElement().getId() : null, "ERROR_EVENT " + errorCode, false, false, false);
                        if (Context.getProcessEngineConfiguration() == null || !Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) continue;
                        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.PROCESS_COMPLETED_WITH_ERROR_END_EVENT, processInstanceEntity));
                    }
                    matchError = ErrorPropagation.executeCatch(eventMap, parentExecution, errorCode);
                    continue;
                }
                toDeleteProcessInstanceIds.add(parentExecution.getProcessInstanceId());
                ExecutionEntity superExecution = parentExecution.getSuperExecution();
                if (superExecution != null) {
                    parentExecution = superExecution;
                    continue;
                }
                if (!parentExecution.getId().equals(parentExecution.getRootProcessInstanceId())) {
                    parentExecution = parentExecution.getProcessInstance();
                    continue;
                }
                parentExecution = null;
            }
        }
        if (eventMap.size() == 0) {
            matchError = false;
            logger.debug("No catching boundary event found for error with errorCode '" + errorCode + "', neither in same process nor in parent process");
        }
        return matchError;
    }

    protected static boolean executeCatch(Map<String, List<Event>> eventMap, ExecutionEntity currentExecution, String errorId) {
        boolean matchError = true;
        Event matchingEvent = null;
        ExecutionEntity parentExecution = null;
        if (eventMap.containsKey(currentExecution.getActivityId())) {
            matchingEvent = eventMap.get(currentExecution.getActivityId()).get(0);
            parentExecution = currentExecution.getParentId() != null && currentExecution.getParent().isMultiInstanceRoot() ? currentExecution.getParent() : currentExecution;
        } else {
            parentExecution = currentExecution.getParent();
            while (matchingEvent == null && parentExecution != null) {
                FlowElementsContainer currentContainer = null;
                if (parentExecution.getCurrentFlowElement() instanceof FlowElementsContainer) {
                    currentContainer = (FlowElementsContainer)((Object)parentExecution.getCurrentFlowElement());
                } else if (parentExecution.getId().equals(parentExecution.getProcessInstanceId())) {
                    currentContainer = ProcessDefinitionUtil.getProcess(parentExecution.getProcessDefinitionId(), parentExecution.getProcessInstanceId());
                }
                for (Map.Entry<String, List<Event>> entry : eventMap.entrySet()) {
                    String refId = entry.getKey();
                    List<Event> events = entry.getValue();
                    if (!CollectionUtil.isNotEmpty(events) || !(events.get(0) instanceof StartEvent) || currentContainer == null || currentContainer.getFlowElement(refId) == null) continue;
                    matchingEvent = events.get(0);
                }
                if (matchingEvent != null) continue;
                if (eventMap.containsKey(parentExecution.getActivityId())) {
                    matchingEvent = eventMap.get(parentExecution.getActivityId()).get(0);
                    if (parentExecution.getParentId() == null || !parentExecution.getParent().isMultiInstanceRoot()) continue;
                    parentExecution = parentExecution.getParent();
                    continue;
                }
                if (WfUtils.isNotEmpty(parentExecution.getParentId())) {
                    parentExecution = parentExecution.getParent();
                    continue;
                }
                parentExecution = null;
            }
        }
        if (matchingEvent != null && parentExecution != null) {
            ErrorPropagation.executeEventHandler(matchingEvent, parentExecution, currentExecution, errorId);
        } else {
            matchError = false;
            logger.debug("No matching parent execution for error code " + errorId + " found");
        }
        return matchError;
    }

    protected static void executeEventHandler(Event event, ExecutionEntity parentExecution, ExecutionEntity currentExecution, String errorId) {
        BpmnModel bpmnModel;
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled() && (bpmnModel = ProcessDefinitionUtil.getBpmnModel(parentExecution.getProcessDefinitionId(), parentExecution.getProcessInstanceId())) != null) {
            String errorCode = bpmnModel.getErrors().get(errorId);
            if (errorCode == null) {
                errorCode = errorId;
            }
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createErrorEvent(ActivitiEventType.ACTIVITY_ERROR_RECEIVED, event.getId(), errorId, errorCode, parentExecution.getId(), parentExecution.getProcessInstanceId(), parentExecution.getProcessDefinitionId(), parentExecution.getBusinessKey()));
        }
        if (event instanceof StartEvent) {
            ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
            if (!currentExecution.getParentId().equals(parentExecution.getId())) {
                Context.getAgenda().planDestroyScopeOperation(currentExecution);
            } else {
                executionEntityManager.deleteExecutionAndRelatedData(currentExecution, null, false);
            }
            ExecutionEntity eventSubProcessExecution = executionEntityManager.createChildExecution(parentExecution);
            eventSubProcessExecution.setCurrentFlowElement(event);
            Context.getAgenda().planContinueProcessOperation(eventSubProcessExecution);
        } else {
            String lastUserNode;
            VariableScope boundaryExecution = null;
            List<? extends ExecutionEntity> childExecutions = parentExecution.getExecutions();
            for (ExecutionEntity executionEntity : childExecutions) {
                if (!executionEntity.getActivityId().equals(event.getId())) continue;
                boundaryExecution = executionEntity;
            }
            if (boundaryExecution != null && WfUtils.isNotEmpty(lastUserNode = (String)boundaryExecution.getVariableLocal("lastUserDealNode")) && ("start".equals(lastUserNode) || "startStrongControl".equals(lastUserNode))) {
                boundaryExecution.setVariableLocal("lastUserDealNode", "error");
            }
            Context.getAgenda().emptyOperation();
            Context.getAgenda().planTriggerExecutionOperation((ExecutionEntity)boundaryExecution);
        }
    }

    protected static Map<String, List<Event>> findCatchingEventsForProcess(Long processDefinitionId, Long processInstanceId, String errorCode) {
        HashMap<String, List<Event>> eventMap = new HashMap<String, List<Event>>();
        Process process = ProcessDefinitionUtil.getProcess(processDefinitionId, processInstanceId);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId, processInstanceId);
        String compareErrorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, errorCode);
        List<EventSubProcess> subProcesses = process.findFlowElementsOfType(EventSubProcess.class, true);
        for (EventSubProcess eventSubProcess : subProcesses) {
            for (FlowElement flowElement : eventSubProcess.getFlowElements()) {
                ErrorEventDefinition errorEventDef;
                String[] eventErrorCode;
                StartEvent startEvent;
                if (!(flowElement instanceof StartEvent) || !CollectionUtil.isNotEmpty((startEvent = (StartEvent)flowElement).getEventDefinitions()) || !(startEvent.getEventDefinitions().get(0) instanceof ErrorEventDefinition) || (eventErrorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, (errorEventDef = (ErrorEventDefinition)startEvent.getEventDefinitions().get(0)).getErrorCode())) != null && compareErrorCode != null && !eventErrorCode.equals(compareErrorCode)) continue;
                ArrayList<StartEvent> startEvents = new ArrayList<StartEvent>();
                startEvents.add(startEvent);
                eventMap.put(eventSubProcess.getId(), startEvents);
            }
        }
        List<BoundaryEvent> boundaryEvents = process.findFlowElementsOfType(BoundaryEvent.class, true);
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            boolean flag;
            if (boundaryEvent.getAttachedToRefId() == null || !CollectionUtil.isNotEmpty(boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof ErrorEventDefinition)) continue;
            ErrorEventDefinition errorEventDef = (ErrorEventDefinition)boundaryEvent.getEventDefinitions().get(0);
            String eventErrorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, errorEventDef.getErrorCode());
            boolean bl = flag = eventErrorCode == null || compareErrorCode == null;
            if (!flag) {
                for (String i : eventErrorCode.split("\\,")) {
                    if (!WfUtils.isNotEmpty(i) || !i.equals(compareErrorCode) && !"*".equalsIgnoreCase(i)) continue;
                    flag = true;
                    break;
                }
            }
            if (!flag) continue;
            List<BoundaryEvent> elementBoundaryEvents = null;
            if (!eventMap.containsKey(boundaryEvent.getAttachedToRefId())) {
                elementBoundaryEvents = new ArrayList();
                eventMap.put(boundaryEvent.getAttachedToRefId(), elementBoundaryEvents);
            } else {
                elementBoundaryEvents = (List)eventMap.get(boundaryEvent.getAttachedToRefId());
            }
            elementBoundaryEvents.add(boundaryEvent);
        }
        return eventMap;
    }

    public static boolean mapException(Exception e, ExecutionEntity execution, List<MapExceptionEntry> exceptionMap) {
        CallActivity callActivity;
        String errorCode = ErrorPropagation.findMatchingExceptionMapping(e, exceptionMap);
        if (errorCode != null) {
            ErrorPropagation.propagateError(errorCode, (DelegateExecution)execution);
            return true;
        }
        DelegateExecution callActivityExecution = null;
        ExecutionEntity parentExecution = execution.getParent();
        while (parentExecution != null && callActivityExecution == null) {
            if (parentExecution.getId().equals(parentExecution.getProcessInstanceId())) {
                if (parentExecution.getSuperExecution() != null) {
                    callActivityExecution = parentExecution.getSuperExecution();
                    continue;
                }
                parentExecution = null;
                continue;
            }
            parentExecution = parentExecution.getParent();
        }
        if (callActivityExecution != null && CollectionUtil.isNotEmpty((callActivity = (CallActivity)callActivityExecution.getCurrentFlowElement()).getMapExceptions()) && (errorCode = ErrorPropagation.findMatchingExceptionMapping(e, callActivity.getMapExceptions())) != null) {
            ErrorPropagation.propagateError(errorCode, callActivityExecution);
            return true;
        }
        return false;
    }

    protected static String findMatchingExceptionMapping(Exception e, List<MapExceptionEntry> exceptionMap) {
        String defaultExceptionMapping = null;
        for (MapExceptionEntry me : exceptionMap) {
            Class<?> exceptionClassClass;
            String exceptionClass = me.getClassName();
            String errorCode = me.getErrorCode();
            if (StringUtils.isNotEmpty((String)errorCode) && StringUtils.isEmpty((String)exceptionClass) && defaultExceptionMapping == null) {
                defaultExceptionMapping = errorCode;
                continue;
            }
            if (StringUtils.isEmpty((String)errorCode) || StringUtils.isEmpty((String)exceptionClass)) continue;
            if (e.getClass().isAssignableFrom(me.getClass())) {
                return errorCode;
            }
            if (!me.isAndChildren() || !(exceptionClassClass = ReflectUtil.loadClass(exceptionClass)).isAssignableFrom(e.getClass())) continue;
            return errorCode;
        }
        return defaultExceptionMapping;
    }

    protected static String retrieveErrorCode(BpmnModel bpmnModel, String errorCode) {
        String finalErrorCode = null;
        finalErrorCode = errorCode != null && bpmnModel.containsErrorRef(errorCode) ? bpmnModel.getErrors().get(errorCode) : errorCode;
        return finalErrorCode;
    }

    public static boolean propagateError(KDBizException kdBizExeception, DelegateExecution execution) {
        String errorCode = "WF_INNER_CODE";
        if (kdBizExeception.getErrorCode() != null && WfUtils.isNotEmpty(kdBizExeception.getErrorCode().getCode())) {
            errorCode = kdBizExeception.getErrorCode().getCode();
        }
        return ErrorPropagation.propagateError(new BpmnError(errorCode, kdBizExeception.getMessage()), execution, kdBizExeception);
    }
}

