/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.helper;

import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.event.ActivitiEvent;
import kd.bos.workflow.engine.impl.bpmn.helper.BaseDelegateEventListener;
import kd.bos.workflow.engine.impl.bpmn.helper.ErrorPropagation;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.WFEngineException;

public class ErrorThrowingEventListener
extends BaseDelegateEventListener {
    protected String errorCode;

    @Override
    public void onEvent(ActivitiEvent event) {
        if (this.isValidEvent(event)) {
            CommandContext commandContext = Context.getCommandContext();
            ExecutionEntity execution = null;
            if (event.getExecutionId() != null) {
                execution = (ExecutionEntity)Context.getCommandContext().getExecutionEntityManager().findById(event.getExecutionId());
            }
            if (execution == null) {
                throw new WFEngineException("No execution context active and event is not related to an execution. No compensation event can be thrown.");
            }
            try {
                ErrorPropagation.propagateError(this.errorCode, (DelegateExecution)execution);
            }
            catch (Exception e) {
                throw new WFEngineException("Error while propagating error-event", e);
            }
        }
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public boolean isFailOnException() {
        return true;
    }
}

