/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.CompensateEventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.util.CollectionUtil;

public class ScopeUtil {
    protected static Log logger = LogFactory.getLog(ScopeUtil.class);

    public static void throwCompensationEvent(List<CompensateEventSubscriptionEntity> eventSubscriptions, DelegateExecution execution, boolean async, Map<String, Object> passVars) {
        if (eventSubscriptions.isEmpty()) {
            return;
        }
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        HashMap payload = new HashMap();
        StringBuilder pkSb = new StringBuilder();
        StringBuilder idSb = new StringBuilder();
        ExecutionEntity compensatingExecution = null;
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            if (compensatingExecution == null) {
                ExecutionEntity tmp;
                compensatingExecution = tmp = executionEntityManager.createChildExecution(eventSubscriptionEntity.getExecution());
                eventSubscriptionEntity.setConfiguration(String.valueOf(compensatingExecution.getId()));
            }
            pkSb.append(eventSubscriptionEntity.getBusinesskey()).append(',');
            idSb.append(eventSubscriptionEntity.getId()).append(',');
        }
        String allEvtSubsIds = idSb.substring(0, idSb.length() - 1);
        String string = pkSb.substring(0, pkSb.length() - 1);
        logger.debug("allEvtSubsIds:" + allEvtSubsIds + "; allBusiensskeys:" + string);
        if (compensatingExecution != null) {
            compensatingExecution.setVariableLocal("batchCompensateBusinesskey", string);
            logger.debug("set variable local batchCompensateBusinesskey:[" + string + "];exeId:" + compensatingExecution.getId());
            compensatingExecution.setVariableLocal("batchCompensateEventSubsId", allEvtSubsIds);
            compensatingExecution.setVariablesLocal(passVars);
            Context.getCommandContext().getEventSubscriptionEntityManager().eventReceived(eventSubscriptions.get(0), payload, async);
        }
    }

    public static void createCopyOfSubProcessExecutionForCompensation(ExecutionEntity subProcessExecution) {
        EventSubscriptionEntityManager eventSubscriptionEntityManager = Context.getCommandContext().getEventSubscriptionEntityManager();
        List<EventSubscriptionEntity> eventSubscriptions = eventSubscriptionEntityManager.findEventSubscriptionsByExecutionAndType(subProcessExecution.getId(), "compensate");
        ArrayList<CompensateEventSubscriptionEntity> compensateEventSubscriptions = new ArrayList<CompensateEventSubscriptionEntity>();
        for (EventSubscriptionEntity event : eventSubscriptions) {
            if (!(event instanceof CompensateEventSubscriptionEntity)) continue;
            compensateEventSubscriptions.add((CompensateEventSubscriptionEntity)event);
        }
        if (CollectionUtil.isNotEmpty(compensateEventSubscriptions)) {
            ExecutionEntity processInstanceExecutionEntity = subProcessExecution.getProcessInstance();
            ExecutionEntity eventScopeExecution = Context.getCommandContext().getExecutionEntityManager().createChildExecution(processInstanceExecutionEntity);
            eventScopeExecution.setActive(false);
            eventScopeExecution.setEventScope(true);
            eventScopeExecution.setCurrentFlowElement(subProcessExecution.getCurrentFlowElement());
            Map<String, Object> variables = subProcessExecution.getVariablesLocal();
            for (Map.Entry<String, Object> variable : variables.entrySet()) {
                eventScopeExecution.setVariableLocal(variable.getKey(), variable.getValue());
            }
            for (CompensateEventSubscriptionEntity eventSubscriptionEntity : compensateEventSubscriptions) {
                eventSubscriptionEntityManager.delete(eventSubscriptionEntity);
                CompensateEventSubscriptionEntity newSubscription = eventSubscriptionEntityManager.insertCompensationEvent(eventScopeExecution, eventSubscriptionEntity.getActivityId());
                newSubscription.setConfiguration(eventSubscriptionEntity.getConfiguration());
                newSubscription.setCreateDate(eventSubscriptionEntity.getCreateDate());
            }
            CompensateEventSubscriptionEntity eventSubscription = eventSubscriptionEntityManager.insertCompensationEvent(processInstanceExecutionEntity, eventScopeExecution.getCurrentFlowElement().getId());
            eventSubscription.setConfiguration(String.valueOf(eventScopeExecution.getId()));
        }
    }
}

