/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.helper;

import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.Expression;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class SkipExpressionUtil {
    public static boolean isSkipExpressionEnabled(DelegateExecution execution, String skipExpression) {
        if (skipExpression == null) {
            return false;
        }
        return SkipExpressionUtil.checkSkipExpressionVariable(execution);
    }

    public static boolean isSkipExpressionEnabled(DelegateExecution execution, Expression skipExpression) {
        if (skipExpression == null) {
            return false;
        }
        return SkipExpressionUtil.checkSkipExpressionVariable(execution);
    }

    private static boolean checkSkipExpressionVariable(DelegateExecution execution) {
        String skipExpressionEnabledVariable = "_ACTIVITI_SKIP_EXPRESSION_ENABLED";
        Object isSkipExpressionEnabled = execution.getVariable("_ACTIVITI_SKIP_EXPRESSION_ENABLED");
        if (isSkipExpressionEnabled == null) {
            return false;
        }
        if (isSkipExpressionEnabled instanceof Boolean) {
            return (Boolean)isSkipExpressionEnabled;
        }
        throw new WFIllegalArgumentException("_ACTIVITI_SKIP_EXPRESSION_ENABLED variable does not resolve to a boolean. " + isSkipExpressionEnabled);
    }

    public static boolean shouldSkipFlowElement(CommandContext commandContext, DelegateExecution execution, String skipExpressionString) {
        Expression skipExpression = commandContext.getProcessEngineConfiguration().getExpressionManager().createExpression(skipExpressionString);
        Object value = skipExpression.getValue(execution);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new WFIllegalArgumentException("Skip expression does not resolve to a boolean: " + skipExpression.getExpressionText());
    }

    public static boolean shouldSkipFlowElement(DelegateExecution execution, Expression skipExpression) {
        Object value = skipExpression.getValue(execution);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new WFIllegalArgumentException("Skip expression does not resolve to a boolean: " + skipExpression.getExpressionText());
    }
}

