/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.helper.nodetemplate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.NodeTemplate;
import kd.bos.workflow.bpmn.model.ExtendAttributeGroup;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.helper.nodetemplate.ISupportExtension;
import kd.bos.workflow.engine.impl.bpmn.helper.nodetemplate.NodeTemplateExtAttrEntity;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cmd.model.GetNodeTemplateExpendDatasCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class NodeTemplateUtil {
    private static Log logger = LogFactory.getLog(NodeTemplateUtil.class);
    private static final String ATTRIBUTES = "attributes";
    private static final String PLUGINS = "plugins";
    public static final String AUDIT_LISTENERS = "auditListeners";
    public static final String NODE_TEMPLATE_NUM = "nodeTemplateNum";
    public static final String PLUGIN_NUMBER = "pluginNumber";
    public static final String FI_RCM_CREDIT_APPROVE = "fircm_creditApprove";
    public static final String FI_RCM_YZJ_CREDIT_APPROVE = "fircm_yzjCreditApprove";

    private NodeTemplateUtil() {
        logger.debug("This is a private constructor");
    }

    public static List<NodeTemplate> getExtendNodeTemplateBystencilType(String stencilType, CommandContext commandContext) {
        String nodeTemplateExpendDatasString = WfCacheHelper.getNodeTemplateExpendData(stencilType);
        List<NodeTemplate> nodeTemplateExpendDatas = null;
        if (WfUtils.isNotEmpty(nodeTemplateExpendDatasString)) {
            return SerializationUtils.fromJsonStringToList((String)nodeTemplateExpendDatasString, NodeTemplate.class);
        }
        if (commandContext != null) {
            nodeTemplateExpendDatas = new GetNodeTemplateExpendDatasCmd(stencilType).execute(commandContext);
        } else {
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            RepositoryService repositoryService = wfService.getRepositoryService();
            nodeTemplateExpendDatas = repositoryService.getNodeTemplateExpendDatas(stencilType);
        }
        WfCacheHelper.putNodeTemplateExpendData(stencilType, nodeTemplateExpendDatas);
        return nodeTemplateExpendDatas;
    }

    public static void removeNodeTemplateExpend() {
        WfCacheHelper.removeNodeTemplateExpendData("UserTask");
        WfCacheHelper.removeNodeTemplateExpendData("AuditTask");
        WfCacheHelper.removeNodeTemplateExpendData("YunzhijiaTask");
        WfCacheHelper.removeNodeTemplateExpendData("SSCApprove");
    }

    public static boolean isScalableNodesByStencilType(String stencilType) {
        return "UserTask".equals(stencilType) || "AuditTask".equals(stencilType) || "YunzhijiaTask".equals(stencilType) || "SSCApprove".equals(stencilType) || "HRActivity".equals(stencilType);
    }

    public static boolean isScalableNodes(FlowElement flowElement) {
        return flowElement instanceof ISupportExtension;
    }

    public static NodeTemplateExtAttrEntity getExtAttrDatas(String stencilType) {
        return NodeTemplateUtil.getExtAttrDatas(stencilType, null);
    }

    public static NodeTemplateExtAttrEntity getExtAttrDatas(String stencilType, CommandContext commandContext) {
        NodeTemplateExtAttrEntity nodeTemplateExtAttrEntity = new NodeTemplateExtAttrEntity();
        List<NodeTemplate> nodeTemplateExpendDatas = NodeTemplateUtil.getExtendNodeTemplateBystencilType(stencilType, commandContext);
        HashMap<String, JSONArray> nodeTemplateExtDatasMap = new HashMap<String, JSONArray>(nodeTemplateExpendDatas.size());
        HashMap<String, String> nodeTemplateNameMap = new HashMap<String, String>();
        for (NodeTemplate nodeTemplate : nodeTemplateExpendDatas) {
            String number = nodeTemplate.getNumber();
            String name = nodeTemplate.getName();
            String propsDefinition = nodeTemplate.getPropsDefinition();
            JSONObject propsDefinitionJsonObject = JSON.parseObject((String)propsDefinition);
            JSONArray attributesArray = propsDefinitionJsonObject == null ? new JSONArray() : propsDefinitionJsonObject.getJSONArray(ATTRIBUTES);
            nodeTemplateExtDatasMap.put(number, attributesArray);
            nodeTemplateNameMap.put(number, name);
        }
        nodeTemplateExtAttrEntity.setExtAttrMap(nodeTemplateExtDatasMap);
        nodeTemplateExtAttrEntity.setExtNameMap(nodeTemplateNameMap);
        return nodeTemplateExtAttrEntity;
    }

    public static JSONArray getExtAttributesByNodeNumber(String stencilType, CommandContext commandContext, String targetNumber) {
        String propsDefinition;
        List<NodeTemplate> nodeTemplateExpendDatas = NodeTemplateUtil.getExtendNodeTemplateBystencilType(stencilType, commandContext);
        if (nodeTemplateExpendDatas == null || nodeTemplateExpendDatas.isEmpty()) {
            return new JSONArray();
        }
        NodeTemplate tagNodeTemplate = new NodeTemplate();
        for (NodeTemplate nodeTemplate : nodeTemplateExpendDatas) {
            if (!targetNumber.equals(nodeTemplate.getNumber())) continue;
            tagNodeTemplate = nodeTemplate;
            break;
        }
        JSONObject propsDefinitionJsonObject = WfUtils.isEmpty(propsDefinition = tagNodeTemplate.getPropsDefinition()) ? new JSONObject() : JSONObject.parseObject((String)propsDefinition);
        return propsDefinitionJsonObject.getJSONArray(ATTRIBUTES);
    }

    public static List<JSONObject> getExtPluginsByType(FlowElement flowElement, String stencilType, String targetKey) {
        List<JSONObject> result = new ArrayList<JSONObject>();
        if (!(flowElement instanceof ISupportExtension)) {
            logger.debug("getExtPluginsByType is error,flowElement is null");
            return result;
        }
        List<String> extGroupNumberList = NodeTemplateUtil.getExtGroupNumberList(flowElement);
        List<NodeTemplate> nodeTemplateExpendDatas = NodeTemplateUtil.getExtendNodeTemplateBystencilType(stencilType, Context.getCommandContext());
        Iterator<NodeTemplate> nodeTemplateExpendIterator = nodeTemplateExpendDatas.iterator();
        while (nodeTemplateExpendIterator.hasNext()) {
            NodeTemplate nodeTemplateExpend = nodeTemplateExpendIterator.next();
            if (extGroupNumberList.contains(nodeTemplateExpend.getNumber())) continue;
            nodeTemplateExpendIterator.remove();
        }
        result = NodeTemplateUtil.getExecutablePlugins(targetKey, nodeTemplateExpendDatas);
        return result;
    }

    public static List<JSONObject> getExtPluginsByType(String stencilType, String targetKey) {
        List<NodeTemplate> nodeTemplateExpendDatas = NodeTemplateUtil.getExtendNodeTemplateBystencilType(stencilType, Context.getCommandContext());
        return NodeTemplateUtil.getExecutablePlugins(targetKey, nodeTemplateExpendDatas);
    }

    private static List<JSONObject> getExecutablePlugins(String targetKey, List<NodeTemplate> nodeTemplateExpendDatas) {
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        for (NodeTemplate nodeTemplate : nodeTemplateExpendDatas) {
            String propsDefinition = nodeTemplate.getPropsDefinition();
            JSONObject propsDefinitionJsonObject = JSONObject.parseObject((String)propsDefinition);
            JSONObject pluginsObject = propsDefinitionJsonObject.getJSONObject(PLUGINS) == null ? new JSONObject() : propsDefinitionJsonObject.getJSONObject(PLUGINS);
            JSONArray listenersArray = pluginsObject.getJSONArray(targetKey) == null ? new JSONArray() : pluginsObject.getJSONArray(targetKey);
            for (Object object : listenersArray) {
                JSONObject listenerJSONObject = (JSONObject)object;
                listenerJSONObject.put(NODE_TEMPLATE_NUM, (Object)nodeTemplate.getNumber());
                result.add(listenerJSONObject);
            }
        }
        return result;
    }

    private static List<String> getExtGroupNumberList(FlowElement flowElement) {
        ArrayList<String> expendGroupNumberList = new ArrayList<String>();
        Map<Object, Object> extAttrGroupMap = ((UserTask)flowElement).getExtAttrGroup() == null ? new HashMap() : ((UserTask)flowElement).getExtAttrGroup();
        Set<Map.Entry<Object, Object>> extAttrGroupEntry = extAttrGroupMap.entrySet();
        for (Map.Entry<Object, Object> extAttrGroup : extAttrGroupEntry) {
            ExtendAttributeGroup expendAttribute = (ExtendAttributeGroup)extAttrGroup.getValue();
            if (expendAttribute == null || !expendAttribute.isGroupEnable()) continue;
            expendGroupNumberList.add((String)extAttrGroup.getKey());
        }
        return expendGroupNumberList;
    }

    public static boolean isSSCCredit(String groupNumber, String stencilType) {
        return Objects.equals(NodeTemplateUtil.getNodeExtNumByStencilType(stencilType), groupNumber);
    }

    public static String getNodeExtNumByStencilType(String stencilType) {
        switch (stencilType) {
            case "AuditTask": {
                return FI_RCM_CREDIT_APPROVE;
            }
            case "YunzhijiaTask": {
                return FI_RCM_YZJ_CREDIT_APPROVE;
            }
        }
        return "";
    }
}

