/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.listener;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.ExecutionListener;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.bpmn.model.Circulate;
import kd.bos.workflow.bpmn.model.CirculateModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.calculator.ParticipantCalculator;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.exception.WFCirculateParserException;
import kd.bos.workflow.exception.WFErrorCode;
import org.apache.commons.lang.StringUtils;

public class AutoCirculateLitstener
implements ExecutionListener {
    private static final long serialVersionUID = -4177296821788027764L;
    private Log logger = LogFactory.getLog((String)this.getClass().getName());

    public void notify(AgentExecution agentExecution) {
        HistoricActivityInstanceEntity ac;
        DelegateExecution execution = (DelegateExecution)agentExecution;
        CommandContext commandContext = Context.getCommandContext();
        if (WfUtils.isNotEmpty(execution.getCurrentActInstId()) && (ac = (HistoricActivityInstanceEntity)commandContext.getHistoricActivityInstanceEntityManager().findById(execution.getCurrentActInstId())) != null && ("jump".equalsIgnoreCase(ac.getExecutionType()) || "skip".equalsIgnoreCase(ac.getExecutionType()))) {
            return;
        }
        UserTask userTask = null;
        if (execution.getCurrentFlowElement() instanceof UserTask) {
            userTask = (UserTask)execution.getCurrentFlowElement();
        }
        if (userTask == null) {
            this.logger.debug(String.format("%s is not usertask node.", execution.getCurrentFlowElement() == null ? "null" : execution.getCurrentFlowElement().getId()));
            return;
        }
        List<CommentEntity> commentEntitys = commandContext.getCommentEntityManager().findCommentsByTaskId(execution.getCurrentTaskId());
        if (WfUtils.isNotEmpty(execution.getCurrentActInstId()) && userTask.getCirculateModel() != null) {
            String eventName;
            QFilter q2;
            QFilter q1;
            QFilter[] qFilters;
            DynamicObjectCollection dynObjectCollection;
            Circulate circulate = userTask.getCirculateModel().getCirculate();
            TaskEntity task = ((ExecutionEntity)execution).getCurrentTask();
            if (circulate == null || task == null) {
                return;
            }
            String trigger = circulate.getTrigger();
            String evt = null;
            if (CollectionUtils.isEmpty(commentEntitys)) {
                if (!"start".equals(trigger)) {
                    return;
                }
            } else {
                evt = commentEntitys.get(0).getResultNumber();
            }
            Long taskId = task.getId();
            if ("YunzhijiaTask".equals(userTask.getType()) && CollectionUtils.isNotEmpty((Collection)(dynObjectCollection = QueryServiceHelper.query((String)"wf_hiactinst", (String)"taskId, executionId, assigneeid", (QFilter[])(qFilters = new QFilter[]{q1 = new QFilter("processInstanceId", "=", (Object)task.getProcessInstanceId()), q2 = new QFilter("parenttaskid", "=", (Object)task.getId())}))))) {
                for (DynamicObject dynamicObject : dynObjectCollection) {
                    if (!RequestContext.get().getUserId().equals(dynamicObject.getString("assigneeid"))) continue;
                    taskId = dynamicObject.getLong("taskId");
                }
            }
            if (this.getValidateCirculateResult(evt, eventName = agentExecution.getEventName(), userTask).booleanValue()) {
                if ("start".equals(eventName)) {
                    if ("start".equals(trigger) && !"SSCApprove".equals(userTask.getType())) {
                        return;
                    }
                    this.planAutoCirculateJob(commandContext, execution, taskId, userTask);
                } else if ("end".equals(eventName)) {
                    this.planAutoCirculateJob(commandContext, execution, taskId, userTask);
                }
            }
        }
    }

    private Boolean getValidateCirculateResult(String evt, String eventName, UserTask userTask) {
        Boolean IsFullItemRule = StringUtils.isNotBlank((String)evt) && "end".equals(eventName) || "start".equals(eventName);
        CirculateModel circulateModel = userTask.getCirculateModel();
        Circulate circulate = circulateModel.getCirculate();
        if (circulate == null || circulate.getTrigger() == null) {
            return false;
        }
        String trigger = circulate.getTrigger();
        Boolean eventTrigger = StringUtils.equals((String)eventName, (String)trigger) || StringUtils.equals((String)evt, (String)trigger);
        return circulateModel.isCirculateWhenMatch() && eventTrigger != false && IsFullItemRule != false;
    }

    protected void planAutoCirculateJob(CommandContext commandContext, DelegateExecution execution, Long taskId, UserTask userTask) {
        try {
            CirculateModel circulateModel = userTask.getCirculateModel();
            Circulate circulate = circulateModel.getCirculate();
            String businessKey = execution.getBusinessKey();
            List<ParticipantModelEntityImpl> participants = circulate.getParticipant();
            ProcessEngineConfigurationImpl processEngineConfigurationImpl = commandContext.getProcessEngineConfiguration();
            ParticipantCalculator participantCalculator = processEngineConfigurationImpl.getParticipantCalculator();
            List<Long> userIds = participantCalculator.getUserIds(businessKey, execution, participants);
            LocaleString suggestion = new LocaleString();
            String suggestionMultiKey = String.format("%s.circulateModel.circulate.suggestion", userTask.getId());
            ILocaleString suggestionExpression = BpmnModelUtil.getMultiLangFieldValue(execution.getProcessInstanceId(), suggestionMultiKey, circulate.getSuggestion());
            if (WfUtils.isEmpty(suggestionExpression)) {
                suggestionExpression = new LocaleString(circulate.getSuggestion());
            }
            DynamicObject dynamicObject = WfUtils.findBusinessObject(businessKey, execution.getEntityNumber());
            for (Map.Entry entry : suggestionExpression.entrySet()) {
                String key = (String)entry.getKey();
                String suggestionParser = ExpressionCalculatorUtil.contentParser((String)suggestionExpression.get((Object)key), dynamicObject, execution, true);
                suggestion.setItem(key, (Object)suggestionParser);
            }
            this.logger.debug(String.format("\u81ea\u52a8\u4f20\u9605\u53d1\u9001\u81f3\u5f02\u6b65\u5904\u7406\uff1ataskId\uff1a%s\uff0cuserIds\uff1a%s\uff0csuggestion\uff1a%s", taskId, userIds, suggestion));
            JobEntity circulateJob = commandContext.getJobManager().createCirculateJob((ExecutionEntity)execution, taskId, userIds, (ILocaleString)suggestion);
            commandContext.getJobManager().scheduleAsyncJob(circulateJob);
        }
        catch (Exception e) {
            String content = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u5728\u201c%2$s\u201d\u8282\u70b9\u81ea\u52a8\u201c%s\u201d\u65f6\uff0c\u53c2\u4e0e\u4eba\u6216\u8005\u201c%3$s\u201d\u610f\u89c1\u89e3\u6790\u51fa\u9519\uff0c\u201c%4$s\u201d:\u201c%5$s\u201d\u3002", (String)"AutoCirculateLitstener_1", (String)"bos-wf-engine", (Object[])new Object[0]), ((ExecutionEntity)execution).getEntraBillName(), userTask.getName(), WfConfigurationUtil.getCirculationName(), WfConfigurationUtil.getCirculationName(), e.getClass().getName(), e.getMessage());
            throw new WFCirculateParserException(e, WFErrorCode.circulateParserError(), WfConfigurationUtil.getCirculationName(), content);
        }
    }
}

