/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.listener;

import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.ExecutionListener;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.IMessageSupport;
import kd.bos.workflow.bpmn.model.MessageSendModel;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;

public class ComingNotifyListener
implements ExecutionListener {
    private static final long serialVersionUID = -5539589312875006038L;
    private Log logger = LogFactory.getLog((String)this.getClass().getName());

    public void notify(AgentExecution agentExecution) {
        HistoricActivityInstanceEntity ac;
        if (WfUtils.isTesting()) {
            return;
        }
        DelegateExecution execution = (DelegateExecution)agentExecution;
        if (WfUtils.isNotEmpty(execution.getCurrentActInstId()) && (ac = (HistoricActivityInstanceEntity)Context.getCommandContext().getHistoricActivityInstanceEntityManager().findById(execution.getCurrentActInstId())) != null && ("jump".equalsIgnoreCase(ac.getExecutionType()) || "skip".equalsIgnoreCase(ac.getExecutionType()) || "addSignBefore".equals(ac.getExecutionType()))) {
            this.logger.debug(String.format("\u8282\u70b9[%s][%s]\u4e0d\u53d1\u9001\u6d88\u606f,\u56e0\u4e3a\u8282\u70b9[%s]", ac.getActivityName(), ac.getActivityId(), ac.getExecutionType()));
            return;
        }
        FlowElement flowElement = execution.getCurrentFlowElement();
        if (flowElement instanceof IMessageSupport) {
            this.handleMessge(execution, this.getMessageSendModels(flowElement), flowElement);
        }
    }

    protected List<MessageSendModel> getMessageSendModels(FlowElement flowElement) {
        return ((IMessageSupport)((Object)flowElement)).getInMsg();
    }

    protected String getType() {
        return "start";
    }

    protected boolean canSend(MessageSendModel sendModel) {
        return "notify".equals(sendModel.getMessagetype());
    }

    private void handleMessge(DelegateExecution execution, List<MessageSendModel> msgModels, FlowElement flowElement) {
        if (CollectionUtil.isEmpty(msgModels)) {
            return;
        }
        String evt = null;
        if ("taskReceived".equals(execution.getCurrentActivitiListener().getEvent())) {
            evt = "taskReceived";
        } else {
            if (flowElement instanceof YunzhijiaTask && execution.getParent().isMultiInstanceRoot()) {
                return;
            }
            evt = this.getSendEvt(execution, flowElement);
        }
        ArrayList<MessageSendModel> msgRet = new ArrayList<MessageSendModel>();
        for (MessageSendModel sendModel : msgModels) {
            if (!sendModel.isNotify() || sendModel.getReceiver() == null || sendModel.getReceiver().isEmpty() || !this.canSend(evt, sendModel) || !this.canSend(sendModel) || !this.isFulfillRule(execution, sendModel, flowElement) || !"notify".equals(sendModel.getMessagetype())) continue;
            msgRet.add(sendModel);
        }
        if (CollectionUtil.isNotEmpty(msgRet)) {
            this.logger.debug(String.format("\u8fdb\u5165\u8282\u70b9\u53d1\u9001\u6d88\u606f,\u8282\u70b9\u540d\u79f0[%s]", flowElement.getName()));
            Context.getCommandContext().getMessageService().sendMessageForNode(execution, flowElement.getId(), msgRet, this.getType());
        }
    }

    protected boolean isFulfillRule(DelegateExecution execution, MessageSendModel sendModel, FlowElement flowElement) {
        ConditionalRuleEntity messageSendRule = sendModel.getRule();
        boolean isFulfillRule = false;
        if (messageSendRule != null) {
            String key = ConditionUtil.getConInstKey(flowElement.getNumber(), "msg");
            isFulfillRule = ConditionUtil.hasTrueCondition(messageSendRule, (VariableScope)execution, key);
        } else {
            isFulfillRule = true;
        }
        return isFulfillRule;
    }

    protected boolean canSend(String evt, MessageSendModel sendModel) {
        boolean send = evt == null && this.getType().equals(sendModel.getSendevt()) || evt != null && evt.equals(sendModel.getSendevt());
        return send;
    }

    protected String getSendEvt(DelegateExecution execution, FlowElement flowElement) {
        if (DynamicFlowUtil.isRejectInCurrentNode(execution, flowElement.getId())) {
            return "reject";
        }
        return null;
    }
}

