/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.listener;

import java.util.List;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.ExecutionListener;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.Expression;
import kd.bos.workflow.engine.delegate.JavaDelegate;
import kd.bos.workflow.engine.impl.bpmn.helper.DelegateExpressionUtil;
import kd.bos.workflow.engine.impl.bpmn.parser.FieldDeclaration;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.delegate.invocation.ExecutionListenerInvocation;
import kd.bos.workflow.engine.impl.delegate.invocation.JavaDelegateInvocation;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class DelegateExpressionExecutionListener
implements ExecutionListener {
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public DelegateExpressionExecutionListener(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    public void notify(AgentExecution agentExecution) {
        DelegateExecution execution = (DelegateExecution)agentExecution;
        Object delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, execution, this.fieldDeclarations);
        if (delegate instanceof ExecutionListener) {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ExecutionListenerInvocation((ExecutionListener)delegate, execution, false));
        } else if (delegate instanceof JavaDelegate) {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation((JavaDelegate)delegate, execution));
        } else {
            throw new WFIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + ExecutionListener.class + " nor " + JavaDelegate.class);
        }
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }
}

