/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.listener;

import java.util.List;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.engine.delegate.DelegateTask;
import kd.bos.workflow.engine.delegate.Expression;
import kd.bos.workflow.engine.delegate.TaskListener;
import kd.bos.workflow.engine.enumeration.TaskListenerInvocationType;
import kd.bos.workflow.engine.impl.bpmn.helper.DelegateExpressionUtil;
import kd.bos.workflow.engine.impl.bpmn.parser.FieldDeclaration;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.delegate.invocation.TaskListenerInvocation;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class DelegateExpressionTaskListener
implements TaskListener {
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public DelegateExpressionTaskListener(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public void notify(AgentTask task) {
        DelegateTask delegateTask = (DelegateTask)task;
        Object delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, delegateTask, this.fieldDeclarations);
        if (delegate instanceof TaskListener) {
            try {
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation((TaskListener)delegate, delegateTask, TaskListenerInvocationType.NOTWITHDRAW));
            }
            catch (WFEngineException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WFEngineException("Exception while invoking TaskListener: " + e.getMessage(), e);
            }
        } else {
            throw new WFIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + TaskListener.class);
        }
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }
}

