/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.listener;

import java.util.ArrayList;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.ExecutionListener;
import kd.bos.workflow.api.WorkflowElement;
import kd.bos.workflow.bpmn.model.BillSubjectModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.calculator.BillSubjectCalculator;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;

public class EnterNodeUpdatesSubjectAndActNames
implements ExecutionListener {
    private static final long serialVersionUID = -1401676817648855234L;

    public void notify(AgentExecution execution) {
        WorkflowElement element = execution.getCurrentFlowElement();
        if (element instanceof UserTask || element instanceof CallActivity && execution instanceof ExecutionEntity && WfUtils.isEmpty(((ExecutionEntity)execution).getSubject()) && ModelType.BizFlow.name().equalsIgnoreCase(((ExecutionEntity)execution).getProcessType())) {
            this.updateSubject(execution);
        }
    }

    protected void updateSubject(AgentExecution execution) {
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntityManager executionMgr = commandContext.getExecutionEntityManager();
        if (commandContext.getWithdrawHitask() != null) {
            HistoricTaskInstanceEntity hiTask = commandContext.getWithdrawHitask();
            ILocaleString subject = hiTask.getSubject();
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            Long rootProInstId = executionEntity.getRootProcessInstanceId();
            ExecutionEntity rootExecutionEntity = (ExecutionEntity)executionMgr.findById(rootProInstId);
            executionEntity = (ExecutionEntity)executionMgr.findById(executionEntity.getId());
            HistoricProcessInstanceEntity hisEntity = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(rootProInstId);
            rootExecutionEntity.setSubject(subject);
            executionEntity.setSubject(subject);
            hisEntity.setSubject(subject);
            executionMgr.update(rootExecutionEntity);
            executionMgr.update(executionEntity);
            commandContext.getHistoricProcessInstanceEntityManager().update(hisEntity);
        } else {
            boolean canUpdateProcInst;
            BillSubjectCalculator calculator = commandContext.getProcessEngineConfiguration().getBillSubjectCalculator();
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            Long rootProInstId = executionEntity.getProcessInstanceId();
            ExecutionEntity rootExecutionEntity = (ExecutionEntity)executionMgr.findById(rootProInstId);
            WorkflowElement f = execution.getCurrentFlowElement();
            ArrayList<BillSubjectModel> subjectModels = new ArrayList();
            if (f instanceof UserTask) {
                subjectModels = ((UserTask)f).getSubject();
            }
            VariableScope scope = executionEntity.getCurrentTask() == null ? executionEntity : executionEntity.getCurrentTask();
            ILocaleString subject = null;
            if (executionEntity.getCurrentTask() != null && WfUtils.isNotEmpty(executionEntity.getCurrentTask().getSubject())) {
                subject = executionEntity.getCurrentTask().getSubject();
                if (this.needUpdateBillNo(rootExecutionEntity, executionEntity)) {
                    String billNo = executionEntity.getCurrentTask().getBillNo();
                    rootExecutionEntity.setBillNo(billNo);
                    executionEntity.setBillNo(billNo);
                    ILocaleString name = commandContext.getExecutionEntityManager().getProcessName(rootExecutionEntity.getProcessDefinitionId(), rootExecutionEntity.getSchemeId(), billNo);
                    rootExecutionEntity.setName(name);
                    executionMgr.update(rootExecutionEntity);
                }
            } else {
                subject = calculator.getSubjectByBillSubjectModel(subjectModels, execution.getBusinessKey(), execution.getEntityNumber(), scope);
            }
            boolean bl = canUpdateProcInst = rootExecutionEntity != null && (ModelType.AuditFlow.name().equalsIgnoreCase(rootExecutionEntity.getProcessType()) || WfUtils.isEmpty(rootExecutionEntity.getSubject()));
            if (canUpdateProcInst) {
                rootExecutionEntity.setSubject(subject);
                executionMgr.update(rootExecutionEntity);
            }
            executionEntity = (ExecutionEntity)executionMgr.findById(executionEntity.getId());
            executionEntity.setSubject(subject);
            executionMgr.update(executionEntity);
            HistoricProcessInstanceEntity hisEntity = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(rootProInstId);
            if (hisEntity != null && canUpdateProcInst) {
                hisEntity.setSubject(subject);
                commandContext.getHistoricProcessInstanceEntityManager().update(hisEntity);
            }
        }
    }

    private boolean needUpdateBillNo(ExecutionEntity rootExecutionEntity, ExecutionEntity executionEntity) {
        if (ModelType.AuditFlow.name().equalsIgnoreCase(rootExecutionEntity.getProcessType())) {
            return rootExecutionEntity != null && rootExecutionEntity.getBillNo() != null && !executionEntity.getCurrentTask().getBillNo().equalsIgnoreCase(rootExecutionEntity.getBillNo()) && rootExecutionEntity.getBusinessKey() != null && rootExecutionEntity.getBusinessKey().equalsIgnoreCase(executionEntity.getBusinessKey());
        }
        return false;
    }

    protected void updateActivityName(AgentExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        BPMNUtil.updateActivityName(executionEntity);
    }
}

