/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpmn.listener;

import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.ExecutionListener;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.service.WfTraceType;

public class ExecuteExecutionListenerTransactionListener
extends DefaultCommandContextCloseListener {
    protected ExecutionListener listener;
    protected DelegateExecution execution;

    public ExecuteExecutionListenerTransactionListener(String aim, ExecutionListener commitListener, DelegateExecution execution) {
        super(aim);
        this.listener = commitListener;
        this.execution = execution;
    }

    @Override
    public void closed(CommandContext commandContext) {
        try {
            if (this.listener != null) {
                CommandConfig commandConfig = commandContext.getProcessEngineConfiguration().getCommandExecutor().getDefaultConfig().transactionRequiresNew();
                commandContext.getProcessEngineConfiguration().getCommandExecutor().execute(commandConfig, new Command<Void>(){

                    @Override
                    public Void execute(CommandContext commandContext) {
                        block5: {
                            try {
                                ExecuteExecutionListenerTransactionListener.this.log.debug(String.format("execution listener[%s] when tx is closed.", ExecuteExecutionListenerTransactionListener.this.listener.getClass().getName()));
                                ExecuteExecutionListenerTransactionListener.this.listener.notify((AgentExecution)ExecuteExecutionListenerTransactionListener.this.execution);
                            }
                            catch (Exception e) {
                                ExecuteExecutionListenerTransactionListener.this.log.error(WfUtils.getExceptionStacktrace(e));
                                if (!commandContext.getEventDispatcher().isEnabled()) break block5;
                                try {
                                    String activityId = "";
                                    if (ExecuteExecutionListenerTransactionListener.this.execution != null && ExecuteExecutionListenerTransactionListener.this.execution.getCurrentFlowElement() != null) {
                                        activityId = ExecuteExecutionListenerTransactionListener.this.execution.getCurrentFlowElement().getId();
                                    }
                                    Long executionId = ExecuteExecutionListenerTransactionListener.this.execution == null ? Long.valueOf(0L) : ExecuteExecutionListenerTransactionListener.this.execution.getId();
                                    Long processInstanceId = ExecuteExecutionListenerTransactionListener.this.execution == null ? Long.valueOf(0L) : ExecuteExecutionListenerTransactionListener.this.execution.getProcessInstanceId();
                                    Long processDefId = ExecuteExecutionListenerTransactionListener.this.execution == null ? Long.valueOf(0L) : ExecuteExecutionListenerTransactionListener.this.execution.getProcessDefinitionId();
                                    String businessKey = ExecuteExecutionListenerTransactionListener.this.execution == null ? "" : ExecuteExecutionListenerTransactionListener.this.execution.getBusinessKey();
                                    Long jobId = WfTraceType.get().getJobInfo() == null ? Long.valueOf(0L) : WfTraceType.get().getJobInfo().getCurrentJobId();
                                    String entityNumber = ExecuteExecutionListenerTransactionListener.this.execution == null ? "" : ExecuteExecutionListenerTransactionListener.this.execution.getEntityNumber();
                                    commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createAsyncMessageEvent(ActivitiEventType.JOB_EXECUTION_FAILURE, "listenerErrorWhenCommit", null, activityId, executionId, processInstanceId, processDefId, businessKey, jobId, entityNumber, e));
                                }
                                catch (Exception ignore) {
                                    ExecuteExecutionListenerTransactionListener.this.log.warn("Exception occurred while dispatching job failure event, ignoring.", (Throwable)ignore);
                                }
                            }
                        }
                        return null;
                    }
                });
            }
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace(e));
        }
    }
}

